function [accepted, adjustetd_p, cutoff]= multiple_test_FDR_correction(p, config)

% correction for multiple tests using False Discovery Rate for correlated statistics 
% code based on Benjamini Y, Yekutieli D, (2001) The control of the False Discovery Rate Under Dependancy. Ann.Stat, 29, 1165-1188
eval(config);
N_tests=(map_y_size*(map_x_size-ref(end)-right_time_margin_px));
spm_corr=zeros(map_y_size,map_x_size);

adjustetd_p=ones(size(p));
accepted=zeros(size(p));

j=1:N_tests;
C_N=sum(ones(1,N_tests)./[1:N_tests]);

p_vec=reshape(p(:,ref(end)+1:end-right_time_margin_px),1,N_tests);
[A, ix]=sort(p_vec);
A_a=min(A*N_tests*C_N./j,1);
A_a(ix)=A_a;
A_ar=reshape(A_a,map_y_size,(map_x_size-ref(end)-right_time_margin_px));
adjustetd_p(:,ref(end)+1:end-right_time_margin_px)=A_ar;

B=j*FDR_q/(C_N*N_tests);
C=A-B;
ix=find(C<0);
if ~isempty(ix)
    d=max(ix);
    cutoff=A(d);
else
    cutoff=0;
end
if PLOT_FDR
    figure(2)
    plot(j,A,j,B)
end
accepted(find(p<cutoff))=1;
accepted(:,1:ref(end))=0;
accepted(:,end-right_time_margin_px+1:end)=0;


% a_tmp=spm_corr(1:map_y_size,1:(map_x_size-ref(end)-right_time_margin_px));

% size(a_tmp);
% accepted=[zeros(size(p(:,1:ref(end)))) a_tmp zeros(size( p(:,end-right_time_margin_px+1:end) ) )];

