function r(config)
% estimating probability maps - free parameters:
%
% map calculation:
% MP, SP
% energy scale: log, sqrt, linear
% probability assesment:
% 1. pseudo-T distribution from reference period only
% 2. permutation test for each point
% Correction for multiple comparisons:
% FDR, BH - stepdown Benferoni, NONE_STATS, FULL_BONFERRONI, BY_COLUMN

if nargin==0
%config='configuration';
config='config_JG_DD';
%config='config_jar2500';
end
disp(config)

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% FIRST READ DATA-SPECIFIC CONFIG -- m-file in current dir
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
eval(config);
[pathstr,fname,ext,versn] = fileparts(bookname);
name=sprintf('%s%s%.2fx%.2f_%.0f-%.0fs%.0f-%.0fHz', fname, MAP_TYPE, dt, df, tmin, tmax, f_min, f_max);
disp(name);
addpath('m'); % PATH TO wignermap.m, calculate_maps_MP.m, ...

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% CALCULATING MAPS OF ENERGY DENSITY 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
switch MAP_TYPE
case 'MP'
    [mapa, t, f] =calculate_maps_MP(config, name);
    [av_map_max_res, t_max_res, f_max_res] =calculate_maps_MP(config, name, 1);
case 'SP'
    [mapa, t, f] =calculate_maps_specgram(config, name);
otherwise
    error('unknown map type');
end

%%%%%%%%%%%%%%%%%%%%%%%%%
%       SQRT or LOG
%%%%%%%%%%%%%%%%%%%%%%%%
switch ENERGY_SCALE
case 'LIN'
    [];
case 'LOG'
    mapa=log((mapa+1));
case 'SQRT'
    mapa=sqrt(mapa);
otherwise
    error('unknown energy scale type');
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% 				Basic maps
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%%%%%%%%%%%%%%%%%%%%%%%%%%%% MEAN map %%%%%%%%%%%%%%%%%%%%%%%%%%%%
av_map=squeeze(mean(mapa,1)); % map of mean energy

if map_y_size==1
	av_map=av_map';
end
%%%%%%%%%%%%%%%%%%%%%%%%%%%% VAR map %%%%%%%%%%%%%%%%%%%%%%%%%%%%
%var_map=zeros(map_y_size, map_x_size);
%for t=1:map_x_size
%    for f=1:map_y_size
%        var_map(f,t)=var( mapa(:, f, t) );
%    end
%end

%%%%%%%%%%%%%%%%%%%%%%%%%%%% ERDS map %%%%%%%%%%%%%%%%%%%%%%%%%%%%
erds_map=zeros(map_y_size, map_x_size);

for f=1:map_y_size
    erds_map(f,ref)= ones(size(ref)).*mean(av_map(f,ref));
end
for t=ref(length(ref))+1:map_x_size
    for f=1:map_y_size
        erds_map(f,t)=(av_map(f,t)-erds_map(f,ref(1)))./erds_map(f,ref(1));
    end
end
for f=1:map_y_size
    erds_map(f,ref)= zeros(size(ref));% ones(size(ref)).*mean(av_map(f,ref));
    if right_time_margin_px >= 1
        erds_map(f,end-right_time_margin_px+1:end)= 0;%zeros(size(erds_map(f,end-right_time_margin_px:end));
    end
end

%%%%%%%%%%%%%%% TRANSFORM FROM XxY INTO TxF %%%%%%%%%%%%%%%
HH=zeros(Fsize, map_y_size);        %transfer matrix HH
for k=1:map_y_size
    HH((1:(Fsize/map_y_size))+Fsize/map_y_size*(k-1),k) = 1;
end
GG=zeros(map_x_size, Tsize);    %transfer matrix GG
for k=1:map_x_size
    GG(k,(1:(Tsize/map_x_size))+Tsize/map_x_size*(k-1)) = 1;
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%% 
% ERDS_max_res map 
%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if strcmp(MAP_TYPE,'MP')
    ref_max_res = ref*Tsize/map_x_size;
    right_time_margin_px_max_res = right_time_margin_px*Tsize/map_x_size;
    erds_map_max_res=zeros(Fsize, Tsize);
    for f=1:Fsize
        erds_map_max_res(f,ref_max_res)= ones(size(ref_max_res)).*mean(av_map_max_res(f,ref_max_res));
    end
    for t=ref_max_res(length(ref_max_res))+1:Tsize
        for f=1:Fsize
            erds_map_max_res(f,t)=(av_map_max_res(f,t)-erds_map_max_res(f,ref_max_res(1)))./erds_map_max_res(f,ref_max_res(1));
        end
    end
    for f=1:Fsize
        erds_map_max_res(f,ref_max_res)= zeros(size(ref_max_res));% ones(size(ref)).*mean(av_map(f,ref));
        if right_time_margin_px >= 1
            erds_map_max_res(f,end-right_time_margin_px_max_res+1:end)= 0;%zeros(size(erds_map(f,end-right_time_margin_px:end));
        end
    end
    
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%		STATISTICS
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%% CALCULATING P %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%[pathstr,fname,ext,versn] = fileparts(bookname);
%name=sprintf('calc_p/%s_%.2fx%.2f_%s_%s', fname, dt, df, MAP_TYPE, lower(ENERGY_SCALE));

switch STATISTICS
case 'NONE_STAT'
    MULTIPLE_TEST_CORRECTION='NONE';
    p=[];
case 'PSEUDO_T'
    p=p_pseudoT(mapa, config, name);
case 'PERM_TEST'
    p=p_perm_test(mapa, config, name);
otherwise
    error('unknown statistics')
end
p(:,ref)=ones(size(p(:,ref)));

%%%%%%%%%%%%%%% multiple tests correction & cutoff %%%%%%%%%%%%%
switch MULTIPLE_TEST_CORRECTION
case 'NONE'
     ;
case 'NONE_CORR'
    eff_p = p_level;
    accepted = p<eff_p;
case 'BY_COLUMN'
    eff_p = p_level/map_y_size;
    accepted = p<eff_p;
    adjustetd_p=p/map_y_size;
case 'FULL_BONFERRONI'
    N_tests=map_y_size * ( map_x_size-ref(end) )
    eff_p = p_level/N_tests;
    accepted = p<eff_p;
    adjustetd_p=p/N_tests;
case 'BH'
    [accepted, adjustetd_p, eff_p]=multiple_test_BH_correction(p,config);
case 'FDR'
    [accepted, adjustetd_p, eff_p]=multiple_test_FDR_correction(p,config);
otherwise
    error('unknown multiple test correction method')
end
if ~isempty(p)
    accepted(:,ref)=ones(size(p(:,ref)));
else
    accepted=[];
end
%disp( sprintf('Effective p: p< %f in %s',eff_p, MULTIPLE_TEST_CORRECTION))


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% DISPLAY %%%%%%%%%%%%%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%


%%LABELS
fticklabels=f_min :(f_max-f_min)/numfreq:f_max;
ftick=0:map_y_size/numfreq:map_y_size;
tticklabels=tmin:(tmax-tmin)/num_time:tmax;
ttick=0:map_x_size/num_time:map_x_size;
ftick=ftick+0.5;
ttick=ttick+0.5;
test_tticklabels=ref_sec(2):(tmax-tmin)/num_time:tmax-right_time_margin;
test_ttick=0:map_x_size/num_time:map_x_size-right_time_margin_px-ref(end)-1;
test_ttick=test_ttick+0.5;
%%LABELS max res
fticklabels_max_res=fticklabels;
ftick_max_res=(ftick-0.5)*Fsize/map_y_size;
ftick_max_res=ftick_max_res+0.5;
tticklabels_max_res=tticklabels;
ttick_max_res=(ttick-0.5)*Tsize/map_x_size;
ttick_max_res=ttick_max_res+0.5;
test_tticklabels_max_res=test_tticklabels;
test_ttick_max_res=(test_ttick-.5)*Tsize/map_x_size;
test_ttick_max_res=test_ttick_max_res+0.5;


figure(1)
%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%    PLOT MAPY SREDNIEJ MAX_RES
%%%%%%%%%%%%%%%%%%%%%%%%%%%%
[xx, a_name, xx, xx]=fileparts(name); 
sbp=0;

if strcmp(MAP_TYPE,'MP')
    sbp=sbp+1;
    subplot(NS,NSx,sbp);
    imagesc(log(1+av_map_max_res));
    set(gca,'ydir','normal');
    set(gca,'xtick', ttick_max_res, 'xticklabel', tticklabels_max_res, 'ytick', ftick_max_res, 'yticklabel', fticklabels_max_res);
    if FULL_PRES
        title(sprintf('av. energy (log) of %d trials', N));
    else
        title(sprintf('%s/log', a_name),'interpreter','none');
    end
    line([ref(1)-1 ref(1)-1]*Tsize/map_x_size, 2*[0 maxF-minF]/df ,'Color',[0 0 0])
    line([ref(end) ref(end)]*Tsize/map_x_size, 2*[0 maxF-minF]/df ,'Color',[0 0 0])
    line([map_x_size-right_time_margin_px map_x_size-right_time_margin_px]*Tsize/map_x_size+0.5, 2*[0 maxF-minF]/df ,'Color',[0 0 0]);
    set(gca,'tickdir','out');
    ylabel(sprintf('%c)',char(96+sbp)),'rotation', 0);
end


%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% calc. ERDS stuff
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ERS_extr=max(max(erds_map)); % tu mozna podac min i max ERDS z configa
ERD_extr=min(min(erds_map));
ERS_extr=max([ERS_extr, 0.01]);
ERD_extr=min([ERD_extr, -0.01]);
scala=max(ERS_extr, abs(ERD_extr));
erds_map_sc=erds_map;  
erds_map_sc(find(erds_map>0))=erds_map(find(erds_map>0))/ERS_extr*100; % w %
erds_map_sc(find(erds_map<=0))=erds_map(find(erds_map<=0))/abs(ERD_extr)*100; % w %
test_erds_map_sc=erds_map_sc(:,ref(end)+1:map_x_size-right_time_margin_px);
CLIM = [-100 100];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%    PLOT MAPY SREDNIEJ
%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if strcmp(MAP_TYPE,'SP') | FULL_PRES
    sbp=sbp+1;
    subplot(NS,NSx,sbp);
    imagesc(log(1+av_map));				
    set(gca,'ydir','normal','xtick', ttick, 'xticklabel', tticklabels, 'ytick', ftick, 'yticklabel', fticklabels);
    title(sprintf('%s/log', a_name),'interpreter','none');
    line([ref(1) ref(1)]-0.5,[f_min f_max]/df+0.5 ,'Color',[0 0 0])
    line([ref(end) ref(end)]+0.5,[f_min f_max]/df+0.5 ,'Color',[0 0 0])
    line([map_x_size-right_time_margin_px map_x_size-right_time_margin_px]+0.5,[f_min f_max]/df+0.5 ,'Color',[0 0 0])
    set(gca,'tickdir','out');
    ylabel(sprintf('%c)',char(96+sbp)),'rotation', 0);
    
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % PLOT MAPY ERD/S
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%
    if FULL_PRES~=-1
       sbp=sbp+1;
       subplot(NS,NSx,sbp);
       CLIM = [-100 100];
       imagesc(test_erds_map_sc,CLIM);
       set(gca,'ydir', 'normal','xtick', test_ttick, 'xticklabel', test_tticklabels, 'ytick', ftick, 'yticklabel', fticklabels);
       h=colorbar;
       set(h,'YTick',[-100 -50 0 50 100]);
       set(h,'YTicklabel',round(100*[ERD_extr ERD_extr/2 0 ERS_extr/2 ERS_extr]));
       set(h,'Xtick',[1],'XTicklabel','%');
       title(sprintf('av. ERD/ERS of %d trials', N));
       set(gca,'tickdir','out');
       ylabel(sprintf('%c)',char(96+sbp)),'rotation', 0);
    end
    
end

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% IF SIGNIFICANT CHANGES WERE FOUND
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if ~isempty(accepted)
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    % PLOT MAPY ACCEPTED ERDS
    %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
    if strcmp(MAP_TYPE,'SP') | FULL_PRES
        sbp=sbp+1;
        subplot(NS,NSx,sbp);
        tested_ERD_S_map=accepted.*erds_map_sc;
        tested_ERD_S_map=tested_ERD_S_map(:,ref(end)+1:map_x_size-right_time_margin_px);
        imagesc(tested_ERD_S_map,CLIM);
        set(gca,'ydir','normal');
        set(gca,'xtick', test_ttick, 'xticklabel', test_tticklabels, 'ytick', ftick, 'yticklabel', fticklabels);
        title(sprintf('ERD/S av. in %d', N));
        h=colorbar;
        set(h,'YTick',[-100 -50 0 50 100]);
        set(h,'YTicklabel',round(100*[ERD_extr ERD_extr/2 0 ERS_extr/2 ERS_extr]));
        set(h,'Xtick',[1],'XTicklabel','%');
        title(sprintf('%s#%.0e; %s:p<%.0g',  STATISTICS, Npseudot, MULTIPLE_TEST_CORRECTION, eff_p), 'interpreter', 'none');
        set(gca,'tickdir','out');
        ylabel(sprintf('%c)',char(96+sbp)),'rotation', 0);
    end
    
    if strcmp(MAP_TYPE,'MP')    
        ERS_extr_max_res=max(max(erds_map_max_res)); % tu mozna podac min i max ERDS z configa
        ERD_extr_max_res=min(min(erds_map_max_res));
        ERS_extr_max_res=max([ERS_extr_max_res, 0.01]);
        ERD_extr_max_res=min([ERD_extr_max_res, -0.01]);
        scala_max_res=max(ERS_extr_max_res, abs(ERD_extr_max_res));
        CLIM = [-100 100];
        erds_map_sc_max_res=erds_map_max_res;  
        erds_map_sc_max_res(find(erds_map_max_res>0))=erds_map_max_res(find(erds_map_max_res>0))/ERS_extr_max_res*100; % w %
        erds_map_sc_max_res(find(erds_map_max_res<=0))=erds_map_max_res(find(erds_map_max_res<=0))/abs(ERD_extr_max_res)*100; % w %
        %accepted matrix in maximum resolution
        accepted_max_res = HH*accepted*GG;
        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % PLOT MAPY ERDS_MAX_RES
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        sbp=sbp+1;subplot(NS,NSx,sbp);
        mm=erds_map_sc_max_res(:,ref_max_res(end)+1:Tsize-right_time_margin_px_max_res);
        imagesc(mm,CLIM);
        set(gca,'ydir','normal');
        set(gca,'xtick', test_ttick_max_res, 'xticklabel', test_tticklabels_max_res, 'ytick', ftick_max_res, 'yticklabel', fticklabels_max_res);
        if FULL_PRES
            title(sprintf('ERD/ERS in high res.'));
        else
            title(sprintf('av. ERD/ERS of %d trials', N));
        end
        h=colorbar;
        set(h,'YTick',[-100 -50 0 50 100]);
        set(h,'YTicklabel',round(100*[ERD_extr_max_res ERD_extr_max_res/2 0 ERS_extr_max_res/2 ERS_extr_max_res]));
        set(h,'Xtick',[1],'XTicklabel','%');
        set(gca,'tickdir','out');
        ylabel(sprintf('%c)',char(96+sbp)),'rotation', 0);
        
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        % PLOT MAPY accepted ERDS_MAX_RES
        %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
        sbp=sbp+1;subplot(NS,NSx,sbp);
        tested_ERDS_map_max_res=accepted_max_res.*erds_map_sc_max_res;
        tested_ERDS_map_max_res=tested_ERDS_map_max_res(:,ref_max_res(end)+1:Tsize-right_time_margin_px_max_res);
        imagesc(tested_ERDS_map_max_res,CLIM);
        set(gca,'ydir','normal');
        set(gca,'xtick', test_ttick_max_res, 'xticklabel', test_tticklabels_max_res, 'ytick', ftick_max_res, 'yticklabel', fticklabels_max_res);
        title(sprintf('ERD/S max_res av. in %d', N));
        h=colorbar;
        set(h,'YTick',[-100 -50 0 50 100]);
        set(h,'YTicklabel',round(100*[ERD_extr_max_res ERD_extr_max_res/2 0 ERS_extr_max_res/2 ERS_extr_max_res]));
        set(h,'Xtick',[1],'XTicklabel','%');
        if FULL_PRES
            title('stat. significant ERD/S');
        else
            title(sprintf('%s#%.0e; %s:p<%.0g',  STATISTICS, Npseudot, MULTIPLE_TEST_CORRECTION, eff_p), 'interpreter', 'none');
        end
        set(gca,'tickdir','out');
        ylabel(sprintf('%c)',char(96+sbp)),'rotation', 0);
    end
    
end


%PRINTING
%prname=sprintf('fig/%s_%s%s.eps', name, STATISTICS, MULTIPLE_TEST_CORRECTION);
%%set(gcf, 'paperposition', [1 1 18 8]);
%print('-depsc', prname);

%%%3D
%figure(2);
%surfl(tested_ERDS_map_max_res);caxis([-scala scala]);
%shading interp;set(gca,'view', [-9 68]); axis off;colormap(gray);

