unit Calibdlg;  { Kalibracja dodatkowo 1997 09 28 }

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, Dialogs, SysUtils;

type
  TCalibDialog = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    Label1: TLabel;
    CalibEdit: TEdit;
  private
    { Private declarations }

  public
    { Public declarations }
    function Execute(var CalibConst : single) : boolean;
  end;

var
  CalibDialog: TCalibDialog;

implementation

{$R *.DFM}

function TCalibDialog.Execute(var CalibConst : single) : boolean;
  var
    NewCalib : single;
    napis    : string;
    Code     : integer;

begin
  str(CalibConst:5:3,napis);
  CalibEdit.Text:=napis;
  Result:=false;
  try Result:=(ShowModal=mrOK);
  finally
    if Result then
      begin
        val(CalibEdit.Text,NewCalib,Code);
        if Code<>0 then
          MessageDlg('Error at position: '+IntToStr(Code),mtError,[mbOk],0)
        else if NewCalib<=0.0 then
          MessageDlg('Bad calibration value !',mtError,[mbOk],0)
        else CalibConst:=NewCalib;
      end;
  end;
end;

end.
