unit Chnfft;     { 1997 07 20 }

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, FFT, FIRST;

const
  MaxSegSize=1024;
  MaxImageSize=1024;   { Musi byc wieksze od rozmiru okna !!!!! }
  MaxSegment=16;

type
  ChnFFTTable=array[1..MaxSegSize] of single;

  TChannelFFT = class(TForm)
    Panel1: TPanel;
    Edit1: TEdit;
    Label1: TLabel;
    BitBtn1: TBitBtn;
    Edit2: TEdit;
    Label2: TLabel;
    LogBox: TCheckBox;
    ScrollBox1: TScrollBox;
    ChnFFTImage: TImage;
    procedure BitBtn1Click(Sender: TObject);
    procedure CreateChnFFT(Sender: TObject);
    procedure OnShowChnFFT(Sender: TObject);
    procedure ImageFFTOnMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure PaintChnFFT(Sender: TObject);
    procedure SetLogScale(Sender: TObject);
    procedure ChnFFTOnKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);

  private
    { Private declarations }
    Spect,SpectLn  : array[1..MaxImageSize] of single;
    LogStat        : boolean;

  public
    { Public declarations }
    ActiveChnFFT : boolean;
    MaxSeg       : integer;
    SampFreq     : single;
    pointsPerSeg : integer;
    ChnSigTab    : ChnFFTTable;

    procedure ComputeSeg(n : integer);
    procedure DrawSpectrum;
  end;

var
  ChannelFFT: TChannelFFT;

implementation

{$R *.DFM}
type
  ImageTable=array[1..MaxImageSize] of single;
  IntTable=array[1..MaxImageSize] of integer;


function Modulus(a,b : single) : single;
begin
  Modulus:=sqrt(sqr(a)+sqr(b));
end;

procedure TChannelFFT.ComputeSeg(n : integer);
 var
   tmp        : ^TWOFFT;
   B          : boolean;
   i,itmp     : integer;
   facm,facp  : single;
   FFTLen     : integer;
   scale,ftmp : single;
   imageSize  : integer;
   Start,Stop : integer;

begin                  { Modyfikacja 1998 02 21 }
   B:=MemInit(tmp,sizeOf(TWOFFT));
   if not B then
     exit;

   ImageSize:=ChnFFTImage.Width;
   FFTlen:=SetLenFFT(pointsPerSeg);
   for i:=1 to 2*FFTLen do
     tmp^[i]:=0.0;

   facm:=FFTLen-0.5;
   facp:=1.0/(FFTLen+0.5);

   for i:=1 to FFTLen do
    begin
      tmp^[2*i-1]:=ChnSigTab[i]*window(2*i-1,facm,facp,PARZEN);
      tmp^[2*i]:=0.0;
    end;

   four1(tmp^,FFTLen,1);

   scale:=ImageSize/(MaxSeg*0.5*FFTLen);
   Start:=round(scale*0.5*n*FFTLen);
   Stop:=round(scale*0.5*(n+1)*FFTLen);

   for i:=1 to (FFTLen div 2) do
    begin
      itmp:=round(scale*(0.5*n*FFTLen+i));
      if itmp<1 then itmp:=1;
      if itmp>ImageSize then itmp:=ImageSize;
      ftmp:=Modulus(tmp^[2*i-1],tmp^[2*i]);

      if (itmp>Start) and (itmp<=Stop) then
         Spect[itmp]:=ftmp;
    end;

   for i:=Start+1 to Stop do
    if i<=MaxImageSize then
      SpectLn[i]:=ln(AbsLevel+Spect[i]);

   MemFree(tmp,sizeOf(TWOFFT));
end;

procedure TChannelFFT.DrawSpectrum;
  var
    i               : integer;
    Pmax,scale,Pmin : single;
    MHeight,MWidth   : integer;

begin
 MHeight:=ChnFFTImage.Height;
 MWidth:=ChnFFTImage.Width;
 if MWidth>MaxImageSize then
   MWidth:=MaxImageSize;

 with ChnFFTImage,ChnFFTImage.Canvas do
  begin
   pen.Color:=clRed;
   if LogStat then
     begin
       Pmax:=SpectLn[1];
       Pmin:=SpectLn[1];
       for i:=1 to MWidth do
        begin
         if Pmax<SpectLn[i] then Pmax:=SpectLn[i];
         if Pmin>SpectLn[i] then Pmin:=SpectLn[i];
        end;

       if Pmax<>Pmin then
         scale:=Height/(Pmax-Pmin)
       else
         scale:=1.0;

       MoveTo(1,MHeight-round(scale*(SpectLn[1]-Pmin)));
       for i:=2 to MWidth do
         LineTo(i,MHeight-round(scale*(SpectLn[i]-Pmin)));
     end
   else
     begin
       Pmax:=Spect[1];
       for i:=1 to MWidth do
         if Pmax<Spect[i] then Pmax:=Spect[i];

      if Pmax<>0.0 then
        scale:=MHeight/Pmax
      else
        scale:=1.0;

      MoveTo(1,MHeight-round(scale*Spect[1]));
      for i:=2 to MWidth do
        LineTo(i,MHeight-round(scale*Spect[i]));
     end;
  end;
end;

procedure TChannelFFT.BitBtn1Click(Sender: TObject);
begin
   ActiveChnFFT:=false;
   Close;
end;

procedure TChannelFFT.CreateChnFFT(Sender: TObject);
  var
    i : integer;

begin
  ActiveChnFFT:=false;
  MaxSeg:=8;
  SampFreq:=102.4;
  PointsPerSeg:=256;
  LogStat:=true;
  LogBox.Checked:=LogStat;
  ScrollBox1.HorzScrollBar.Range:=ChnFFTImage.Width;
  for i:=1 to MaxSegSize do
    ChnSigTab[i]:=0.0;
  for i:=1 to MaxImageSize do
    begin
      Spect[i]:=0.0;
      SpectLn[i]:=0.0;
    end;
end;

procedure TChannelFFT.OnShowChnFFT(Sender: TObject);
begin
   ActiveChnFFT:=true;
end;

procedure TChannelFFT.ImageFFTOnMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
 var
   t1,t2,freq         : string;
   seg,freqVal,PPS    : integer;

begin
  with ChnFFTImage do                { Pozycja w widmie kanalu }
    begin
      PPS:=Width div MaxSeg;
      seg:=X div PPS;
      freqVal:=X mod PPS;
      str(0.5*freqVal*SampFreq/PPS:5:2,freq);
      Edit1.Text:='     '+freq;
      str(PointsPerSeg*seg/SampFreq:3:2,t1);
      str(PointsPerSeg*(seg+1)/SampFreq:3:2,t2);
      Edit2.Text:='  '+t1+' - '+t2;
    end;
end;

procedure TChannelFFT.PaintChnFFT(Sender: TObject);
  var
    i         : integer;
    scale     : single;
    tmpTab    : array[0..10] of single;
    napis     : string;
    Pmin,Pmax : single;
    itmp      : integer;
    OldStyle  : TBrushStyle;

begin
 if not ActiveChnFFT then
   exit;

 with ChannelFFT do
   begin
     font.Color:=clBlue;
     if LogStat then
       font.size:=5
     else
       font.size:=6;
     font.Name:='Times New Roman CE';
     font.Style:=[fsBold];
     Canvas.Brush.Color:=clLtGray;
   end;

  with ChnFFTImage,ChnFFTImage.Canvas do
   begin
     pen.Color:=clBlack;
     brush.Color:=clWhite;
     rectangle(0,0,Width,Height);
     pen.Color:=clLtGray;

     if not LogStat then
      for i:=1 to 10 do
       begin
         itmp:=Height-round(0.10*Height*i);
         moveTo(0,itmp);
         lineTo(Width,itmp);

         Str(10*i:3,napis);    { Opis osi }
         if i<>0 then
           ChannelFFT.Canvas.TextOut(15,itmp,napis);
        end
      else                     { Skala pseudo-logarytmiczna }
        begin
          for i:=0 to 10 do
            tmpTab[i]:=ln(AbsLevel+0.1*i);

          Pmin:=tmpTab[0];     { Rysowanie skali logarytmicznej }
          Pmax:=tmpTab[10];
          scale:=Height/(Pmax-Pmin);
          for i:=1 to 10 do
           begin
             itmp:=Height-round(scale*(tmpTab[i]-Pmin));
             moveTo(0,itmp);
             lineTo(Width,itmp);

             Str(10.0*i:3:0,napis);          { Opis osi }
             if i<>0 then
              ChannelFFT.Canvas.TextOut(15,itmp+3,napis);
            end;
        end;

        DrawSpectrum;                        { Rysowanie widma }
        pen.Color:=clBlue;
        scale:=Width/MaxSeg;
        for i:=1 to MaxSeg-1 do              { Separacja widm czastkowych }
         begin
           MoveTo(round(scale*i),0);
           LineTo(round(scale*i),Height);
         end;

        pen.Color:=clBlack;
        OldStyle:=brush.Style;
        brush.Style:=bsClear;
        rectangle(0,0,Width,Height);
        brush.Style:=OldStyle;
   end;
end;

procedure TChannelFFT.SetLogScale(Sender: TObject);
begin
   if LogBox.Checked then { Skala logarytmiczna }
    LogStat:=true
  else
    LogStat:=false;

  Repaint;
end;

procedure TChannelFFT.ChnFFTOnKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
   poz,maxpoz : integer;

begin
  poz:=ScrollBox1.HorzScrollBar.Position;
  maxpoz:=ScrollBox1.HorzScrollBar.Range;
  if Key=VK_ESCAPE then
    BitBtn1Click(Sender)
  else if Key=VK_ADD then
         begin
           poz:=poz+ChnFFTImage.Width;
           if poz>maxpoz then poz:=MaxPoz;
           ScrollBox1.HorzScrollBar.Position:=poz;
         end
  else if Key=VK_SUBTRACT then
         begin
           poz:=poz-ChnFFTImage.Width;
           if poz<0 then poz:=0;
           ScrollBox1.HorzScrollBar.Position:=poz;
         end;
end;


end.
