unit DDVGOTO;

interface

uses  WinTypes, WinProcs, SysUtils, Classes,  Graphics, Forms,    Controls,
      Buttons,  StdCtrls, ExtCtrls,
      FIRST,    DDVINI;

type  TGoToDialog = class(TForm)
                     Bevel:          TBevel;
                     LabelPageNo:    TLabel;
                     ComboBoxPageNo: TComboBox;
                     BtnOK:          TBitBtn;
                     BtnCancel:      TBitBtn;
                     procedure FormCreate(Sender: TObject);
                    private { Private declarations }
                    public { Public declarations }
                     function  Execute(var PageNo: Word;
                                       Min, Max: Word): Boolean;
                    end;

var   GoToDialog: TGoToDialog;

implementation

{$R *.DFM}

                                                                  { FormCreate }
procedure TGoToDialog.FormCreate(Sender: TObject);
begin
 ComboBoxPageNo.DropDownCount:=MaxHistory;
 LoadHistory(MainIniFileName,HstPagSec,ComboBoxPageNo.Items)
end;
                                                                     { Execute }
function TGoToDialog.Execute(var PageNo: Word; Min, Max: Word): Boolean;
 var P: string;
begin
 Result:=false;
 ComboBoxPageNo.Text:=SN(PageNo,0); ActiveControl:=ComboBoxPageNo;
 try Result:=ShowModal=mrOK;
 finally
  if Result then
   begin
    P:=ComboBoxPageNo.Text; CleanStr(P,'01234567890');
    PageNo:=StrToIntDef(P,0);
    if PageNo<Min then PageNo:=Min else if PageNo>Max then PageNo:=Max; 
    ComboBoxPageNo.Text:=SN(PageNo,0);
    UpdateHistory(ComboBoxPageNo.Text,ComboBoxPageNo.Items,ecNormal);
    SaveHistory(MainIniFileName,HstPagSec,ComboBoxPageNo.Items)
   end
 end
end;

end. { DDVGOTO }
