unit  DDVINSTR;

interface

uses  WinTypes, WinProcs, SysUtils, Controls, Dialogs,  IniFiles,
      FIRST,    DDVINI,   DDVAPDLG, PEGTAIL, EXTHEAD, FILTFFT;

const MaxChannels           = 64;        { Mozliwosc zmiany na 99 }
                                         { trzeba zmieniac przy oknie dialogowym
                                           montarzy 1998 02 27 }
      MinBufferSmps: Word   = 64;
      MaxSizeOfCBUnit       = SizeOf(ShortInt)+SizeOf(Integer);

      MaxSampsPerPage: Word = 10240;                         { zweryfikowac ~~~}

      LablLen               = 5;
      HintLen               = 20;

type  TWBuf     = array[1..MaxSize div SizeOf(Word)] of Word;
      TIBuf     = array[1..MaxSize div SizeOf(Integer)] of Integer;
      TBBuf     = array[1..MaxSize] of Byte;

      TWBufPtr  = ^TWBuf;
      TIBufPtr  = ^TIBuf;
      TBBufPtr  = ^TBBuf;

      TMontRec  = record
                   Channel: Byte;
                   Labl:    string[LablLen];
                   Hint:    string[HintLen];
                   M:       Integer;
                   D:       Integer;
                   Refs:    array[1..MaxChannels] of Boolean
                  end;


      TMontTab  = array[1..MaxChannels] of TMontRec;

      TMontage  = class
                  private
                   FItems:    TMontTab;
                   FChannels: Byte;
                   FDefault:  Boolean;
                   procedure CheckChannel(Channel: Byte);
                   function  GetItems(Ch: Byte): TMontRec;
                   procedure SetItems(Ch: Byte; const Value: TMontRec);
                   function  GetChannel(Ch: Byte): Byte;
                   procedure SetChannel(Ch: Byte; Value: Byte);
                   function  GetLabl(Ch: Byte): string;
                   procedure SetLabl(Ch: Byte; const Value: string);
                   function  GetHint(Ch: Byte): string;
                   procedure SetHint(Ch: Byte; const Value: string);
                   function  GetM(Ch: Byte): Integer;
                   procedure SetM(Ch: Byte; Value: Integer);
                   function  GetD(Ch: Byte): Integer;
                   procedure SetD(Ch: Byte; Value: Integer);
                   function  GetRefs(Ch: Byte; RefCh: Byte): Boolean;
                   procedure SetRefs(Ch: Byte; RefCh: Byte; Value: Boolean);
                  public
                   constructor Create;
                   constructor Assign(SrcMontage: TMontage);

                   property    Items[Channel: Byte]: TMontRec
                               read GetItems write SetItems; default;

                   property    Channel[Ch: Byte]: Byte
                               read GetChannel write SetChannel;
                   property    Labl[Ch: Byte]: string
                               read GetLabl write SetLabl;
                   property    Hint[Ch: Byte]: string
                               read GetHint write SetHint;
                   property    M[Ch: Byte]: Integer read GetM write SetM;
                   property    D[Ch: Byte]: Integer read GetD write SetD;
                   property    Refs[Ch, RefCh: Byte]: Boolean
                               read GetRefs write SetRefs;

                   property    Channels: Byte read FChannels write FChannels;
                   property    Deflt: Boolean read FDefault write FDefault;

                   procedure   LoadOptions(const FileName: string);
                   procedure   SaveOptions(const FileName: string);
                   procedure   MoveChannel(SrcChn, DstChn: Byte);
                  end;

      TCBinHDR  = record
                   Channels,
                   SamplesInRecord,
                   FirstRecordNo,
                   Filler,
                   RecordsInFile: Word
                  end;

      TDBinHDR  = record
                   Signature:     array[1..15] of Char;
                   FType:         Char;
                   Channels:      Byte;
                   AuxChannels:   Byte;
                   SampFrq:       Word;
                   SamplesInFile: LongInt;
                   DValid:        Byte;
                   SFactor:       Byte;
                   ZeroLevel:     Integer;
                   DataOrigin:    Word;
                   XHDROrigin:    Word
                  end;

      TFInfoRec = record
                   FName: string[MaxNameLen];
                   FExt:  TFileExt;
                   FSize: LongInt
                  end;

const MaxFiles  = MaxSize div SizeOf(TFInfoRec);

type  TFTable   = array[0..Pred(MaxFiles)] of TFInfoRec;

      TiStream  = class
                  private
                   FTable:          ^TFTable;
                   FCount:          Word;
                   FSize:           LongInt;
                   FDir:            TFileName;
                   FMask:           string[MaxNameLen];

                   iFile:           Word;
                   iSize:           LongInt;
                  public { Modyfikacja: na pole publiczne 1997 06 22}
                   iChannels:       Byte;
                   iCalibConst:     single;
                   FilePath:        string;
                   FilterNumber:    integer;
                   FilterEnabled:   boolean;
                   SampFreq:        single;
                   ReLoadStatus:    boolean;
                   UsedChannels : array[1..MaxChannels] of boolean;

                  private
                   iFrameOffset:    LongInt;
                   iFrameSmps:      Word;

                   iPageOffset:     LongInt;
                   iPageSmps:       Word;
                   iPageMax:        Word;
                   iSampleBytes:    Word;
                   iBufferSmps:     Word;

                   iBufBytes:       Word;
                   iBuf:            ^TIBuf;
                   iBufPos:         Word;

                   iBinBufBytes:    Word;
                   iBinBuf:         ^TBBuf;
                   iBinBufPos:      Word;

                   iChannelTable:   array[1..MaxChannels] of ^TIBuf;

                   iSmpsReadTot:    LongInt;
                   iSmpsReadFil:    LongInt;
                   iSmpsInBuf:      LongInt;
                   iSmpsInOut:      LongInt;

                   iEoF:            Boolean;
                   FilterParam : TFilterParam; { 1998 01 21 }

                   function    SortByExt(i: Word; var S: string): Word;
                   function    SortByNum(i: Word; var S: string): Word;
                   procedure   FInfoSwap(d, u: Word);
                   procedure   CheckChannel(Channel: Byte);
                   procedure   CheckIndex(F: Integer);
                   function    GetFName(F: Integer): TFileName;
                   function    GetFSize(F: Integer): LongInt;
                   function    GetFile(F: Integer): TFInfoRec;
                   function    ChannelTableInit(Smps: Word): Boolean;
                   procedure   ChannelTableFree(Smps: Word);
                   procedure   SetPageSize(Smps: Word);
                   procedure   SetPageOffset(Offset: LongInt);
                   function    GetMatchingFiles(const Path: string): Boolean;
                   function    iOpen(NextFile: Boolean): Boolean;
                   procedure   Load(Offset: LongInt; Unconditional: Boolean);
                   function    GetBuf(Ch: Byte): TIBufPtr;
                  protected
                   procedure   DataError;
                   procedure   CheckPage;
                   function    CreateBuffers(SampleBytes,
                                             BinSampleBytes: Word): Boolean;
                   function    CreateFInfo(const Path: string;
                                           SortByNo: Boolean): Boolean;
                   function    iFileSize(const Path: string;
                                         var FSize: LongInt): Boolean;
                                         virtual; abstract;
                   function    AdjustSeekIndex(var Samples: LongInt): Boolean;
                   function    iSeek(SamplesToSkip: LongInt): Boolean;
                                     virtual; abstract;
                   procedure   CountInc(Samples: Word);
                   function    GetSamplesToRead: Word;
                   procedure   iFillBuf; virtual; abstract;
                   function    iReset: Boolean; virtual; abstract;
                   procedure   iClose; virtual; abstract;
                   procedure   SplitChannels;
                  public
                   constructor Create(Channels: Byte);
                   destructor  Destroy; override;

                   property    FileName[F: Integer]: TFileName read GetFName;
                   property    FileSize[F: Integer]: LongInt read GetFSize;
                   property    Files[F: Integer]: TFInfoRec read GetFile;
                   property    FileCount: Word read FCount;

                   property    Channels: Byte read iChannels;
                   property    Buf[Ch: Byte]: TIBufPtr read GetBuf; default;
                   property    Size: LongInt read iSize;
                   property    PageSize: Word read iPageSmps write SetPageSize;
                   property    PageOffset: LongInt read  iPageOffset
                                                   write SetPageOffset;
                   property    PageMax: Word read iPageMax;

                   function    Useful: Boolean;
                   procedure Filtracja;
                   procedure SetFilter(Min,Max,Dysp,PGain,Averg : single;
                                       Typ : TFilterTypes;
                                       status,FilterNo : integer);
                  end;


      Ti12B     = class(TiStream)
                  private
                   fi:              File;
                  protected
                   function    iFileSize(const Path: string;
                                         var FSize: LongInt): Boolean;
                                         override;
                   function    iSeek(SamplesToSkip: LongInt): Boolean; override;
                   function    iRead: Word;
                   procedure   iFillBuf; override;
                   function    iReset: Boolean; override;
                   procedure   iClose; override;
                  public
                   constructor Create(const Path: string; SortByNo: Boolean;
                               Channels: Byte);
                  end;

      TiASCII   = class(TiStream)
                  private
                   fi:              TextFile;
                  protected
                   function    iFileSize(const Path: string;
                                         var FSize: LongInt): Boolean;
                                         override;
                   function    iSeek(SamplesToSkip: LongInt): Boolean; override;
                   procedure   iFillBuf; override;
                   function    iReset: Boolean; override;
                   procedure   iClose; override;
                  public
                   constructor Create(const Path: string; SortByNo: Boolean;
                               Channels: Byte);
                  end;

      TiBin     = class(TiStream)
                  private
                   fi:              File;
                  protected
                   function    iFileSize(const Path: string;
                                         var FSize: LongInt): Boolean;
                                         override;
                   function    iSeek(SamplesToSkip: LongInt): Boolean; override;
                   procedure   iFillBuf; override;
                   function    iReset: Boolean; override;
                   procedure   iClose; override;
                  public
                   constructor Create(const Path: string; SortByNo: Boolean;
                               Channels: Byte);
                  end;
        { Dane float 1998 09 01 }
      TiFloatBin     = class(TiStream)
                  private
                   fi:              File;
                  protected
                   function    iFileSize(const Path: string;
                                         var FSize: LongInt): Boolean;
                                         override;
                   function    iSeek(SamplesToSkip: LongInt): Boolean; override;
                   procedure   iFillBuf; override;
                   function    iReset: Boolean; override;
                   procedure   iClose; override;
                  public
                   constructor Create(const Path: string; SortByNo: Boolean;
                               Channels: Byte);
                  end;

      TiPegasus = class(TiStream)   { Format PEGASUS 1997 09 20 }
                  private
                   fi:              File;
                   Header        : TPegasusHeader;   { Naglowek pliku}
                   ChnInfo       : TPegasusChnInfo;  { Kalibracje kanalow }
                   FileLen       : longint;          { Dlugosc pliku }

                  protected
                   function    iFileSize(const Path: string;
                                         var FSize: LongInt): Boolean;
                                         override;
                   function    iSeek(SamplesToSkip: LongInt): Boolean; override;
                   procedure   iFillBuf; override;
                   function    iReset: Boolean; override;
                   procedure   iClose; override;
                   function    iRead: Word;

                  public
                   PegasusOk     : boolean;       { Kontrola poprawnosci }
                   iSamplingFreq : word;          { Czestotliwosc probkowania }

                   constructor Create(const Path: string; SortByNo: Boolean;
                               Channels: Byte);
                   function GetSamplingFreq : word;
                  end;

      TiBBin    = class(TiStream)
                  private
                   iDataOffset:     Word;
                   iCounterSize:    Byte;
                   fi:              File;
                  protected
                   function    iFileSize(const Path: string;
                                         var FSize: LongInt): Boolean;
                                         override;
                   function    iSeek(SamplesToSkip: LongInt): Boolean; override;
                   function    iRead: Word;
                   procedure   iFillBuf; override;
                   function    iReset: Boolean; override;
                   procedure   iClose; override;
                  public
                   constructor Create(const Path: string; SortByNo: Boolean;
                               Channels: Byte);
                  end;

      TiCBin    = class(TiStream)
                  private
                   icExt:           TFileExt;
                   fi:              File;
                   fic:             File;
                   SampleBuffer:    array[1..MaxChannels] of Integer;
                  protected
                   function    iFileSize(const Path: string;
                                         var FSize: LongInt): Boolean;
                                         override;
                   function    iSeek(SamplesToSkip: LongInt): Boolean; override;
                   function    iRead: Word;
                   procedure   iFillBuf; override;
                   function    iReset: Boolean; override;
                   procedure   iClose; override;
                  public
                   constructor Create(const Path: string; SortByNo: Boolean;
                               Channels: Byte; AuxExt: TFileExt);
                  end;

      TiDBin    = class(TiStream)
                  private
                   iSamplingFreq:   Word;
                   iDataOffset:     Word;
                   fi:              File;
                   function    iFileSize(const Path: string;
                                         var FSize: LongInt): Boolean;
                                         override;
                   function    iSeek(SamplesToSkip: LongInt): Boolean; override;
                   procedure   iFillBuf; override;
                   function    iReset: Boolean; override;
                   procedure   iClose; override;
                  public
                   constructor Create(const Path: string; SortByNo: Boolean;
                               Channels: Byte; SamplingFreq: Word);
                  end;

      EChError  = class(Exception);
      EFTError  = class(Exception);
      EPSError  = class(Exception);
      EFFError  = class(Exception);

var   CBinHDR: TCBinHDR;
      DBinHDR: TDBinHDR;

function  ReadHDR(const Path: string; var HDR; Size: Word;
                  QuietMode: Boolean): Boolean;
function  ValidateDBinHDR(const Path: string; QuietMode: Boolean): Boolean;

implementation

const ChannelErrorTxt:   string[40] = 'Channel number out of range';
      FTableErrorTxt:    string[40] = 'Input file index out of range';
      PageSmpsErrorTxt:  string[40] = 'Input stream page size not initialized';
      NoProperFileTxt:   string[40] = 'Cannot find any data of given format.';



(****************************** OVERALL ROUTINES ******************************)
                                                                     { ReadHDR }
function ReadHDR(const Path: string; var HDR; Size: Word;
                 QuietMode: Boolean): Boolean;
 var f: File;
begin
 Result:=false; AssignFile(f,Path);
 try Reset(f,1);
  try BlockRead(f,HDR,Size); Result:=true
  finally CloseFile(f)
  end
 except on E:EInOutError do if not QuietMode then IOError(Path,E.ErrorCode)
 end
end;
                                                             { ValidateDBinHDR }
function ValidateDBinHDR(const Path: string; QuietMode: Boolean): Boolean;
begin
 Result:=ReadHDR(Path,DBinHDR,SizeOf(DBinHDR),QuietMode);
 if Result then
  begin
   Result:=DBinHDR.FType in [#0,'D'];
   if not (Result or QuietMode) then
    MessageDlg(CutPath(Path,40)+CRLF+CRLF+InvalidFilFormTxt,mtError,[mbOK],0)
  end
end;
                                                                        { GetI }
function GetI(var M): Integer;
 var I: Integer absolute M;
begin
 GetI:=I
end;
                                                                       { C3to4 }
procedure C3to4(var X, Y; L: Byte);
 var B:  array[1..MaxChannels,1..3] of Byte absolute X;
     W:  array[1..MaxChannels,1..4] of Byte absolute Y;
     i:  Byte;
begin
 for i:=1 to L div 2 do
  begin
   W[i,1]:=(B[i,1] shl 4) or (B[i,2] shr 4);
   if (B[i,1] and $80)=0 then W[i,2]:=0 else W[i,2]:=$F0;
   W[i,2]:=W[i,2] or (B[i,1] shr 4);
   W[i,3]:=B[i,3];
   if (B[i,2] and $08)=0 then W[i,4]:=0 else W[i,4]:=$F0;
   W[i,4]:=W[i,4] or (B[i,2] and $0F)
  end
end;
                                                                       { C4to3 }
procedure C4to3(var X, Y; L: Byte);
 var W: array[1..MaxChannels,1..4] of Byte absolute X;
     B: array[1..MaxChannels,1..3] of Byte absolute Y;
     i: Byte;
begin
 for i:=1 to L div 2 do
  begin
   B[i,1]:=(W[i,2] and $80) or ((W[i,2] and $07) shl 4) or (W[i,1] shr 4);
   B[i,2]:=(W[i,1] shl 4) or ((W[i,4] and $80) shr 4) or (W[i,4] and $07);
   B[i,3]:=W[i,3]
  end
end;


(******************* INPUT STREAM CREATORS AND DESTRUCTORS ********************)
                                                                      { Create }
constructor TiStream.Create(Channels: Byte);
var
  i : integer;

begin
 inherited Create;
 iChannels:=Channels;
 FilterEnabled:=false;
 FilterNumber:=1;      { Domyslny filtr }
 with FilterParam do
   begin
      RawFreqMin:=10.5;
      RawFreqMax:=16.5;
      RawFreqDysp:=1.0;
      RawFreqAverg:=15.0;
      FilterType:=Cosinus;
      FilterStatus:=1;
      Gain:=1.0;
   end;

 for i:=1 to MaxChannels do
   UsedChannels[i]:=false;
 ReLoadStatus:=false;
end;

constructor Ti12B.Create(const Path: string; SortByNo: Boolean;
                         Channels: Byte);
 var SampBytes: Word;
begin
 inherited Create(Channels);
 TFileRec(fi).Mode:=fmClosed;
 SampBytes:=(iChannels*SizeOf(Integer)*3) div 4;
 if CreateBuffers(SampBytes,SampBytes) then CreateFInfo(Path,SortByNo)
end;

constructor TiASCII.Create(const Path: string; SortByNo: Boolean;
                           Channels: Byte);
begin
 inherited Create(Channels);
 TTextRec(fi).Mode:=fmClosed;
 if CreateBuffers(0,0) then CreateFInfo(Path,SortByNo)
end;

constructor TiBin.Create(const Path: string; SortByNo: Boolean;
                         Channels: Byte);
 var SampBytes: Word;
begin
 inherited Create(Channels);
 TFileRec(fi).Mode:=fmClosed;
 SampBytes:=iChannels*SizeOf(Integer);
 if CreateBuffers(SampBytes,0) then CreateFInfo(Path,SortByNo)
end;
       { 1998 09 01 }
constructor TiFloatBin.Create(const Path: string; SortByNo: Boolean;
                         Channels: Byte);
 var SampBytes: Word;

begin
 inherited Create(Channels);
 TFileRec(fi).Mode:=fmClosed;
 SampBytes:=iChannels*SizeOf(single);
 if CreateBuffers(SampBytes,0) then CreateFInfo(Path,SortByNo)
end;

function TiPegasus.GetSamplingFreq : word;
begin        { Czestotliwosc probkowania 1997 09 20 }
  Result:=10*iSamplingFreq;
end;

constructor TiPegasus.Create(const Path: string; SortByNo: Boolean;
                         Channels: Byte);
 var
   SampBytes: Word;      { 1997 09 20 }
   i,j      : integer;
   S        : string;

begin
 inherited Create(Channels);
 PegasusOk:=ReadPegasusTail(Header,ChnInfo,Path); { Odczyt ogonka }
 FileLen:=PegasusEndOfFile;                       { Aktualna dlugosc danych }

 if PegasusOk then
  begin
   iChannels:=Header.Nch_AD;
   iSamplingFreq:=Header.Nhz;
  end
 else MessageDlg('Bad PEGASUS file format !', mtError,[mbOk], 0);

 TFileRec(fi).Mode:=fmClosed;
 SampBytes:=iChannels*SizeOf(Integer)+sizeof(integer);
 if CreateBuffers(SampBytes,SampBytes) then
   CreateFInfo(Path,SortByNo);

 if PegasusOk then
  begin
   for i:=1 to MaxChannels do     { Ladowanie inforacji o kanalach do importu }
    if i<=Header.Nch_AD then
     begin
      S:='';
      for j:=1 to 6 do
        if ChnInfo[i].K_H_Text[j]<>chr(0) then
          S:=S+ChnInfo[i].K_H_Text[j]
        else
          Break;
        ExtHeaderDlg.ChnLabels[i]:=S;
     end
    else
     ExtHeaderDlg.ChnLabels[i]:=IntToStr(i);
   end;
 end;

constructor TiBBin.Create(const Path: string; SortByNo: Boolean;
                          Channels: Byte);
 var SampBytes: Word;
begin
 inherited Create(Channels); iDataOffset:=3268; iCounterSize:=4;
 TFileRec(fi).Mode:=fmClosed;
 SampBytes:=iCounterSize+iChannels*SizeOf(Integer);
 if CreateBuffers(SampBytes,SampBytes) then CreateFInfo(Path,SortByNo)
end;

constructor TiCBin.Create(const Path: string; SortByNo: Boolean;
                          Channels: Byte; AuxExt: TFileExt);
 var SampBytes: Word;
begin
 inherited Create(Channels); icExt:=AuxExt;
 TFileRec(fi).Mode:=fmClosed; TFileRec(fic).Mode:=fmClosed;
 SampBytes:=iChannels*MaxSizeOfCBUnit;
 if CreateBuffers(SampBytes,SampBytes) then CreateFInfo(Path,SortByNo)
end;

constructor TiDBin.Create(const Path: string; SortByNo: Boolean;
                          Channels: Byte; SamplingFreq: Word);
 var SampBytes: Word;
begin
 inherited Create(Channels); iSamplingFreq:=SamplingFreq;
 TFileRec(fi).Mode:=fmClosed;
 SampBytes:=iChannels*SizeOf(Integer);
 if CreateBuffers(SampBytes,0) then CreateFInfo(Path,SortByNo)
end;
                                                                     { Destroy }
destructor TiStream.Destroy;
begin
 iClose;
 ChannelTableFree(iFrameSmps);
 MemFree(FTable,FCount*SizeOf(TFInfoRec));
 MemFree(iBinBuf,iBinBufBytes); MemFree(iBuf,iBufBytes);
 inherited Destroy
end;


(************************** ERROR CHECKING ROUTINES ***************************)
                                                                   { DataError }
procedure TiStream.DataError;
begin
 raise EFFError.Create('')
end;
                                                                   { CheckPage }
procedure TiStream.CheckPage;
begin
 if iPageSmps=0 then raise EPSError.Create(PageSmpsErrorTxt)
end;
                                                                { CheckChannel }
procedure TiStream.CheckChannel(Channel: Byte);
begin
 if (Channel=0) or (Channel>iChannels) then
  raise EChError.Create(ChannelErrorTxt)
end;
                                                                  { CheckIndex }
procedure TiStream.CheckIndex(F: Integer);
begin
 if (F<0) or (F>=FCount) then raise EFTError.Create(FTableErrorTxt)
end;


(**************************** FILE TABLE MANAGEMENT ***************************)
                                                                   { SortByExt }
function TiStream.SortByExt(i: Word; var S: string): Word;
begin
 with FTable^[i] do
  begin S:=FExt; PadStr(S,MaxExtLen,' '); AppendStr(S,FName) end;
 Result:=i
end;
                                                                   { SortByNum }
function TiStream.SortByNum(i: Word; var S: string): Word;
 const SV: string[MaxNameLen] = '';
       SC: string[MaxNameLen] = '';
 var   C:  Char;
       P:  Byte;
begin
 SV:=''; SC:='';
 with FTable^[i] do
  begin
   for P:=1 to Byte(FName[0]) do
    if FMask[P]='?' then
     begin
      C:=FName[P];
      if (C>='0') and (C<='9') then AppendStr(SV,C) else AppendStr(SC,C);
     end;
   ShrStr(SV,MaxNameLen,'0');
   S:=FExt; PadStr(S,MaxExtLen,' '); AppendStr(S,SV); AppendStr(S,SC)
  end;
 Result:=i
end;
                                                                   { FInfoSwap }
procedure TiStream.FInfoSwap(d, u: Word);
 var r: TFInfoRec;
begin
 r:=FTable^[d]; FTable^[d]:=FTable^[u]; FTable^[u]:=r
end;

                                                            { GetMatchingFiles }
function TiStream.GetMatchingFiles(const Path: string): Boolean;
 var ec: Integer;
     C:  TCursor;
     FS: LongInt;
     E:  string[Succ(MaxExtLen)];
begin
 FCount:=0; iSize:=0;
 C:=SetCursor(crHourglass); ec:=TryFindFirst(Path,true);
 try
  while (ec=0) and (FCount<MaxFiles) do with FileInfo do
   begin
    if iFileSize(FDir+Name,FS) then with FTable^[FCount] do
     begin
      FName:=ChangeFileExt(Name,'');
      E:=ExtractFileExt(Name); Delete(E,1,1); FExt:=E;
      FSize:=FS; Inc(iSize,FS);
      Inc(FCount)
     end;
    ec:=TryFindNext
   end
 finally TryFindClose; SetCursor(C)
 end;
 Result:=FCount>0;
 if not Result then
  MessageDlg(CutPath(Path,40)+CRLF+CRLF+NoProperFileTxt+
             CRLF+CRLF+PleaseVerifyTxt+NameGivenTxt,mtWarning,[mbOK],0)
end;
                                                                 { CreateFInfo }
function TiStream.CreateFInfo(const Path: string; SortByNo: Boolean): Boolean;
 var P: string;
     I: Byte;
begin
 P:=ExpandFileName(Path); FDir:=ExtractFilePath(P);
 FMask:=ExtractFileName(P); I:=Pos(FMask,'*');
 if I>0 then begin FMask[0]:=Char(Pred(I)); PadStr(FMask,MaxNameLen,'?') end;
 Result:=MemInit(FTable,MaxFiles*SizeOf(TFInfoRec)) and GetMatchingFiles(Path);
 if Result then
  begin
   Result:=MemResize(FTable,MaxFiles*SizeOf(TFInfoRec),
                            FCount*SizeOf(TFInfoRec));
   if Result then
    if SortByNo then QSort(0,Pred(FCount),SortByNum,FInfoSwap)
    else             QSort(0,Pred(FCount),SortByExt,FInfoSwap)
  end;
 if not Result then
  begin MemFree(FTable,MaxFiles*SizeOf(TFInfoRec)); FCount:=0 end
end;

                                                                    { GetFName }
function TiStream.GetFName(F: Integer): TFileName;
begin
 CheckIndex(F); Result:=FDir+FTable^[F].FName+'.'+FTable^[F].FExt
end;
                                                                    { GetFSize }
function TiStream.GetFSize(F: Integer): LongInt;
begin
 CheckIndex(F); Result:=FTable^[F].FSize
end;
                                                                     { GetFile }
function TiStream.GetFile(F: Integer): TFInfoRec;
begin
 CheckIndex(F); Result:=FTable^[F]
end;


(************************ OUTPUT PARAMETERS MANAGEMENT ************************)
                                                            { ChannelTableInit }
function TiStream.ChannelTableInit(Smps: Word): Boolean;
 var Ch: Byte;
begin
 Result:=true;
 for Ch:=1 to iChannels do
  begin
   Result:=MemInit(iChannelTable[Ch],Smps*SizeOf(Integer));
   if not Result then Break
  end;
 if not Result then ChannelTableFree(Smps)
end;
                                                            { ChannelTableFree }
procedure TiStream.ChannelTableFree(Smps: Word);
 var Ch: Byte;
begin
 for Ch:=1 to iChannels do MemFree(iChannelTable[Ch],Smps*SizeOf(Integer))
end;
                                                                 { SetPageSize }
procedure TiStream.SetPageSize(Smps: Word);
begin
 if Smps<>iPageSmps then
  begin
   ChannelTableFree(iFrameSmps); iPageSmps:=0; iFrameSmps:=0;
   if (Smps>0) and ChannelTableInit(Smps*2) then
    begin
      iPageSmps:=Smps;
      iFrameSmps:=iPageSmps*2;
      Load(iPageOffset,true);
      Filtracja;
     end
  end
end;
                                                               { SetPageOffset }
procedure TiStream.SetPageOffset(Offset: LongInt);
begin
 Load(Offset,ReLoadStatus);
 Filtracja;
end;


(****************************** INPUT FILE SIZE *******************************)
                                                                   { iFileSize }
function Ti12B.iFileSize(const Path: string; var FSize: LongInt): Boolean;
 var f: File;
begin
 FSize:=0; AssignFile(f,Path);
 try Reset(f,1);
  try FSize:=System.FileSize(f) div iSampleBytes
  finally CloseFile(f)
  end
 except on EInOutError do FSize:=0
 end;
 Result:=FSize>0
end;

function TiASCII.iFileSize(const Path: string; var FSize: LongInt): Boolean;
 var f:  TextFile;
     Ch: Byte;
     V:  Real;
begin                                          { do zmiany (TextFile->File) ~~~}
 FSize:=0; AssignFile(f,Path);
 try Reset(f);
  try
   while not SeekEoF(f) do
    begin
     for Ch:=1 to iChannels do
      begin
       if not SeekEoF(f) then
        begin Read(f,V); if Ch=iChannels then Inc(FSize) end
       else Break
      end
    end
  finally CloseFile(f)
  end
 except on EInOutError do FSize:=0
 end;
 Result:=FSize>0
end;

function TiBin.iFileSize(const Path: string; var FSize: LongInt): Boolean;
 var f: File;
begin
 FSize:=0; AssignFile(f,Path);
 try Reset(f,1);
  try FSize:=System.FileSize(f) div iSampleBytes
  finally CloseFile(f)
  end
 except on EInOutError do FSize:=0
 end;
 Result:=FSize>0
end;

function TiFloatBin.iFileSize(const Path: string; var FSize: LongInt): Boolean;
 var f: File;   { 1998 09 01 }
begin
 FSize:=0; AssignFile(f,Path);
 try Reset(f,1);
  try FSize:=System.FileSize(f) div longint(iSampleBytes);
  finally CloseFile(f)
  end
 except on EInOutError do FSize:=0
 end;
 Result:=FSize>0
end;

function TiPegasus.iFileSize(const Path: string; var FSize: LongInt): Boolean;
 var f: File;
begin        { Obliczmy dlugosc pliku 1997 09 20 }
 if not PegasusOK then
   FSize:=0
 else
   FSize:=FileLen div longint(iSampleBytes);
 Result:=FSize>0
end;

function TiBBin.iFileSize(const Path: string; var FSize: LongInt): Boolean;
 var f: File;
begin
 FSize:=0; AssignFile(f,Path);
 try Reset(f,1);
  try FSize:=(System.FileSize(f)-iDataOffset) div iSampleBytes
  finally CloseFile(f)
  end
 except on EInOutError do FSize:=0
 end;
 Result:=FSize>0
end;

function TiCBin.iFileSize(const Path: string; var FSize: LongInt): Boolean;
begin
 if ReadHDR(ChangeFileExt(Path,'.'+icExt),CBinHDR,SizeOf(CBinHDR),true) and
    (CBinHDR.Channels=iChannels) then
  FSize:=CBinHDR.SamplesInRecord*CBinHDR.RecordsInFile
 else FSize:=0;
 Result:=FSize>0
end;

function TiDBin.iFileSize(const Path: string; var FSize: LongInt): Boolean;
begin
 if ValidateDBinHDR(Path,true) and
    (DBinHDR.Channels=iChannels) and (DBinHDR.SampFrq*10=iSamplingFreq) then
  FSize:=DBinHDR.SamplesInFile
 else FSize:=0;
 Result:=FSize>0
end;


(****************************** INPUT FILE SEEK *******************************)
                                                                       { iSeek }
function TiStream.AdjustSeekIndex(var Samples: LongInt): Boolean;
 var Size: LongInt;
begin
 Size:=FTable^[iFile].FSize;
 if Samples<0 then Samples:=0 else if Samples>Size then Samples:=Size;
 Result:=Samples<Size
end;

function Ti12B.iSeek(SamplesToSkip: LongInt): Boolean;
begin
 Result:=AdjustSeekIndex(SamplesToSkip); Seek(fi,iSampleBytes*SamplesToSkip)
end;

function TiASCII.iSeek(SamplesToSkip: LongInt): Boolean;
 var SampSkipped: LongInt;
     Ch:          Byte;
     V:           Real;
begin
 Result:=AdjustSeekIndex(SamplesToSkip); iReset; SampSkipped:=0;
 while not SeekEoF(fi) and (SampSkipped<SamplesToSkip) do
  begin
   for Ch:=1 to iChannels do
    begin if SeekEoF(fi) then DataError; Read(fi,V) end;
   Inc(SampSkipped)
  end
end;

function TiBin.iSeek(SamplesToSkip: LongInt): Boolean;
begin
 Result:=AdjustSeekIndex(SamplesToSkip); Seek(fi,iSampleBytes*SamplesToSkip)
end;

function TiFloatBin.iSeek(SamplesToSkip: LongInt): Boolean;
begin { 1998 09 01 }
 Result:=AdjustSeekIndex(SamplesToSkip); Seek(fi,iSampleBytes*SamplesToSkip)
end;

function TiPegasus.iSeek(SamplesToSkip: LongInt): Boolean;
begin
 Result:=AdjustSeekIndex(SamplesToSkip); Seek(fi,iSampleBytes*SamplesToSkip)
end;

function TiBBin.iSeek(SamplesToSkip: LongInt): Boolean;
begin
 Result:=AdjustSeekIndex(SamplesToSkip);
 Seek(fi,iDataOffset+iSampleBytes*SamplesToSkip)
end;

function TiCBin.iSeek(SamplesToSkip: LongInt): Boolean;
 var RecToSkip,  RecSkipped,
     SampToSkip, SampSkipped,
     SampPos,    RecPos:      LongInt;
     Ch:                      Byte;
     BufPos,
     BytesToRead, BytesRead:  Word;
     Loop:                    Boolean;
begin
 Result:=AdjustSeekIndex(SamplesToSkip);

 with CBinHDR do
  begin
   {~~~}RecToSkip :=SamplesToSkip div SamplesInRecord;
   SampToSkip:=SamplesToSkip mod SamplesInRecord
  end;

 RecPos:=0; RecSkipped:=0; Seek(fic,SizeOf(CBinHDR));
 if RecToSkip>0 then            { read from counter file no. of bytes to skip  }
  begin                         {  (RecPos value)                              }
   repeat                       { CBinHDR is already filled by iOpen procedure }
    FillChar(iBinBuf^,iBinBufBytes,#0); BufPos:=1;
    BlockRead(fic,iBinBuf^,iBinBufBytes,BytesRead);
    while (RecSkipped<RecToSkip) and (BytesRead>=SizeOf(Word)) do
     begin
      Inc(RecPos,TWBufPtr(iBinBuf)^[BufPos]); Inc(BufPos);
      Inc(RecSkipped); Dec(BytesRead,SizeOf(Word))
     end
   until (RecSkipped=RecToSkip) or (BytesRead<SizeOf(Word));
   if RecSkipped<RecToSkip then DataError
  end;

 SampPos:=0; SampSkipped:=0;
 if SampToSkip>0 then
  begin
   BytesToRead:=iChannels*SizeOf(Integer);
   Seek(fi,RecPos); BlockRead(fi,SampleBuffer[1],BytesToRead,BytesRead);
   if BytesRead<BytesToRead then DataError;

   SampPos:=BytesToRead; SampSkipped:=1; Ch:=1; Loop:=true;
   while (SampSkipped<SampToSkip) and Loop do
    begin
     FillChar(iBinBuf^,iBinBufBytes,#0); BufPos:=1;
     Seek(fi,RecPos+SampPos); BlockRead(fi,iBinBuf^,iBinBufBytes,BytesRead);
     Loop:=BytesRead>0;
     while (SampSkipped<SampToSkip) and (BytesRead>0) do
      if iBinBuf^[BufPos]<>$80 then
       begin
        Dec(SampleBuffer[Ch],ShortInt(iBinBuf^[BufPos]));
        if Ch=iChannels then begin Ch:=1; Inc(SampSkipped) end else Inc(Ch);
        Inc(BufPos,SizeOf(ShortInt)); Inc(SampPos,SizeOf(ShortInt));
        Dec(BytesRead,SizeOf(ShortInt))
       end
      else
       if BufPos<=Succ(BytesRead)-MaxSizeOfCBUnit then
        begin
         Dec(SampleBuffer[Ch],GetI(iBinBuf^[Succ(BufPos)]));
         if Ch=iChannels then begin Ch:=1; Inc(SampSkipped) end else Inc(Ch);
         Inc(BufPos,MaxSizeOfCBUnit); Inc(SampPos,MaxSizeOfCBUnit);
         Dec(BytesRead,MaxSizeOfCBUnit)
        end
       else BytesRead:=0
    end;
   if SampSkipped<SampToSkip then DataError
  end;

 Seek(fi,RecPos+SampPos)
end;

function TiDBin.iSeek(SamplesToSkip: LongInt): Boolean;
begin
 Result:=AdjustSeekIndex(SamplesToSkip);
 Seek(fi,iDataOffset+iSampleBytes*SamplesToSkip)
end;


(*************************** CREATING INPUT BUFFERS ***************************)
                                                               { CreateBuffers }
function TiStream.CreateBuffers(SampleBytes, BinSampleBytes: Word): Boolean;
 var MaxSmps:    Word;
     BufferSmps: LongInt;
begin
 iSampleBytes:=SampleBytes;

 SampleBytes:=iChannels*SizeOf(Integer); MaxSmps:=MaxSize div SampleBytes;

 if (BinSampleBytes>0) and (MaxSmps>MaxSize div BinSampleBytes) then
  MaxSmps:=MaxSize div BinSampleBytes;

 BufferSmps:=MaxAvail div (SampleBytes+BinSampleBytes);
 if BufferSmps>MaxSmps then BufferSmps:=MaxSmps;
 if BufferSmps<MinBufferSmps then BufferSmps:=MinBufferSmps;
 if BufferSmps<2 then BufferSmps:=2;

 iBufferSmps:=BufferSmps;

 iBufBytes:=iBufferSmps*SampleBytes; iBinBufBytes:=iBufferSmps*BinSampleBytes;
 Result:=MemInit(iBuf,iBufBytes) and
         ((iBinBufBytes=0) or MemInit(iBinBuf,iBinBufBytes));
 if not Result then
  begin MemFree(iBuf,iBufBytes); MemFree(iBinBuf,iBinBufBytes) end
end;


(**************************** LOADING INPUT BUFFERS ***************************)
                                                                    { iFillBuf }
procedure TiStream.CountInc(Samples: Word);
begin
 Inc(iSmpsReadTot,Samples); Inc(iSmpsReadFil,Samples);
 Inc(iSmpsInBuf,Samples);   iEoF:=iSmpsReadFil=FTable^[iFile].FSize
end;

function TiStream.GetSamplesToRead: Word;
begin
 Result:=iBufferSmps-iSmpsInBuf;
 if iSmpsReadTot+Result>iFrameOffset+iFrameSmps then
  Result:=iFrameOffset+iFrameSmps-iSmpsReadTot;
 if iSmpsReadFil+Result>FTable^[iFile].FSize then
  Result:=FTable^[iFile].FSize-iSmpsReadFil
end;

function Ti12B.iRead: Word;
begin
 FillChar(iBinBuf^,iBinBufBytes,#0); iBinBufPos:=1;
 BlockRead(fi,iBinBuf^[iBinBufPos],GetSamplesToRead*iSampleBytes,Result)
end;

function TiBBin.iRead: Word;
begin
 FillChar(iBinBuf^,iBinBufBytes,#0); iBinBufPos:=1;
 BlockRead(fi,iBinBuf^[iBinBufPos],GetSamplesToRead*iSampleBytes,Result)
end;

function TiPegasus.iRead: Word;
begin
 FillChar(iBinBuf^,iBinBufBytes,#0); iBinBufPos:=1;
 BlockRead(fi,iBinBuf^[iBinBufPos],GetSamplesToRead*iSampleBytes,Result)
end;


function TiCBin.iRead: Word;
begin
 FillChar(iBinBuf^,iBinBufBytes,#0); iBinBufPos:=1;
 BlockRead(fi,iBinBuf^[iBinBufPos],GetSamplesToRead*iSampleBytes,Result)
end;

procedure Ti12B.iFillBuf;
 var S, SmpsRead: Word;
begin
 SmpsRead:=iRead div iSampleBytes; if SmpsRead=0 then DataError;
 for S:=1 to SmpsRead do
  begin
   C3to4(iBinBuf^[iBinBufPos],iBuf^[iBufPos],iChannels);
   Inc(iBinBufPos,iSampleBytes); Inc(iBufPos,iChannels)
  end;
 CountInc(SmpsRead)
end;

procedure TiASCII.iFillBuf;
 var SmpsRead,
     SmpsToRead: Word;
     Ch:         Byte;
     V:          Real;
begin
 SmpsToRead:=GetSamplesToRead; SmpsRead:=0;
 while not SeekEoF(fi) and (SmpsRead<SmpsToRead) do
  begin
   for Ch:={0}1 to {Pred(}iChannels{)} do
    begin
     if SeekEoF(fi) then DataError; Read(fi,V);
     iBuf^[iSmpsInBuf*iChannels+Ch]:=Round(V)
    end;
   Inc(SmpsRead); CountInc(1)
  end
end;

procedure TiBin.iFillBuf;
 var BytesRead, SmpsRead: Word;
begin
 BlockRead(fi,iBuf^[iBufPos],GetSamplesToRead*iSampleBytes,BytesRead);
 SmpsRead:=BytesRead div iSampleBytes; if SmpsRead=0 then DataError;
 Inc(iBufPos,SmpsRead*iChannels);
 CountInc(SmpsRead)
end;

procedure TiFloatBin.iFillBuf; { 1998 09 01 *** }
 var SmpsRead,
     SmpsToRead: Word;
     Ch:         Byte;
     V:          single;
     OKRead,BlockSize : word;
     buffor           : array[1..MaxChannels] of single;

begin
 SmpsToRead:=GetSamplesToRead; SmpsRead:=0;
 BlockSize:=sizeof(single)*iChannels;
 while (SmpsRead<SmpsToRead) do
  begin
   BlockRead(fi,buffor,BlockSize,OKRead);
   if OKRead<>BlockSize then DataError;
   for Ch:=1 to iChannels do
      iBuf^[iSmpsInBuf*iChannels+Ch]:=Round(buffor[Ch]);
   Inc(SmpsRead); CountInc(1)
  end
end;

procedure TiBBin.iFillBuf;
 var S, SmpsRead: Word;
begin
 SmpsRead:=iRead div iSampleBytes; if SmpsRead=0 then DataError;
 for S:=1 to SmpsRead do
  begin
   Move(iBinBuf^[iBinBufPos+iCounterSize],iBuf^[iBufPos],
        iChannels*SizeOf(Integer));
   Inc(iBinBufPos,iSampleBytes); Inc(iBufPos,iChannels)
  end;
 CountInc(SmpsRead)
end;

procedure TiPegasus.iFillBuf;
 var S, SmpsRead: Word;
begin
 SmpsRead:=iRead div iSampleBytes; if SmpsRead=0 then DataError;
 for S:=1 to SmpsRead do
  begin   { Konieczne 2 bajtowe przesuniecie 1997 09 20 }
   Move(iBinBuf^[iBinBufPos+sizeOf(integer)],iBuf^[iBufPos],
        iChannels*SizeOf(Integer));
   Inc(iBinBufPos,iSampleBytes); Inc(iBufPos,iChannels)
  end;
 CountInc(SmpsRead)
end;

procedure TiCBin.iFillBuf;
 var SmpsRead,
     BytesRead,
     SmpsToRead: Word;
     Ch:         Byte;
begin
 BytesRead:=iRead; SmpsToRead:=GetSamplesToRead;
 SmpsRead:=0; Ch:=1;
 while (SmpsRead<SmpsToRead) and (iBinBufPos<=BytesRead) do
  if (Ch=1) and                                        {first channel in sample}
     (iSmpsReadFil mod CBinHDR.SamplesInRecord=0) then  {first sample in record}
   if (iBinBufPos<=Succ(BytesRead)-iChannels*SizeOf(Integer)) then
    begin
     Move(iBinBuf^[iBinBufPos],SampleBuffer[1],iChannels*SizeOf(Integer));
     Move(SampleBuffer[1],iBuf^[iBufPos],iChannels*SizeOf(Integer));
     Inc(iBinBufPos,iChannels*SizeOf(Integer)); Inc(iBufPos,iChannels);
     Inc(SmpsRead); CountInc(1)
    end
   else Break
  else
   if Byte(iBinBuf^[iBinBufPos])<>$80 then
    begin
     Dec(SampleBuffer[Ch],ShortInt(iBinBuf^[iBinBufPos]));
     Inc(iBinBufPos);
     if Ch=iChannels then
      begin
       Move(SampleBuffer[1],iBuf^[iBufPos],iChannels*SizeOf(Integer));
       Inc(iBufPos,iChannels); Inc(SmpsRead); CountInc(1); Ch:=1
      end
     else Inc(Ch)
    end
   else
    if iBinBufPos<=Succ(BytesRead)-MaxSizeOfCBUnit then
     begin
      Dec(SampleBuffer[Ch],GetI(iBinBuf^[Succ(iBinBufPos)]));
      Inc(iBinBufPos,MaxSizeOfCBUnit);
      if Ch=iChannels then
       begin
        Move(SampleBuffer[1],iBuf^[iBufPos],iChannels*SizeOf(Integer));
        Inc(iBufPos,iChannels); Inc(SmpsRead); CountInc(1); Ch:=1
       end
      else Inc(Ch)
     end
    else Break;
 if SmpsRead=0 then DataError
end;

procedure TiDBin.iFillBuf;
 var BytesRead, SmpsRead: Word;
begin
 BlockRead(fi,iBuf^[iBufPos],GetSamplesToRead*iSampleBytes,BytesRead);
 SmpsRead:=BytesRead div iSampleBytes; if SmpsRead=0 then DataError;
 Inc(iBufPos,SmpsRead*iChannels);
 CountInc(SmpsRead)
end;


(********************** OPENING AND CLOSING INPUT FILE ************************)
                                                                      { iReset }
function FileReset(var f: File; const FileName: string): Boolean;
begin
 Result:=false; AssignFile(f,FileName);
 try Reset(f,1); Result:=true
 except on E:EInOutError do IOError(FileName,E.ErrorCode)
 end
end;

function TextReset(var f: TextFile; const FileName: string): Boolean;
begin
 Result:=false; AssignFile(f,FileName);
 try Reset(f); Result:=true
 except on E:EInOutError do IOError(FileName,E.ErrorCode)
 end
end;

function Ti12B.iReset: Boolean;
begin
iClose; Result:=FileReset(fi,FileName[iFile])
end;

function TiASCII.iReset: Boolean;
begin
 iClose; Result:=TextReset(fi,FileName[iFile])
end;

function TiBin.iReset: Boolean;
begin
 iClose; Result:=FileReset(fi,FileName[iFile])
end;

function TiFloatBin.iReset: Boolean;
begin   { 1998 09 01 }
 iClose; Result:=FileReset(fi,FileName[iFile])
end;

function TiPegasus.iReset: Boolean;
begin
 iClose;
 Result:=FileReset(fi,FileName[iFile]);
end;

function TiBBin.iReset: Boolean;
begin
 iClose; Result:=FileReset(fi,FileName[iFile])
end;

function TiCBin.iReset: Boolean;
 var AuxName: string;
begin
 AuxName:=FDir+FTable^[iFile].FName+'.'+icExt;
 iClose; Result:=ReadHDR(AuxName,CBinHDR,SizeOf(TCBinHDR),false) and
                 FileReset(fi,FileName[iFile]) and FileReset(fic,AuxName)
end;

function TiDBin.iReset: Boolean;
begin
 iClose; Result:=ReadHDR(FileName[iFile],DBinHDR,SizeOf(TDBinHDR),false) and
                 FileReset(fi,FileName[iFile]);
 if Result then iDataOffset:=DBinHDR.DataOrigin*16
end;
                                                                      { iClose }
procedure FileClose(var f: File);
begin
 if TFileRec(f).Mode<>fmClosed then
  try CloseFile(f) except on EInOutError do end
end;

procedure TextClose(var f: TextFile);
begin
 if TTextRec(f).Mode<>fmClosed then
  try CloseFile(f) except on EInOutError do end
end;

procedure Ti12B.iClose;
begin
 FileClose(fi);
end;

procedure TiASCII.iClose;
begin
 TextClose(fi);
end;

procedure TiBin.iClose;
begin
 FileClose(fi);
end;

procedure TiFloatBin.iClose;
begin
 FileClose(fi);
end;

procedure TiPegasus.iClose;
begin
 FileClose(fi);
end;

procedure TiBBin.iClose;
begin
 FileClose(fi);
end;

procedure TiCBin.iClose;
begin
 FileClose(fi); FileClose(fic);
end;

procedure TiDBin.iClose;
begin
 FileClose(fi);
end;
                                                                       { iOpen }
function TiStream.iOpen(NextFile: Boolean): Boolean;
begin
 if NextFile then begin Inc(iFile); Result:=iFile<FCount; iSmpsReadFil:=0 end
 else Result:=true;
 Result:=Result and iReset; iEoF:=not (Result and iSeek(iSmpsReadFil))
end;


(************************** MAIN CONVERTING ROUTINE ***************************)
                                                               { SplitChannels }
procedure TiStream.SplitChannels;
 var Sample: Word;
     Ch:     Byte;
begin
 if iSmpsInBuf>0 then
  for Sample:=0 to Pred(iSmpsInBuf) do
   begin
    if iSmpsInOut=iFrameSmps then Break; Inc(iSmpsInOut);
    for Ch:=1 to iChannels do
     iChannelTable[Ch]^[iSmpsInOut]:=iBuf^[Sample*iChannels+Ch]
   end
end;


(**************************** MAIN LOADING ROUTINE ****************************)

procedure TiStream.SetFilter(Min,Max,Dysp,PGain,Averg : single;
                             Typ : TFilterTypes;
                             status,FilterNo : integer);
begin              { Inicjacja filtra 1998 01 21 }
  with FilterParam do
    begin
       FilterType:=Typ;
       Gain:=PGain;
       RawFreqMin:=Min;
       RawFreqMax:=Max;
       RawFreqAverg:=Averg;
       RawFreqDysp:=Dysp;
       FilterStatus:=Status;
    end;
  FilterNumber:=FilterNo;
end;

procedure TiStream.Filtracja; { Filtracja Sygalu przez fft }
var
  k,i,OldPageSize   : word ;
  Sig               : ^TSingleTab;
  BuffPtr           : TIBufPtr;
  OK                : boolean;
  C                 : TCursor;

begin
  if not FilterEnabled then Exit;
  Ok:=MemInit(Sig,sizeof(TSingleTab));
  if not OK then Exit;

  C:=SetCursor(crHourglass);
  FilterParam.RawFreqSamp:=SampFreq;

  OldPageSize:=PageSize;
  for k:=1 to Channels do
   if UsedChannels[k] then
    begin
      BuffPtr:=GetBuf(k);
      for i:=1 to OldPageSize do
        Sig^[i]:=BuffPtr^[i];

       SignalFilter(Sig^,OldPageSize,FilterParam);
       for i:=1 to OldPageSize do
         BuffPtr^[i]:=round(Sig^[i]+0.5);
    end;

  SetCursor(C);
  MemFree(Sig,sizeof(TSingleTab));
end;
                                                                        { Load }
procedure TiStream.Load(Offset: LongInt; Unconditional: Boolean);
 var Ch: Byte;
     C:  TCursor;
begin
 CheckPage;
 if Offset<0 then iPageOffset:=0
 else
  if Offset>iSize then iPageOffset:=iSize
  else iPageOffset:=Offset;
 if iPageOffset+iPageSmps>iSize then iPageMax:=iSize-iPageOffset
 else iPageMax:=iPageSmps;

 if not Unconditional and
    (iPageOffset>=iFrameOffset) and
    (iPageOffset+iPageMax<=iFrameOffset+iFrameSmps) then Exit;

 iFrameOffset:=(iPageOffset div iPageSmps)*iPageSmps;

 for Ch:=1 to iChannels do
  FillChar(iChannelTable[Ch]^,iFrameSmps*SizeOf(Integer),#0);

 try C:=SetCursor(crHourglass);
  try
   iFile:=0; iSmpsReadTot:=0;
   while (iFile<FCount) and (iSmpsReadTot+FTable^[iFile].FSize<=iFrameOffset) do
    begin Inc(iSmpsReadTot,FTable^[iFile].FSize); Inc(iFile) end;

   if iFile<FCount then
    begin
     iSmpsReadFil:=iFrameOffset-iSmpsReadTot; iSmpsInOut:=0;
     if iOpen(false) then
      try
       repeat
        iBufPos:=1; FillChar(iBuf^,iBufBytes,#0); iSmpsInBuf:=0;
        repeat
         if not iEoF and (not (Self is TiCBin) or iSeek(iSmpsReadFil)) then
          begin
           iFillBuf;
           if (iSmpsInBuf=iBufferSmps) or
              (iSmpsReadTot=iFrameOffset+iFrameSmps) then Break
          end
         else if not iOpen(true) then Break
        until false;
        SplitChannels;
       until (iFile=FCount) or (iSmpsInOut=iFrameSmps)
      finally iClose
      end
    end;

  finally SetCursor(C)
  end;
 except
  on E:EInOutError do IOError(ChangeFileExt(FileName[iFile],''),E.ErrorCode);
  on E:EFFError do IOError(ChangeFileExt(FileName[iFile],''),107)
 end
end;


(************************** MAIN INTERFACE ROUTINES ***************************)
                                                                      { GetBuf }
function TiStream.GetBuf(Ch: Byte): TIBufPtr;
begin
 CheckChannel(Ch);
 Result:=Addr(iChannelTable[Ch]^[Succ(iPageOffset-iFrameOffset)])
end;

                                                                      { Useful }
function TiStream.Useful: Boolean;
begin
 Result:=FCount>0
end;



(******************************************************************************)
(*                                                                            *)
(*                                  MONTAGE                                   *)
(*                                                                            *)
(******************************************************************************)
                                                                      { Create }
constructor TMontage.Create;
 var Ch: Byte;
begin
 inherited Create;
 FChannels:=MaxChannels;
 for Ch:=1 to MaxChannels do with FItems[Ch] do
  begin Channel:=Ch; Labl:=SN(Channel,0); M:=1; D:=1; end
end;
                                                                      { Assign }
constructor TMontage.Assign(SrcMontage: TMontage);
begin
 inherited Create;
 FChannels:=SrcMontage.FChannels; FDefault:=SrcMontage.FDefault;
 Move(SrcMontage.FItems,FItems,SizeOf(FItems))
end;

                                                                { CheckChannel }
procedure TMontage.CheckChannel(Channel: Byte);
begin
 if (Channel=0) or (Channel>MaxChannels) then
  raise EChError.Create(ChannelErrorTxt)
end;
                                                                    { GetItems }
function TMontage.GetItems(Ch: Byte): TMontRec;
begin
 CheckChannel(Ch); Result:=FItems[Ch]
end;
                                                                    { SetItems }
procedure TMontage.SetItems(Ch: Byte; const Value: TMontRec);
begin
 CheckChannel(Ch); FItems[Ch]:=Value
end;
                                                                  { GetChannel }
function TMontage.GetChannel(Ch: Byte): Byte;
begin
 CheckChannel(Ch); Result:=FITems[Ch].Channel
end;
                                                                  { SetChannel }
procedure TMontage.SetChannel(Ch: Byte; Value: Byte);
begin
 CheckChannel(Ch); FITems[Ch].Channel:=Value;
end;
                                                                     { GetLabl }
function TMontage.GetLabl(Ch: Byte): string;
begin
 CheckChannel(Ch); Result:=FITems[Ch].Labl
end;
                                                                     { SetLabl }
procedure TMontage.SetLabl(Ch: Byte; const Value: string);
begin
 CheckChannel(Ch); FITems[Ch].Labl:=Value
end;
                                                                     { GetHint }
function TMontage.GetHint(Ch: Byte): string;
begin
 CheckChannel(Ch); Result:=FITems[Ch].Hint
end;
                                                                     { SetHint }
procedure TMontage.SetHint(Ch: Byte; const Value: string);
begin
 CheckChannel(Ch); FITems[Ch].Hint:=Value
end;
                                                                        { GetM }
function TMontage.GetM(Ch: Byte): Integer;
begin
 CheckChannel(Ch); Result:=FITems[Ch].M
end;
                                                                        { SetM }
procedure TMontage.SetM(Ch: Byte; Value: Integer);
begin
 CheckChannel(Ch); FITems[Ch].M:=Value
end;
                                                                        { GetD }
function TMontage.GetD(Ch: Byte): Integer;
begin
 CheckChannel(Ch); Result:=FITems[Ch].D
end;
                                                                        { SetD }
procedure TMontage.SetD(Ch: Byte; Value: Integer);
begin
 CheckChannel(Ch); FITems[Ch].D:=Value
end;
                                                                     { GetRefs }
function TMontage.GetRefs(Ch: Byte; RefCh: Byte): Boolean;
begin
 CheckChannel(Ch);  CheckChannel(RefCh); Result:=FITems[Ch].Refs[RefCh]
end;
                                                                     { SetRefs }
procedure TMontage.SetRefs(Ch: Byte; RefCh: Byte; Value: Boolean);
begin
 CheckChannel(Ch);  CheckChannel(RefCh); FITems[Ch].Refs[RefCh]:=Value
end;

                                                                 { LoadOptions }
procedure TMontage.LoadOptions(const FileName: string);
 var C:       TCursor;
     IniFile: TIniFile;
     Ch, ChR,
     P:       Byte;
     I:       Integer;
     S:       string;
begin
 if FileName<>'' then
  begin
   C:=SetCursor(crHourglass);
   try IniFile:=TIniFile.Create(FileName);
    with IniFile do
     try
      FChannels:=IntInRange(ReadInteger(MontageSec,NoOfChannelsID,FChannels),
                            1,MaxChannels);
      FDefault:=ReadBool(MontageSec,DefaultID,FDefault);
      for Ch:=1 to MaxChannels do with FItems[Ch] do
       begin
        S:=ReadString(MontageSec,ChannelID+SN(Ch,-3),'');
        if S<>'' then
         begin
          P:=1; 
          if SetIntegerValue('',Copy(S,P,3),I,true) and
             (I>0) and (I<=MaxChannels) then
           begin
            Channel:=I; Inc(P,3);
            Labl:=Copy(S,P,LablLen); TrimStr(Labl); Inc(P,LablLen);
            Hint:=Copy(S,P,HintLen); TrimStr(Hint); Inc(P,HintLen);
            if SetIntegerValue('',Copy(S,P,6),I,true) and (I<>0) then M:=I;
            Inc(P,6);
            if SetIntegerValue('',Copy(S,P,6),I,true) and (I<>0) then D:=I
           end
         end
       end;
      for Ch:=1 to MaxChannels do with FItems[Ch] do
       begin
        S:=ReadString(ReferenceSec,ChannelID+SN(Ch,-3),'');
        if S<>'' then
         begin
          PadStr(S,MaxChannels,'0');
          for ChR:=1 to MaxChannels do Refs[ChR]:=S[ChR]='1'
         end
       end
     finally IniFile.Free
     end
   finally SetCursor(C)
   end
  end
end;
                                                                 { SaveOptions }
procedure TMontage.SaveOptions(const FileName: string);
 const B: array[Boolean] of Char = ( '0', '1' );
 var   C:       TCursor;
       IniFile: TIniFile;
       Ch, ChR: Byte;
       S:       string;
       SL:      Byte absolute S;
begin
 if FileName<>'' then
  begin
   C:=SetCursor(crHourglass);
   try IniFile:=TIniFile.Create(FileName);
    with IniFile do
     try
      WriteInteger(MontageSec,NoOfChannelsID,FChannels);
      WriteBool(MontageSec,DefaultID,FDefault);
      for Ch:=1 to MaxChannels do with FItems[Ch] do
       begin
        S:=Labl; S:=PadStr(S,LablLen,' ')+Hint;
        S:=PadStr(S,LablLen+HintLen,' ');
        WriteString(MontageSec,ChannelID+SN(Ch,-3),
                    SN(Channel,-3)+S+SN(M,-6)+SN(D,-6))
       end;
      for Ch:=1 to MaxChannels do with FItems[Ch] do
       begin
        S:=''; PadStr(S,MaxChannels,'0');
        for ChR:=1 to MaxChannels do S[ChR]:=B[Refs[ChR]];
        while (SL>0) and (S[SL]<>'1') do Dec(SL);
        WriteString(ReferenceSec,ChannelID+SN(Ch,-3),S)
       end
     finally IniFile.Free
    end
   finally SetCursor(C)
   end
  end
end;
                                                                 { MoveChannel }
procedure TMontage.MoveChannel(SrcChn, DstChn: Byte);
 var R: TMontRec;
begin
 CheckChannel(SrcChn); CheckChannel(DstChn);
 R:=FItems[SrcChn];
 if SrcChn<MaxChannels then
  Move(FItems[Succ(SrcChn)],FItems[SrcChn],
       (MaxChannels-SrcChn)*SizeOf(TMontRec));
 if DstChn<MaxChannels then
  Move(FItems[DstChn],FItems[Succ(DstChn)],
       (MaxChannels-DstChn)*SizeOf(TMontRec));
 FItems[DstChn]:=R;
end;

end. { DDVINSTR }
