unit  DDVMNTG;

interface

uses  WinTypes, WinProcs, SysUtils, Classes,  Graphics,   Forms,    Controls,
      StdCtrls, ExtCtrls, Buttons,  Spin,     Grids,      Dialogs,
      FIRST,    DDVINI,   DDVAPDLG, DDVINSTR, DDVMAIN, HREAD, EXTHEAD;

type  TMontageDialog = class(TForm)
                        PanelGrid:        TPanel;
                             Grid:        TDrawGrid;
                             PanelNo:     TPanel;
                             PanelNoF:    TPanel;
                             PanelDscr:   TPanel;
                             PanelDscrF:  TPanel;
                             PanelGain:   TPanel;
                             PanelGainF:  TPanel;
                             PanelRef:    TPanel;
                             PanelScroll: TPanel;
                        LabelChannels:    TLabel;
                        LabelChannels1:   TLabel;
                        SpinEditChannels: TSpinEdit;
                        BtnLoad:          TBitBtn;
                        BtnSave:          TBitBtn;
                        CheckBoxDefault:  TCheckBox;
                        BtnOK:            TBitBtn;
                        BtnCancel:        TBitBtn;

    ImportBtn: TBitBtn;
    ButtonReset: TBitBtn;
                        procedure FormCreate(Sender: TObject);
                        procedure GridDrawCell(Sender: TObject;
                                               C, R: Longint; Rect: TRect;
                                               State: TGridDrawState);
                        procedure GridGetEditMask(Sender: TObject;
                                                  ACol, ARow: Longint;
                                                  var Value: OpenString);
                        procedure GridGetEditText(Sender: TObject;
                                                  ACol, ARow: Longint;
                                                  var Value: OpenString);
                        procedure GridSetEditText(Sender: TObject;
                                                  ACol, ARow: Longint;
                                                  const Value: string);
                        procedure GridSelectCell(Sender: TObject;
                                                 Col, Row: Longint;
                                                 var CanSelect: Boolean);
                        procedure GridTopLeftChanged(Sender: TObject);
                        procedure GridRowMoved(Sender: TObject;
                                               FromIndex, ToIndex: Longint);
                        procedure GridMouseMove(Sender: TObject;
                                                Shift: TShiftState;
                                                X, Y: Integer);
                        procedure GridMouseDown(Sender: TObject;
                                                Button: TMouseButton;
                                                Shift: TShiftState;
                                                X, Y: Integer);
                        procedure GridMouseUp(Sender: TObject;
                                              Button: TMouseButton;
                                              Shift: TShiftState;
                                              X, Y: Integer);
                        procedure GridKeyDown(Sender: TObject; var Key: Word;
                                              Shift: TShiftState);
                        procedure GridKeyUp(Sender: TObject; var Key: Word;
                                            Shift: TShiftState);
                        procedure BtnLoadClick(Sender: TObject);
                        procedure BtnSaveClick(Sender: TObject);
    procedure ImportBtnClick(Sender: TObject);
    procedure ButtonResetClick(Sender: TObject);

                       private { Private declarations }
                        MCol, MRow: LongInt;
                        procedure SetCaptions;
                        procedure SetGridEditMode(C, R: LongInt);
                       public  { Public declarations }
                        Mont: TMontage;
                        function Execute(Montage: TMontage): Boolean;
                        procedure SetMontChnLabels;
                       end;

var   MontageDialog: TMontageDialog;

implementation

{$R *.DFM}
                                                                  { FormCreate }
const CaptionTxt: array[0..5] of string[10]
                  = ( 'Scr.:', 'Dat.:', 'Label:',
                      'Comment:', 'Multipl.:', 'Divisor:' );

      ChanCapTxt: array[Boolean] of string[10]
                  = ( 'Chan. No.' , 'No.' );
      NoOfChannelTxt:    string[20] = 'Channel number ';
      OnScreenTxt:       string[10] = 'on screen';
      InDataTxt:         string[10] = 'in data';

procedure TMontageDialog.FormCreate(Sender: TObject);
begin
 SetFormPos(Self,220,130);
 with Grid do
  begin
   ColWidths[0]:=2*DefaultColWidth+GridLineWidth;
   ColWidths[1]:=2*DefaultColWidth+GridLineWidth;
   ColWidths[2]:=3*DefaultColWidth+2*GridLineWidth;
   ColWidths[3]:=8*DefaultColWidth+7*GridLineWidth;
   ColWidths[4]:=3*DefaultColWidth+2*GridLineWidth;
   ColWidths[5]:=3*DefaultColWidth+2*GridLineWidth
  end;
 SetCaptions;
 with SpinEditChannels do begin MinValue:=1; MaxValue:=MaxChannels end
end;
                                                                { GridDrawCell }
procedure TMontageDialog.GridDrawCell(Sender: TObject; C, R: Longint;
                                      Rect: TRect; State: TGridDrawState);
 var Sel: Boolean;
begin
 if Mont=nil then Exit;
 Sel:=gdSelected in State;
 with Grid do
  if (C=0) or (R=0) then
   begin
    if R>0 then DrawCaption(Canvas,Rect,bvLowered,8,-5,SN(R,0))
    else
     if C<=5 then DrawCaption(Canvas,Rect,bvLowered,7,0,CaptionTxt[C])
     else DrawCaption(Canvas,Rect,bvLowered,6,0,SN(C-5,0))
   end
  else with Mont[R] do
   if C=1 then DrawField(Canvas,Rect,GridFldColor,Sel,8,-5,SN(Channel,0))
   else
    if C=2 then DrawField(Canvas,Rect,GridFldColor,Sel,8,2,Labl)
    else
     if C=3 then DrawField(Canvas,Rect,GridFldColor,Sel,8,2,Hint)
     else
      if C=4 then DrawField(Canvas,Rect,GridFldColor,Sel,8,-5,SN(M,0))
      else
       if C=5 then DrawField(Canvas,Rect,GridFldColor,Sel,8,-5,SN(D,0))
       else DrawCheckBox(Canvas,Rect,bvNone,Sel,Refs[C-5]);
 if gdFocused in State then Grid.Canvas.DrawFocusRect(Rect);
 SetFont(Grid.Font,DrawFonts[true],8,[],clWindowText)
end;
                                                             { GridGetEditMask }
procedure TMontageDialog.GridGetEditMask(Sender: TObject; ACol,
                                         ARow: Longint; var Value: OpenString);
 var M: string;
begin
{
 if ACol=1 then Value:='999;0;_'
 else
  if ACol=2 then begin M:=''; Value:=PadStr(M,LablLen,'c')+';0;_' end
  else
   if ACol=3 then begin M:=''; Value:=PadStr(M,HintLen,'c')+';0;_' end
   else
    if (ACol=4) or (ACol=5) then Value:='######;0;_'
}
end;
                                                             { GridGetEditText }
procedure TMontageDialog.GridGetEditText(Sender: TObject; ACol,
                                         ARow: Longint; var Value: OpenString);
begin
 if Mont=nil then Exit;
 with Mont[ARow] do
  if ACol=1 then Value:=SN(Channel,0)
  else
   if ACol=2 then Value:=Labl
   else
    if ACol=3 then Value:=Hint
    else
     if ACol=4 then Value:=SN(M,0)
     else
      if ACol=5 then Value:=SN(D,0)
end;
                                                             { GridSetEditText }
procedure TMontageDialog.GridSetEditText(Sender: TObject; ACol,
                                         ARow: Longint; const Value: string);
 const Nums = '0123456789';
 var   S:     string;
       I:     Integer;
       Minus: Boolean;
begin
 if Mont=nil then Exit;
 S:=Value;
 with Mont do
  if ACol=1 then
   begin
    if SetIntegerValue('',CleanStr(S,Nums),I,true) then
     Channel[ARow]:=IntInRange(I,1,MaxChannels)
   end
  else
   if ACol=2 then Labl[ARow]:=TrimStr(S)
   else
    if ACol=3 then Hint[ARow]:=TrimStr(S)
    else
     if ACol=4 then
      begin
       Minus:=Pos('-',S)>0;
       if SetIntegerValue('',CleanStr(s,Nums),I,true) then
        begin I:=IntInRange(I,1,MaxInt); if Minus then I:=-I; M[ARow]:=I end
      end
     else
      if ACol=5 then
       begin
        Minus:=Pos('-',S)>0;
        if SetIntegerValue('',CleanStr(s,Nums),I,true) then
         begin I:=IntInRange(I,1,MaxInt); if Minus then I:=-I; D[ARow]:=I end
       end
end;
                                                              { GridSelectCell }
procedure TMontageDialog.GridSelectCell(Sender: TObject; Col, Row: Longint;
                                        var CanSelect: Boolean);
begin
 SetGridEditMode(Col,Row)
end;
                                                          { GridTopLeftChanged }
procedure TMontageDialog.GridTopLeftChanged(Sender: TObject);
begin
 SetCaptions
end;
                                                                { GridRowMoved }
procedure TMontageDialog.GridRowMoved(Sender: TObject;
                                      FromIndex, ToIndex: Longint);
begin
 if Mont=nil then Exit;
 Mont.MoveChannel(FromIndex,ToIndex); Grid.Invalidate
end;
                                                               { GridMouseMove }
procedure TMontageDialog.GridMouseMove(Sender: TObject;
                                       Shift: TShiftState; X, Y: Integer);
 var C, R: LongInt;
begin
 with Grid do
  begin
   MouseToCell(X,Y,C,R);
   if R=0 then
    if C=0 then
     begin Hint:=NoOfChannelTxt+OnScreenTxt; Exit end
    else
     if C=1 then
      begin Hint:=NoOfChannelTxt+InDataTxt; Exit end;
   Hint:=''; ShowHint:=false
  end
end;
                                                               { GridMouseDown }
procedure TMontageDialog.GridMouseDown(Sender: TObject; Button: TMouseButton;
                                       Shift: TShiftState; X, Y: Integer);
begin
 Grid.MouseToCell(X,Y,MCol,MRow);
 if (MCol<=5) and ( (MRow>0) or (MCol<=3) ) then begin MCol:=-1; MRow:=-1 end
end;
                                                                 { GridMouseUp }
procedure TMontageDialog.GridMouseUp(Sender: TObject; Button: TMouseButton;
                                     Shift: TShiftState; X, Y: Integer);
 var C, R:  LongInt;
     Rect:  TRect;
     State: TGridDrawState;
begin
 if Mont=nil then Exit;
 Grid.MouseToCell(X,Y,C,R);
 if (C=MCol) and (R=MRow) then
  if MRow>0 then with Grid, Mont do
   begin
    Refs[MRow,MCol-5]:=not Refs[MRow,MCol-5];
    Rect:=CellRect(MCol,MRow);
    with Rect do
     if (Right>Left) and (Bottom>Top) then
      begin
       if (MCol=Col) and (MRow=Row) then State:=[gdSelected,gdFocused]
       else State:=[];
       GridDrawCell(Grid,MCol,MRow,Rect,State)
      end
   end
  else with Grid do
   if MCol>5 then
    for R:=1 to MaxChannels do with Mont do
     begin
      Refs[R,MCol-5]:=Refs[TopRow,MCol-5];
      Rect:=CellRect(MCol,R);
      with Rect do
       if (Right>Left) and (Bottom>Top) then
        begin
         if (MCol=Col) and (R=Row) then State:=[gdSelected,gdFocused]
         else State:=[];
         GridDrawCell(Grid,MCol,R,Rect,State)
        end
     end
   else
    if MCol>3 then
     for R:=1 to MaxChannels do with Mont do
      begin
       if MCol=4 then M[R]:=M[TopRow] else D[R]:=D[TopRow];
       Rect:=CellRect(MCol,R);
       with Rect do
        if (Right>Left) and (Bottom>Top) then
         begin
          if (MCol=Col) and (R=Row) then State:=[gdSelected,gdFocused]
          else State:=[];
          GridDrawCell(Grid,MCol,R,Rect,State)
         end
      end;
 MCol:=-1; MRow:=-1
end;
                                                                 { GridKeyDown }
procedure TMontageDialog.GridKeyDown(Sender: TObject; var Key: Word;
                                     Shift: TShiftState);
begin
 if Key=VK_SPACE then with Grid do
  if (Col>5) and (Row>0) then
   begin MCol:=Col; MRow:=Row end else begin MCol:=-1; MRow:=-1 end
end;
                                                                   { GridKeyUp }
procedure TMontageDialog.GridKeyUp(Sender: TObject; var Key: Word;
                                   Shift: TShiftState);
 var Rect: TRect;
begin
 if Mont=nil then Exit;
 with Grid do
  if (Col=MCol) and (Row=MRow) then with Mont do
   begin
    Refs[MRow,MCol-5]:=not Refs[MRow,MCol-5];
    Rect:=CellRect(MCol,MRow);
    with Rect do
     if (Right>Left) and (Bottom>Top) then
      begin
       DrawCheckBox(Canvas,Rect,bvNone,true,Refs[MRow,MCol-5]);
       Canvas.DrawFocusRect(Rect)
      end
   end;
 MCol:=-1; MRow:=-1
end;
                                                                { BtnLoadClick }
procedure TMontageDialog.BtnLoadClick(Sender: TObject);
begin
 if Mont=nil then Exit;
 if ApplyOpenDialog(dkIni,IniFileName) then
  begin
   Mont.LoadOptions(IniFileName);
   SpinEditChannels.Value:=Mont.Channels;
   CheckBoxDefault.Checked:=Mont.Deflt;
   Grid.Invalidate
  end
end;
                                                                { BtnSaveClick }
procedure TMontageDialog.BtnSaveClick(Sender: TObject);
begin
 if Mont=nil then Exit;
 if ApplySaveDialog(dkIni,IniFileName) then
  begin
   Mont.Channels:=SpinEditChannels.Value;
   Mont.Deflt:=CheckBoxDefault.Checked;
   Mont.SaveOptions(IniFileName)
  end
end;
                                                                 { SetCaptions }
procedure TMontageDialog.SetCaptions;
 var C: Byte;
begin
 with Grid do
  begin
   C:=LeftCol;
   if PanelDscr.Width=0 then begin PanelGain.Width:=0; PanelGainF.Width:=0 end;
   if C=1 then
    begin
     PanelNo.Width:=ColWidths[0]+ColWidths[1]+GridLineWidth;
     PanelNo.Caption:=ChanCapTxt[false]
    end
   else
    begin
     PanelNo.Width:=ColWidths[0];
     PanelNo.Caption:=ChanCapTxt[true]
    end;
   PanelNoF.Width:=GridLineWidth;
   case C of
    1:   begin
          PanelDscr.Width:=ColWidths[2]+ColWidths[3]+GridLineWidth;
          PanelDscrF.Width:=GridLineWidth;
          PanelGain.Width:=ColWidths[4]+ColWidths[5]+GridLineWidth;
          PanelGainF.Width:=GridLineWidth
         end;
    2:   begin
          PanelDscr.Width:=ColWidths[2]+ColWidths[3]+GridLineWidth;
          PanelDscrF.Width:=GridLineWidth;
          PanelGain.Width:=ColWidths[4]+ColWidths[5]+GridLineWidth;
          PanelGainF.Width:=GridLineWidth
         end;
    3:   begin
          PanelDscr.Width:=ColWidths[3];
          PanelDscrF.Width:=GridLineWidth;
          PanelGain.Width:=ColWidths[4]+ColWidths[5]+GridLineWidth;
          PanelGainF.Width:=GridLineWidth
         end;
    4:   begin
          PanelDscr.Width:=0;
          PanelDscrF.Width:=0;
          PanelGain.Width:=ColWidths[4]+ColWidths[5]+GridLineWidth;
          PanelGainF.Width:=GridLineWidth
         end;
    5:   begin
          PanelDscr.Width:=0;
          PanelDscrF.Width:=0;
          PanelGain.Width:=ColWidths[5];
          PanelGainF.Width:=GridLineWidth
         end
    else begin
          PanelDscr.Width:=0;
          PanelDscrF.Width:=0;
          PanelGain.Width:=0;
          PanelGainF.Width:=0
         end
   end;
  end
end;
                                                             { SetGridEditMode }
procedure TMontageDialog.SetGridEditMode(C, R: LongInt);
begin
 with Grid do
  if C>5 then Options:=Options-[goEditing{,goAlwaysShowEditor}]
  else        Options:=Options+[goEditing{,goAlwaysShowEditor}]
end;
                                                                     { Execute }
function TMontageDialog.Execute(Montage: TMontage): Boolean;
 var Channels,
     Ch:       Byte;
     Default:  Boolean;
     MontDup:  ^TMontTab;
begin
 Result:=false; if Montage=nil then Exit;
 if MemInit(MontDup,SizeOf(TMontTab)) then
  try
   Mont:=Montage;
   for Ch:=1 to MaxChannels do MontDup^[Ch]:=Mont[Ch];
   Channels:=Mont.Channels; Default:=Mont.Deflt;
   SpinEditChannels.Value:=Mont.Channels;
   CheckBoxDefault.Checked:=Mont.Deflt;
   with Grid do
    begin
     Col:=1; Row:=1; LeftCol:=1; TopRow:=1;
     SetCaptions; SetGridEditMode(Col,Row)
    end;
   MCol:=-1; MRow:=-1; ActiveControl:=nil;
   try Result:=ShowModal=mrOK;
   finally
    if Result then
     begin
      Mont.Channels:=SpinEditChannels.Value;
      Mont.Deflt:=CheckBoxDefault.Checked;
      if CheckBoxDefault.Checked then Mont.SaveOptions(MainIniFileName)
     end
    else
     begin
      for Ch:=1 to MaxChannels do Mont[Ch]:=MontDup^[Ch];
      Mont.Channels:=Channels; Mont.Deflt:=Default
     end;
    Mont:=nil
   end
  finally MemFree(MontDup,SizeOf(TMontTab))
  end
end;
                                            { 1997 09 11 }
procedure TMontageDialog.ImportBtnClick(Sender: TObject);
begin
 SetMontChnLabels;
 Grid.Invalidate;
end;

procedure TMontageDialog.SetMontChnLabels;
var
 i : integer;

begin
  for i:=1 to ExtHeaderDlg.NumOfChannels do
     Mont.Labl[i]:=TrimStr(ExtHeaderDlg.ChnLabels[i]);
end;

procedure TMontageDialog.ButtonResetClick(Sender: TObject);
  var               { 1997 12 30 }
    i,j : integer;  { zerowanie montarzu }
    s   : string[5];

 begin
   for i:=1 to MaxChannels do
     begin
       str(i,s);
       Mont.Channel[i]:=i;
       Mont.M[i]:=1;
       Mont.D[i]:=1;
       Mont.Labl[i]:=TrimStr(s);
       for j:=1 to MaxChannels do
         Mont.Refs[i,j]:=false;
     end;
   Grid.Invalidate;
end;

end. { DDVMNTG }
