unit DDVTAGED;

interface

uses  WinTypes, WinProcs, Classes,  Graphics, Forms,    Controls, Buttons,
      StdCtrls, ExtCtrls, Spin,
      FIRST,    DDVINI,   DDVTAGS,  DDVMAIN;

type  TEditMode = ( emAdd, emEdit );

      TTagEdDialog = class(TForm)
                      LabelType:              TLabel;
                      EditType:               TEdit;
                      LabelDscr:              TLabel;
                      EditDscr:               TEdit;
                      GroupBoxBrush:          TGroupBox;
                              LabelBColor:    TLabel;
                              ComboBoxBColor: TComboBox;
                              LabelBStyle:    TLabel;
                              ComboBoxBStyle: TComboBox;
                      GroupBoxPen:            TGroupBox;
                              LabelPColor:    TLabel;
                              ComboBoxPColor: TComboBox;
                              LabelPMode:     TLabel;
                              ComboBoxPMode:  TComboBox;
                              Label1:         TLabel;
                              ComboBoxPStyle: TComboBox;
                              LabelPWidth:    TLabel;
                              SpinEditPWidth: TSpinEdit;
                      BtnOK:                  TBitBtn;
                      BtnCancel:              TBitBtn;
                      GroupBoxTest:           TGroupBox;
                      ImageTest:              TImage;
                      procedure FormCreate(Sender: TObject);
                      procedure BtnOKClick(Sender: TObject);
                      procedure TestImage(Sender: TObject);
                     private { Private declarations }
                      EditMode: TEditMode;
                      Tags:     TTagHDR;
                      Kind:     TTagKind;
                      Index:    Integer;
                      HDRRec:   TTagHDRRec;
                     public  { Public declarations }
                      function Execute(EditMode: TEditMode; TagHDR: TTagHDR;
                                       Kind: TTagKind; Index: Integer;
                                       const HDRRec: TTagHDRRec): Boolean;
                     end;

var   TagEdDialog: TTagEdDialog;

implementation

{$R *.DFM}

const DialogCaptions:    array[TEditMode] of string[20]
                                  = ( 'Add New Tag', 'Edit Existing Tag' );

      TagTypeTxt:        string[10] = 'Tag type';
                                                                  { FormCreate }
procedure TTagEdDialog.FormCreate(Sender: TObject);
begin
 SetFormPos(Self,288,152);
 EditType.MaxLength:=1; EditDscr.MaxLength:=TagHintLen;
 AssignColor(ComboBoxBColor.Items); AssignBrushStyle(ComboBoxBStyle.Items);
 AssignColor(ComboBoxPColor.Items); AssignPenMode(ComboBoxPMode.Items);
 AssignPenStyle(ComboBoxPStyle.Items)
end;
                                                                  { BtnOKClick }
procedure TTagEdDialog.BtnOKClick(Sender: TObject);
begin
 with HDRRec do
  begin
   Tag:=StrToChar(EditType.Text);
   Hint:=EditDscr.Text; TrimStr(Hint);
   BColor:=GetColor(ComboBoxBColor.Text);
   BStyle:=GetBrushStyle(ComboBoxBStyle.Text);
   PColor:=GetColor(ComboBoxPColor.Text);
   PMode:=GetPenMode(ComboBoxPMode.Text);
   PStyle:=GetPenStyle(ComboBoxPStyle.Text);
   PWidth:=SpinEditPWidth.Value
  end;
 if Tags<>nil then
  if EditMode=emAdd then
   if Tags.InsertHDR(Kind,Index,HDRRec) then ModalResult:=mrOK
   else ModalResult:=mrNone
  else
   if EditMode=emEdit then
    if Tags.ReplaceHDR(Kind,Index,HDRRec) then ModalResult:=mrOK
    else ModalResult:=mrNone
end;
                                                                   { TestImage }
procedure TTagEdDialog.TestImage(Sender: TObject);
 var T:    TTagHDRRec;
     X, Y,
     X1,Y1,
     C,
     R, B: Integer;
begin
 with T do
  begin
   BColor:=GetColor(ComboBoxBColor.Text);
   BStyle:=GetBrushStyle(ComboBoxBStyle.Text);
   PColor:=GetColor(ComboBoxPColor.Text);
   PMode:=GetPenMode(ComboBoxPMode.Text);
   PStyle:=GetPenStyle(ComboBoxPStyle.Text);
   PWidth:=SpinEditPWidth.Value
  end;

 with ImageTest, Canvas do
  if (Width>0) and (Height>0) then
   begin
    R:=Pred(Width); B:=Pred(Height);

    SetBrush(Brush,clWhite,bsSolid);
    SetPen(Pen,clBlack,pmCopy,psSolid,1);
    FillRect(Rect(0,0,R,B));

    X:=Width div 2; Y:=Height div 2;
    X1:=Width div 20; Y1:=Height div 10;

    SetBrush(Brush,clNavy,bsSolid);
    SetPen(Pen,clRed,pmCopy,psInsideFrame,3);
    Rectangle(X1,Y1,X+3*X1,Y+3*Y1);

    SetBrush(Brush,T.BColor,T.BStyle);
    SetPen(Pen,T.PColor,T.PMode,T.PStyle,T.PWidth);
    Rectangle(X-3*X1,Y-3*Y1,R-X1,B-Y1);

    X1:=Width div 4;
    SetBrush(Brush,clWhite,bsSolid);
    SetPen(Pen,GridColors[true],pmCopy,psSolid,1);
    PolyLine([Point(0,0),Point(X,0)]);   PolyLine([Point(0,Y),Point(X,Y)]);
    PolyLine([Point(0,B),Point(X,B)]);   PolyLine([Point(0,0),Point(0,B)]);
    PolyLine([Point(X1,0),Point(X1,B)]); PolyLine([Point(X,0),Point(X,B)]);

    Inc(X); X1:=Width div 4*3;
    SetPen(Pen,GridColors[false],pmCopy,psSolid,1);
    PolyLine([Point(X,0),Point(R,0)]);   PolyLine([Point(X,Y),Point(R,Y)]);
    PolyLine([Point(X,B),Point(R,B)]);   PolyLine([Point(X,0),Point(X,B)]);
    PolyLine([Point(X1,0),Point(X1,B)]); PolyLine([Point(R,0),Point(R,B)]);

    SetBrush(Brush,clWhite,bsSolid);
    SetPen(Pen,clBlack,pmCopy,psSolid,1);
    C:=Height div 5; X:=0; Y:=C; MoveTo(X,Y);
    repeat
     X1:=X+Width div 9; if Y=C then Y1:=B-C else Y1:=C;
     LineTo(X1,Y1); X:=X1; Y:=Y1
    until X>=R
   end
end;
                                                                     { Execute }
function TTagEdDialog.Execute(EditMode: TEditMode; TagHDR: TTagHDR;
                              Kind: TTagKind; Index: Integer;
                              const HDRRec: TTagHDRRec): Boolean;
begin
 if TagHDR=nil then Exit;
 with HDRRec do
  begin
   Result:=false;
   Tags:=TagHDR; Self.EditMode:=EditMode; Self.Kind:=Kind; Self.Index:=Index;
   Self.HDRRec:=HDRRec;
   Caption:=DialogCaptions[EditMode];
   LabelType.Enabled:=(EditMode=emAdd) or not Tags.Fixed;
   EditType.Enabled:=LabelType.Enabled;
   if (Tag=#0) or (Tag=' ') then EditType.Text:='' else EditType.Text:=Tag;
   EditDscr.Text:=Hint;
   with ComboBoxBColor, Items do ItemIndex:=IndexOf(SetColor(BColor));
   with ComboBoxBStyle, Items do ItemIndex:=IndexOf(SetBrushStyle(BStyle));
   with ComboBoxPColor, Items do ItemIndex:=IndexOf(SetColor(PColor));
   with ComboBoxPMode,  Items do ItemIndex:=IndexOf(SetPenMode(PMode));
   with ComboBoxPStyle, Items do ItemIndex:=IndexOf(SetPenStyle(PStyle));
   with SpinEditPWidth do Value:=IntInRange(PWidth,MinValue,MaxValue);
   TestImage(Self); ActiveControl:=nil;
   Result:=ShowModal=mrOK;
   Tags:=nil
  end
end;

end. { DDVTAGED }
