unit DDVTAGS;

interface

uses  SysUtils, Controls, Graphics, Forms,    Dialogs,
      FIRST,    DDVAPDLG, DDVINSTR,
      GETWZR; { Czytanie i zapis WZR'a  }

const
      TagHintLen   = 30;
      HDRSizeStep  = 8;
      MaxHDR       = 254;
      MaxSecPP     = 99;
      MaxBlkPP     = 255;
      MaxChnTagLen = MaxInt;
      MaxStructures=10000;
      HowPages=5;               { Liczba stron do usrednienaia }

type
      HipnoTable=array[1..MaxStructures] of byte;

      TTagKind     = (tkPag, tkBlk, tkChn);

      TTagHDRRec   = record
                      Tag:    Char;
                      Hint:   string[TagHintLen];
                      BColor: TColor;
                      BStyle: TBrushStyle;
                      PColor: TColor;
                      PMode:  TPenMode;
                      PStyle: TPenStyle;
                      PWidth: Integer
                     end;

      TTagHDRTab   = array[Byte] of TTagHDRRec;

      TTagHDRCount = record
                      SecPP: Word;
                      BlkPP: Word;
                      Count: array[TTagKind] of Integer
                     end;

      TTagPagRec   = record
                      Tag:    Char;
                      Page:   Word
                     end;

      TTagBlkRec   = record
                      Tag:    Char;
                      Page:   Word;
                      Block:  Byte
                     end;

      TTagChnRec   = record
                      Tag:    Char;
                      Offset: LongInt;
                      Length: Word;
                     end;

const MaxTagPag    = MaxSize div SizeOf(TTagPagRec);
      MaxTagBlk    = MaxSize div SizeOf(TTagBlkRec);
      MaxTagChn    = MaxSize div SizeOf(TTagChnRec);

type  TTagPagTab   = array[1..MaxTagPag] of TTagPagRec;
      TTagBlkTab   = array[1..MaxTagBlk] of TTagBlkRec;
      TTagChnTab   = array[1..MaxTagChn] of TTagChnRec;

      TTagHDR      = class
                     private
                      FHDRCount:  TTagHDRCount;
                      FHDR:       array[TTagKind] of ^TTagHDRTab;
                      FHDRSpace:  array[TTagKind] of Integer;
                      FHDRIndex:  array[TTagKind,Char] of Byte;
                      FPath:      TFileName;
                      FFixed:     Boolean;

                      function    ImmediateLoadHDR(QuietMode: Boolean): Boolean;
                      function    ImmediateSaveHDR: Boolean;

                      procedure   CheckIndex(Kind: TTagKind; I: Integer);
                      function    CheckFixed: Boolean;
                      function    CheckUniq(Kind: TTagKind; Tag: Char): Boolean;
                      function    CheckMaxHDR(Kind: TTagKind): Boolean;
                      function    CheckSpace(Kind: TTagKind): Boolean;

                      function    GetHDRList(Kind: TTagKind; Tag: Char):
                                             TTagHDRRec;
                      function    GetHDRIndex(Kind: TTagKind; Tag: Char):
                                              Integer;
                      function    GetHDR(Kind: TTagKind; I: Integer):
                                         TTagHDRRec;
                      function    GetHDRCount(Kind: TTagKind): Integer;
                      procedure   SetSecPP(Value: Word);
                      procedure   SetBlkPP(Value: Word);

                      procedure   ClearAllHDR;
                      procedure   ClearHDR(Kind: TTagKind);
                      procedure   RebuildAllHDRIndexes;
                      procedure   RebuildHDRIndex(Kind: TTagKind);
                     protected
                      function    EmptyData: Boolean;
                     public
                      property    HDRList[Kind: TTagKind; Tag: Char]: TTagHDRRec
                                  read GetHDRList; default;
                      property    NDX[Kind: TTagKind; Tag: Char]: Integer
                                  read GetHDRIndex;
                      property    HDR[Kind: TTagKind; I: Integer]: TTagHDRRec
                                  read GetHDR;
                      property    Count[Kind: TTagKind]: Integer
                                  read GetHDRCount;
                      property    SecPerPage: Word
                                  read FHDRCount.SecPP write SetSecPP;
                      property    BlkPerPage: Word
                                  read FHDRCount.BlkPP write SetBlkPP;
                      property    Path: TFileName read FPath;
                      property    Fixed: Boolean read FFixed;

                      constructor Create(const Path: string;
                                         SecondsPerPage, BlocksPerPage: Word);
                      destructor  Destroy; virtual;
                      function    LoadHDR: Boolean;
                      procedure   SaveHDR;

                      function    ReplaceHDR(Kind: TTagKind; I: Integer;
                                             var Value: TTagHDRRec): Boolean;
                      function    InsertHDR(Kind: TTagKind; I: Integer;
                                            var Value: TTagHDRRec): Boolean;
                      procedure   DeleteHDR(Kind: TTagKind; I: Integer);
                      procedure   MoveHDR(Kind: TTagKind; SrcI, DstI: Integer);
                           { Ustawienie artefaktow }
                      function SetHDRArtifacts(filename : string;
                                               BlockPP,
                                               PageSize : word) : boolean;
                           { Ustawienie tagow do oznaczanie snu }
                      function SetSleepTags : boolean;
                      function IsBlkTagInHDR(TagName : char) : boolean;
                      function GetBPP: word;
                      function GetSecPP : word;
                     end;

      TTag         = class(TTagHDR)
                     private
                      FPagCount:  Word;
                      FPag:       ^TTagPagTab;
                      FBlkCount:  Word;
                      FBlk:       ^TTagBlkTab;
                      FChannels:  Byte;
                      FChnCount:  array[1..MaxChannels] of Word;
                      FChn:       array[1..MaxChannels] of ^TTagChnTab;
                      FUseful:    Boolean;
                      FLoaded:    Boolean;
                      FModified:  Boolean;
                      FPagMin:    Word;
                      FPagMax:    Word;
                      FBlkMin:    Word;
                      FBlkMax:    Word;
                      FChnMin:    array[1..MaxChannels] of Word;
                      FChnMax:    array[1..MaxChannels] of Word;
                      function    GetPagTag(I: Word): TTagHDRRec;
                      function    GetBlkTag(I: Word): TTagHDRRec;
                      function    GetChnTag(Chn: Byte; I: Word): TTagHDRRec;
                      function    GetPag(I: Word): TTagPagRec;
                      function    GetBlk(I: Word): TTagBlkRec;
                      function    GetChn(Chn: Byte; I: Word): TTagChnRec;
                      function    GetChnMin(Chn: Byte): Word;
                      function    GetChnMax(Chn: Byte): Word;
                      procedure   SetLoaded(Flag: Boolean);
                  public { Modyfikacja 1997 06 29 }
                      procedure   SetModified(Flag: Boolean);
                  private
                      function    ImmediateLoad: Boolean;
                      function    ImmediateSave: Boolean;
                      function    PagCmp(Pag: Word; I: Word): Integer;
                      function    BlkCmp(Pag: Word; Blk: Byte;
                                         I: Word): Integer;
                      function    ChnCmp(Chn: Byte; Offs: LongInt;
                                         I: Word): Integer;
                      function    ChnSearchFirst(Chn: Byte; Offs: LongInt;
                                                 var I: Word): Integer;
                     public
                      property    PagTag[I: Word]: TTagHDRRec read GetPagTag;
                      property    BlkTag[I: Word]: TTagHDRRec read GetBlkTag;
                      property    ChnTag[Chn: Byte;
                                         I: Word]: TTagHDRRec read GetChnTag;

                      property    Pag[I: Word]: TTagPagRec read GetPag;
                      property    Blk[I: Word]: TTagBlkRec read GetBlk;
                      property    Chn[Chn: Byte;
                                      I: Word]: TTagChnRec read GetChn;

                      property    PagMin: Word read FPagMin;
                      property    PagMax: Word read FPagMax;
                      property    BlkMin: Word read FBlkMin;
                      property    BlkMax: Word read FBlkMax;
                      property    ChnMin[Chn: Byte]: Word read GetChnMin;
                      property    ChnMax[Chn: Byte]: Word read GetChnMax;

                      property    Useful: Boolean read FUseful;
                      property    Loaded: Boolean
                                  read FLoaded write SetLoaded;
                      property    Modified: Boolean
                                  read FModified write SetModified;

                      constructor Create(TagHDR: TTagHDR; Channels: Byte);
                      destructor  Destroy; override;

                      procedure   Clear;
                      function    TrySaveModified: Boolean;
                      function    Load: Boolean;
                      function    Save(Immediate: Boolean): Boolean;
                      function    Close: Boolean;

                      function    PagSearch(Pag: Word; var I: Word): Integer;
                      function    BlkSearch(Pag: Word; Blk: Byte;
                                            var I: Word): Integer;
                      function    ChnSearch(Chn: Byte; Offs: LongInt;
                                            var I: Word): Integer;

                      function    PagGetFrame(PagMin, PagMax: Word): Boolean;
                      function    BlkGetFrame(PagMin, PagMax: Word): Boolean;
                      function    ChnGetFrame(Chn: Byte;
                                              OffsMin,
                                              OffsMax: LongInt): Boolean;

                      function    PagAdd(const R: TTagPagRec): Word;
                      function    BlkAdd(const R: TTagBlkRec): Word;
                      function    ChnAdd(Chn: Byte;
                                         const R: TTagChnRec): Word;

                      function    PagDel(I: Word): Boolean;
                      function    BlkDel(I: Word): Boolean;
                      function    ChnDel(Chn: Byte; I: Word): Boolean;
                      { Modyfikacja dodawanie atrtefaktow i stadiow snu }
                      function SetTagArtifacts(filename : string;
                                               BlockPP,PageSize : word) : boolean;
                       { Zapis specjalnego Taga do WZR'a }
                      function SaveTagToWzrFile(filename : string;
                                                pageNo,PageSize : word) : boolean;
                       { Tworzenie Hipnogramu }
                       procedure MakeHipnogram(var hipno : HipnoTable;
                                               maxPage : word);

                       function IsBlkTag(Tag : char) : boolean;
                       function GetBlockPerPage : word;
                       { Modyfikacja 1998 08 18 }
                       function GetBadPage(var ok : boolean;
                                           StartPage,MaxPage : word) : word;
                     end;

      ETLError     = class(Exception);

const BlankHDRRec: TTagHDRRec = ( Tag:    ' ';
                                  Hint:   '';
                                  BColor: clGray;
                                  BStyle: bsSolid;
                                  PColor: clGray;
                                  PMode:  pmCopy;
                                  PStyle: psSolid;
                                  PWidth: 1 );

      NoNameTagTxt: string[12] = 'NONAME.TAG';

function TagPagRec(Tag: Char; Pag: Word): TTagPagRec;
function TagBlkRec(Tag: Char; Pag: Word; Blk: Byte): TTagBlkRec;
function TagChnRec(Tag: Char; Offs: LongInt; Len: Word): TTagChnRec;

implementation

uses  DDVTAGLI;

const TagFileNotEmptyTxt:string[30] = 'File contains tagging data.';
      OverwriteTxt:      string[40] = 'Are you sure you want to overwrite it?';
      TTableErrorTxt:    string[40] = 'Tag list index out of range';
      TagListFixedTxt:   string[40] = 'Tag list is fixed.';
      TagExistsTxt:      string[40] = 'Tag of this type already exists.';
      CannottAddTag:     string[40] = 'Cannot add any new tag.';


(****************************** OVERALL ROUTINES ******************************)
                                                                   { TagPagRec }
function TagPagRec(Tag: Char; Pag: Word): TTagPagRec;
begin
 Result.Tag:=Tag; Result.Page:=Pag
end;
                                                                   { TagBlkRec }
function TagBlkRec(Tag: Char; Pag: Word; Blk: Byte): TTagBlkRec;
begin
 Result.Tag:=Tag; Result.Page:=Pag; Result.Block:=Blk
end;
                                                                   { TagChnRec }
function TagChnRec(Tag: Char; Offs: LongInt; Len: Word): TTagChnRec;
begin
 Result.Tag:=Tag; Result.Offset:=Offs; Result.Length:=Len
end;

(********************************** TTagHDR ***********************************)

function TTagHDR.GetSecPP : word;
begin
  Result:=FHDRCount.SecPP;
end;

function TTagHDR.GetBPP : word;
begin
  Result:=FHDRCount.BlkPP;
end;
                                                                      { Create }
constructor TTagHDR.Create(const Path: string;
                           SecondsPerPage, BlocksPerPage: Word);
begin
 inherited Create;
 FPath:=Path; SecPerPage:=SecondsPerPage; BlkPerPage:=BlocksPerPage;
 ImmediateLoadHDR(true)
end;
                                                                     { Destroy }
destructor TTagHDR.Destroy;
begin
 ClearAllHDR;
 inherited Destroy
end;

{ ********************************* 1997 06 19 }

function TTagHDR.SetSleepTags : boolean; { Ustawienie tagow do oznaczania snu }
  type
    SleepString=array[0..6] of string[30];

  const                         { Nazwy stadiow }
    HintStadium : SleepString=( 'Stadium 4','Stadium 3',
                                'Stadium 2', 'Stadium 1',
                                'REM', 'WAKE', 'MUSC');
                                { Oznaczenia tagow }
    SleepName   : array[0..6] of char =(STADIUM_4, STADIUM_3,
                                        STADIUM_2, STADIUM_1,
                                        REM, WAKE, MUSC);
                                { Kolory tagow }
                                {
    SleepColor  : SleepString=('Green','Blue',
                               'Aqua','Teal','Gray',
                               'Silver', 'Lime Green');
                                }
   SleepColor : SleepString=('White','White','White',
                             'White','White','White','White');
  var
    C : TCursor;
    B : boolean;
    OldSecPerPage,OldBlkPerPage,i : integer;

begin
 OldSecPerPage:=SecPerPage;
 OldBlkPerPage:=BlkPerPage;
 C:=SetCursor(crHourglass);
 ClearAllHDR;
 FHDRCount.Count[tkPag]:=7;
 FHDRCount.Count[tkChn]:=0;
 FHDRCount.Count[tkBlk]:=1;        { Poprawka 1999 01 27 }
{ FHDRCount.SecPP:=20;}            { Tak konstruowane sa WZRy }
{ FHDRCount.BlkPP:=8; }            { Zachowujemy stare oznaczenia } 
                                  { Atrefakty (tag na blok) }
 FHDRSpace[tkChn]:=0;
 FHDRSpace[tkBlk]:=((FHDRCount.Count[tkBlk]+Pred(HDRSizeStep)) div
                     HDRSizeStep)*HDRSizeStep;
 B:=MemInit(FHDR[tkBlk],FHDRSpace[tkBlk]*SizeOf(TTagHDRRec));
 if B then
   begin
      FHDR[tkBlk]^[0]:=BlankHDRRec; { Opis artefaktu }
      with FHDR[tkblk]^[0] do
        begin
          Tag:=ARTIFACT;
          Hint:='Atrifact'; TrimStr(Hint);
          PWidth:=1;
          BColor:=GetColor('Gray');
          BStyle:=GetBrushStyle('Solid');
          PColor:=GetColor('Gray');
          PMode:=GetPenMode('Copy');
          PStyle:=GetPenStyle('Solid');
        end;
    end;
                                { Stadia snu (tag na strone) }
   FHDRSpace[tkPag]:=((FHDRCount.Count[tkBlk]+Pred(HDRSizeStep)) div
                       HDRSizeStep)*HDRSizeStep;
   B:=MemInit(FHDR[tkPag],FHDRSpace[tkPag]*SizeOf(TTagHDRRec));
   if B then
     for i:=0 to 6 do
       begin
           FHDR[tkPag]^[i]:=BlankHDRRec; { Opis stadia snu }
           with FHDR[tkPag]^[i] do
             begin
              Tag:=SleepName[i];
              Hint:=HintStadium[i]; TrimStr(Hint);
              PWidth:=1;
              BColor:=GetColor(SleepColor[i]);
              PColor:=GetColor(SleepColor[i]);
           {
              BStyle:=GetBrushStyle('Solid');
              PMode:=GetPenMode('Copy');
              PStyle:=GetPenStyle('Solid');
           }
            end;
       end;

 Result:=B;
 if Result then
    RebuildAllHDRIndexes
  else
    begin
      SecPerPage:=OldSecPerPage;
      BlkPerPage:=OldBlkPerPage;
      ClearAllHDR;
    end;
 SetCursor(C);
end;

{ ********************************* 1997 06 17/19 }

function TTagHDR.SetHDRArtifacts(filename : string;
                                 BlockPP,PageSize : word) : boolean;
begin
 if not LoadWzr(filename,BlockPP,PageSize) then  { Ladowanie WZr'a }
   begin
     MessageDlg('Nie mozna otworzyc pliku '+
                filename,mtError,[mbOk],0);
     exit;
    end;
    { Ustawienie tagow do ozanczania stadiow snu }
 if not SetSleepTags then
   MessageDlg('Problemy z alokacja Tagow'+
                filename,mtError,[mbOk],0);

end;

 { *********************************************** }

function TTagHDR.ImmediateLoadHDR(QuietMode: Boolean): Boolean;
 var C:   TCursor;
     K:   TTagKind;
     f:   File;
     B:   Boolean;
     SPP,
     BPP: Word;
begin
 Result:=FPath=''; ClearAllHDR; if Result then Exit;
 C:=SetCursor(crHourglass);
 try SPP:=SecPerPage; BPP:=BlkPerPage; AssignFile(f,FPath);
  try Reset(f,1);
   try
    BlockRead(f,FHDRCount,SizeOf(FHDRCount));
    B:=true;
    for K:=tkPag to tkChn do
     if FHDRCount.Count[K]>0 then
      begin
       FHDRSpace[K]:=((FHDRCount.Count[K]+Pred(HDRSizeStep)) div HDRSizeStep)*
                     HDRSizeStep;
       B:=MemInit(FHDR[K],FHDRSpace[K]*SizeOf(TTagHDRRec));
       if B then BlockRead(f,FHDR[K]^,FHDRCount.Count[K]*SizeOf(TTagHDRRec))
       else Break
      end
     else FHDRSpace[K]:=0;
    Result:=B
   finally CloseFile(f)
   end
  except on E:EInOutError do if not QuietMode then IOError(FPath,E.ErrorCode)
  end;
  if Result then RebuildAllHDRIndexes
  else begin FPath:=''; SecPerPage:=SPP; BlkPerPage:=BPP; ClearAllHDR end
 finally SetCursor(C)
 end
end;
                                                                     { LoadHDR }
function TTagHDR.LoadHDR: Boolean;
 var P: string;
begin
 P:=FPath;
 Result:=CheckFixed and ApplyOpenDialog(dkTag,FPath) and
         ImmediateLoadHDR(false);
 if not Result and (FPath<>'') then FPath:=P
end;
                                                                   { EmptyData }
function TTagHDR.EmptyData: Boolean;
 var CountRec: TTagHDRCount;
     K:        TTagKind;
     f:        File;
     Size:     LongInt;
begin
 Result:=false; AssignFile(f,FPath);
 try Reset(f,1);
  try
   Result:=EoF(f);
   if not Result then
    begin
     Size:=SizeOf(TTagHDRCount); BlockRead(f,CountRec,Size);
     for K:=tkPag to tkChn do Inc(Size,CountRec.Count[K]*SizeOf(TTagHDRRec));
     Result:=(FileSize(f)=Size) or
             (MessageDlg(CutPath(FPath,40)+CRLF+
                         TagFileNotEmptyTxt+CRLF+CRLF+OverwriteTxt,
                         mtConfirmation,[mbYes,mbNo],0)=mrYes)
    end
  finally CloseFile(f)
  end
 except on E:EInOutError do
  if E.ErrorCode=2 then Result:=true else IOError(FPath,E.ErrorCode)
 end;
end;
                                                            { ImmediateSaveHDR }
function TTagHDR.ImmediateSaveHDR: Boolean;
 var C: TCursor;
     K: TTagKind;
     f: File;
begin
 Result:=true;
 C:=SetCursor(crHourglass);
 try AssignFile(f,FPath);
  try Rewrite(f,1);
   try
    BlockWrite(f,FHDRCount,SizeOf(FHDRCount));
    for K:=tkPag to tkChn do
     BlockWrite(f,FHDR[K]^,FHDRCount.Count[K]*SizeOf(TTagHDRRec))
   finally CloseFile(f)
   end
  except on E:EInOutError do begin Result:=false; IOError(FPath,E.ErrorCode) end
  end
 finally SetCursor(C)
 end
end;
                                                                     { SaveHDR }
procedure TTagHDR.SaveHDR;
 var P: string;
begin
 P:=FPath;
 if not (ApplySaveDialog(dkTag,FPath) and EmptyData and
         ImmediateSaveHDR) or FFixed then FPath:=P
end;
                                                                  { CheckIndex }
procedure TTagHDR.CheckIndex(Kind: TTagKind; I: Integer);
begin
 if (I<0) or (I>=FHDRCount.Count[Kind]) then
  raise ETLError.Create(TTableErrorTxt)
end;
                                                                  { CheckFixed }
function TTagHDR.CheckFixed: Boolean;
begin
 Result:=not FFixed;
 if not Result then MessageDlg(TagListFixedTxt,mtError,[mbOK],0)
end;
                                                                   { CheckUniq }
function TTagHDR.CheckUniq(Kind: TTagKind; Tag: Char): Boolean;
begin
 Result:=FHDRIndex[Kind,Tag]=255;
 if not Result then MessageDlg(TagExistsTxt,mtError,[mbOK],0)
end;
                                                                 { CheckMaxHDR }
function TTagHDR.CheckMaxHDR(Kind: TTagKind): Boolean;
begin
 Result:=FHDRCount.Count[Kind]<=MaxHDR;
 if not Result then MessageDlg(CannottAddTag,mtError,[mbOK],0)
end;
                                                                  { CheckSpace }
function TTagHDR.CheckSpace(Kind: TTagKind): Boolean;
 var NewSize: Word;
begin
 if FHDRCount.Count[Kind]=FHDRSpace[Kind] then
  begin
   NewSize:=FHDRSpace[Kind]+HDRSizeStep;
   Result:=MemResize(FHDR[Kind],FHDRSpace[Kind]*SizeOf(TTagHDRRec),
                                NewSize*SizeOf(TTagHDRRec));
   if Result then FHDRSpace[Kind]:=NewSize
  end
 else Result:=true;
end;
                                                                  { GetHDRList }
function TTagHDR.GetHDRList(Kind: TTagKind; Tag: Char): TTagHDRRec;
 var I: Byte;
begin
 I:=FHDRIndex[Kind,Tag];
 if I=255 then Result:=BlankHDRRec else Result:=FHDR[Kind]^[I]
end;
                                                                 { GetHDRIndex }
function TTagHDR.GetHDRIndex(Kind: TTagKind; Tag: Char): Integer;
begin
 Result:=FHDRIndex[Kind,Tag]; if Result=255 then Result:=-1
end;
                                                                      { GetHDR }
function TTagHDR.GetHDR(Kind: TTagKind; I: Integer): TTagHDRRec;
begin
 CheckIndex(Kind,I); Result:=FHDR[Kind]^[I]
end;
                                                                 { GetHDRCount }
function TTagHDR.GetHDRCount(Kind: TTagKind): Integer;
begin
 Result:=FHDRCount.Count[Kind]
end;
                                                                    { SetSecPP }
procedure TTagHDR.SetSecPP(Value: Word);
begin
 FHDRCount.SecPP:=IntInRange(Value,1,MaxSecPP)
end;
                                                                    { SetBlkPP }
procedure TTagHDR.SetBlkPP(Value: Word);
begin
 FHDRCount.BlkPP:=IntInRange(Value,1,MaxBlkPP)
end;
                                                                 { ClearAllHDR }
procedure TTagHDR.ClearAllHDR;
 var K: TTagKind;
begin
 for K:=tkPag to tkChn do ClearHDR(K)
end;
                                                                    { ClearHDR }
procedure TTagHDR.ClearHDR(Kind: TTagKind);
begin
 MemFree(FHDR[Kind],FHDRSpace[Kind]*SizeOf(TTagHDRRec));
 FHDRSpace[Kind]:=0; FHDRCount.Count[Kind]:=0;
 RebuildHDRIndex(Kind)
end;
                                                        { RebuildAllHDRIndexes }
procedure TTagHDR.RebuildAllHDRIndexes;
 var K: TTagKind;
begin
 for K:=tkPag to tkChn do RebuildHDRIndex(K)
end;
                                                             { RebuildHDRIndex }
procedure TTagHDR.RebuildHDRIndex(Kind: TTagKind);
 var I: Integer;
begin
 FillChar(FHDRIndex[Kind,#0],256,#255);
 for I:=0 to Pred(FHDRCount.Count[Kind]) do
  FHDRIndex[Kind,FHDR[Kind]^[I].Tag]:=I
end;
                                                                  { ReplaceHDR }
function TTagHDR.ReplaceHDR(Kind: TTagKind; I: Integer;
                            var Value: TTagHDRRec): Boolean;
begin
 CheckIndex(Kind,I);
 with FHDR[Kind]^[I] do
  if not FFixed then
   begin
    Result:=(Value.Tag=Tag) or CheckUniq(Kind,Value.Tag);
    if Result then
     begin FHDRIndex[Kind,Tag]:=255; FHDRIndex[Kind,Value.Tag]:=I end
   end
  else begin Result:=true; Value.Tag:=Tag end;
 if Result then FHDR[Kind]^[I]:=Value
end;
                                                                   { InsertHDR }
function TTagHDR.InsertHDR(Kind: TTagKind; I: Integer;
                           var Value: TTagHDRRec): Boolean;
begin
 if (I<0) or (I>FHDRCount.Count[Kind]) then
  raise ETLError.Create(TTableErrorTxt);
 Result:={CheckFixed and }CheckMaxHDR(Kind) and
         CheckUniq(Kind,Value.Tag) and CheckSpace(Kind);
 if Result then
  begin
   if I<FHDRCount.Count[Kind] then
    Move(FHDR[Kind]^[I],FHDR[Kind]^[Succ(I)],
         (FHDRCount.Count[Kind]-I)*SizeOf(TTagHDRRec));
   FHDR[Kind]^[I]:=Value;
   Inc(FHDRCount.Count[Kind]); RebuildHDRIndex(Kind)
  end
end;
                                                                   { DeleteHDR }
procedure TTagHDR.DeleteHDR(Kind: TTagKind; I: Integer);
begin
 CheckIndex(Kind,I);
 if CheckFixed then
  begin
   if I<Pred(FHDRCount.Count[Kind]) then
    Move(FHDR[Kind]^[Succ(I)],FHDR[Kind]^[I],
         (Pred(FHDRCount.Count[Kind])-I)*SizeOf(TTagHDRRec));
   Dec(FHDRCount.Count[Kind]); RebuildHDRIndex(Kind)
  end
end;
                                                                     { MoveHDR }
procedure TTagHDR.MoveHDR(Kind: TTagKind; SrcI, DstI: Integer);
 var R: TTagHDRRec;
begin
 CheckIndex(Kind,SrcI); CheckIndex(Kind,DstI);
 R:=FHDR[Kind]^[SrcI];
 if SrcI<Pred(FHDRCount.Count[Kind]) then
  Move(FHDR[Kind]^[Succ(SrcI)],FHDR[Kind]^[SrcI],
       (Pred(FHDRCount.Count[Kind])-SrcI)*SizeOf(TTagHDRRec));
 if DstI<Pred(FHDRCount.Count[Kind]) then
  Move(FHDR[Kind]^[DstI],FHDR[Kind]^[Succ(DstI)],
       (Pred(FHDRCount.Count[Kind])-DstI)*SizeOf(TTagHDRRec));
 FHDR[Kind]^[DstI]:=R;
 RebuildHDRIndex(Kind)
end;

function TTagHDR.IsBlkTagInHDR(TagName : char) : boolean;
  var
    i,n : integer;

begin
  Result:=false;
  n:=FHDRCount.Count[tkBlk];
  if n<>0 then
    for i:=0 to n-1 do
      with FHDR[tkBlk]^[i] do
       begin
        if Tag=TagName then
          begin
            Result:=true;
            break;
          end;
       end;
end;

(************************************ TTag ************************************)
                                                                      { Create }
constructor TTag.Create(TagHDR: TTagHDR; Channels: Byte);
 var K:  TTagKind;
     Ch: Byte;
begin
 if TagHDR<>nil then
  begin
   inherited Create('',TagHDR.SecPerPage,TagHDR.BlkPerPage); FUseful:=true;

   for K:=tkPag to tkChn do
    begin
     FHDRSpace[K]:=TagHDR.FHDRSpace[K];
     FHDRCount.Count[K]:=TagHDR.FHDRCount.Count[K];
     FUseful:=(FHDRSpace[K]=0) or
              MemInit(FHDR[K],FHDRSpace[K]*SizeOf(TTagHDRRec));
     if not FUseful then Break;
     Move(TagHDR.FHDR[K]^,FHDR[K]^,FHDRSpace[K]*SizeOf(TTagHDRRec))
    end;

   FChannels:=Channels;

   FUseful:=FUseful and
            MemInit(FPag,MaxTagPag*SizeOf(TTagPagRec)) and
            MemInit(FBlk,MaxTagBlk*SizeOf(TTagBlkRec));
   if FUseful then for Ch:=1 to FChannels do
    if not MemInit(FChn[Ch],MaxTagChn*SizeOf(TTagChnRec)) then
     begin FUseful:=false; Break end;

   if FUseful then
    begin
     Move(TagHDR.FHDRIndex,FHDRIndex,SizeOf(FHDRIndex));
     FPagMin:=1; FBlkMin:=1; for Ch:=1 to MaxChannels do FChnMin[Ch]:=1
    end
   else
    begin
     for Ch:=1 to FChannels do MemFree(FChn[Ch],MaxTagChn*SizeOf(TTagChnRec));
     MemFree(FBlk,MaxTagBlk*SizeOf(TTagBlkRec));
     MemFree(FPag,MaxTagPag*SizeOf(TTagPagRec));
     ClearAllHDR
    end
  end
end;
                                                                     { Destroy }
destructor TTag.Destroy;
 var Ch: Byte;
begin
 for Ch:=1 to FChannels do MemFree(FChn,MaxTagChn*SizeOf(TTagChnRec));
 MemFree(FBlk,MaxTagBlk*SizeOf(TTagBlkRec));
 MemFree(FPag,MaxTagPag*SizeOf(TTagPagRec));
 ClearAllHDR;
 inherited Destroy
end;
                                                                   { SetLoaded }
procedure TTag.SetLoaded(Flag: Boolean);
begin
 FLoaded:=Flag; FFixed:=FLoaded or FModified
end;
                                                                 { SetModified }
procedure TTag.SetModified(Flag: Boolean);
begin
 FModified:=Flag; FFixed:=FLoaded or FModified
end;
                                                                   { GetPagTag }
function TTag.GetPagTag(I: Word): TTagHDRRec;
 var NDX: Byte;
     T:   Char;
begin
 if (I>0) and (I<=FPagCount) then T:=FPag^[I].Tag else T:=#0;
 if T=#0 then NDX:=255 else NDX:=FHDRIndex[tkPag,T];
 if NDX=255 then Result:=BlankHDRRec else Result:=FHDR[tkPag]^[NDX]
end;

function TTag.IsBlkTag(Tag : char) : boolean;
begin
  Result:=IsBlkTagInHDR(Tag);
end;
                                                                   { GetBlkTag }
function TTag.GetBlkTag(I: Word): TTagHDRRec;
 var NDX: Byte;
     T:   Char;
begin
 if (I>0) and (I<=FBlkCount) then T:=FBlk^[I].Tag else T:=#0;
 if T=#0 then NDX:=255 else NDX:=FHDRIndex[tkBlk,T];
 if NDX=255 then Result:=BlankHDRRec else Result:=FHDR[tkBlk]^[NDX]
end;
                                                                   { GetChnTag }
function TTag.GetChnTag(Chn: Byte; I: Word): TTagHDRRec;
 var NDX: Byte;
     T:   Char;
begin
 if (Chn>0) and (Chn<=FChannels) and
    (I>0) and (I<=FChnCount[Chn]) then T:=FChn[Chn]^[I].Tag else T:=#0;
 if T=#0 then NDX:=255 else NDX:=FHDRIndex[tkChn,T];
 if NDX=255 then Result:=BlankHDRRec else Result:=FHDR[tkChn]^[NDX]
end;
                                                                      { GetPag }
function TTag.GetPag(I: Word): TTagPagRec;
begin
 if (I>0) and (I<=FPagCount) then Result:=FPag^[I]
 else Result:=TagPagRec(#0,0)
end;
                                                                      { GetBlk }
function TTag.GetBlk(I: Word): TTagBlkRec;
begin
 if (I>0) and (I<=FBlkCount) then Result:=FBlk^[I]
 else Result:=TagBlkRec(#0,0,0)
end;
                                                                      { GetChn }
function TTag.GetChn(Chn: Byte; I: Word): TTagChnRec;
begin
 if (Chn>0) and (Chn<=FChannels) and
    (I>0) and (I<=FChnCount[Chn]) then Result:=FChn[Chn]^[I]
 else Result:=TagChnRec(#0,0,0)
end;
                                                                   { GetChnMin }
function TTag.GetChnMin(Chn: Byte): Word;
begin
 Result:=FChnMin[Chn]
end;
                                                                   { GetChnMax }
function TTag.GetChnMax(Chn: Byte): Word;
begin
 Result:=FChnMax[Chn]
end;
                                                                       { Clear }
procedure TTag.Clear;
 var Ch: Byte;
begin
 FPagCount:=0; FillChar(FPag^,MaxTagPag*SizeOf(TTagPagRec),#0);
 FPagMin:=1; FPagMax:=0;
 FBlkCount:=0; FillChar(FBlk^,MaxTagBlk*SizeOf(TTagBlkRec),#0);
 FBlkMin:=1; FBlkMax:=0;
 FillChar(FChnCount,SizeOf(FChnCount),#0);
 for Ch:=1 to FChannels do FillChar(FChn[Ch]^,MaxTagChn*SizeOf(TTagChnRec),#0);
 for Ch:=1 to MaxChannels do begin FChnMin[Ch]:=1; FChnMax[Ch]:=0 end;
 Modified:=false
end;
                                                             { TrySaveModified }
function TTag.TrySaveModified: Boolean;
 var mr: TModalResult;
     S:  string;
begin
 Result:=not Modified;
 if not Result then
  begin
   if Loaded then S:=CutPath(FPath,40) else S:=NoNameTagTxt;
   mr:=MessageDlg(S+CRLF+CRLF+SaveTxt,mtConfirmation,mbYesNoCancel,0);
   case mr of
    mrYes: Result:=Save(true);
    mrNo:  Result:=true
   end
  end
end;

function TTag.GetBlockPerPage : word;
begin
 Result:=GetBPP;
end;

{ ************************************** 1997 06 17/19/21 }

function FileExit(filename : string) : boolean;
  var                        { Sprawdzamy istnienie pliku }
    out  : boolean;
    plik : file;

begin
  Out:=false;
  Assign(plik,filename);
  {$I-}
  Reset(plik);
  {$i+}
  if IOResult=0 then
    begin
     Out:=true;
     Close(plik);
    end;
  FileExit:=Out;
end;

{ Modyfikacja 1998 08 18 }
function TTag.GetBadPage(var OK : boolean;
                         StartPage,MaxPage : word) : word;
type
  BoolTab=array[1..MaxTagPag] of boolean;
var
  Sleep   : ^BoolTab;
  i       : word;
  AllocOK : boolean;

begin
  AllocOK:=MemInit(sleep,sizeof(BoolTab));
  if AllocOK then
    begin
      for i:=StartPage to MaxPage do
        Sleep^[i]:=true;

      for i:=1 to FPagCount do
       if FPag^[i].Tag<>'0' then
          Sleep^[FPag^[i].Page]:=false;

      for i:=StartPage to MaxPage do
        if Sleep^[i]=true then
           begin
             MemFree(Sleep,sizeof(BoolTab));
             OK:=true;
             Result:=i;
             Exit;
           end;
    end;
    OK:=false;
    Result:=1;
end;

function TTag.SaveTagToWzrFile(filename : string;
                               pageNo,PageSize : word ) : boolean;
  var
    C        : TCursor;                   { Zapis Tagow do WZR }
    i        : word;

begin
  if FileExit(filename) then
   if MessageDlg('Overwrite exiting "'+filename,
      mtConfirmation,[mbYes,mbNo,mbCancel],0)=mrNo then
    begin
      Result:=true;                        { Zaniechanie nagrywania }
      Exit;
    end;

  if pageNo=0 then
    begin
      Result:=false;
      Exit;
    end;

  if not OpenWzrFileToSave(filename,pageNo,PageSize,GetBlockPerPage) then
    begin
      Result:=false;
      Exit;
    end;
  C:=SetCursor(crHourglass);
  for i:=1 to FPagCount do            { Zapis stadiow }
    PutWzrStadium(FPag^[i].Tag,FPag^[i].Page);

  for i:=1 to FBlkCount do             { Oznacznaie artefaktow }
   if Fblk^[i].tag=ARTIFACT then
     with FBlk^[i] do
       begin
         PutWzrStatus(Page,Block);
       end;

  CloseAndSaveWzrFile;                 { Zwolnienie zasobow }
  SetCursor(C);
  Result:=true;
end;

function TTag.SetTagArtifacts(filename : string; BlockPP,PageSize : word): boolean;
 var
      C     :   TCursor;              { Oznaczanie artefaktow i stadiow snu }
      count,maxseg,i,j,k,pages : integer;
      Rec     : TTagBlkRec;
      PagRec  : TTagPagRec;
      stadium : char;

begin
 Clear;
 Result:=SetHDRArtifacts(filename,BlockPP,PageSize);
 if not Result then
   Exit;
 C:=SetCursor(crHourglass);

 maxseg:=GetWzrLength;            { Obliczenie istniejacych blokow }
 pages:=maxseg div BlockPP;       { Liczba stron w WZR }

 for i:=1 to MaxChannels do         { Tych nie ma }
   FChnCount[i]:=0;

 Count:=1;                          { Poprawka 1999 01 27 }
 k:=0;                              { Zaznaczanie artefaktow }
 for i:=1 to pages do               { Po stronach }
  for j:=1 to BlockPP do            { Po blokach }
   begin
    if IsArtifact(k) then           { Po wszystkich artefaktach }
      begin
         with Rec do
          begin
            Tag:=ARTIFACT;
            Page:=i;
            Block:=j;
          end;

         FBlk^[Count]:=Rec;
         inc(Count);
      end;
     inc(k);
    end;

 FBlkCount:=Count-1;

 Count:=1;                 { Oznaczanie stadiow snu }
 FPagCount:=0;
 for i:=0 to pages do
  begin
   Stadium:=SleepValue(i);
   if (Stadium<>'E') and (Stadium<>'e') then
     begin
       with PagRec do
         begin
           Tag:=Stadium;
           page:=i+1;
         end;
        FPag^[Count]:=PagRec;
        inc(Count); inc(FPagCount);
     end;
  end;

 CloseWzr;             { Zwolnienie pamieci }
 SetCursor(C);
end;

{ ******************************************************* }
                                                               { ImmediateLoad }
function TTag.ImmediateLoad: Boolean;
 var C:   TCursor;
     L:   LongInt;
     K:   TTagKind;
     Ch,
     Chn: Byte;
     OK:  Boolean;
     f:   File;
begin
 Clear;
 Result:=ImmediateLoadHDR(false); if not Result then Exit;
 Result:=FPath=''; if Result then Exit;
 C:=SetCursor(crHourglass);
 try AssignFile(f,FPath);
  try Reset(f,1);
   try
    L:=SizeOf(TTagHDRCount);
    for K:=tkPag to tkChn do Inc(L,FHDRCount.Count[K]*SizeOf(TTagHDRRec));
    Seek(f,L);
    if not EoF(f) then
     begin
      BlockRead(f,FPagCount,SizeOf(FPagCount));
      BlockRead(f,FPag^,FPagCount*SizeOf(TTagPagRec));
      BlockRead(f,FBlkCount,SizeOf(FBlkCount));
      BlockRead(f,FBlk^,FBlkCount*SizeOf(TTagBlkRec));
      BlockRead(f,Chn,SizeOf(Chn));
      BlockRead(f,FChnCount,Chn*SizeOf(Word));
      OK:=true;
      if Chn>FChannels then
       begin
        for Ch:=Succ(FChannels) to Chn do
         if not MemInit(FChn[Ch],MaxTagChn*SizeOf(TTagChnRec)) then
          begin OK:=false; Break end;
        if OK then FChannels:=Chn
        else for Ch:=Succ(FChannels) to Chn do
              MemFree(FChn[Ch],MaxTagChn*SizeOf(TTagChnRec))
       end;
       if OK then
        begin
         for Ch:=1 to FChannels do
          BlockRead(f,FChn[Ch]^,FChnCount[Ch]*SizeOf(TTagChnRec));
         Result:=true
        end
     end
    else Result:=true
   finally CloseFile(f)
   end
  except on E:EInOutError do IOError(FPath,E.ErrorCode)
  end;
  if not Result then begin FPath:=''; Clear end
 finally SetCursor(C)
 end
end;
                                                                        { Load }
function TTag.Load: Boolean;
 var P: string;
begin
 P:=FPath;
 Result:=TrySaveModified and ApplyOpenDialog(dkTag,FPath) and ImmediateLoad;
 if not Result and (FPath<>'') then FPath:=P;
 Loaded:=FPath<>''
end;
                                                               { ImmediateSave }
function TTag.ImmediateSave: Boolean;
 var C:  TCursor;
     K:  TTagKind;
     Ch,
     fm: Byte;
     f:  File;
begin
 Result:=ImmediateSaveHDR;
 if not Result then Exit;
 Result:=(FPagCount=0) and (FBlkCount=0);
 if Result then for Ch:=1 to FChannels do
  if FChnCount[Ch]<>0 then begin Result:=false; Break end;
 if Result then Exit; Result:=true;
 C:=SetCursor(crHourglass);
 try AssignFile(f,FPath);
  try fm:=FileMode; FileMode:=2; Reset(f,1);
   try
    Seek(f,FileSize(f));
    BlockWrite(f,FPagCount,SizeOf(FPagCount));
    BlockWrite(f,FPag^,FPagCount*SizeOf(TTagPagRec));
    BlockWrite(f,FBlkCount,SizeOf(FBlkCount));
    BlockWrite(f,FBlk^,FBlkCount*SizeOf(TTagBlkRec));
    BlockWrite(f,FChannels,SizeOf(FChannels));
    BlockWrite(f,FChnCount,FChannels*SizeOf(Word));
    for Ch:=1 to FChannels do
     BlockWrite(f,FChn[Ch]^,FChnCount[Ch]*SizeOf(TTagChnRec))
   finally FileMode:=fm; CloseFile(f)
   end
  except on E:EInOutError do begin Result:=false; IOError(FPath,E.ErrorCode) end
  end;
  if Result then Modified:=false
 finally SetCursor(C)
 end
end;
                                                                        { Save }
function TTag.Save(Immediate: Boolean): Boolean;
 var P: string;
begin
 P:=FPath; if FPath='' then Immediate:=false;
 Result:=( (Immediate or ApplySaveDialog(dkTag,FPath) and EmptyData) and
           ImmediateSave);
 if not Result then FPath:=P;
 Loaded:=FPath<>''
end;
                                                                       { Close }
function TTag.Close: Boolean;
begin
 Result:=TrySaveModified;
 if Result then begin Clear; FPath:=''; Loaded:=false end
end;

                                                                      { PagCmp }
function TTag.PagCmp(Pag: Word; I: Word): Integer;
begin
 if Pag<FPag^[I].Page then Result:=-1
 else
  if Pag>FPag^[I].Page then Result:=1
  else Result:=0
end;
                                                                   { PagSearch }
function TTag.PagSearch(Pag: Word; var I: Word): Integer;
 var d, u: Word;
begin
 if FPagMax<FPagMin then begin I:=FPagMax; Result:=1; Exit end;
 d:=FPagMin; u:=FPagMax;
 repeat
  I:=(d+u) shr 1;
  Result:=PagCmp(Pag,I);
  if Result<0 then u:=Pred(I)
  else
   if Result>0 then d:=Succ(I)
   else Exit
 until d>u;
 if (Result>0) and (I<FPagMax) then begin Inc(I); Result:=-1 end
end;
                                                                 { PagGetFrame }
function TTag.PagGetFrame(PagMin, PagMax: Word): Boolean;
 var I:  Word;
begin
 Result:=false; FPagMin:=1; FPagMax:=FPagCount; if FPagCount=0 then Exit;
 if (PagSearch(PagMin,I)<=0) and (PagMax>=FPag^[I].Page) then
  begin
   FPagMin:=I; PagSearch(Succ(PagMax),I);
   while (I>=FPagMin) and (FPag^[I].Page>PagMax) do Dec(I);
   if I>=FPagMin then begin FPagMax:=I; Result:=true; Exit end
  end;
 FPagMin:=1; FPagMax:=0
end;

                                                                      { BlkCmp }
function TTag.BlkCmp(Pag: Word; Blk: Byte; I: Word): Integer;
begin
 if Pag<FBlk^[I].Page then Result:=-1
 else
  if Pag>FBlk^[I].Page then Result:=1
  else
   if Blk<FBlk^[I].Block then Result:=-1
   else
    if Blk>FBlk^[I].Block then Result:=1
    else Result:=0
end;
                                                                   { BlkSearch }
function TTag.BlkSearch(Pag: Word; Blk: Byte; var I: Word): Integer;
 var d, u: Word;
begin
 if FBlkMax<FBlkMin then begin I:=FBlkMax; Result:=1; Exit end;
 d:=FBlkMin; u:=FBlkMax;
 repeat
  I:=(d+u) shr 1;
  Result:=BlkCmp(Pag,Blk,I);
  if Result<0 then u:=Pred(I)
  else
   if Result>0 then d:=Succ(I)
   else Exit
 until d>u;
 if (Result>0) and (I<FBlkMax) then begin Inc(I); Result:=-1 end
end;
                                                                 { BlkGetFrame }
function TTag.BlkGetFrame(PagMin, PagMax: Word): Boolean;
 var I: Word;
begin
 Result:=false; FBlkMin:=1; FBlkMax:=FBlkCount; if FBlkCount=0 then Exit;
 if (BlkSearch(PagMin,1,I)<=0) and (PagMax>=FBlk^[I].Page) then
  begin
   FBlkMin:=I; BlkSearch(Succ(PagMax),1,I);
   while (I>=FBlkMin) and (FBlk^[I].Page>PagMax) do Dec(I);
   if I>=FBlkMin then begin FBlkMax:=I; Result:=true; Exit end
  end;
 FBlkMin:=1; FBlkMax:=0
end;

                                                                      { ChnCmp }
function TTag.ChnCmp(Chn: Byte; Offs: LongInt; I: Word): Integer;
begin
 if Offs<FChn[Chn]^[I].Offset then Result:=-1
 else
  if Offs>FChn[Chn]^[I].Offset then Result:=1
  else Result:=0
end;
                                                                   { ChnSearch }
function TTag.ChnSearch(Chn: Byte; Offs: LongInt; var I: Word): Integer;
 var d, u: Word;
begin
 if FChnMax[Chn]<FChnMin[Chn] then begin I:=FChnMax[Chn]; Result:=1; Exit end;
 d:=FChnMin[Chn]; u:=FChnMax[Chn];
 repeat
  I:=(d+u) shr 1;
  Result:=ChnCmp(Chn,Offs,I);
  if Result<0 then u:=Pred(I)
  else
   if Result>0 then d:=Succ(I)
   else Break
 until d>u;
 while (Result<0) and (I>FChnMin[Chn]) do
  begin Dec(I); Result:=ChnCmp(Chn,Offs,I) end;
 if Result<0 then Exit;
 while (Result>=0) and (I<FChnMax[Chn]) and (ChnCmp(Chn,Offs,Succ(I))>=0) do
  begin Inc(I); Result:=ChnCmp(Chn,Offs,I) end;    { znaleziono pierwszy kanal }
                                           { o offsecie mniejszym od szukanego }
 repeat
  if (Offs<FChn[Chn]^[I].Offset+FChn[Chn]^[I].Length) then
   begin Result:=0; Exit end
  else if I>FChnMin[Chn] then Dec(I) else Exit
 until false
end;
                                                              { ChnSearchFirst }
function TTag.ChnSearchFirst(Chn: Byte; Offs: LongInt; var I: Word): Integer;
 var d, u: Word;
begin
 if FChnMax[Chn]<FChnMin[Chn] then
   begin
     I:=FChnMax[Chn];
     Result:=1;
     Exit
   end;
 d:=FChnMin[Chn];
 u:=FChnMax[Chn];
 repeat
  I:=(d+u) shr 1;
  Result:=ChnCmp(Chn,Offs,I);
  if Result<0 then u:=Pred(I)
  else
   if Result>0 then d:=Succ(I)
   else Break
 until d>u;
 while (Result>0) and (I<FChnMax[Chn]) do
  begin
    Inc(I);
    Result:=ChnCmp(Chn,Offs,I)
  end;
 while (Result=0) and (I>FChnMin[Chn]) and (Offs=FChn[Chn]^[Pred(I)].Offset) do
  Dec(I)
end;
                                                                 { ChnGetFrame }
function TTag.ChnGetFrame(Chn: Byte; OffsMin, OffsMax: LongInt): Boolean;
 var I: Word;
begin                         { TEST }
 Result:=false;
 FChnMin[Chn]:=1;
 FChnMax[Chn]:=FChnCount[Chn];
 if FChnCount[Chn]=0 then
    Exit;
 if (ChnSearchFirst(Chn,OffsMin-MaxChnTagLen,I)<=0) and
    (OffsMax>=FChn[Chn]^[I].Offset) then
  begin
   FChnMin[Chn]:=I;
   ChnSearchFirst(Chn,Succ(OffsMax),I);
   while (I>=FChnMin[Chn]) and (FChn[Chn]^[I].Offset>OffsMax) do Dec(I);

   if I>=FChnMin[Chn] then
      begin
        FChnMax[Chn]:=I;
        Result:=true;
        Exit
      end
  end;
 FChnMin[Chn]:=1;
 FChnMax[Chn]:=0
end;

                                                                      { PagAdd }
function TTag.PagAdd(const R: TTagPagRec): Word;
 var C:   Integer;
     Min,
     Max,
     I:   Word;
begin
 Min:=FPagMin; FPagMin:=1; Max:=FPagMax; FPagMax:=FPagCount;
 Result:=0; C:=PagSearch(R.Page,I);
 if C=0 then begin FPag^[I].Tag:=R.Tag; Result:=I end
 else
  if FPagCount<MaxTagPag then
   if C>0 then begin Inc(I); Inc(FPagCount); FPag^[I]:=R; Result:=I end
   else
    begin
     Move(FPag^[I],FPag^[Succ(I)],Succ(FPagCount-I)*SizeOf(TTagPagRec));
     Inc(FPagCount); FPag^[I]:=R; Result:=I
    end
  else MessageDlg(CannottAddTag,mtError,[mbOK],0);
 if Result<>0 then Modified:=true
 else begin FPagMin:=Min; FPagMax:=Max end
end;
                                                                      { BlkAdd }
function TTag.BlkAdd(const R: TTagBlkRec): Word;
 var C:   Integer;
     Min,
     Max,
     I:   Word;
begin
 Min:=FBlkMin; FBlkMin:=1; Max:=FBlkMax; FBlkMax:=FBlkCount;
 Result:=0; C:=BlkSearch(R.Page,R.Block,I);
 if C=0 then begin FBlk^[I].Tag:=R.Tag; Result:=I end
 else
  if FBlkCount<MaxTagBlk then
   if C>0 then begin Inc(I); Inc(FBlkCount); FBlk^[I]:=R; Result:=I end
   else
    begin
     Move(FBlk^[I],FBlk^[Succ(I)],Succ(FBlkCount-I)*SizeOf(TTagBlkRec));
     Inc(FBlkCount); FBlk^[I]:=R; Result:=I
    end
  else MessageDlg(CannottAddTag,mtError,[mbOK],0);
 if Result<>0 then Modified:=true
 else begin FBlkMin:=Min; FBlkMax:=Max end
end;
                                                                      { ChnAdd }
function TTag.ChnAdd(Chn: Byte; const R: TTagChnRec): Word;
 var C:   Integer;
     Min,
     Max,
     I:   Word;
begin
 Min:=FChnMin[Chn]; FChnMin[Chn]:=1;
 Max:=FChnMax[Chn]; FChnMax[Chn]:=FChnCount[Chn];
 Result:=0; C:=ChnSearchFirst(Chn,R.Offset,I);
 if FChnCount[Chn]<MaxTagChn then
  if C>0 then begin Inc(I); Inc(FChnCount[Chn]); FChn[Chn]^[I]:=R; Result:=I end
  else
   begin
    Move(FChn[Chn]^[I],FChn[Chn]^[Succ(I)],
         Succ(FChnCount[Chn]-I)*SizeOf(TTagChnRec));
    Inc(FChnCount[Chn]); FChn[Chn]^[I]:=R; Result:=I
   end
 else MessageDlg(CannottAddTag,mtError,[mbOK],0);
 if Result<>0 then Modified:=true
 else begin FChnMin[Chn]:=Min; FChnMax[Chn]:=Max end
end;

                                                                      { PagDel }
function TTag.PagDel(I: Word): Boolean;
 var Min, Max: Word;
begin
 Min:=FPagMin; FPagMin:=1; Max:=FPagMax; FPagMax:=FPagCount;
 Result:=(I>0) and (I<=FPagCount);
 if Result then
  begin
   if I<FPagCount then Move(FPag^[Succ(I)],FPag^[I],
                            (FPagCount-I)*SizeOf(TTagPagRec));
   Dec(FPagCount); Modified:=true
  end
 else begin FPagMin:=Min; FPagMax:=Max end
end;
                                                                      { BlkDel }
function TTag.BlkDel(I: Word): Boolean;
 var Min, Max: Word;
begin
 Min:=FBlkMin; FBlkMin:=1; Max:=FBlkMax; FBlkMax:=FBlkCount;
 Result:=(I>0) and (I<=FBlkCount);
 if Result then
  begin
   if I<FBlkCount then Move(FBlk^[Succ(I)],FBlk^[I],
                            (FBlkCount-I)*SizeOf(TTagBlkRec));
   Dec(FBlkCount); Modified:=true
  end
 else begin FBlkMin:=Min; FBlkMax:=Max end
end;
                                                                      { ChnDel }
function TTag.ChnDel(Chn: Byte; I: Word): Boolean;
 var Min, Max: Word;
begin
 Min:=FChnMin[Chn]; FChnMin[Chn]:=1;
 Max:=FChnMax[Chn]; FChnMax[Chn]:=FChnCount[Chn];
 Result:=(I>0) and (I<=FChnCount[Chn]);
 if Result then
  begin
   if I<FChnCount[Chn] then Move(FChn[Chn]^[Succ(I)],FChn[Chn]^[I],
                                 (FChnCount[Chn]-I)*SizeOf(TTagChnRec));
   Dec(FChnCount[Chn]); Modified:=true
  end
 else begin FChnMin[Chn]:=Min; FChnMax[Chn]:=Max end
end;

 { ******************************************** 1997 07 16 }

function HipnoValue(tag : char) : byte;
  var
    tmp : integer;        { Wartosci hipnogramu }

begin
  case tag of
    STADIUM_4: tmp:=1;
    STADIUM_3: tmp:=2;
    STADIUM_2: tmp:=3;
    STADIUM_1: tmp:=5;
    REM:       tmp:=4;
    WAKE:      tmp:=6;
    MUSC:      tmp:=7;
   else
    tmp:=0;
  end;
 HipnoValue:=tmp;
end;

procedure TTag.MakeHipnogram(var hipno : HIPNOTABLE; maxPage : word);
  var
    i,PageNo,avrPage : word;
    sleep            : array[1..MaxStructures] of byte;
    maxstad          : word;
    stadia           : array[0..7] of word;
    k,itmp,j         : word;

begin
  pageNo:=maxPage div HowPages;
  for i:=1 to PageNo do
     hipno[i]:=0;

  for i:=1 to maxPage do
    sleep[i]:=0;

  if FPagCount<>0 then
   for i:=1 to FPagCount do
     sleep[FPag^[i].Page]:=HipnoValue(FPag^[i].Tag)
  else
    exit;

  i:=1;
  j:=1;
  while i<=maxPage do
    begin
      for k:=0 to 7 do
        stadia[k]:=0;

      for k:=0 to HowPages do
       begin
        itmp:=i+k;
        if itmp<=maxPage then
          inc(stadia[sleep[itmp]]);
       end;

       maxstad:=stadia[0];
       itmp:=0;
       for k:=1 to 7 do
         if maxstad<stadia[k] then
           begin
             maxstad:=stadia[k];
             itmp:=k;
           end;

       hipno[j]:=itmp;
       inc(j);
       inc(i,HowPages);
     end;
end;

end. { DDVTAGS }
