unit  FIRST;

interface

uses  WinTypes, WinProcs, SysUtils, Classes,  Graphics, Forms,    Controls,
      StdCtrls, ExtCtrls, Buttons,  Dialogs,
      IniFiles;

type  TurboReal = Real;
      {$IFOPT N+}
      Real      = Extended;
      {$ELSE}
      Single    = Real;
      Double    = Real;
      Extended  = Real;
      {$ENDIF}

const MaxSize    = 65520;
      MaxNameLen = 8;
      MaxExtLen  = Pred(SizeOf(TFileExt));
      MaxHistory = 8;

      Colors:            array[0..34] of record C: TColor; S: string[25] end
                 = ( (C: clBlack;	        S: 'Black'                  ),
                     (C: clMaroon;	        S: 'Maroon'                 ),
                     (C: clGreen;	        S: 'Green'                  ),
                     (C: clOlive;	        S: 'Olive Green'            ),
                     (C: clNavy;	        S: 'Navy Blue'              ),
                     (C: clPurple;	        S: 'Purple'                 ),
                     (C: clTeal;	        S: 'Teal'                   ),
                     (C: clGray;	        S: 'Gray'                   ),
                     (C: clSilver;	        S: 'Silver'                 ),
                     (C: clRed;	                S: 'Red'                    ),
                     (C: clLime;	        S: 'Lime Green'             ),
                     (C: clBlue;	        S: 'Blue'                   ),
                     (C: clFuchsia;	        S: 'Fuchsia'                ),
                     (C: clAqua;	        S: 'Aqua'                   ),
                     (C: clWhite;	        S: 'White'                  ),
                     (C: clBackground;          S: 'Desktop'                ),
                     (C: clAppWorkSpace;        S: 'Application Workspace'  ),
                     (C: clWindow;              S: 'Window Background'      ),
                     (C: clWindowText;          S: 'Window Text'            ),
                     (C: clMenu;                S: 'Menu Bar'               ),
                     (C: clMenuText;            S: 'Menu Text'              ),
                     (C: clActiveCaption;       S: 'Active Title Bar'       ),
                     (C: clInactiveCaption;     S: 'Inactive Title Bar'     ),
                     (C: clCaptionText;         S: 'Active Title Bar Text'  ),
                     (C: clInactiveCaptionText; S: 'Inactive Title Bar Text'),
                     (C: clActiveBorder;        S: 'Active Border'          ),
                     (C: clInactiveBorder;      S: 'Inactive Border'        ),
                     (C: clWindowFrame;         S: 'Window Frame'           ),
                     (C: clBtnFace;             S: 'Button Face'            ),
                     (C: clBtnShadow;           S: 'Button Shadow'          ),
                     (C: clBtnText;             S: 'Button Text'            ),
                     (C: clBtnHighlight;        S: 'Button Highlight'       ),
                     (C: clGrayText;            S: 'Disabled Text'          ),
                     (C: clHighlight;           S: 'Highlight'              ),
                     (C: clHighlightText;       S: 'Highlighted Text'       ) );

      BrushStyles:       array[TBrushStyle] of string[15]
                         = ( 'Solid', 'Clear', 'Horizontal', 'Vertical',
                             'FDiagonal', 'BDiagonal', 'Cross', 'DiagCross' );

      PenModes:          array[TPenMode] of string[15]
                         = ( 'Black', 'White', 'Nop', 'Not', 'Copy', 'NotCopy',
                             'MergePenNot', 'MaskPenNot', 'MergeNotPen',
                             'MaskNotPen', 'Merge', 'NotMerge', 'Mask',
                             'NotMask', 'Xor', 'NotXor' );

      PenStyles:         array[TPenStyle] of string[15]
                         = ( 'Solid', 'Dash', 'Dot', 'DashDot',
                             'DashDotDot', 'Clear', 'InsideFrame' );

      AllFilter:         string[30] = 'All files (*.*)|*.*';
      SaveTxt:           string[30] = 'Save changes to file?';

      CannotFindFileTxt: string[30] = 'Cannot find any file.';
      PathNotExistsTxt:  string[30] = 'Path does not exist.';
      PleaseVerifyTxt:   string[40] = 'Please verify that the correct ';
      NameGivenTxt:      string[30] = 'file name is given.';
      PathGivenTxt:      string[30] = 'path is given.';

      InvalidNumFormTxt: string[30] = 'Invalid numeric format for ';
      MustNotBeEmptyTxt: string[30] = 'This field must not be empty';
      InvalidFilFormTxt: string[20] = 'Invalid file format.';
      MemOverflowTxt:    string[20] = 'Out of memory.';
      IOErrorNoTxt:      string[20] = 'I/O error ';

      IOErrorTxt:        array[1..18] of record C: Integer; T: string[30] end
                         = ( (C:   2; T: 'File not found.'              ),
                             (C:   3; T: 'Path not found.'              ),
                             (C:   4; T: 'Too many open files.'         ),
                             (C:   5; T: 'File access denied.'          ),
                             (C:   6; T: 'Invalid file handle.'         ),
                             (C:  12; T: 'Invalid file access code.'    ),
                             (C:  15; T: 'Invalid drive.'               ),
                             (C:  16; T: 'Cannot remove current dir.'   ),
                             (C:  17; T: 'Cannot rename across drives.' ),
                             (C:  18; T: 'No more matching files.'      ),
                             (C: 100; T: 'Disk read error.'             ),
                             (C: 101; T: 'Disk full.'                   ),
                             (C: 102; T: 'File not assigned.'           ),
                             (C: 103; T: 'File not open.'               ),
                             (C: 104; T: 'File not open for input.'     ),
                             (C: 105; T: 'File not open for output.'    ),
                             (C: 106; T: 'Invalid numeric format.'      ),
                             (C: 107; T: 'Invalid file format.'         ) );

      DrawFonts:         array[Boolean] of TFontName
                         = ( 'Small Fonts', 'MS Sans Serif' );

      faNormal: Word = faReadOnly or faArchive;

      MainIniFileName: TFileName  = '';

      CRLF = #13#10;

var   FileInfo: TSearchRec;

type  SearchFunType = function(i: Word; var s: string): Word of object;
      SwapProcType  = procedure(d, u: Word) of object;


procedure QSort(Lo, Hi: Word; SearchFun: SearchFunType; SwapProc: SwapProcType);
function  BSearch(const Key: string;
                  Lo, Hi: Word; SearchFun: SearchFunType): Word;

function  StrToChar(const Str: string): Char;
function  CutStr(var Str): string;
function  FillStr(var Str; Filler: Char): string;
function  CleanStr(var Str; const Mask: string): string;
function  PadStr(var Str; W: Byte; Filler: Char): string;
function  TrimStr(var Str): string;
function  ShrStr(var Str; W: Integer; Filler: Char): string;
function  CutPath(P: string; W: Integer): string;
function  SN(N: LongInt; W: Integer): string;
function  SR(R: Real; W, D: Integer): string;
function  BinB(var X): string;
function  BinW(var X): string;
function  BinL(var X): string;
function  HexB(var X): string;
function  HexW(var X): string;
function  HexL(var X): string;

function  IntInRange(Value, Min, Max: LongInt): LongInt;
function  SetIntegerValue(const Name: string; S: string; var Value: Integer;
                          QuietMode: Boolean): Boolean;
function  CheckNotEmpty(const Name: string; Value: string): Boolean;

procedure ClearHint;
function  SetCursor(Cursor: TCursor): TCursor;
procedure SetFormPos(F: TForm; LMargin, TMargin: Integer);

function  TextLeft(Canvas: TCanvas; Rect: TRect; Offset: Integer;
                   const Text: string): Integer;
function  TextTop(Canvas: TCanvas; Rect: TRect; const Text: string): Integer;
procedure SetFont(Font: TFont; const FName: TFontName; const FSize: Integer;
                  const FStyle: TFontStyles; const FColor: TColor);
procedure SetBrush(Brush: TBrush; Color: TColor; Style: TBrushStyle);
procedure SetPen(Pen: TPen; Color: TColor; Mode: TPenMode;
                 Style: TPenStyle; Width: Integer);
procedure DrawButton(Canvas: TCanvas; Rect: TRect; W, H: Integer;
                     Down: Boolean; FontColor: TColor; FontSize: Integer;
                     const Caption: string);
procedure DrawCaption(Canvas: TCanvas; Rect: TRect;
                      BevelType: TPanelBevel;
                      FontSize, Offset: Integer;
                      const Caption: string);
procedure DrawCheckBox(Canvas: TCanvas; Rect: TRect;
                       BevelType: TPanelBevel;
                       Selected, Checked: Boolean);
procedure DrawField(Canvas: TCanvas; Rect: TRect; Color: TColor;
                    Selected: Boolean;
                    FontSize, Offset: Integer;
                    const Text: string);

procedure AssignColor(List: TStrings);
function  SetColor(Color: TColor): string;
function  GetColor(const Color: string): TColor;
procedure AssignBrushStyle(List: TStrings);
function  SetBrushStyle(BrushStyle: TBrushStyle): string;
function  GetBrushStyle(const BrushStyle: string): TBrushStyle;
procedure AssignPenMode(List: TStrings);
function  SetPenMode(PenMode: TPenMode): string;
function  GetPenMode(const PenMode: string): TPenMode;
procedure AssignPenStyle(List: TStrings);
function  SetPenStyle(PenStyle: TPenStyle): string;
function  GetPenStyle(const PenStyle: string): TPenStyle;

procedure UpdateHistory(const Text: string; Strings: TStrings;
                        CharCase: TEditCharCase);
procedure LoadHistory(const FileName, Section: string; Strings: TStrings);
procedure SaveHistory(const FileName, Section: string; Strings: TStrings);

function  MemOverflowError: Boolean;
function  MemInit(var PA; Size: Word): Boolean;
function  MemInitQuiet(var PA; Size: Word): Boolean;
function  MemResize(var PA; CurSize, NewSize: Word): Boolean;
procedure MemFree(var PA; Size: Word);

function  IOError(const FileName: string; Code: Integer): Boolean;
function  TryFindFirst(const FileMask: string; QuietMode: Boolean): Integer;
function  TryFindNext: Integer;
procedure TryFindClose;
function  FindFile(var FileMask: string; QuietMode: Boolean): Boolean;


implementation

const HexDig: array[0..15] of Char = ('0','1','2','3','4','5','6','7',
                                      '8','9','A','B','C','D','E','F');

                                                                       { QSort }
procedure QSort(Lo, Hi: Word; SearchFun: SearchFunType; SwapProc: SwapProcType);

 procedure QS(down, up: word);
  var
     d,u     : longint;      { Modyfikacja 1998 02 21 }
     s,sd,su : string;

 begin
  s:=''; sd:=''; su:='';
  d:=down; u:=up; SearchFun((d+u) shr 1,s);
  repeat
    repeat
      SearchFun(d,sd);
      if ANSICompareText(sd,s)<0 then
        Inc(d)
      else Break
    until false;

   repeat
      SearchFun(u,su);
      if ANSICompareText(su,s)>0 then
        Dec(u)
      else Break
   until false;

   if d<=u then
      begin
        SwapProc(d,u);
        Inc(d);
        Dec(u);
      end;
  until d>u;
  if down<u  then QS(down,u );
  if    d<up then QS(   d,up)
 end; { QS }

begin
 if Lo<Hi then QS(Lo,Hi)
end;
                                                                     { BSearch }
function BSearch(const Key: string;
                 Lo, Hi: Word; SearchFun: SearchFunType): Word;
 var i, down, up: Word;
     s:           string;
     c:           Integer;
begin
 down:=Lo; up:=Hi;
 Result:=0; if up<down then Exit;
 repeat
  i:=(down+up) shr 1;
  Result:=SearchFun(i,s); c:=ANSICompareText(Key,Copy(s,1,Length(Key)));
  if c<0 then
   if i=Lo then Break
   else up:=Pred(i)
  else
   if c>0 then
    if i=Hi then Break
    else down:=Succ(i)
   else Break
 until down>up;
 while (c>0) and (i<Hi) do
  begin
   Result:=SearchFun(Succ(i),s); c:=ANSICompareText(Key,Copy(s,1,Length(Key)));
   if c>0 then Inc(i) else Exit
  end;
 while (c=0) and (i>Lo) do
  begin
   SearchFun(Pred(i),s); c:=ANSICompareText(Key,Copy(s,1,Length(Key)));
   if c=0 then begin Dec(i); Result:=SearchFun(i,s) end else Exit
  end
end;

                                                                     { TrimStr }
function TrimStr(var Str): string;
 var S:  string absolute Str;
     SL: Byte   absolute Str;
begin
 while (SL>0) and ((S[SL]=' ') or (S[SL]=#0)) do Dec(SL); Result:=S
end;
                                                                   { StrToChar }
function StrToChar(const Str: string): Char;
begin
 if Str<>'' then Result:=Str[1] else Result:=' '
end;
                                                                      { CutStr }
function CutStr(var Str): string;
 var S:  string absolute Str;
     SL: Byte   absolute Str;
begin
 while (SL>0) and ((S[SL]=' ') or (S[SL]=#0)) do Dec(SL);
 while (SL>0) and ((S[1]=' ') or (S[1]=#0)) do Delete(S,1,1);
 Result:=S
end;
                                                                     { FillStr }
function FillStr(var Str; Filler: Char): string;
 var S:  string absolute Str;
     SL: Byte   absolute Str;
     P:  Byte;
begin
 repeat
  P:=Pos(' ',S); if P>0 then if Filler=' ' then Delete(S,P,1) else S[P]:=Filler
 until P=0;
 Result:=S
end;
                                                                    { CleanStr }
function CleanStr(var Str; const Mask: string): string;
 var S:  string absolute Str;
     SL: Byte   absolute Str;
     P:  Byte;
begin
 Result:='';
 for P:=1 to SL do if Pos(S[P],Mask)>0 then Result:=Result+S[P];
 S:=Result
end;
                                                                      { PadStr }
function PadStr(var Str; W: Byte; Filler: Char): string;
 var S:  string absolute Str;
     SL: Byte   absolute Str;
begin
 if SL<W then begin FillChar(S[Succ(SL)],W-SL,Filler); SL:=W end;
 Result:=S
end;
                                                                      { ShrStr }
function ShrStr(var Str; W: Integer; Filler: Char): string;
 var S:  string absolute Str;
     SL: Byte   absolute Str;
     L:  Byte;
begin
 if SL<W then
  begin L:=W-SL; Move(S[1],S[Succ(L)],SL); FillChar(S[1],L,Filler); SL:=W end;
 Result:=S
end;
                                                                     { CutPath }
function CutPath(P: string; W: Integer): string;
 var PL: Byte absolute P;
     j:  Boolean;
begin
 P:=ANSILowerCase(ExpandFileName(P));
 j:=W<0; W:=IntInRange(Abs(W),18,255);
 if PL>W then P:=Copy(P,1,3)+'...'+Copy(P,PL-W+7,W-6)
 else if j then ShrStr(P,W,' ');
 Result:=P
end;
                                                                          { SN }
function SN(N: LongInt; W: Integer): string;
 var S: string;
begin
 Str(N,S);
 if W<0 then
  if S[1]<>'-' then ShrStr(S,-W,'0')
  else begin Delete(S,1,1); S:='-'+ShrStr(S,Pred(-W),'0') end
 else ShrStr(S,W,' ');
 Result:=S
end;
                                                                          { SR }
function SR(R: Real; W, D: Integer): string;
 var S: string;
begin
 Str(R:Abs(W):D,S);
 if W<0 then
  if S[1]<>'-' then ShrStr(S,-W,'0')
  else begin Delete(S,1,1); S:='-'+ShrStr(S,Pred(-W),'0') end
 else ShrStr(S,W,' ');
 Result:=S
end;
                                                                        { BinB }
function BinB(var X): string;
 const S: string[8] = '12345678';
 var   B: Byte absolute X;
       i: Byte;
begin
 for i:=0 to 7 do Byte(S[8-i]):=Byte('0') + ((B shr i) and $01);
 Result:=S
end;
                                                                        { BinW }
function BinW(var X): string;
 var W: array[0..1] of Byte absolute X;
begin
 Result:=BinB(W[1])+BinB(W[0])
end;
                                                                        { BinL }
function BinL(var X): string;
 var L: array[0..3] of Byte absolute X;
begin
 Result:=BinB(L[3])+BinB(L[2])+BinB(L[1])+BinB(L[0])
end;
                                                                        { HexB }
function HexB(var X): string;
 var B: Byte absolute X;
begin
 Result:=HexDig[B shr 4]+HexDig[B and $0F]
end;
                                                                        { HexW }
function HexW(var X): string;
 var W: array[0..1] of Byte absolute X;
begin
 Result:=HexB(W[1])+HexB(W[0])
end;
                                                                        { HexL }
function HexL(var X): string;
 var L: array[0..3] of Byte absolute X;
begin
 Result:=HexB(L[3])+HexB(L[2])+HexB(L[1])+HexB(L[0])
end;

                                                                  { IntInRange }
function IntInRange(Value, Min, Max: LongInt): LongInt;
begin
 if Value<Min then Result:=Min
 else
  if Value>Max then Result:=Max
  else Result:=Value
end;
                                                             { SetIntegerValue }
function SetIntegerValue(const Name: string; S: string; var Value: Integer;
                         QuietMode: Boolean): Boolean;
 var V, ec: Integer;
begin
 Val(CutStr(S),V,ec); Result:=ec=0;
 if Result then Value:=V
 else if not QuietMode then
  MessageDlg(S+CRLF+InvalidNumFormTxt+Name+'.',mtError,[mbOK],0)
end;
                                                               { CheckNotEmpty }
function CheckNotEmpty(const Name: string; Value: string): Boolean;
begin
 TrimStr(Value);
 Result:=TrimStr(Value)<>'';
 if not Result then
  MessageDlg(Name+CRLF+CRLF+MustNotBeEmptyTxt+'.',mtError,[mbOK],0)
end;
                                                                   { ClearHint }
procedure ClearHint;
begin
 Application.Hint:=''
end;
                                                                   { SetCursor }
function SetCursor(Cursor: TCursor): TCursor;
begin
 Result:=Screen.Cursor; Screen.Cursor:=Cursor
end;
                                                                  { SetFormPos }
procedure SetFormPos(F: TForm; LMargin, TMargin: Integer);
begin
 with F do
  begin
   Position:=poDesigned;
   if LMargin+Width>Screen.Width then LMargin:=Screen.Width-Width;
   if LMargin<0 then LMargin:=0;
   if TMargin+Height>Screen.Height then TMargin:=Screen.Height-Height;
   if TMargin<0 then TMargin:=0;
   Left:=LMargin; Top:=TMargin
  end
end;
                                                                    { TextLeft }
function TextLeft(Canvas: TCanvas; Rect: TRect; Offset: Integer;
                  const Text: string): Integer;
begin
 with Canvas, Rect do
  if Offset=0 then  Result:=Left+(Succ(Right-Left)-TextWidth(Text)) div 2
  else
   if Offset>0 then Result:=Left+Offset
   else             Result:=Left+Succ(Right-Left)+Offset-TextWidth(Text)
end;
                                                                     { TextTop }
function TextTop(Canvas: TCanvas; Rect: TRect; const Text: string): Integer;
begin
 with Canvas, Rect do Result:=Top+(Succ(Bottom-Top)-TextHeight(Text)) div 2
end;
                                                                     { SetFont }
procedure SetFont(Font: TFont; const FName: TFontName; const FSize: Integer;
                  const FStyle: TFontStyles; const FColor: TColor);
begin
 with Font do begin Name:=FName; Size:=FSize; Style:=FStyle; Color:=FColor end
end;
                                                                    { SetBrush }
procedure SetBrush(Brush: TBrush; Color: TColor; Style: TBrushStyle);
begin
 Brush.Color:=Color; Brush.Style:=Style
end;
                                                                      { SetPen }
procedure SetPen(Pen: TPen; Color: TColor; Mode: TPenMode;
                 Style: TPenStyle; Width: Integer);
begin
 Pen.Color:=Color; Pen.Mode:=Mode; Pen.Style:=Style; Pen.Width:=Width
end;
                                                                  { DrawButton }
procedure DrawButton(Canvas: TCanvas; Rect: TRect; W, H: Integer;
                     Down: Boolean; FontColor: TColor; FontSize: Integer;
                     const Caption: string);
begin
 SetFont(Canvas.Font,DrawFonts[FontSize>=8],FontSize,[fsBold],FontColor);
 with Rect do
  begin
   W:=-((Succ(Right-Left)-W) div 2);
   H:=-((Succ(Bottom-Top)-H) div 2)
  end;
 if W>0 then W:=0; if H>0 then H:=0;
 InflateRect(Rect,W,H);
 DrawButtonFace(Canvas,Rect,1,bsAutoDetect,true,Down,false);
 InflateRect(Rect,-2,-2);
 Canvas.TextRect(Rect,TextLeft(Canvas,Rect,0,Caption),
                      TextTop(Canvas,Rect,Caption),
                 Caption)
end;
                                                                 { DrawCaption }
procedure DrawCaption(Canvas: TCanvas; Rect: TRect;
                      BevelType: TPanelBevel;
                      FontSize, Offset: Integer;
                      const Caption: string);
 var L, T: Integer;
begin
 SetFont(Canvas.Font,DrawFonts[FontSize>=8],FontSize,[fsBold],clWindowText);
 if BevelType=bvLowered then Frame3D(Canvas,Rect,clBtnShadow,clBtnHighlight,1)
 else
  if BevelType=bvRaised then Frame3D(Canvas,Rect,clBtnHighlight,clBtnShadow,1);
 Canvas.Brush.Color:=clBtnFace; Canvas.FillRect(Rect);
 Canvas.TextRect(Rect,TextLeft(Canvas,Rect,Offset,Caption),
                      TextTop(Canvas,Rect,Caption),
                 Caption)
end;
                                                                { DrawCheckBox }
procedure DrawCheckBox(Canvas: TCanvas; Rect: TRect;
                       BevelType: TPanelBevel;
                       Selected, Checked: Boolean);
 const CheckMark: array[Boolean] of Char = ( ' ', #215 );
begin
 if Selected then
  if BevelType<>bvLowered then BevelType:=bvLowered
  else BevelType:=bvNone;
 if BevelType=bvLowered then Frame3D(Canvas,Rect,clBtnShadow,clBtnHighlight,1)
 else
  if BevelType=bvRaised then Frame3D(Canvas,Rect,clBtnHighlight,clBtnShadow,1);
 Canvas.Brush.Color:=clBtnFace; Canvas.FillRect(Rect);
 with Rect do
  InflateRect(Rect,(Left-Right+13) div 2,(Top-Bottom+13) div 2);
 Frame3D(Canvas,Rect,clBtnShadow,clBtnHighlight,1);
 Frame3D(Canvas,Rect,clBlack,clBtnFace,1);
 if Selected then
  begin
   SetFont(Canvas.Font,'Fixedsys',8,[fsBold],clHighlightText);
   Canvas.Brush.Color:=clHighlight
  end
 else
  begin
   SetFont(Canvas.Font,'Fixedsys',8,[fsBold],clWindowText);
   Canvas.Brush.Color:=clWindow
  end;
 Canvas.FillRect(Rect);
 Canvas.TextRect(Rect,TextLeft(Canvas,Rect,0,CheckMark[Checked]),
                      Pred(TextTop(Canvas,Rect,CheckMark[Checked])),
                 CheckMark[Checked])
end;
                                                                   { DrawField }
procedure DrawField(Canvas: TCanvas; Rect: TRect; Color: TColor;
                    Selected: Boolean;
                    FontSize, Offset: Integer;
                    const Text: string);
begin
 if Selected then
  begin
   SetFont(Canvas.Font,DrawFonts[FontSize>=8],FontSize,[],clHighlightText);
   Canvas.Brush.Color:=clHighlight
  end
 else
  begin
   SetFont(Canvas.Font,DrawFonts[FontSize>=8],FontSize,[],Color);
   Canvas.Brush.Color:=clWindow
  end;
 Canvas.FillRect(Rect);
 Canvas.TextRect(Rect,TextLeft(Canvas,Rect,Offset,Text),
                      TextTop(Canvas,Rect,Text),
                 Text)
end;
                                                                 { AssignColor }
procedure AssignColor(List: TStrings);
 var I: Integer;
begin
 List.Clear;
 for I:=Low(Colors) to High(Colors) do List.Add(Colors[I].S)
end;
                                                                    { SetColor }
function SetColor(Color: TColor): string;
 var I: Integer;
begin
 for I:=Low(Colors) to High(Colors) do
  if Colors[I].C=Color then begin Result:=Colors[I].S; Exit end;
 Result:=Colors[Low(Colors)].S
end;
                                                                    { GetColor }
function GetColor(const Color: string): TColor;
 var I: Integer;
begin
 for I:=Low(Colors) to High(Colors) do
  if Colors[I].S=Color then begin Result:=Colors[I].C; Exit end;
 Result:=Colors[Low(Colors)].C
end;
                                                            { AssignBrushStyle }
procedure AssignBrushStyle(List: TStrings);
 var I: TBrushStyle;
begin
 List.Clear;
 for I:=Low(TBrushStyle) to High(TBrushStyle) do List.Add(BrushStyles[I])
end;
                                                               { SetBrushStyle }
function SetBrushStyle(BrushStyle: TBrushStyle): string;
begin
 Result:=BrushStyles[BrushStyle]
end;
                                                               { GetBrushStyle }
function GetBrushStyle(const BrushStyle: string): TBrushStyle;
 var I: TBrushStyle;
begin
 for I:=Low(TBrushStyle) to High(TBrushStyle) do
  if BrushStyles[I]=BrushStyle then begin Result:=I; Exit end;
 Result:=Low(TBrushStyle)
end;
                                                               { AssignPenMode }
procedure AssignPenMode(List: TStrings);
 var I: TPenMode;
begin
 List.Clear;
 for I:=Low(TPenMode) to High(TPenMode) do List.Add(PenModes[I])
end;
                                                                  { SetPenMode }
function SetPenMode(PenMode: TPenMode): string;
begin
 Result:=PenModes[PenMode]
end;
                                                                  { GetPenMode }
function GetPenMode(const PenMode: string): TPenMode;
 var I: TPenMode;
begin
 for I:=Low(TPenMode) to High(TPenMode) do
  if PenModes[I]=PenMode then begin Result:=I; Exit end;
 Result:=Low(TPenMode)
end;
                                                              { AssignPenStyle }
procedure AssignPenStyle(List: TStrings);
 var I: TPenStyle;
begin
 List.Clear;
 for I:=Low(TPenStyle) to High(TPenStyle) do List.Add(PenStyles[I])
end;
                                                                 { SetPenStyle }
function SetPenStyle(PenStyle: TPenStyle): string;
begin
 Result:=PenStyles[PenStyle]
end;
                                                                 { GetPenStyle }
function GetPenStyle(const PenStyle: string): TPenStyle;
 var I: TPenStyle;
begin
 for I:=Low(TPenStyle) to High(TPenStyle) do
  if PenStyles[I]=PenStyle then begin Result:=I; Exit end;
 Result:=Low(TPenStyle)
end;

                                                               { UpdateHistory }
procedure UpdateHistory(const Text: string; Strings: TStrings;
                        CharCase: TEditCharCase);
 var C: TCursor;
     I: Integer;
begin
 if Text<>'' then
  begin
   C:=SetCursor(crHourglass);
   try
    I:=Strings.IndexOf(Text);
    if I>=0 then Strings.Delete(I)
    else
     if (MaxHistory>0) and (Strings.Count>=MaxHistory) then
      Strings.Delete(Pred(MaxHistory));
    case CharCase of
     ecNormal:    Strings.Insert(0,Text);
     ecUpperCase: Strings.Insert(0,ANSIUpperCase(Text));
     ecLowerCase: Strings.Insert(0,ANSILowerCase(Text));
    end
   finally SetCursor(C)
   end
  end
end;
                                                                 { LoadHistory }
procedure LoadHistory(const FileName, Section: string; Strings: TStrings);
 var C:       TCursor;
     IniFile: TIniFile;
     S, H:    string;
     I:       Integer;
begin
 if (FileName<>'') and (Section<>'') then
  begin
   C:=SetCursor(crHourglass);
   try IniFile:=TIniFile.Create(FileName);
    try
     S:='History_'+Section;
     Strings.Clear;
     for I:=1 to MaxHistory do
      begin
       H:=IniFile.ReadString(S,IntToStr(I),'');
       if H<>'' then Strings.Add(H)
      end
    finally IniFile.Free
    end
   finally SetCursor(C)
   end
  end
end;
                                                                 { SaveHistory }
procedure SaveHistory(const FileName, Section: string; Strings: TStrings);
 var C:       TCursor;
     IniFile: TIniFile;
     S:       string;
     I:       Integer;
begin
 if (FileName<>'') and (Section<>'') then
  begin
   C:=SetCursor(crHourglass);
   try IniFile:=TIniFile.Create(FileName);
    try
     S:='History_'+Section;
     IniFile.EraseSection(S);
     for I:=1 to Strings.Count do
      IniFile.WriteString(S,IntToStr(I),Strings[Pred(I)])
    finally IniFile.Free
    end
   finally SetCursor(C)
   end
  end
end;
                                                            { MemOverflowError }

function MemOverflowError: Boolean;
begin
 Result:=false;
 MessageDlg(MemOverflowTxt,mtError,[mbOK],0)
end;
                                                            { HeapErrorUnquiet }
function HeapErrorUnquiet(Size: Word): Integer; far;
begin
 MemOverflowError; Result:=1
end;
                                                              { HeapErrorQuiet }
function HeapErrorQuiet(Size: Word): Integer; far;
begin
 Result:=1
end;
                                                                     { MemInit }
function MemInit(var PA; Size: Word): Boolean;
 var P:             Pointer absolute PA;
     HeapErrorSave: Pointer;
begin
 if Size>0 then
  begin
   HeapErrorSave:=HeapError; HeapError:=@HeapErrorUnquiet;
   GetMem(P,Size);           HeapError:=HeapErrorSave
  end
 else P:=nil;
 Result:=P<>nil; if Result then FillChar(P^,Size,#0)
end;
                                                                { MemInitQuiet }
function MemInitQuiet(var PA; Size: Word): Boolean;
 var P:             Pointer absolute PA;
     HeapErrorSave: Pointer;
begin
 if Size>0 then
  begin
   HeapErrorSave:=HeapError; HeapError:=@HeapErrorQuiet;
   GetMem(P,Size);           HeapError:=HeapErrorSave
  end
 else P:=nil;
 Result:=P<>nil; if Result then FillChar(P^,Size,#0)
end;
                                                                   { MemResize }
function MemResize(var PA; CurSize, NewSize: Word): Boolean;
 var P:             Pointer absolute PA;
     PC:            Pointer;
     Size:          Word;
     {HeapErrorSave: Pointer;}
begin
 PC:=P; P:=nil; Result:=MemInit(P,NewSize);
 if Result then
  begin
   if NewSize>CurSize then Size:=CurSize else Size:=NewSize;
   if PC<>nil then begin Move(PC^,P^,Size); MemFree(PC,CurSize) end
  end
 else P:=PC
(*
 if (PC<>nil) and (NewSize>0) then
  begin
   HeapErrorSave:=HeapError;           HeapError:=@HeapErrorUnquiet;
   PN:=ReallocMem(PC,CurSize,NewSize); HeapError:=HeapErrorSave
  end
 else PN:=nil;
 Result:=PN<>nil;
 try MemFree(PC,CurSize)
 except on EInvalidPointer do PC:=nil
 end
*)
end;
                                                                     { MemFree }
procedure MemFree(var PA; Size: Word);
 var P: Pointer absolute PA;
begin
 if P<>nil then begin FreeMem(P,Size); P:=nil end
end; { MemFree }

                                                                     { IOError }
function IOError(const FileName: string; Code: Integer): Boolean;
 var I: Byte;
     T: string;
begin
 Result:=Code=0; if Result then Exit;
 T:='';
 for I:=Low(IOErrorTxt) to High(IOErrorTxt) do
  if Code=IOErrorTxt[I].C then begin T:=IOErrorTxt[I].T; Break end;
 if T='' then T:=IOErrorNoTxt+Sn(Code,0)+'.';
 if FileName<>'' then T:=CutPath(FileName,40)+CRLF+CRLF+T;
 MessageDlg(T,mtError,[mbOK],0)
end;
                                                                { TryFindFirst }
function TryFindFirst(const FileMask: string; QuietMode: Boolean): Integer;
begin
 Result:=FindFirst(FileMask,faNormal,FileInfo);
 if (Result=-3) and (ExtractFileName(FileMask)='') then Result:=-18;
 if (Result=0) or QuietMode then Exit;
 if Result=-3 then
  MessageDlg(CutPath(FileMask,40)+CRLF+CRLF+PathNotExistsTxt+
             CRLF+CRLF+PleaseVerifyTxt+PathGivenTxt,mtWarning,[mbOK],0)
 else
  MessageDlg(CutPath(FileMask,40)+CRLF+CRLF+CannotFindFileTxt+
             CRLF+CRLF+PleaseVerifyTxt+NameGivenTxt,mtWarning,[mbOK],0)
end;
                                                                 { TryFindNext }
function TryFindNext: Integer;
begin
 Result:=FindNext(FileInfo)
end;
                                                                { TryFindClose }
procedure TryFindClose;
begin
 FindClose(FileInfo)
end;
                                                                    { FindFile }
function FindFile(var FileMask: string; QuietMode: Boolean): Boolean;
begin
 Result:=TryFindFirst(FileMask,QuietMode)=0; TryFindClose;
 if Result then
  FileMask:=ExtractFilePath(ExpandFileName(FileMask))+FileInfo.Name
 else FileMask:=''
end;

initialization
 FileMode:=0;
 MainIniFileName:=ChangeFileExt(Application.ExeName,'.INI')
end. { FIRST }
