unit Hread;     { 1997 09 05 }

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls,ExtHead;

type
  EASHDR=record
          sign     : array[1..15] of char;
          ftype    : char;
          nchan    : byte;
          naux     : byte;
          fsamp    : word;
          nsamp    : longint;    { Bez znaku }
          d_val    : byte;
          units    : byte;
          zero     : integer;
          data_org : word;
          xhdr_org : word;
        end;

  TReadHeader = class(TForm)
    GroupBox1: TGroupBox;
    BitBtn1: TBitBtn;
    Signature: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    EditFileType: TEdit;
    Label3: TLabel;
    EditNumChn: TEdit;
    Label4: TLabel;
    EditAuxChn: TEdit;
    Label5: TLabel;
    EditFreq: TEdit;
    Label7: TLabel;
    EditFactor: TEdit;
    Label8: TLabel;
    EditZero: TEdit;
    GroupBox2: TGroupBox;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    CheckBox5: TCheckBox;
    CheckBox6: TCheckBox;
    Label6: TLabel;
    EditCellCode: TEdit;
    Label9: TLabel;
    EditSize: TEdit;
    ShowAllButton: TBitBtn;
    procedure BitBtn1Click(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure CheckBox5Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure CheckBox6Click(Sender: TObject);
    procedure ShowAllButtonClick(Sender: TObject);
  private
     stdheader : EASHDR;
     BoxState  : array[1..6] of boolean;
     plik      : file;
    { Private declarations }
  public
    { Public declarations }
    function LoadHeader(s : string; pic : boolean) : boolean;
    function CalibConst : single;
  end;

var
  ReadHeader: TReadHeader;

implementation

function GetBitState(x,k : byte) : boolean;
begin
  if (x and (1 shl k))<>0 then
    GetBitState:=true
  else
    GetBitState:=false;
end;

{$R *.DFM}

function TReadHeader.CalibConst : single;
begin
  Result:=stdheader.units;
end;

function TReadHeader.LoadHeader(s : string; pic : boolean) : boolean;
  var
    i,Code : integer;
    sign,stest : string[20];

begin
  {$I-}
   assignfile(plik,s); reset(plik,1);
  {$I+}
  if IOResult<>0 then
    begin
     MessageDlg('File access error', mtError, [mbOk], 0);
     Result:=false;
     exit;
    end;

  BlockRead(plik,stdheader,sizeof(EASHDR));
  sign:='';
  for i:=1 to 15 do
   begin
    if (Ord(stdheader.sign[i])<32) or (Ord(stdheader.sign[i])>126) then
      break;
    sign:=sign+stdheader.sign[i];
   end;

  stest:='';
  for i:=1 to 6 do
   stest:=stest+sign[i];
  if stest<>'EASREC' then
   begin
     MessageDlg('File format error', mtError, [mbOk], 0);
     Result:=false;
     exit;
   end;

  Signature.Text:=sign;
  EditFileType.Text:=stdheader.ftype+'-file';
  EditNumChn.Text:=inttostr(stdheader.nchan);
  EditAuxChn.Text:=inttostr(stdheader.naux);
  EditFreq.Text:=inttostr(stdheader.fsamp);
  EditFactor.Text:=inttostr(stdheader.units);
  EditZero.Text:=inttostr(stdheader.zero);

  for i:=1 to 6 do
    BoxState[i]:=GetBitState(stdheader.d_val,i+1);

  CheckBox1.Checked:=BoxState[1];
  CheckBox2.Checked:=BoxState[2];
  CheckBox3.Checked:=BoxState[3];
  CheckBox4.Checked:=BoxState[4];
  CheckBox5.Checked:=BoxState[5];
  CheckBox6.Checked:=BoxState[6];

  if not ((stdheader.xhdr_org=0) and (stdheader.ftype<>'D')) then
    begin
       ExtHeaderDlg.LoadNextHeaders(plik,stdheader.nchan);
       if pic then
        begin
         ShowAllButton.Enabled:=true;
         ExtHeaderDlg.Show;
        end
       else ShowAllButton.Enabled:=false;
    end;

  CloseFile(plik);
  Code:=0;
  if GetBitState(stdheader.d_val,0) then
    Code:=Code+1;
  if GetBitState(stdheader.d_val,1) then
    Code:=Code+2;

  EditCellCode.Text:=inttostr(Code);
  if Code<>0 then
    begin
      Label9.Visible:=true;
      EditSize.Visible:=true;
      EditSize.Text:=inttostr(1 shl (Code-1));
    end
  else
    begin
      Label9.Visible:=false;
      EditSize.Visible:=false;
    end;
  Result:=true;
end;

procedure TReadHeader.BitBtn1Click(Sender: TObject);
begin
  ExtHeaderDlg.Close;
  Close;
end;

procedure TReadHeader.CheckBox1Click(Sender: TObject);
begin
  CheckBox1.Checked:=BoxState[1];
end;

procedure TReadHeader.CheckBox2Click(Sender: TObject);
begin
   CheckBox2.Checked:=BoxState[2];
end;

procedure TReadHeader.CheckBox3Click(Sender: TObject);
begin
  CheckBox3.Checked:=BoxState[3];
end;

procedure TReadHeader.CheckBox5Click(Sender: TObject);
begin
  CheckBox5.Checked:=BoxState[5];
end;

procedure TReadHeader.CheckBox4Click(Sender: TObject);
begin
  CheckBox4.Checked:=BoxState[4];
end;

procedure TReadHeader.CheckBox6Click(Sender: TObject);
begin
  CheckBox6.Checked:=BoxState[6];
end;

procedure TReadHeader.ShowAllButtonClick(Sender: TObject);
begin
  ExtHeaderDlg.Show;
end;

end.
