unit Convdlg;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, Dialogs, SysUtils;

type
  TBtnBottomDlg = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    Edit1: TEdit;
    Edit2: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    procedure OKBtnClick(Sender: TObject);
    procedure CancelBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormPaint(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    MaxValue,ConvFactor : single;
    OK                  : boolean;

  end;

var
  BtnBottomDlg: TBtnBottomDlg;

implementation

{$R *.DFM}

procedure TBtnBottomDlg.OKBtnClick(Sender: TObject);
  var
    Code : integer;
    Old  : single;

begin
  OK:=true;
  Old:=ConvFactor;
  Val(Edit1.Text,ConvFactor, Code);
  if code<>0 then
   begin
     MessageDlg('Error at position: ' + IntToStr(Code), mtWarning, [mbOk], 0);
     ConvFactor:=Old;
     OK:=false;
   end;

  Old:=MaxValue;
  Val(Edit2.Text,MaxValue, Code);
  if code<>0 then
   begin
     MessageDlg('Error at position: ' + IntToStr(Code), mtWarning, [mbOk], 0);
     MaxValue:=Old;
     Ok:=false;
   end;
  Close;
end;

procedure TBtnBottomDlg.CancelBtnClick(Sender: TObject);
begin
  OK:=false;
  Close;
end;

procedure TBtnBottomDlg.FormCreate(Sender: TObject);
begin
  ConvFactor:=1.0;
  MaxValue:=100.0;
end;

procedure TBtnBottomDlg.FormPaint(Sender: TObject);
  var
    s : string;

begin
  str(ConvFactor:5:3,s);
  Edit1.Text:=s;
  str(MaxValue:5:3,s);
  Edit2.Text:=s;
end;

end.
