unit  DDVAPDLG;

interface

uses  SysUtils, StdCtrls, Dialogs,
      FIRST,    DDVINI;

type  TDialogKind = (dkTag, dkIni);

function ApplyOpenDialog(DialogKind: TDialogKind; var FName: string): Boolean;
function ApplySaveDialog(DialogKind: TDialogKind; var FName: string): Boolean;

implementation

uses  DDVMAIN;

const DefExt:      array[TDialogKind] of string[3]
                   = ( 'TAG', 'INI' );

      DefFilter:   array[TDialogKind] of string[40]
                   = ( 'Tag files (*.TAG)|*.TAG|', 'INI files (*.INI)|*.INI|' );

      OpenOptions: array[TDialogKind] of TOpenOptions
                   = ( [ofReadOnly,{ofNoChangeDir,}
                        ofPathMustExist,ofFileMustExist],
                       [ofReadOnly,{ofNoChangeDir,}
                        ofPathMustExist,ofFileMustExist] );

      SaveOptions: array[TDialogKind] of TOpenOptions
                   = ( [ofOverwritePrompt,ofHideReadOnly,{ofNoChangeDir,}
                        ofPathMustExist,ofNoReadOnlyReturn],
                       [ofHideReadOnly,{ofNoChangeDir,}
                        ofPathMustExist,ofNoReadOnlyReturn] );

      OpenTitle:   array[TDialogKind] of string[40]
                   = ( 'Open Tag File', 'Load From File' );

      SaveTitle:   array[TDialogKind] of string[40]
                   = ( 'Save Tag File As...', 'Save To File' );

function ApplyOpenDialog(DialogKind: TDialogKind; var FName: string): Boolean;
begin
 with MainForm.OpenDialog do
  begin
   DefaultExt:=DefExt[DialogKind]; Filter:=DefFilter[DialogKind]+AllFilter;
   Options:=OpenOptions[DialogKind]; Title:=OpenTitle[DialogKind];
   LoadHistory(MainIniFileName,DefExt[DialogKind],HistoryList);
   FileName:=ANSILowerCase(ExtractFileName(FName));
   InitialDir:=ExtractFilePath(ExpandFileName(FName));

   Result:=Execute;

   if Result then
    begin
     FName:=ANSILowerCase(ExpandFileName(FileName));
     UpdateHistory(FileName,HistoryList,ecLowerCase);
     SaveHistory(MainIniFileName,DefExt[DialogKind],HistoryList)
    end
  end
end;

function ApplySaveDialog(DialogKind: TDialogKind; var FName: string): Boolean;
begin
 with MainForm.SaveDialog do
  begin
   DefaultExt:=DefExt[DialogKind]; Filter:=DefFilter[DialogKind]+AllFilter;
   Options:=SaveOptions[DialogKind]; Title:=SaveTitle[DialogKind];
   LoadHistory(MainIniFileName,DefExt[DialogKind],HistoryList);
   FileName:=ANSILowerCase(ExtractFileName(FName));
   InitialDir:=ExtractFilePath(ExpandFileName(FName));

   Result:=Execute;

   if Result then
    begin
     FName:=ANSILowerCase(ExpandFileName(FileName));
     UpdateHistory(FileName,HistoryList,ecLowerCase);
     SaveHistory(MainIniFileName,DefExt[DialogKind],HistoryList)
    end
  end
end;

end. { DDVAPDLG }
