unit  DDVCHILD;

interface

uses  WinTypes, WinProcs, SysUtils, Classes,  Graphics, Forms,    Controls,
      StdCtrls, ExtCtrls, Menus,    Dialogs,  ClipBrd,
      FIRST,    DDVINI,   DDVAPDLG, DDVINSTR, DDVTAGS,  DDVMAIN,  DDVGOTO,
      DDVMNTG,  DDVTAGLI, DDVFRMT, GETWZR, FFT, ZOOM, CHNFFT, HREAD,
      PEGDLG, CALIBDLG, FILTFFT, Printers, PATIENT;

type  TPoints    = array[0..Pred(MaxSize div SizeOf(TPoint))] of TPoint;
      TX2Smp     = array[0..Pred(MaxSize div SizeOf(Word))] of Word;
      TY2Chn     = array[0..Pred(MaxSize)] of Byte;

      TDragMode  = ( dmNone, dmMove, dmLeft, dmRight );

      TChLabel   = class;

      TChRec     = record
                    Channel: Byte;
                    M:       Integer;
                    D:       Integer;
                    Refs:    Byte;
                    Ref:     array[1..MaxChannels] of Byte;
                    Org:     LongInt;
                    ValFun:  char; { Zmiana typu }
                    ChLabel: TChLabel
                   end;

      TTagBtnRec = record
                    BtnInc:           Integer;
                    BtnLeft:          Integer;
                    TagLeft:          Char;
                    TagAct:           Char
                   end;

      TChildForm = class(TForm)
                    ScrollBox:             TScrollBox;
                          PanelLab:        TPanel;
                          Image:           TImage;
                          LabelScroll:     TLabel;
         { Modyfikacja }
    OpenWzrLoadDialog: TOpenDialog;
    SaveWzrDialog: TSaveDialog;
    SaveAsciiDialog: TSaveDialog;

                    procedure FormCreate(Sender: TObject);
                    procedure FormResize(Sender: TObject);
                    procedure FormCloseQuery(Sender: TObject;
                                             var CanClose: Boolean);
                    procedure FormClose(Sender: TObject;
                                        var Action: TCloseAction);

                    procedure FormKeyPress(Sender: TObject; var Key: Char);

                    procedure ImageMouseDown(Sender: TObject;
                                             Button: TMouseButton;
                                             Shift: TShiftState; X, Y: Integer);
                    procedure ImageMouseMove(Sender: TObject;
                                             Shift: TShiftState; X, Y: Integer);
                    procedure ImageMouseUp(Sender: TObject;
                                           Button: TMouseButton;
                                           Shift: TShiftState; X, Y: Integer);
                    procedure ImageDblClick(Sender: TObject);
                    { Modyfikacja + i - 1997 06 29 }
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure OnActive(Sender: TObject);
    procedure FormKeyUP(Sender: TObject; var Key: Word;
      Shift: TShiftState);
                   private { Private declarations }
                    FormOK:  Boolean;
                    iStream:          TiStream;
                    Tags:             TTag;
                    Mont:             TMontage;

                    ChTab:            array[1..MaxChannels] of TChRec;
                    BufTab:           array[1..MaxChannels] of TIBufPtr;

                    MaxOffset:        LongInt;
                    { Input stream related variables }
                    iSampFreq:        Word;
                    iADBits:          Byte;
                    { Tagging parameters }
                    TagKind:          TTagKind;
                    TagBtns:          array[TTagKind] of TTagBtnRec;
                    { Mapping buffers }
                    Points:           ^TPoints;
                    X2Smp:            ^TX2Smp;
                    Y2Chn:            ^TY2Chn;
                    MappingOK:        Boolean;
                    { Mouse coordinates }
                    mOrg:             TPoint;
                    mSmp:             LongInt;
                    mChn:             Byte;
                    mBlk:             Byte;
                    mPag:             Word;
                    { Dragging parameters }
                    DragMode:         TDragMode;
                    Dragging:         Boolean;
                    DoubleClicked:    Boolean;
                    dRect:            TRect;
                    dSmp:             LongInt;
                    { Selected block parameters }
                    BlkAct:           array[TTagKind] of Boolean;
                    TagNDX:           array[TTagKind] of Word;
                    pPag:             Word;
                    bPag:             Word;
                    bBlk:             Byte;
                    cChn:             Byte;
                    cOffs:            LongInt;
                    cLen:             Word;

                    sPag:             Word;
                    sBlk:             Byte;
                    sOffs:            LongInt;
                    sLen:             Word;
                    { Page layout variables }
                    SmpsPerPage,
                    SmpsPerBlock:     Word;

                    PageWidth,
                    PageHeight,
                    ChLines,
                    ChInc,
                    ZeroRef:          LongInt;

                    Shift:            Byte;

                    { Mouse related methods }
                    procedure InitBlockParms;
                    procedure SetTagNDX(I: Word);
                    function  BlockOff: Boolean;
                    procedure BlockOn;
                    procedure SetImageMode(Mode: TDragMode);
                    function  SplitCoord(X, Y: Integer;
                                         var Pag: Word; var Blk, Chn: Byte;
                                         var Smp: LongInt): Boolean;
                    procedure SetMouseCoord(First: Boolean; X, Y: Integer);
                    { Tagging methods }
                    function  SearchTag(var I: Word): Char;
                    function  AddTag(Tag: Char): Word;
                    function  ReplaceTag: Word;
                    { Input data scrolling methods }
                    function  ScrollBarPos: Integer;
                    { Controls setting methods }
                    procedure DrawTagName;
                    procedure DrawBlockCoord;
                    procedure DrawMouseCoord;
                    procedure SetComButtons;
                    procedure MakeTagButtons(Kind: TTagKind);
                    procedure SetTagShiftButtons;
                    procedure SetWavesButtons;
{                    procedure SetScrollBar;}
                    { Drawing related methods }
                     { Modyfikacja 1997 06 22 }
                    function GetVal(func : char;Ch : byte; X: Word) : LongInt;

                    function  Val_Z(Ch: Byte; X: Word): LongInt;
                    function  Val_N(Ch: Byte; X: Word): LongInt;
                    function  Val_M(Ch: Byte; X: Word): LongInt;
                    function  Val_D(Ch: Byte; X: Word): LongInt;
                    function  Val_B(Ch: Byte; X: Word): LongInt;
                    function  GetChLab(Channel: Byte): string;
                    procedure SetChannelTab;
                    procedure SetBufTab;
                    function  ImageFrameHeight: Integer;
                    function  ImageFrameWidth: Integer;
                    procedure LayOut;
                    function  PagRect(var R: TRect; Pag: LongInt): Boolean;
                    function  BlkRect(var R: TRect; Pag: LongInt;
                                      Blk: Byte): Boolean;
                    function  ChnRect(var R: TRect; Chn: Byte;
                                      Offset: LongInt;
                                      Length: Word): Boolean;
                    function  ChnBlkRect(var R: TRect; Pag: LongInt;
                                         Blk: Byte; Chn: Byte): Boolean;
                    procedure DrawVCursor;
                    procedure DrawCursor;
                    procedure DrawBlock;
                    procedure DrawTag(Canvas: TCanvas;
                                      R: TRect; const T: TTagHDRRec);
                    procedure DrawTags(Canvas: TCanvas);
                    procedure DrawLine(Canvas: TCanvas;
                                       X1, Y1, X2, Y2: Integer;
                                       Color: TColor);
                    procedure DrawTime(Canvas: TCanvas;
                                       pOdd: Boolean; pFirst, pBound: Integer);
                    procedure DrawAxes(Canvas: TCanvas;
                                       pOdd: Boolean; pBound: Integer);
                    procedure DrawWave(Canvas: TCanvas; Chn: Byte);
                    procedure DrawWaves(Canvas: TCanvas);
                    procedure ScrollImage(R: TRect);
                    procedure FormPaint(Sender: TObject);

                   public  { Public declarations }
                    { Viewer state flags }
                    ScaledHFlag,
                    ScaledVFlag,
                    LabelsFlag,
                    AxesFlag,
                    TimeFlag,
                    CursorFlag,
                    SpeedbarFlag,
                    StatusFlag,
                    TagDeleteFlag: Boolean;
                    OldCordX,OldCordY,Skok : integer;
                    SetHighlightColor : TColor; { kolor podswietlonego sygnalu }

                    { Mouse related methods }
                    procedure TagBtnClick(Tag: Char);
                    { Tagging methods }
                    function  DeleteTag: Boolean;
                    { Form related methods }
                    function  FormInitialize: Boolean;
                    { Input data scrolling methods }
                    procedure ScrollData(ScrollCode: TScrollCode;
                                         var ScrollPos: Integer);
                    { Controls setting methods }
                    procedure ShiftTagButtonsLeft;
                    procedure ShiftTagButtonsRight;
                    procedure SetPageButtons;
                    procedure SetControls;
                    procedure SetPanelSpeed;
                    procedure SetPanelStatus;
                    procedure SetTagKind;
                    { Drawing related methods }
                    procedure ShiftInc;
                    procedure ShiftDec;
                    function  ShiftDef: Boolean;
                    procedure HighlightOff;
                    procedure HighlightOn;
                    { Main menu services }
                    procedure OpenTag;
                    procedure SaveTag(Immediate: Boolean);
                    procedure CloseTag;
                    procedure Print(where : boolean; filename : string);
                    procedure EditMontage;
                    procedure EditTags;
                    procedure ClipboardCopy;
                    procedure GoToPage;
                      { Modufikacja 1998 08 18 }
                    procedure GoToBadPage(what : boolean);
                      { Modyfikacje }
                    procedure GotoSelectPage(page : word);
                    procedure OpenWzr;
                    procedure SaveWzr;
                    procedure DrawSleepStadium;
                    procedure ComputeFFT;
                    procedure DrawHipnogram(page: word);
                    function GetMaxPageNo : word;
                    function GetCurrentPageNo : word;
                    procedure SetHipnogramPosition;
                    function GetHipnoStadium(page : word) : string;
                    procedure LoadSignalToZoom;
                    procedure LoadFixedSignalToZoom;
                    procedure ComputeChannelFFT;
                    procedure DrawOneSekAndAmpliBar(Canavs : TCanvas);
                    procedure ViewHeaderInfo;
                    procedure Calibration;
                    procedure SaveChnToAsciiFile;
                    procedure SetFilter(Min,Max,Dysp,Gain,Averg : single;
                                        Typ : TFilterTypes;
                                        status,FilterNo : integer);
                    function GetSamplingFreq : single;
                    procedure SetFilterFlags;
                    function IsFilterEnabled : boolean;
                    procedure SetFilterEnabled(x : boolean);
                    procedure ReLoad;   { 1998 01 04 }
                    procedure SetActiveChannels;
                    procedure OneSekAndAmpli(ScaleX,ScaleY : single);
                   end;

      TChLabel   = class(TLabel)
                   private
                   public
                    constructor Create(AOwner: TChildForm; AParent: TPanel;
                                       No: Byte; const ALab, AHint: string);
                   end;

implementation

{$R *.DFM}

const ScrollBarWidth: Word    = 17;                          { zweryfikowac ~~~}
      MaxPageHeight:  LongInt = 2048;                        { zweryfikowac ~~~}
      FMaxInt:        Real    = MaxInt;

      RefTxt:         string[20] = 'Referenced to';

var
     Hipnogram   : HipnoTable;

(****************************** TChLabel METHODS ******************************)
                                                             { TChLabel.Create }
constructor TChLabel.Create(AOwner: TChildForm; AParent: TPanel;
                            No: Byte; const ALab, AHint: string);
begin
 inherited Create(AOwner); Name:='ChLab'+SN(No,-2); Parent:=AParent;
 Left:=1; Top:=-20; ShowAccelChar:=false; ShowHint:=true; Transparent:=true;
 Caption:=ALab; Hint:=AHint;
 {AutoSize:=false; Width:=PanelLabWidth-Left-1;}
end;

procedure TChildForm.SetActiveChannels;
var
  i,j : integer;      { Ustawienie w strumieniu aktywnych kanalow }

begin
  if mont<>nil then
    begin
      for i:=1 to MaxChannels do
        iStream.UsedChannels[i]:=false;

      for i:=1 to Mont.Channels do
        with ChTab[i] do
         begin
          iStream.UsedChannels[Channel]:=true;
          if Refs>0 then
            for j:=1 to Refs do
              iStream.UsedChannels[Ref[j]]:=true;
         end;
       Reload;
    end;
end;

procedure TChildForm.SetFilter(Min,Max,Dysp,Gain,Averg : single;
                               Typ : TFilterTypes;
                               status,FilterNo : integer);
begin
 if iStream<>nil then
  begin
   iStream.SetFilter(Min,Max,Dysp,Gain,Averg,Typ,status,FilterNo);
   SetActiveChannels;
  end;
end;

function TChildForm.IsFilterEnabled : boolean;
begin
  if iStream<>nil then
    Result:=iStream.FilterEnabled
  else
    Result:=false;
end;

procedure TChildForm.SetFilterEnabled(x : boolean);
begin
  if iStream<>nil then
    iStream.FilterEnabled:=x;
end;

function TChildForm.GetSamplingFreq : single;
begin
  Result:=0.1*iSampFreq;
end;

(******************************* EVENT HANDLERS *******************************)
                                                                 { Form-Create }
procedure TChildForm.FormCreate(Sender: TObject);
begin
 iStream:=FormatDialog.iStream; FormatDialog.iStream:=nil;
 Mont:=FormatDialog.Mont;       FormatDialog.Mont:=nil;
 Tags:=FormatDialog.Tags;       FormatDialog.Tags:=nil;
 Caption:=ANSIUpperCase(ExtractFileName(FormatDialog.ComboBoxPath.Text));
 iSampFreq:=FormatDialog.SamplingFreq;
 iADBits:=FormatDialog.SpinEditBits.Value;
 OldCordX:=0;
 OldCordY:=0;
 Skok:=1;
 SetHighlightColor:=clBlue;    { Domyslny kolor podswietlonego sygnlu }

 with MainForm do
  begin
   ScaledHFlag:=ViewScaledH.Checked;   ScaledVFlag:=ViewScaledV.Checked;
   LabelsFlag:=ViewLabels.Checked;     AxesFlag:=ViewAxes.Checked;
   TimeFlag:=ViewTime.Checked;         CursorFlag:=ViewCursor.Checked;
   SpeedbarFlag:=ViewSpeedbar.Checked; StatusFlag:=ViewStatus.Checked
  end;
 SetChannelTab;
 TagKind:=tkPag;
 PanelLab.Width:=PanelLabWidth;
 SetFont(PanelLab.Font,DrawFonts[PanelLabFontSize>=8],PanelLabFontSize,
                       [fsBold],LabelColor);
 with Image do
   begin
     Top:=0;
     Left:=PanelLabWidth;
     Width:=0;
     Height:=0
   end;
  SetActiveChannels;
end;
                                                                 { Form-Resize }
procedure TChildForm.FormResize(Sender: TObject);
begin
 ShiftDef; Invalidate
end;
                                                             { Form-CloseQuery }
procedure TChildForm.FormCloseQuery(Sender: TObject; var CanClose: Boolean);
begin
 CanClose:=Tags.TrySaveModified
end;
                                                                  { Form-Close }
procedure TChildForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
 ClipCursor(nil); OnPaint:=nil; FormOK:=false;
 MemFree(Points,Succ(SmpsPerPage)*SizeOf(TPoint));
 MemFree(X2Smp,PageWidth*SizeOf(Word)); MemFree(Y2Chn,PageHeight);
 Tags.Free; Mont.Free; iStream.Free;
 Action:=caFree
end;

procedure TChildForm.FormKeyPress(Sender: TObject; var Key: Char);
 var
   I       : Integer;
   OldKind : TTagKind;

begin
 with MainForm.PagTag do
  for I:=0 to Pred(ControlCount) do
   if (Controls[I] as TTagBtn).Caption=Key then
     begin
       TagBtnClick(Key);
       Exit;
     end;
end;

                                                              { ImageMouseDown }
procedure TChildForm.ImageMouseDown(Sender: TObject; Button: TMouseButton;
                                    Shift: TShiftState; X, Y: Integer);
 var Pag:      Word;
     Blk, Chn : Byte;
     Delta    : LongInt;
     s        : integer;

begin
 if not MappingOK or (Button<>mbLeft) then
  begin                { Przesuwanie kursorem myszy o strone 1997 09 11 }
   if MappingOk then
    begin
     if Button=mbRight then
      begin
        ScrollData(scPageDown,s);
        SetHipnogramPosition;
      end
     else if Button=mbMiddle then
      begin
        ScrollData(scPageUp,s);
        SetHipnogramPosition;
      end;
    end;
    Exit;
  end;

 with dRect do begin Top:=Image.ClientOrigin.Y+Y; Bottom:=Top end;
 ClipCursor(@dRect); if DoubleClicked then begin DoubleClicked:=false; Exit end;
 if not SplitCoord(X,Y,Pag,Blk,Chn,dSmp) then Exit; Dragging:=true; DrawCursor;
 if TagKind=tkChn then
  if BlkAct[tkChn] then
   if ssShift in Shift then
    begin
     DrawBlock;
     if Pred(dSmp)<cOffs then
      begin
       Delta:=cOffs-Pred(dSmp); Dec(cOffs,Delta);
       if Delta+cLen<=MaxChnTagLen then Inc(cLen,Delta) else cLen:=MaxChnTagLen;
       SetImageMode(dmLeft)
      end
     else
      begin
       Delta:=dSmp-cOffs-cLen;
       if Delta+cLen<=MaxChnTagLen then Inc(cLen,Delta) else cLen:=MaxChnTagLen;
       SetImageMode(dmRight)
      end;
     DrawBlock; DrawBlockCoord
    end
   else
  else
   begin
    cChn:=Chn; cOffs:=Pred(dSmp); cLen:=0;
    BlkAct[tkChn]:=true; SetTagNDX(0); DrawBlock; SetImageMode(dmRight)
   end
end;
                                                              { ImageMouseMove }
procedure TChildForm.ImageMouseMove(Sender: TObject;
                                    Shift: TShiftState; X, Y: Integer);
 var Delta:    Integer;
     L:        LongInt;
begin
 OldCordX:=X;
 OldCordY:=Y;
 MainForm.HipnoPanel.Visible:=false;
 if not MappingOK then Exit;
 if not Dragging then SetMouseCoord(false,X,Y)
 else
  begin
   if not SplitCoord(X,Y,mPag,mBlk,mChn,mSmp) then Exit;
   mOrg:=Point(X,Y); DrawMouseCoord; if DragMode=dmNone then Exit;
   Delta:=mSmp-dSmp; dSmp:=mSmp;
   case TagKind of
    tkPag: if mPag<>pPag then
            begin DrawBlock; pPag:=mPag; DrawBlock; DrawBlockCoord end;
    tkBlk: if (mBlk<>bBlk) or (mPag<>bPag) then
            begin
             DrawBlock; bPag:=mPag; bBlk:=mBlk; DrawBlock; DrawBlockCoord
            end;
    tkChn: begin
            DrawBlock;
            case DragMode of
             dmMove:  begin
                       Inc(cOffs,Delta);
                       if cOffs<0 then cOffs:=0
                      end;
             dmLeft:  begin
                       L:=cLen-Delta;
                       if L<0 then L:=0
                       else if L>MaxChnTagLen then L:=MaxChnTagLen;
                       Inc(cOffs,cLen-L); cLen:=L
                      end;
             dmRight: begin
                       L:=cLen+Delta;
                       if L<0 then L:=0
                       else if L>MaxChnTagLen then L:=MaxChnTagLen;
                       cLen:=L
                      end
            end;
            DrawBlock; DrawBlockCoord
           end
   end
  end
end;
                                                                { ImageMouseUp }
procedure TChildForm.ImageMouseUp(Sender: TObject; Button: TMouseButton;
                                  Shift: TShiftState; X, Y: Integer);
 var
   I: Word;
   OldTag : char;

begin
 if not MappingOK or (Button<>mbLeft) then Exit;
 ClipCursor(nil); if not Dragging then Exit;
 if (TagKind=tkChn) and BlkAct[tkChn] and (cLen=0) then
  begin cChn:=0; cOffs:=0; BlkAct[tkChn]:=false; SetTagNDX(0) end;
 DrawCursor; Dragging:=false;

 if TagKind=tkChn then       { Modyfikacja 1997 07 22 }
  with MainForm do
   begin
      SpeedChnFFT.Enabled:=true;
      FFTSpeedButton.Enabled:=true;
      FFT1.Enabled:=true;
      ChannelFFT1.Enabled:=true;
      SeleckZoom1.Enabled:=true;
   end;

 with MainForm do
   begin
     PrintToBMP1.Enabled:=true;
     FilePrint.Enabled:=true;
     SaveTag.Enabled:=true;
   end;

 if BlkAct[TagKind] then
  if TagNDX[TagKind]<>0 then ReplaceTag
  else
   if (TagKind=tkPag) or (TagKind=tkBlk) then
    begin SearchTag(I); SetTagNDX(I) end
   else
     begin
      if TagKind=tkChn then           { Modyfiakcja 1997 07 22 }
       with TagBtns[TagKind] do
         if (TagAct<>#0) then
           begin
             AddTag(TagAct);
             OldTag:=TagAct;
             TagAct:=#0;                     { Powrot do trybu bez guzika }
             with MainForm.PagTag do
               for I:=0 to Pred(ControlCount) do
                  with Controls[I] as TTagBtn do
                     Down:=Caption=TagAct;

             if MappingOK then
              begin
               HighLightOff;
               if not BlockOff then BlockOn;  { Potwierdzenie }
               if not BlockOff then BlockOn;  { Wygaszenie kursora }
               HighlightOn;
             end;

           TagAct:=OldTag;                    { Powrot do aktualnego trybu  }
           with MainForm.PagTag do
               for I:=0 to Pred(ControlCount) do
                  with Controls[I] as TTagBtn do
                     Down:=Caption=TagAct;
            sOffs:=cOffs;
            sLen:=cLen;
       end;

     end
 else begin sPag:=0; sBlk:=0; sOffs:=0; sLen:=0 end
end;
                                                               { ImageDblClick }
procedure TChildForm.ImageDblClick(Sender: TObject);
begin
 if not MappingOK then Exit; DoubleClicked:=true;
 HighLightOff; if not BlockOff then BlockOn; HighlightOn;
 if BlkAct[TagKind] then with TagBtns[TagKind] do
  if (TagAct<>#0) then AddTag(TagAct);
end;

(*************************** MOUSE RELATED METHODS ****************************)
                                                              { InitBlockParms }
procedure TChildForm.InitBlockParms;
 var K: TTagKind;
begin
 pPag:=0; bPag:=0; bBlk:=0; cChn:=0; cOffs:=0; cLen:=0;
 sPag:=0; sBlk:=0; sOffs:=0; sLen:=0;
 for K:=tkPag to tkChn do begin BlkAct[K]:=false; TagNDX[K]:=0 end;
 TagDeleteFlag:=false; MainForm.TagDelete.Enabled:=TagDeleteFlag;
 DrawBlockCoord
end;
                                                                   { SetTagNDX }
procedure TChildForm.SetTagNDX(I: Word);
begin
 TagNDX[TagKind]:=I; sPag:=0; sBlk:=0; sOffs:=0; sLen:=0;
 if (I<>0) and BlkAct[TagKind] then
  case TagKind of
   tkPag: sPag:=pPag;
   tkBlk: begin sPag:=bPag; sBlk:=bBlk end;
   tkChn: begin sOffs:=cOffs; sLen:=cLen end
  end;
 TagDeleteFlag:=I<>0; MainForm.TagDelete.Enabled:=TagDeleteFlag; DrawBlockCoord
end;
                                                                    { BlockOff }
function TChildForm.BlockOff: Boolean;
begin
 Result:=false;
 if BlkAct[TagKind] then
  case TagKind of
   tkPag: begin Result:=(pPag=mPag); pPag:=0 end;
   tkBlk: begin Result:=(bPag=mPag) and (bBlk=mBlk); bPag:=0; bBlk:=0 end;
   tkChn: begin
           Result:=(cChn=mChn) and (mSmp>=Succ(cOffs)) and (mSmp<=cOffs+cLen);
           cChn:=0; cOffs:=0; cLen:=0
          end
  end;
 BlkAct[TagKind]:=false; SetTagNDX(0);
 if Result and (TagKind=tkChn) then     { Modyfikachja 1997 07 22 }
  with MainForm do
   begin
    SpeedChnFFT.Enabled:=false;
    FFTSpeedButton.Enabled:=false;
    FFT1.Enabled:=false;
    ChannelFFT1.Enabled:=false;
    SeleckZoom1.Enabled:=false;
  end;

  if Result then
    with MainForm do
      begin
        PrintToBMP1.Enabled:=false;
        FilePrint.Enabled:=false;
        SaveTag.Enabled:=false;
      end;
end;
                                                                     { BlockOn }
procedure TChildForm.BlockOn;
 var I: Word;
begin
 SearchTag(I);
 case TagKind of
  tkPag: pPag:=mPag;
  tkBlk: begin bPag:=mPag; bBlk:=mBlk; end;
  tkChn: if I=0 then
          begin
           cChn:=mChn; cOffs:=(Pred(mSmp) div SmpsPerBlock) * SmpsPerBlock;
           cLen:=SmpsPerBlock
          end
         else
          begin
           cChn:=mChn;
           with Tags.Chn[ChTab[cChn].Channel,I] do
            begin cOffs:=Offset; cLen:=Length end
          end
 end;
 BlkAct[TagKind]:=true; SetTagNDX(I);

 if TagKind=tkChn then       { Modyfikacja 1997 07 22 }
  with MainForm do
   begin
      SpeedChnFFT.Enabled:=true;
      FFTSpeedButton.Enabled:=true;
      FFT1.Enabled:=true;
      ChannelFFT1.Enabled:=true;
      SeleckZoom1.Enabled:=true;
   end;

  with MainForm do
    begin
      PrintToBMP1.Enabled:=true;
      FilePrint.Enabled:=true;
      SaveTag.Enabled:=true;
    end;
end;
                                                                { SetImageMode }
procedure TChildForm.SetImageMode(Mode: TDragMode);
 var C: TCursor;
begin
 DragMode:=Mode;
 case Mode of
  dmNone:  Image.Cursor:=crCross;
  dmMove:  Image.Cursor:=crArrow;
  else     Image.Cursor:=crSizeWE
 end;
 C:=SetCursor(Image.Cursor); SetCursor(C)
end;
                                                                  { SplitCoord }
function TChildForm.SplitCoord(X, Y: Integer; var Pag: Word;
                               var Blk, Chn: Byte; var Smp: LongInt): Boolean;
begin
 Result:=MappingOK and (X>=0) and (X<PageWidth) and (Y>=0) and (Y<PageHeight);
 if not Result then Exit;
 Smp:=iStream.PageOffset+X2Smp^[X]; Chn:=Y2Chn^[Y];
 Blk:=Succ((Pred(Smp) mod SmpsPerPage) div SmpsPerBlock);
 Pag:=Succ(Pred(Smp) div SmpsPerPage)
end;
                                                               { SetMouseCoord }
procedure TChildForm.SetMouseCoord(First: Boolean; X, Y: Integer);
 var Chn, Blk:   Byte;
     Pag:        Word;
     ChnChanged,
     BlkChanged: Boolean;
begin
 if not (MappingOK and SplitCoord(X,Y,Pag,Blk,Chn,mSmp)) then Exit;
 mOrg:=Point(X,Y);

 if BlkAct[TagKind] then
  case TagKind of
   tkPag: if Pag=pPag then SetImageMode(dmMove)
          else SetImageMode(dmNone);
   tkBlk: if (Pag=bPag) and (Blk=bBlk) then SetImageMode(dmMove)
          else SetImageMode(dmNone);
   tkChn: if (Chn=cChn) and (mSmp>=Succ(cOffs)) and (mSmp<=cOffs+cLen) then
           if mSmp>=cOffs+cLen-5 then SetImageMode(dmRight)
           else
            if mSmp<=Succ(cOffs)+5 then SetImageMode(dmLeft)
            else SetImageMode(dmMove)
          else SetImageMode(dmNone)
  end
 else SetImageMode(dmNone);

 ChnChanged:=Chn<>mChn; BlkChanged:=(Blk<>mBlk) or (Pag<>mPag);
 if not First then
  if ChnChanged then HighlightOff else if BlkChanged then DrawVCursor;
 mChn:=Chn; mBlk:=Blk; mPag:=Pag; DrawMouseCoord;
 if First or ChnChanged then HighlightOn else if BlkChanged then DrawVCursor
end;
                                                                 { TagBtnClick }
procedure TChildForm.TagBtnClick(Tag: Char);
 var
   I: Integer;

begin
 with TagBtns[TagKind] do
  begin
   if TagAct=#0 then if BlkAct[TagKind] then
     begin
        AddTag(Tag); { Modyfikacja }
        if MappingOK then
         begin
           DoubleClicked:=true;
           HighLightOff;
           if not BlockOff then BlockOn;
           HighlightOn;
         end;
     end
     else TagAct:=Tag
   else if TagAct=Tag then TagAct:=#0 else TagAct:=Tag;

   with MainForm.PagTag do
    for I:=0 to Pred(ControlCount) do with Controls[I] as TTagBtn do
     Down:=Caption=TagAct
  end
end;

(****************************** TAGGING METHODS *******************************)
                                                                   { SearchTag }
function TChildForm.SearchTag(var I: Word): Char;
begin
 Result:=#0;
 case TagKind of
  tkPag: if Tags.PagSearch(mPag,I)=0 then
          Result:=Tags.PagTag[I].Tag;
  tkBlk: if Tags.BlkSearch(mPag,mBlk,I)=0 then
          Result:=Tags.BlkTag[I].Tag;
  tkChn: if Tags.ChnSearch(ChTab[mChn].Channel,Pred(mSmp),I)=0 then
          Result:=Tags.ChnTag[ChTab[mChn].Channel,I].Tag
 end;
 if Result=#0 then I:=0
end;
                                                                      { AddTag }
function TChildForm.AddTag(Tag: Char): Word;
begin
 Result:=0;
 if BlkAct[TagKind] then
  case TagKind of
   tkPag: Result:=Tags.PagAdd(TagPagRec(Tag,pPag));
   tkBlk: Result:=Tags.BlkAdd(TagBlkRec(Tag,bPag,bBlk));
   tkChn: Result:=Tags.ChnAdd(ChTab[cChn].Channel,TagChnRec(Tag,cOffs,cLen))
  end;
 if Result<>0 then begin SetTagNDX(Result); DrawTagName; Invalidate end
end;
                                                                   { DeleteTag }
function TChildForm.DeleteTag: Boolean;
begin
 Result:=false;
 if BlkAct[TagKind] and (TagNDX[TagKind]<>0) then
  case TagKind of
   tkPag: Result:=Tags.PagDel(TagNDX[tkPag]);
   tkBlk: Result:=Tags.BlkDel(TagNDX[tkBlk]);
   tkChn: Result:=Tags.ChnDel(ChTab[cChn].Channel,TagNDX[tkChn])
  end;
 if Result then begin SetTagNDX(0); DrawTagName; Invalidate end
end;
                                                                  { ReplaceTag }
function TChildForm.ReplaceTag: Word;
 var T:       Char;
     DelFlag: Boolean;
begin
 Result:=0; DelFlag:=false;
 if BlkAct[TagKind] and (TagNDX[TagKind]<>0) then
  case TagKind of
   tkPag: if sPag<>pPag then
           begin
            T:=Tags.PagTag[TagNDX[tkPag]].Tag;
            DelFlag:=Tags.PagDel(TagNDX[tkPag]);
            if DelFlag then
             begin
              Result:=Tags.PagAdd(TagPagRec(T,pPag));
              if Result=0 then pPag:=sPag
             end
            else begin DrawBlock; pPag:=sPag; DrawBlock end
           end;
   tkBlk: if (sPag<>bPag) or (sBlk<>bBlk) then
           begin
            T:=Tags.BlkTag[TagNDX[tkBlk]].Tag;
            DelFlag:=Tags.BlkDel(TagNDX[tkBlk]);
            if DelFlag then
             begin
              Result:=Tags.BlkAdd(TagBlkRec(T,bPag,bBlk));
              if Result=0 then begin bPag:=sPag; bBlk:=sBlk end
             end
            else begin DrawBlock; bPag:=sPag; bBlk:=sBlk; DrawBlock end
           end;
   tkChn: if (sOffs<>cOffs) or (sLen<>cLen) then
           begin
            T:=Tags.ChnTag[ChTab[cChn].Channel,TagNDX[tkChn]].Tag;
            DelFlag:=Tags.ChnDel(ChTab[cChn].Channel,TagNDX[tkChn]);
            if DelFlag then
             begin
              Result:=Tags.ChnAdd(ChTab[cChn].Channel,TagChnRec(T,cOffs,cLen));
              if Result=0 then begin cOffs:=sOffs; cLen:=sLen end
             end
            else begin DrawBlock; cOffs:=sOffs; cLen:=sLen; DrawBlock end
           end
  end;
 if DelFlag then begin SetTagNDX(Result); DrawTagName; Invalidate end
end;

(**************************** FORM RELATED METHODS ****************************)
                                                              { FormInitialize }
function TChildForm.FormInitialize: Boolean;
begin
 OnPaint:=nil;

 MemFree(Points,Succ(SmpsPerPage)*SizeOf(TPoint));

 SmpsPerPage:=(LongInt(iSampFreq)*Tags.SecPerPage) div 10;
 SmpsPerBlock:=SmpsPerPage div Tags.BlkPerPage;

 iStream.PageSize:=SmpsPerPage;

 Result:=(iStream.PageSize>0) and
         MemInit(Points,Succ(SmpsPerPage)*SizeOf(TPoint));

 FormOK:=Result;

 if FormOK then
  begin
   SetControls;
   MaxOffset:=(iStream.Size div SmpsPerPage) * SmpsPerPage;
   iStream.PageOffset:=(iStream.PageOffset div SmpsPerBlock)*SmpsPerBlock;
   ShiftDef; OnPaint:=FormPaint;
  end;

 InitBlockParms; Invalidate
end;


(************************ INPUT DATA SCROLLING METHODS ************************)
                                                                { ScrollBarPos }
function TChildForm.ScrollBarPos: Integer;
begin
 if MaxOffset>0 then Result:=Round(FMaxInt*iStream.PageOffset/MaxOffset)
 else Result:=0
end;

procedure TChildForm.ReLoad;
var
  P : LongInt; { Przeladowanie strony 1998 01 04 }

begin
 if not FormOk then Exit;
 P:=iStream.PageOffset;
 iStream.ReLoadStatus:=true;
 iStream.PageOffset:=P;
 iStream.ReLoadStatus:=false;
 Invalidate;
 Repaint;
end;
                                                                  { ScrollData }
procedure TChildForm.ScrollData(ScrollCode: TScrollCode;
                                var ScrollPos: Integer);
 var P: LongInt;

begin
 if not FormOK then Exit;
 P:=iStream.PageOffset;
 case ScrollCode of
  scLineUp:    if P-SmpsPerBlock>=0 then Dec(P,SmpsPerBlock)
               else P:=0;
  scLineDown:  if P+SmpsPerBlock<=MaxOffset then Inc(P,SmpsPerBlock)
               else P:=MaxOffset;
  scPageUp:    if P-SmpsPerPage>=0 then Dec(P,SmpsPerPage)
               else P:=0;
  scPageDown:  if P+SmpsPerPage<=MaxOffset then Inc(P,SmpsPerPage)
               else P:=MaxOffset;
               { Modyfikacja (Niepoprawna ? konwersja typow) 1997 06 22 }
  scPosition:  P:=(LongInt(Round(ScrollPos*(MaxOffset/FMaxInt)))
                   div LongInt(SmpsPerBlock))*LongInt(SmpsPerBlock);
  scTrack:     ;
  scTop:       P:=0;
  scBottom:    P:=MaxOffset;
  scEndScroll: ;
 end;
 if P<>iStream.PageOffset then
   begin
     iStream.PageOffset:=P;
     Invalidate
   end;

 ScrollPos:=ScrollBarPos;  { Synchronizachja okien 1998 01 17 }
 if MainForm.SynchroStatus=true then
   MainForm.Synchronize;
end;

(************************* CONTROLS SETTING METHODS ***************************)
                                                                 { DrawTagName }
procedure TChildForm.DrawTagName;
begin
 with Tags do
  begin
   if Loaded then
    MainForm.PagTagName.Caption:=' '+ANSIUpperCase(ExtractFileName(Path))
   else MainForm.PagTagName.Caption:=' '+NoNameTagTxt;
   if Modified then MainForm.LabelModified.Caption:='[m]'
   else MainForm.LabelModified.Caption:=''
  end
end;
         { Modyfikacja 1997 07 16 }

function TChildForm.GetHipnoStadium(page : word) : string;
  var
    NewPage : word;                        { Odczyt stadia snu z bufora }
    napis   : string;

begin
  NewPage:=1+(page div HowPages);
  napis:='HIPNO: ';
  case Hipnogram[NewPage] of
    1: napis:=napis+'STADIUM 4';
    2: napis:=napis+'STADIUM 3';
    3: napis:=napis+'STADIUM 2';
    4: napis:=napis+'REM';
    5: napis:=napis+'STADIUM 1';
    6: napis:=napis+'WAKE';
    7: napis:=napis+'MUSC';
  else
     napis:=napis+'NO';
  end;
  Result:=napis;
end;

procedure TChildForm.DrawHipnogram(page : word);
  var
    maxPage,i,Y : word;                     { Rysowanie Hipnogramu }
    X,k         : integer;
    maxPageNo   : word;
    scale       : single;
    itmp,itmp2  : integer;

begin
  if not FormOk then Exit;
  maxPage:=GetMaxPageNo;

  if maxPage<=HowPages then
   Exit;

  with MainForm do
    Tags.MakeHipnogram(Hipnogram,maxPage);

  with MainForm.HipnoImage,MainForm.HipnoImage.Canvas do
    begin
      X:=round(((page-1.0)/maxPage)*ClientWidth);
      brush.Color:=clltGray;
      pen.Color:=clBlack;
      rectangle(0,0,ClientWidth,ClientHeight);
      Pen.Color:=clRed;
      MoveTo(X,0);
      LineTo(X,ClientHeight);

      maxPageNo:=maxPage div HowPages;
      moveTo(0,2*hipnogram[1]);
      scale:=ClientWidth/maxPageNo;
      for i:=1 to maxPageNo do   { Modyfikacja 1998 02 21 }
        begin
          itmp:=17-2*hipnogram[i];
          itmp2:=round(scale*(i-1));

          case hipnogram[i] of
            0: Pen.Color:=clWhite;   { NO }
            4: Pen.Color:=clRed;     { REM }
            6: Pen.Color:=clBlue;    { WAKE }
          else
            Pen.Color:=clBlack;
          end;

          MoveTo(itmp2,itmp);
          LineTo(round(scale*i),itmp);
          Pen.Color:=clBlack;

          if i=1 then
            MoveTo(itmp2,17-2*hipnogram[1])
          else
            MoveTo(itmp2,17-2*hipnogram[i-1]);
          LineTo(itmp2,itmp);
        end;
    end;
end;

     { Modyfikacja 1997 06 29 }
function StadiumToString(stadium : char) : string;
  var
     tmp: string;   { Numer stadia na nazwe }

begin
  case stadium of
    STADIUM_4: tmp:='STADIUM 4';
    STADIUM_3: tmp:='STADIUM 3';
    STADIUM_2: tmp:='STADIUM 2';
    STADIUM_1: tmp:='STADIUM 1';
    REM:       tmp:='REM';
    MUSC:      tmp:='MUSC';
    WAKE:      tmp:='WAKE';
  else
    tmp:='UNDEF'; { Nieznane }
  end;
 StadiumToString:=tmp;
end;

procedure TChildForm.LoadFixedSignalToZoom;
  var
    OK    : boolean;
    i,Len : integer;
    bRect : TRect;
    X,EndPage,k,StartOffset : word;
    V     : longint;

 begin
   HighlightOff;
   OK:=false;
   if BlkAct[TagKind] then
     if TagKind=tkChn then
       OK:=ChnRect(bRect,cChn,cOffs,cLen);

    if not OK then
     begin
      HighlightOn;
      exit;
     end;

   StartOffset:=1+(cOffs mod iStream.PageMax);
   Len:=clen;
   if Len>MaxSignalLen then
     Len:=MaxSignalLen;
   EndPage:=StartOffset+Len;
   if EndPage>=iStream.PageMax then
     EndPage:=iStream.PageMax-1;

   SetBufTab;
   k:=1;
   ZoomForm.AmpliBarStat:=MainForm.AmpliBarStat;
   ZoomForm.SecBarStat:=MainForm.OneSekBarStat;
   ZoomForm.ZoomInit:=true;
   ZoomForm.MinSigLen:=SmpsPerBlock;
   ZoomForm.SampFreq:=iSampFreq/10.0;
   ZoomForm.CalibConst:=iStream.iCalibConst;

   for X:=StartOffset to EndPage do
    if k<=MaxSignalLen then
     begin
       V:=GetVal(ChTab[cChn].ValFun,cChn,X);
       ZoomForm.sig[k]:=-V;
       inc(k);
     end;

   HighlightOn;
   ZoomForm.SigLen:=k-1;
   ZoomForm.BlockOn:=true;
   ZoomForm.DrawSignal;
 end;

procedure TChildForm.LoadSignalToZoom; { Ladowanie sygnalu do Zoom'a }
  var
    Start,Stop,X,k : word;
    V              : longint;

begin
 with MainForm do
  begin
    if ZoomForm.ActiveZoom then { 1997 07 19 }
      begin
        if ZoomForm.BlockOn then
           exit;

        SetBufTab;
        k:=1;
        Start:=1+(mBlk-1)*SmpsPerBlock;
        Stop:=Start+SmpsPerBlock;
        if Stop>=SmpsPerPage then
          Stop:=SmpsPerPage;

        ZoomForm.AmpliBarStat:=MainForm.AmpliBarStat;
        ZoomForm.SecBarStat:=MainForm.OneSekBarStat;
        ZoomForm.ZoomInit:=true;
        ZoomForm.MinSigLen:=SmpsPerBlock;
        ZoomForm.SampFreq:=iSampFreq/10.0;
        ZoomForm.CalibConst:=iStream.iCalibConst;

        for X:=Start to Stop  do
         if k<=MaxSignalLen then
         begin
           V:=GetVal(ChTab[mChn].ValFun,mChn,X);
           ZoomForm.sig[k]:=-V;
           inc(k);
         end;
        ZoomForm.SigLen:=k-1;
        ZoomForm.DrawSignal;
      end;
  end;
end;

procedure TChildForm.DrawSleepStadium;
  var
    I,k,X : word;               { Zapis stadia snu 1996 06 29 }
    V     : longint;
    Start,Stop : word;

begin
  with MainForm do
   begin
    if Tags.PagSearch(mPag,I)=0 then
      SleepLabel.Caption:='SLEEP: '+StadiumToString(Tags.PagTag[I].Tag)
    else
      SleepLabel.Caption:='SLEEP: NO';
   end;
end;

procedure TChildForm.DrawBlockCoord;
 const NullCoord = {#151}'-';
 var
   czas : string;

begin
 with MainForm do
  begin
   LabelTagSelNo.Caption:=NullCoord;
   LabelPageSelNo.Caption:=NullCoord;
   LabelBlockSelNo.Caption:=NullCoord;
   LabelChannelSelNo.Caption:=NullCoord;
   LabelSampleSelNo.Caption:=NullCoord;
   LabelTagSel.Show; LabelTagSelNo.Show;
   case TagKind of
    tkPag: begin
            LabelPageSel.Show;    LabelPageSelNo.Show;
            LabelBlockSel.Hide;   LabelBlockSelNo.Hide;
            LabelChannelSel.Hide; LabelChannelSelNo.Hide;
            LabelSampleSel.Hide;  LabelSampleSelNo.Hide;
            if BlkAct[TagKind] then
             begin
              if TagNDX[tkPag]<>0 then
               LabelTagSelNo.Caption:=Tags.PagTag[TagNDX[tkPag]].Tag;
              LabelPageSelNo.Caption:=SN(pPag,0)
             end
           end;
    tkBlk: begin
            LabelPageSel.Show;    LabelPageSelNo.Show;
            LabelBlockSel.Show;   LabelBlockSelNo.Show;
            LabelChannelSel.Hide; LabelChannelSelNo.Hide;
            LabelSampleSel.Hide;  LabelSampleSelNo.Hide;
            if BlkAct[TagKind] then
             begin
              if TagNDX[tkBlk]<>0 then
               LabelTagSelNo.Caption:=Tags.BlkTag[TagNDX[tkBlk]].Tag;
              LabelPageSelNo.Caption:=SN(bPag,0);
              LabelBlockSelNo.Caption:=SN(bBlk,0)
             end
           end;
    tkChn: begin
            LabelPageSel.Hide;    LabelPageSelNo.Hide;
            LabelBlockSel.Hide;   LabelBlockSelNo.Hide;
            LabelChannelSel.Show; LabelChannelSelNo.Show;
            LabelSampleSel.Show;  LabelSampleSelNo.Show;
            if BlkAct[TagKind] then
             begin
              if TagNDX[tkChn]<>0 then
               LabelTagSelNo.Caption:=Tags.ChnTag[ChTab[cChn].Channel,
                                                  TagNDX[tkChn]].Tag;
              LabelChannelSelNo.Caption:=Mont.Labl[cChn];
              str((10.0*cLen)/iSampFreq:6:3,czas);
              { Czas trwania struktury w sek }
              LabelSampleSelNo.Caption:=czas+' s'; { 1998 01 17 }
              {SN(Succ(cOffs),0)+'-'+SN(cOffs+cLen,0)}
             end
           end
   end
  end
end;
                                                              { DrawMouseCoord }
procedure TChildForm.DrawMouseCoord;
 var H, M, S: LongInt;
begin
 if not MappingOK then Exit;
 with MainForm do
  begin
   LabelSampleNo.Caption:=SN(mSmp,0);
   LabelChannelNo.Caption:=Mont.Labl[mChn];
   LabelBlockNo.Caption:=SN(mBlk,0);
   LabelPageNo.Caption:=SN(mPag,0);

   S:=Pred(mSmp)*10 div iSampFreq;
   H:=S div 3600;
   M:=S  mod 3600 div 60;
   S:=S mod 3600 mod 60;
   LabelTime.Caption:=SN(H,-2)+TimeSeparator+SN(M,-2)+TimeSeparator+SN(S,-2)
  end;
  DrawSleepStadium;
end;
                                                               { SetComButtons }
procedure TChildForm.SetComButtons;
begin
 {~~~}
end;
                                                              { MakeTagButtons }
procedure TChildForm.MakeTagButtons(Kind: TTagKind);
 var MaxTag,
     MaxBtn,
     I, L:   Integer;
     K:      TTagKind;
begin
 TagKind:=Kind; MainForm.TabSet.TabIndex:=Ord(TagKind);

 with TagBtns[TagKind] do
  begin
   with MainForm.PagTag do
    begin
     BtnInc:=Height-3;
     while ControlCount>0 do (Controls[0] as TTagBtn).Destroy
    end;

   MaxTag:=1;
   for K:=tkPag to tkChn do
    begin if Tags.Count[K]>MaxTag then MaxTag:=Tags.Count[K] end;
   with MainForm do MaxBtn:=(PanelSpeed.Width-MinSpeedComWidth-
                             PagLeft.Width-PagRight.Width-3) div BtnInc;
   if MaxBtn>MaxTag then MaxBtn:=MaxTag;

   with MainForm do
    SpeedPag.Width:=PagLeft.Width+MaxBtn*BtnInc+3+PagRight.Width;

   BtnLeft:=Tags.NDX[TagKind,TagLeft];
   if BtnLeft=-1 then begin TagLeft:=#0; BtnLeft:=0 end;
   if Tags.NDX[TagKind,TagAct]=-1 then TagAct:=#0;

   L:=1-BtnLeft*BtnInc;
   for I:=0 to Pred(Tags.Count[TagKind]) do with Tags.HDR[TagKind,I] do
    TTagBtn.Create(Tag,Hint,L,BtnInc,Tag=TagAct{,Ord(TagAct<>#0)});

   SetTagShiftButtons
  end
end;

                                                          { SetTagShiftButtons }
procedure TChildForm.SetTagShiftButtons;
begin
 with TagBtns[TagKind] do
  begin
   MainForm.TagRight.Enabled:=BtnLeft<Pred(MainForm.PagTag.ControlCount);
   MainForm.TagLeft.Enabled:=BtnLeft>0
  end
end;
                                                         { ShiftTagButtonsLeft }
procedure TChildForm.ShiftTagButtonsLeft;
 var I: Integer;
begin
 with TagBtns[TagKind], MainForm.PagTag do
  if BtnLeft<Pred(ControlCount) then
   begin
    for I:=0 to Pred(ControlCount) do with Controls[I] as TTagBtn do
     begin
      Left:=Left-BtnInc;
      Visible:=(Left>0) and (Left+BtnInc<Pred(MainForm.PagTag.Width))
     end;
    Inc(BtnLeft); TagLeft:=Tags.HDR[TagKind,BtnLeft].Tag;
    SetTagShiftButtons
   end
end;
                                                        { ShiftTagButtonsRight }
procedure TChildForm.ShiftTagButtonsRight;
 var I: Integer;
begin
 with TagBtns[TagKind], MainForm.PagTag do
  if BtnLeft>0 then
   begin
    for I:=0 to Pred(ControlCount) do with Controls[I] as TTagBtn do
     begin
      Left:=Left+BtnInc;
      Visible:=(Left>0) and (Left+BtnInc<Pred(MainForm.PagTag.Width))
     end;
    Dec(BtnLeft); TagLeft:=Tags.HDR[TagKind,BtnLeft].Tag;
    SetTagShiftButtons
   end
end;
                                                              { SetPageButtons }
procedure TChildForm.SetPageButtons;
begin
 MainForm.ModeScaleH.Down:=ScaledHFlag;
 MainForm.ModeScaleV.Down:=ScaledVFlag
end;
                                                             { SetWavesButtons }
procedure TChildForm.SetWavesButtons;
begin
 with MainForm do
  begin
   ViewExpand.Enabled:=Shift>0;        ModeExpand.Enabled:=ViewExpand.Enabled;
   ViewTighten.Enabled:=Shift<iADBits; ModeTighten.Enabled:=ViewTighten.Enabled
  end
end;

                                                                 { SetControls }
procedure TChildForm.SetControls;
begin
 if not FormOK then Exit;
 SetFilterFlags;
 SetComButtons;
 MakeTagButtons(TagKind);
 SetPageButtons;
 SetWavesButtons;
 DrawTagName;
 DrawBlockCoord;
 DrawMouseCoord;
end;

procedure TChildForm.SetFilterFlags;
begin
  with MainForm do
    SetFilterMenus(iStream.FilterNumber);
end;
                                                                   { SetPanels }
procedure TChildForm.SetPanelSpeed;
begin
 with MainForm.PanelSpeed do if SpeedbarFlag then Show else Hide
end;

procedure TChildForm.SetPanelStatus;
begin
 with MainForm.PanelStatus do if StatusFlag then Show else Hide
end;

procedure TChildForm.SetTagKind;
begin
 HighlightOff;
 case MainForm.TabSet.TabIndex of
  1:   MakeTagButtons(tkBlk);
  2:   MakeTagButtons(tkChn);
  else MakeTagButtons(tkPag)
 end;
 HighlightOn; SetTagNDX(TagNDX[TagKind])
end;


(************************** DRAWING RELATED METHODS ***************************)

{ Modufikacja 1997 06 22 }

function TChildForm.GetVal(func : char; Ch : Byte; X : Word) : longint;
  var
    s : longint;  { Modyfikujemy przekaz informacji o przekazie }
                  { sposobu sumowania kanalow (Mont) }
begin
  s:=0;
  case func of
      'Z' : s:=Val_Z(Ch,X);
      'N' : s:=Val_N(Ch,X);
      'M' : s:=Val_M(Ch,X);
      'D' : s:=Val_D(Ch,X);
      'B' : s:=Val_B(Ch,X);
    end;

 if MainForm.Reverse then
   Result:=s
 else
   Result:=-s;
end;

function TChildForm.Val_Z(Ch: Byte; X: Word): LongInt;
begin
 Result:=0
end;
                                                                       { Val_N }
function TChildForm.Val_N(Ch: Byte; X: Word): LongInt;
 var
   ChRef: Byte;

begin
 with ChTab[Ch] do
  if Refs>0 then
   begin
    Result:=0;
    for ChRef:=1 to Refs do
      Inc(Result,BufTab[Ref[ChRef]]^[X]);
    Result:=BufTab[Channel]^[X]-Result div Refs
   end
  else Result:=BufTab[Channel]^[X]
end;
                                                                       { Val_M }
function TChildForm.Val_M(Ch: Byte; X: Word): LongInt;
 var ChRef: Byte;
begin
 with ChTab[Ch] do
  if Refs>0 then
   begin
    Result:=0; for ChRef:=1 to Refs do Inc(Result,BufTab[Ref[ChRef]]^[X]);
    Result:=(BufTab[Channel]^[X]-Result div Refs)*M
   end
  else Result:=BufTab[Channel]^[X]*M
end;
                                                                       { Val_D }
function TChildForm.Val_D(Ch: Byte; X: Word): LongInt;
 var ChRef: Byte;
begin
 with ChTab[Ch] do
  if Refs>0 then
   begin
    Result:=0; for ChRef:=1 to Refs do Inc(Result,BufTab[Ref[ChRef]]^[X]);
    Result:=(BufTab[Channel]^[X]-Result div Refs) div D
   end
  else Result:=BufTab[Channel]^[X] div D
end;
                                                                       { Val_B }
function TChildForm.Val_B(Ch: Byte; X: Word): LongInt;
 var ChRef: Byte;
begin
 with ChTab[Ch] do
  if Refs>0 then
   begin
    Result:=0; for ChRef:=1 to Refs do Inc(Result,BufTab[Ref[ChRef]]^[X]);
    Result:=(BufTab[Channel]^[X]-Result div Refs)*M div D
   end
  else Result:=BufTab[Channel]^[X]-Result*M div D
end;

                                                                    { GetChLab }
function TChildForm.GetChLab(Channel: Byte): string;
 var Ch: Byte;
begin
 for Ch:=1 to MaxChannels do
  if Mont[Ch].Channel=Channel then begin Result:=Mont[Ch].Labl; Exit end;
 Result:=''
end;
                                                               { SetChannelTab }
procedure TChildForm.SetChannelTab;
 var
     Ch, ChRef: Byte;
     H:         string;

begin
 for Ch:=1 to MaxChannels do ChTab[Ch].ChLabel.Free;
 FillChar(ChTab,SizeOf(ChTab),#0);
 for Ch:=1 to Mont.Channels do with Mont[Ch] do
  begin
   if (Channel>0) and (Channel<=iStream.Channels) then
    begin
     ChTab[Ch].Channel:=Channel; ChTab[Ch].M:=M; ChTab[Ch].D:=D;
     for ChRef:=1 to iStream.Channels do if Refs[ChRef] then
      begin
        Inc(ChTab[Ch].Refs);
        ChTab[Ch].Ref[ChTab[Ch].Refs]:=ChRef
      end;
     with ChTab[Ch] do             { Modyfikacja sposobu przekozu informacji o }
      if (D=0) or (D=1)  then      { funkcjach 1997 06 22 }
       if M=1 then ValFun:='N' {Val_N}
       else ValFun:='M' {Val_M}
      else
       if M=1 then ValFun:='D' {Val_D}
       else ValFun:='B' {Val_B}
    end
   else ChTab[Ch].ValFun:='Z'{Val_Z};
   H:=Hint; if ChTab[Ch].Refs>0 then with ChTab[Ch] do
    begin
     if H<>'' then H:=H+'. '; H:=H+RefTxt+': ';
     for ChRef:=1 to Refs do
      begin
       H:=H+GetChLab(Ref[ChRef]); if ChRef<Refs then H:=H+', '
      end
    end;
   ChTab[Ch].ChLabel:=TChLabel.Create(Self,PanelLab,Ch,Labl,H)
  end
end;
                                                                   { SetBufTab }
procedure TChildForm.SetBufTab;
 var Ch: Byte;
begin
 FillChar(BufTab,SizeOf(BufTab),#0);
 for Ch:=1 to iStream.Channels do BufTab[Ch]:=iStream[Ch]
end;

                                                                    { ShiftInc }
procedure TChildForm.ShiftInc;
begin
 if Shift<iADBits then
  begin ChLines:=ChLines shr 1; Inc(Shift); SetWavesButtons; Invalidate end
end;
                                                                    { ShiftDec }
procedure TChildForm.ShiftDec;
begin
 if Shift>0 then
  begin ChLines:=ChLines shl 1; Dec(Shift); SetWavesButtons; Invalidate end
end;
                                                                    { ShiftDef }
function TChildForm.ShiftDef: Boolean;
 var S: Byte;
     H: LongInt;
     L: Word;
begin
 S:=Shift; H:=ImageFrameHeight;
 if H<=0 then L:=0
 else
  if H<=Mont.Channels then L:=H
  else L:=(H div Succ(Mont.Channels)) shl 1;
 ChLines:=$10000 shr (16-iADBits); Shift:=0; ZeroRef:=Succ(ChLines shr 1);
 while (ChLines>L) and (Shift<iADBits) do
  begin ChLines:=ChLines shr 1; Inc(Shift) end;
 SetWavesButtons; Result:=Shift<>S
end;

                                                            { ImageFrameHeight }
function TChildForm.ImageFrameHeight: Integer;
begin
 Result:=ScrollBox.Height;
 if not ScaledHFlag and (SmpsPerPage>ScrollBox.Width-PanelLab.Width) then
  Dec(Result,ScrollBarWidth)
end;
                                                             { ImageFrameWidth }
function TChildForm.ImageFrameWidth: Integer;
begin
 Result:=ScrollBox.Width-PanelLab.Width;
 if not ScaledVFlag and (PageHeight>ScrollBox.Height) then
  Dec(Result,ScrollBarWidth)
end;

                                                                      { LayOut }
procedure TChildForm.LayOut;
 var ChOrg:     LongInt;
     Ch:        Byte;
     PW, PH, S: Word;
     C:         Integer;
begin
 MappingOK:=false;
 MemFree(X2Smp,PageWidth*SizeOf(Word)); MemFree(Y2Chn,PageHeight);

 PW:=PageWidth; PH:=PageHeight;

 if ScaledVFlag then
  begin
   PageHeight:=ImageFrameHeight;
   if (Mont.Channels=1) or (PageHeight<ChLines) then ChInc:=0
   else
    begin
     ChInc:=(PageHeight-ChLines) div Pred(Mont.Channels);
     if ChInc>ChLines then ChInc:=ChLines
    end;
   ChOrg:=(PageHeight-ChLines-ChInc*Pred(Mont.Channels)) div 2
  end
 else
  if Mont.Channels*ChLines<=MaxPageHeight then
   begin PageHeight:=Mont.Channels*ChLines; ChInc:=ChLines; ChOrg:=0 end
  else
   begin
    if (Mont.Channels=1) or (MaxPageHeight<ChLines) then ChInc:=0
    else ChInc:=(MaxPageHeight-ChLines) div Pred(Mont.Channels);
    ChOrg:=(MaxPageHeight-ChLines-ChInc*Pred(Mont.Channels)) div 2;
    if ChOrg>0 then
     begin ChOrg:=0; PageHeight:=ChLines+ChInc*Pred(Mont.Channels) end
    else PageHeight:=MaxPageHeight
   end;

 for Ch:=1 to Mont.Channels do with ChTab[Ch] do
  begin
   Org:=ChOrg; if ChLabel<>nil then
    ChLabel.Top:=Org+(ChLines shr 1)-(ChLabel.Height shr 1);
   Inc(ChOrg,ChInc)
  end;

 Points^[0].X:=0;
 if ScaledHFlag then
  begin
   PageWidth:=ImageFrameWidth;
   for S:=1 to SmpsPerPage do
    Points^[S].X:=Pred((longint(S)*longint(PageWidth)+longint(Pred(SmpsPerPage)))
                        div SmpsPerPage)
  end
 else
  begin
   PageWidth:=SmpsPerPage;
   for S:=1 to SmpsPerPage do Points^[S].X:=Pred(S)
  end;

 with dRect do
  begin
   Left:=Image.ClientOrigin.X; Top:=Image.ClientOrigin.Y;
   Right:=Pred(Left+ImageFrameWidth); Bottom:=Pred(Top+ImageFrameHeight)
  end;

 if MemInit(X2Smp,PageWidth*SizeOf(Word)) and MemInit(Y2Chn,PageHeight) then
  begin
   for C:=0 to Pred(PageWidth) do X2Smp^[C]:=Succ(C*SmpsPerPage div PageWidth);
   Ch:=1;
   for C:=0 to Pred(PageHeight) do
    begin
     if (Ch<Mont.Channels) and (C=ChTab[Succ(Ch)].Org) then Inc(Ch);
     Y2Chn^[C]:=Ch
    end;
   if PW=0 then mOrg.X:=0 else mOrg.X:=LongInt(mOrg.X)*PageWidth div PW;
   if PH=0 then mOrg.Y:=0 else mOrg.Y:=LongInt(mOrg.Y)*PageHeight div PH;
   MappingOK:=true
  end
 else
  begin
   MemFree(X2Smp,PageWidth*SizeOf(Word)); MemFree(Y2Chn,PageHeight);
   mOrg:=Point(0,0); mPag:=0; mBlk:=0; mChn:=0; mSmp:=0;
   InitBlockParms
  end;

 with MainForm do
  begin
   LabelSampleNo.Visible:=MappingOK;     LabelChannelNo.Visible:=MappingOK;
   LabelBlockNo.Visible:=MappingOK;      LabelPageNo.Visible:=MappingOK;
   LabelTime.Visible:=MappingOK
  end
end;

                                                                     { PagRect }
function TChildForm.PagRect(var R: TRect; Pag: LongInt): Boolean;
 var SL, SR: LongInt;
begin
 Result:=false; R:=Rect(0,0,0,0); if not MappingOK then Exit;
 SL:=Succ(Pred(Pag)*SmpsPerPage-iStream.PageOffset);
 SR:=Pred(SL+SmpsPerPage);
 if (SR>=1) and (SL<=SmpsPerPage) then with R do
  begin
   Result:=true;
   if SL<1 then Left:=-Points^[-SL].X
   else Left:=Points^[SL].X;
   if SR>SmpsPerPage then Right:=PageWidth+Points^[SR-SmpsPerPage].X
   else Right:=Points^[SR].X;
   Top:=0; Bottom:=Pred(PageHeight)
  end
end;
                                                                     { BlkRect }
function TChildForm.BlkRect(var R: TRect; Pag: LongInt; Blk: Byte): Boolean;
 var SL, SR: LongInt;
begin
 Result:=false; R:=Rect(0,0,0,0); if not MappingOK then Exit;
 SL:=Succ(Pred(Pag)*SmpsPerPage+Pred(Blk)*SmpsPerBlock-iStream.PageOffset);
 SR:=Pred(SL+SmpsPerBlock);
 if (SR>=1) and (SL<=SmpsPerPage) then with R do
  begin
   Result:=true;
   if SL<1 then Left:=-Points^[-SL].X
   else Left:=Points^[SL].X;
   if SR>SmpsPerPage then Right:=PageWidth+Points^[SR-SmpsPerPage].X
   else Right:=Points^[SR].X;
   Top:=0; Bottom:=Pred(PageHeight)
  end
end;
                                                                     { ChnRect }
function TChildForm.ChnRect(var R: TRect; Chn: Byte;
                            Offset: LongInt; Length: Word): Boolean;
 var SL, SR: LongInt;
begin
 Result:=false; R:=Rect(0,0,0,0); if not MappingOK then Exit;
 SL:=Succ(Offset-iStream.PageOffset);
 SR:=Pred(SL+Length);
 if (SR>=1) and (SL<=SmpsPerPage) then with R do
  begin
   Result:=true;
   if SL<-SmpsPerPage then SL:=-SmpsPerPage;
   if SR>2*SmpsPerPage then SR:=2*SmpsPerPage;
   if SL<1 then Left:=-Points^[-SL].X
   else Left:=Points^[SL].X;
   if SR>SmpsPerPage then Right:=PageWidth+Points^[SR-SmpsPerPage].X
   else Right:=Points^[SR].X;
   with ChTab[Chn] do begin Top:=Org; Bottom:=Pred(Org+ChLines) end
  end
end;
                                                                  { ChnBlkRect }
function TChildForm.ChnBlkRect(var R: TRect; Pag: LongInt;
                               Blk: Byte; Chn: Byte): Boolean;
 var SL, SR: LongInt;
begin
 Result:=false; R:=Rect(0,0,0,0); if not MappingOK then Exit;
 SL:=Succ(Pred(Pag)*SmpsPerPage+Pred(Blk)*SmpsPerBlock-iStream.PageOffset);
 SR:=Pred(SL+SmpsPerBlock);
 if (SR>=1) and (SL<=SmpsPerPage) then with R do
  begin
   Result:=true;
   if SL<1 then Left:=-Points^[-SL].X
   else Left:=Points^[SL].X;
   if SR>SmpsPerPage then Right:=PageWidth+Points^[SR-SmpsPerPage].X
   else Right:=Points^[SR].X;
   with ChTab[Chn] do begin Top:=Org; Bottom:=Pred(Org+ChLines) end
  end
end;

                                                                 { DrawVCursor }
procedure TChildForm.DrawVCursor;
 var mRect: TRect;
begin
 LoadSignalToZoom;
 if CursorFlag and ChnBlkRect(mRect,mPag,mBlk,mChn) then
  with Image, Canvas, mRect do
   begin
    SetBrush(Brush,clWhite,bsClear);
    SetPen(Pen,HighlightColor,pmNotXor,psDot,1);
    PolyLine([Point(Succ(Left),0),Point(Succ(Left),Pred(Height))]);
    PolyLine([Point(Pred(Right),0),Point(Pred(Right),Pred(Height))])
   end
end;
                                                                  { DrawCursor }
procedure TChildForm.DrawCursor;
 var
   mRect: TRect;

begin
 LoadSignalToZoom;  { ###### }
 if CursorFlag and ChnBlkRect(mRect,mPag,mBlk,mChn) then
  with Image, Canvas, mRect do
   begin
    SetBrush(Brush,clWhite,bsClear);
    SetPen(Pen,HighlightColor,pmNotXor,psDot,1);
    PolyLine([Point(0,Succ(Top)),Point(Pred(Width),Succ(Top))]);
    PolyLine([Point(0,Pred(Bottom)),Point(Pred(Width),Pred(Bottom))]);
    PolyLine([Point(Succ(Left),0),Point(Succ(Left),Pred(Height))]);
    PolyLine([Point(Pred(Right),0),Point(Pred(Right),Pred(Height))])
   end
end;
                                                                   { DrawBlock }
procedure TChildForm.DrawBlock;
 var bRect: TRect;
     OK:    Boolean;
begin
 if not BlkAct[TagKind] then Exit;
 OK:=false;
 case TagKind of
  tkPag: OK:=PagRect(bRect,pPag);
  tkBlk: OK:=BlkRect(bRect,bPag,bBlk);
  tkChn: OK:=ChnRect(bRect,cChn,cOffs,cLen)
 end;
 if OK then with Image, Canvas do
  begin
   SetBrush(Brush,clBlack,bsSolid);
   SetPen(Pen,clBlack,pmNotXor,psInsideFrame,5);
   with bRect do Rectangle(Left,Top,Succ(Right),Succ(Bottom))
  end
end;
                                                                { HighlightOff }
procedure TChildForm.HighlightOff;
begin
 DrawCursor; DrawBlock;
 if mChn<>0 then
  begin
   SetPen(Image.Canvas.Pen,clBlack,pmCopy,psSolid,0);
   DrawWave(Image.Canvas,mChn)
  end
end;
                                                                 { HighlightOn }
procedure TChildForm.HighlightOn;
begin
 if mChn<>0 then
  begin
   SetPen(Image.Canvas.Pen,SetHighlightColor,pmCopy,psSolid,0);
   DrawWave(Image.Canvas,mChn);
   Image.Canvas.PolyLine([Point(-1,-1),Point(-1,-1)])
  end;
 DrawBlock; DrawCursor
end;

procedure TChildForm.DrawTag(Canvas: TCanvas; R: TRect; const T: TTagHDRRec);
begin
 SetBrush(Canvas.Brush,T.BColor,T.BStyle);
 SetPen(Canvas.Pen,T.PColor,T.PMode,T.PStyle,T.PWidth);
 Canvas.Rectangle(R.Left,R.Top,Succ(R.Right),Succ(R.Bottom))
end;

{ ******************************************* 1997 06 22 }

function MinValue(a,b : byte) : byte;
begin              { Minimum 2 liczb }
  if a<b then
    MinValue:=a
  else
    MinValue:=b;
end;
                                                                    { DrawTags }
procedure TChildForm.DrawTags(Canvas: TCanvas);
 var bRect:   TRect;
     I,
     pMin,
     pMax:    Word;
     Ch, C:   Byte;
     OffsMin,
     OffsMax: LongInt;
     Current : Byte;

begin
 pMin:=Succ(iStream.PageOffset div SmpsPerPage);
 pMax:=pMin+Ord((iStream.PageOffset mod SmpsPerPage)<>0);
 OffsMin:=iStream.PageOffset; OffsMax:=Pred(iStream.PageOffset+SmpsPerPage);
 with Tags do
  begin
   if PagGetFrame(pMin,pMax) then for I:=PagMin to PagMax do
    if PagRect(bRect,Pag[I].Page) then DrawTag(Canvas,bRect,PagTag[I]);
   if BlkGetFrame(pMin,pMax) then for I:=BlkMin to BlkMax do with Blk[I] do
    if BlkRect(bRect,Page,Block) then DrawTag(Canvas,bRect,BlkTag[I]);
       { Modyfikacja 1997 06 22, Bierzemy mniejsza wartosc  }
   Current:=MinValue(Mont.Channels,iStream.iChannels);
   for Ch:=1 to Current do
    begin
     C:=ChTab[Ch].Channel;
     if ChnGetFrame(C,OffsMin,OffsMax)then
      for I:=ChnMin[C] to ChnMax[C] do
        with Chn[C,I] do
         if ChnRect(bRect,Ch,Offset,Length) then
            DrawTag(Canvas,bRect,ChnTag[C,I])
    end
  end
end;

procedure TChildForm.DrawLine(Canvas: TCanvas;
                              X1, Y1, X2, Y2: Integer; Color: TColor);
begin
 Canvas.Pen.Color:=Color; Canvas.PolyLine([Point(X1,Y1),Point(X2,Y2)])
end;
                                                                    { DrawTime }
procedure TChildForm.DrawTime(Canvas: TCanvas;
                              pOdd: Boolean; pFirst, pBound: Integer);
 var X, Y, P: Integer;
     S:       Word;
begin
 Y:=Pred(PageHeight);
 for S:=1 to Pred(Tags.SecPerPage*2) do
  begin
   P:=pFirst+(LongInt(iSampFreq)*S) div 10;
   if (P>=0) and (P<SmpsPerPage) then
    begin
     X:=Points^[Succ(P)].X;
     if X<=pBound then DrawLine(Canvas,X,0,X,Y,GridColors[pOdd])
     else              DrawLine(Canvas,X,0,X,Y,GridColors[not pOdd])
    end
  end;
 if pFirst=0 then DrawLine(Canvas,0,0,0,Y,GridColors[pOdd]);
 DrawLine(Canvas,pBound,0,pBound,Y,GridColors[pOdd]);
 if pBound<Pred(PageWidth) then
  begin
   X:=Succ(pBound);
   DrawLine(Canvas,Succ(pBound),0,Succ(pBound),Y,GridColors[not pOdd])
  end;
end;
                                                                    { DrawAxes }
procedure TChildForm.DrawAxes(Canvas: TCanvas;
                              pOdd: Boolean; pBound: Integer);
 var X, Y: Integer;
     Ch:   Byte;
begin
 X:=Pred(PageWidth);
 DrawLine(Canvas,0,0,pBound,0,GridColors[pOdd]);
 DrawLine(Canvas,Succ(pBound),0,X,0,GridColors[not pOdd]);
 for Ch:=1 to Mont.Channels do
  begin
   Y:=ChTab[Ch].Org+ChLines shr 1;
   DrawLine(Canvas,0,Y,pBound,Y,GridColors[pOdd]);
   DrawLine(Canvas,Succ(pBound),Y,X,Y,GridColors[not pOdd])
  end;
 Y:=Pred(PageHeight);
 DrawLine(Canvas,0,Y,pBound,Y,GridColors[pOdd]);
 DrawLine(Canvas,Succ(pBound),Y,X,Y,GridColors[not pOdd])
end;

procedure TChildForm.DrawOneSekAndAmpliBar(Canavs : TCanvas);
  var
    Len   : integer;                   { Rysowanie paleczek }
    point : array[0..3] of TPoint;

begin
  if MainForm.OneSekBarStat then   { Odcinek 1 sek }
    begin
      Len:=iSampFreq div 10;
      Len:=Points^[Succ(80+Len)].X-Points^[Succ(80)].X;
      point[0].X:=80;
      point[0].Y:=5;
      point[1].X:=80;
      point[1].Y:=10;
      point[2].X:=80+Len;
      point[2].Y:=10;
      point[3].X:=80+Len;
      point[3].Y:=5;
      with Image.Canvas do
        begin
          Font.Name:='Times New Roman';
          Font.Size:=8;
          Font.Color:=clGreen;
          TextOut(80+Len div 2,10,'1s');
          pen.Color:=clBlue;
          PolyLine(Point);
        end;
    end;

  if MainForm.AmpliBarStat then    { Odcinek 75 uV }
    begin
      Len:=round(75.0*iStream.iCalibConst) shr shift;
      if ScaledVFlag then
         Len:=Len div 2;

      point[0].X:=40;
      point[0].Y:=20;
      point[1].X:=35;
      point[1].Y:=20;
      point[2].X:=35;
      point[2].Y:=20+Len;
      point[3].X:=40;
      point[3].Y:=20+Len;
      with Image.Canvas do
         begin
           Font.Name:='Times New Roman';
           Font.Size:=8;
           Font.Color:=clGreen;
           TextOut(40,17+Len div 2,'75'+chr(181)+'V');
           pen.Color:=clBlue;
           PolyLine(Point);
         end;
     end;
end;

procedure TChildForm.DrawWave(Canvas: TCanvas; Chn: Byte);
 var X: Word;
     V: LongInt;
begin
 for X:=1 to iStream.PageMax do
  begin { Modyfikacja przekazu argumentow funkcji 1997 06 22 }
   V:=GetVal(ChTab[Chn].ValFun,Chn,X)+ZeroRef;
   if V<0 then Points^[X].Y:=ChTab[Chn].Org-(-V shr Shift)
   else        Points^[X].Y:=ChTab[Chn].Org+(V shr Shift)
  end;
 Points^[0].Y:=Points^[1].Y;
 WinProcs.PolyLine(Canvas.Handle,Points^,Succ(iStream.PageMax))
end;
                                                                   { DrawWaves }
procedure TChildForm.DrawWaves(Canvas: TCanvas);
 var Ch: Byte;
begin
 if iStream.PageMax>0 then
  begin
   SetBufTab;
   SetPen(Image.Canvas.Pen,clBlack,pmCopy,psSolid,0);
   for Ch:=1 to Mont.Channels do DrawWave(Canvas,Ch);
   DrawOneSekAndAmpliBar(Canvas);
  end
end;

procedure TChildForm.ScrollImage(R: TRect);
begin
 with LabelScroll do
  begin
   Left:=R.Left+PanelLab.Width; Top:=R.Top;
   Width:=Succ(R.Right-R.Left); Height:=Succ(R.Bottom-R.Top)
  end;
 ScrollBox.ScrollInView(LabelScroll)
end;

procedure TChildForm.FormPaint(Sender: TObject);
 var C:      TCursor;
     pOdd:   Boolean;
     pFirst,
     pBound: Integer;
     mRect:  TRect;
     CP:     TPoint;
     S:      Integer;

begin
 SetHipnogramPosition;  { Modyfikacja }
 C:=SetCursor(crHourglass);
 try
  { przed inicjacja struktur kursor musi byc wyzerowany }
  ScrollBox.HorzScrollBar.Position:=0; { Modyfikacja 1997 06 22 }
  LayOut;
  pOdd:=Odd(Succ(iStream.PageOffset div SmpsPerPage));
  pFirst:=-(iStream.PageOffset mod SmpsPerPage);
  pBound:=Points^[pFirst+SmpsPerPage].X;

  with Image.Picture.Bitmap do
   begin
    SetBrush(Canvas.Brush,clWhite,bsSolid);
    SetPen(Canvas.Pen,clWhite,pmCopy,psInsideFrame,1);
    Canvas.Rectangle(0,0,Width,Height);

    Width:=PageWidth; Height:=PageHeight;

    DrawTags(Canvas);

    SetBrush(Canvas.Brush,clWhite,bsSolid);
    SetPen(Canvas.Pen,clBlack,pmCopy,psSolid,1);

    if TimeFlag then DrawTime(Canvas,pOdd,pFirst,pBound);
    if AxesFlag then DrawAxes(Canvas,pOdd,pBound);

    DrawWaves(Canvas)
   end;

  ClipCursor(nil);
  if ChnBlkRect(mRect,mPag,mBlk,mChn) then ScrollImage(mRect);
  GetCursorPos(CP); CP:=Image.ScreenToClient(CP);
  S:=Pred(ImageFrameWidth);  if CP.X<0 then CP.X:=0 else if CP.X>S then CP.X:=S;
  S:=Pred(ImageFrameHeight); if CP.Y<0 then CP.Y:=0 else if CP.Y>S then CP.Y:=S;
  SetMouseCoord(true,CP.X,CP.Y);
 finally SetCursor(C)
 end
end;


(**************************** MAIN MENU SERVICES ******************************)
                                                                     { OpenTag }
procedure TChildForm.OpenTag;
 var SPP, BPP: Word;
begin
 ClearHint; SPP:=Tags.SecPerPage; BPP:=Tags.BlkPerPage;
 if Tags.Load and ((Tags.SecPerPage<>SPP) or (Tags.BlkPerPage<>BPP)) then
  begin
   if not FormInitialize then
    begin
     Tags.SecPerPage:=SPP; Tags.BlkPerPage:=BPP;
     if not FormInitialize then Close
    end
  end
 else begin MakeTagButtons(TagKind); Invalidate end;
 DrawTagName
end;

{ ************************************* 1997 06 19 }

procedure TChildForm.SaveWzr;
begin
  if not SaveWzrDialog.Execute then
    Exit;
  if not Tags.SaveTagToWzrFile(SaveWzrDialog.filename,
                               1+word(MaxOffset div istream.PageSize),
                               iStream.PageSize) then
    MessageDlg('Nie mozna zapisac WZRa',mtError,[mbOk], 0);
end;

procedure TChildForm.OpenWzr;
 var
    SPP,BPP: Word;

begin
 if not OpenWzrLoadDialog.Execute then
   Exit;
 ClearHint; SPP:=Tags.SecPerPage; BPP:=Tags.BlkPerPage;
 if Tags.SetTagArtifacts(OpenWzrLoadDialog.filename,BPP,iStream.PageSize)
    and ((Tags.SecPerPage<>SPP) or (Tags.BlkPerPage<>BPP)) then
  begin
   if not FormInitialize then
    begin
     Tags.SecPerPage:=SPP; Tags.BlkPerPage:=BPP;
     if not FormInitialize then Close
    end
  end
 else begin MakeTagButtons(TagKind); Invalidate end;
 DrawTagName;
 Tags.SetModified(true);
end;

{ **************************************************** }

procedure TChildForm.SaveTag(Immediate: Boolean);
begin
 ClearHint; Tags.Save(Immediate); DrawTagName
end;
                                                                    { CloseTag }
procedure TChildForm.CloseTag;
begin
 ClearHint; if Tags.Close then begin Invalidate; DrawTagName end
end;

function RemoveEND(source : string) : string;
var
  Output : string;
  len,i  : integer;

begin
  Output:='';
  len:=length(source);
  for i:=1 to len do
    if (source[i]=#10) or (source[i]=#13) then
      break
    else
      Output:=Output+source[i];
  Result:=Output;
end;

{ 1998 08 23/25/26 }

procedure TChildForm.OneSekAndAmpli(ScaleX,ScaleY : single);
  var
    Len   : integer;                   { Rysowanie paleczek }
    point : array[0..3] of TPoint;
    YPOS  : integer;

begin

  Len:=round(ScaleX*(iSampFreq div 10));
  YPOS:=round(0.9*0.150*Printer.PageHeight);
  if MainForm.OneSekBarStat then   { Odcinek 1 sek }
    begin
      point[0].X:=80;
      point[0].Y:=YPOS+15;
      point[1].X:=80;
      point[1].Y:=YPOS+20;
      point[2].X:=80+Len;
      point[2].Y:=YPOS+20;
      point[3].X:=80+Len;
      point[3].Y:=YPOS+15;
      with Printer.Canvas do
        begin
          TextOut(80+Len div 2,YPOS+10,'1s');
          PolyLine(Point);
        end;
     end;

 if MainForm.AmpliBarStat then    { Odcinek 75 uV }
   begin
      Len:=round(2.0*75.0*iStream.iCalibConst*ScaleY);
      if ScaledVFlag then
         Len:=Len div 2;

      point[0].X:=20;
      point[0].Y:=YPOS+20;
      point[1].X:=15;
      point[1].Y:=YPOS+20;
      point[2].X:=15;
      point[2].Y:=YPOS+20+Len;
      point[3].X:=20;
      point[3].Y:=YPOS+20+Len;
      with Printer.Canvas do
        begin
          TextOut(20,YPOS+17+Len div 2,'75'+chr(181)+'V');
          PolyLine(Point);
        end;
  end;
end;
                                                 { Print }
procedure TChildForm.Print(where : boolean; filename : string);
  type
     SigBuffor=array[1..10240] of integer;

  var
     OK                       : Boolean;
     bRect                    : TRect;
     Bitmap                   : TBitmap;
     StartOffset,StopOffset,X : word;
     MaxX,MaxY,Y,i,k,j        : word;
     MaxVal,MinVal,tmp        : integer;
     ScaleX,ScaleY            : single;
     FontSize,PageX,PageY     : integer;
     LinesMax                 : integer;
     YStep,YPos,dtmp          : single;
     Buffor                   : SigBuffor;
     MaxMontChannels          : integer;
     C                        : TCursor;
     napis                    : string;

begin
 HighlightOff;
 OK:=false;
 if BlkAct[TagKind] then
  case TagKind of
   tkPag: OK:=PagRect(bRect,pPag);
   tkBlk: OK:=BlkRect(bRect,bPag,bBlk);
   tkChn: OK:=ChnRect(bRect,cChn,cOffs,cLen)
  end;
 if OK then
  begin
   if not where then
    begin
      Bitmap:=TBitmap.Create;
      try
        with Bitmap, bRect do
          begin
            Width:=Succ(Right-Left); Height:=Succ(Bottom-Top);
            Canvas.CopyRect(Rect(0,0,Width,Height),
                            Image.Picture.Bitmap.Canvas,
                            Rect(Left,Top,Succ(Right),Succ(Bottom)));
          end;
        Bitmap.SaveToFile(filename);
       finally
         Bitmap.Free;
       end;
     end
   else
      begin
        Printer.BeginDoc;
        C:=SetCursor(crHourglass);
        PageX:=round(0.100*Printer.PageWidth);
        PageY:=round(0.150*Printer.PageHeight);
        MaxX:=Printer.PageWidth-2*PageX;
        MaxY:=Printer.PageHeight-PageY;
        MaxMontChannels:=Mont.Channels;

        with Printer.Canvas do
          begin
             napis:='File: '+ExtractFileName(FormatDialog.ComboBoxPath.Text)
                          +'  Date: '+DateToStr(Date)
                          +'  Time: '+TimeToStr(Time);

             case TagKind of
                tkPag: napis:=napis+'  Page: '+IntToStr(pPag);
                tkBlk: napis:=napis+'  Page: '+IntToStr(bPag)
                       +'  Block: '+IntToStr(bBlk);
                tkChn: napis:=napis+'  Channel: '+IntToStr(cChn)
                       +' ('+Mont.Labl[cChn]+')'
                       +'  Offset: '+IntToStr(cOffs)
                       +'  Length: '+IntToStr(cLen)
                       +'  (Page: '+IntToStr(1+(cOffs div iStream.PageMax))+')';
             end;

             FontSize:=TextHeight(napis);
             TextOut(0,0,napis);

             if PatientIDDlg.OK then
               begin
                 k:=1;
                 LinesMax:=PatientIDDlg.MaxLines;
                 for i:=0 to LinesMax do
                   begin
                    TextOut(0,FontSize*k,RemoveEND(PatientIDDlg.GetLines(i)));
                    Inc(k);
                   end;
               end;
          end;

        SetBufTab;
        case TagKind of
          tkChn:
              begin
                StartOffset:=1+(cOffs mod iStream.PageMax);
                StopOffset:=StartOffset+clen;
                if StopOffset>=iStream.PageMax then
                   StopOffset:=iStream.PageMax-1;

                MaxVal:=GetVal(ChTab[cChn].ValFun,cChn,StartOffset);
                MinVal:=MaxVal;
                Buffor[StartOffset]:=MaxVal;

                for X:=StartOffset+1 to StopOffset do
                  begin
                     tmp:=GetVal(ChTab[cChn].ValFun,cChn,X);
                     if tmp>MaxVal then MaxVal:=tmp;
                     if tmp<MinVal then MinVal:=tmp;
                     Buffor[X]:=tmp;
                  end;

                if MinVal<>MaxVal then
                   ScaleY:=(MaxY/Mont.Channels)/(MaxVal-MinVal)
                 else
                   ScaleY:=1.0;

                if StopOffset<>StartOffset then
                  ScaleX:=MaxX/(StopOffset-StartOffset)
                else
                  ScaleX:=1.0;

                X:=round(PageX+ScaleX);
                Y:=round(PageY+ScaleY*(GetVal(ChTab[cChn].ValFun,cChn,StartOffset)
                         -MinVal));
                Printer.Canvas.MoveTo(X,Y);
                K:=2;
                for i:=StartOffset+1 to StopOffset do
                  begin
                    X:=round(PageX+ScaleX*k);
                    Y:=round(PageY+ScaleY*(Buffor[i]-MinVal));
                    Printer.Canvas.LineTo(X,Y);
                    inc(K);
                  end;

                OneSekAndAmpli(ScaleX,ScaleY);
                Printer.Canvas.TextOut(PageX div 2,round(PageY+ScaleY*
                                       (MaxVal-MinVal)*0.5),Mont.Labl[cChn]);
              end;
          tkBlk,tkPag:
                 begin
                  if TagKind=tkBlk then
                    begin
                      StartOffset:=1+(bBlk-1)*SmpsPerBlock;
                      StopOffset:=StartOffset+SmpsPerBlock;
                      if StopOffset>=iStream.PageMax then
                        StopOffset:=iStream.PageMax-1;
                    end
                  else
                    begin
                      StartOffset:=1;
                      StopOffset:=iStream.PageMax-1
                    end;

                  MaxVal:=GetVal(ChTab[1].ValFun,1,StartOffset);
                  MinVal:=MaxVal;

                  for k:=1 to MaxMontChannels do
                    for X:=StartOffset+1 to StopOffset do
                       begin
                          tmp:=GetVal(ChTab[k].ValFun,k,X);
                          if tmp>MaxVal then MaxVal:=tmp;
                          if tmp<MinVal then MinVal:=tmp;
                       end;

                   if MinVal<>MaxVal then
                     ScaleY:=(MaxY/Mont.Channels)/(MaxVal-MinVal)
                   else
                     ScaleY:=1.0;

                   if StopOffset<>StartOffset then
                      ScaleX:=MaxX/(StopOffset-StartOffset)
                   else
                      ScaleX:=1.0;

                   YStep:=MaxY/MaxMontChannels;
                   dtmp:=0.5*ScaleY*(MaxVal-MinVal);

                   for j:=1 to MaxMontChannels do
                    begin
                      YPos:=YStep*(j-1)+PageY;
                      X:=round(PageX+ScaleX); tmp:=j;
                      Y:=round(YPos+ScaleY*(GetVal(ChTab[j].ValFun,
                               tmp,StartOffset)-MinVal));
                      Printer.Canvas.MoveTo(X,Y);
                      K:=2;
                      for i:=StartOffset+1 to StopOffset do
                         begin
                           X:=round(PageX+ScaleX*k);
                           Y:=round(YPos+ScaleY*(GetVal(ChTab[j].ValFun,j,i)
                                    -MinVal));
                           Printer.Canvas.LineTo(X,Y);
                           inc(K);
                         end;
                      Printer.Canvas.TextOut(PageX div 2,round(YPos+dtmp),
                                             Mont.Labl[j]);
                  end;
                  OneSekAndAmpli(ScaleX,ScaleY);
                end;
       end;
       Printer.EndDoc;
       SetCursor(C);
      end;
  end;

  HighlightOn;
  Invalidate;
end;
                                                                 { EditMontage }
procedure TChildForm.EditMontage;
 var Ch: Byte;
begin
 ClearHint; Ch:=Mont.Channels;
 if MontageDialog.Execute(Mont) then
  begin
     SetChannelTab;
     SetActiveChannels; { 1998 01 04 }
     if Mont.Channels<>Ch then
       ShiftDef;
     (* SetActiveChannels; { 1998 01 04 } *)
     Invalidate;
  end;
end;
                                                                    { EditTags }
procedure TChildForm.EditTags;
 var SPP, BPP: Word;
begin
 ClearHint; SPP:=Tags.SecPerPage; BPP:=Tags.BlkPerPage;
 TagListDialog.Execute(Tags,TagKind,iSampFreq);
 if (Tags.SecPerPage<>SPP) or (Tags.BlkPerPage<>BPP) then
  begin
   if not FormInitialize then
    begin
     Tags.SecPerPage:=SPP; Tags.BlkPerPage:=BPP;
     if not FormInitialize then Close
    end
  end
 else begin MakeTagButtons(TagKind); Invalidate end
end;

{ Modyfikacja 1997 07 20 }

procedure TChildForm.ComputeChannelFFT;
  var
   bRect  : TRect;
   OK     : boolean;
   X,i,j  : word;
   V      : longint;
   sum    : single;

begin
  HighlightOff;
  OK:=false;
  if BlkAct[TagKind] then
    if TagKind=tkChn then
      OK:=ChnRect(bRect,cChn,cOffs,cLen);

  if not OK then
   begin
     HighlightOn;
     exit;
   end;

  ChannelFFT.MaxSeg:=Tags.BlkPerPage;
  ChannelFFT.SampFreq:=0.1*iSampFreq;
  ChannelFFT.pointsPerSeg:=SmpsPerBlock;

  sum:=0.0;
  SetBufTab;
  for x:=1 to iStream.PageMax do
    begin
       V:=GetVal(ChTab[cChn].ValFun,cChn,X)+ZeroRef;
       sum:=sum+ChTab[cChn].Org+V;
    end;
  sum:=sum/(iStream.PageMax);

  X:=1;
  SetBufTab;
  for i:=1 to Tags.BlkPerPage do
    begin
      for j:=1 to SmpsPerBlock do
       if j<=MaxSegSize then
       begin
         V:=GetVal(ChTab[cChn].ValFun,cChn,X)+ZeroRef+ChTab[cChn].Org;
         ChannelFFT.ChnSigTab[j]:=V-sum;
         inc(x);
       end;
      ChannelFFT.ComputeSeg(i-1);
    end;

  HighlightOn;
  ChannelFFT.Show;
end;

 { Modyfikacja 1997 12 10, 1998 10 23 }

procedure TChildForm.SaveChnToAsciiFile; { Zapis Wybranego odcinka do pliku }
  var
    OK    : boolean;
    bRect : TRect;
    X,EndPage,StartOffset,k,StopOffset,MaxMontChannels : word;
    V     : longint;
    plik  : TextFile;

 begin
   HighlightOff;
   OK:=false;
   if BlkAct[TagKind] then
    case TagKind of
      tkPag: OK:=PagRect(bRect,pPag);
      tkBlk: OK:=BlkRect(bRect,bPag,bBlk);
      tkChn: OK:=ChnRect(bRect,cChn,cOffs,cLen)
    end;

    if not OK then
     begin
      HighlightOn;
      exit;
     end;

   if SaveAsciiDialog.Execute then  { Bring up open file dialog }
    begin
     SetBufTab;
     {$I-}
     AssignFile(plik,SaveAsciiDialog.FileName); { File selected in dialog }
     ReWrite(plik);
     {$I+}
     if IOResult<>0 then
      begin
        MessageDlg('File access error !', mtWarning, [mbOk], 0);
        exit;
      end;

   if TagKind=tkChn then
     begin
       StartOffset:=1+(cOffs mod iStream.PageMax);
       if StartOffset<1 then StartOffset:=1;
       EndPage:=StartOffset+clen;
       if EndPage>=iStream.PageMax then
       EndPage:=iStream.PageMax;

       for X:=StartOffset to EndPage do
          writeln(plik,-GetVal(ChTab[cChn].ValFun,cChn,X):6);
     end
   else
     begin
      if TagKind=tkBlk then
       begin
         StartOffset:=1+(bBlk-1)*SmpsPerBlock;
         StopOffset:=StartOffset+SmpsPerBlock;
         if StopOffset>iStream.PageMax then
            StopOffset:=iStream.PageMax;
       end
      else
        begin
          StartOffset:=1;
          StopOffset:=iStream.PageMax
        end;
        MaxMontChannels:=Mont.Channels;
        for X:=StartOffset to StopOffset do
          begin
            for k:=1 to MaxMontChannels do
               write(plik,-GetVal(ChTab[k].ValFun,k,X):6,' ');
            writeln(plik);
          end;
     end;

    CloseFile(plik);
   end;
   HighlightOn;
 end;
                                                               { ClipboardCopy }
{ Modyfikacja 1997 07 13 }

procedure TChildForm.ComputeFFT; { Wyznaczenie FFT }
  var
    OK    : boolean;
    i,len : integer;
    dane  : ^FFTTABLE;
    bRect : TRect;
    X,EndPage,k,StartOffset : word;
    V     : longint;
    B     : boolean;

 begin
   HighlightOff;
   OK:=false;
   if BlkAct[TagKind] then
     if TagKind=tkChn then
       OK:=ChnRect(bRect,cChn,cOffs,cLen);

    if not OK then
     begin
      HighlightOn;
      exit;
     end;

   B:=MemInit(dane,sizeOf(FFTTABLE));
   if not B then
    begin
      HighlightOn;
      exit;
    end;

   for i:=1 to MaxFFTSize do
     dane^[i]:=0.0;

   StartOffset:=1+(cOffs mod iStream.PageMax);
   if StartOffset<1 then StartOffset:=1;
   len:=clen;
   if len>MaxFFTSize then
    len:=MaxFFTSize;
   EndPage:=StartOffset+len;
   if EndPage>=iStream.PageMax then
     EndPage:=iStream.PageMax;

   SetBufTab;
   k:=1;
   for X:=StartOffset to EndPage do
    if k<=MaxFFTSize then
     begin
       V:=GetVal(ChTab[cChn].ValFun,cChn,X)+ZeroRef;
       dane^[k]:=ChTab[cChn].Org+V;
       inc(k);
     end;

   HighlightOn;
   FormFFT.SetFFT(dane^,Len,iSampFreq/10.0); { ????? }
   FormFFT.show;
   FreeMem(dane,sizeOf(FFTTABLE));
 end;
                                                               { ClipboardCopy }
procedure TChildForm.ClipboardCopy;
 var OK:     Boolean;
     bRect:  TRect;
     Bitmap: TBitmap;
begin
 HighlightOff;
 OK:=false;
 if BlkAct[TagKind] then
  case TagKind of
   tkPag: OK:=PagRect(bRect,pPag);
   tkBlk: OK:=BlkRect(bRect,bPag,bBlk);
   tkChn: OK:=ChnRect(bRect,cChn,cOffs,cLen)
  end;
 if OK then
  begin
   Bitmap:=TBitmap.Create;
   try
    with Bitmap, bRect do
     begin
      Width:=Succ(Right-Left); Height:=Succ(Bottom-Top);
      Canvas.CopyRect(Rect(0,0,Width,Height),
                      Image.Picture.Bitmap.Canvas,
                      Rect(Left,Top,Succ(Right),Succ(Bottom)))
     end;
    Clipboard.Assign(Bitmap)
   finally Bitmap.Free
   end
  end
 else Clipboard.Assign(Image.Picture.Bitmap);
 HighlightOn
end;

function TChildForm.GetMaxPageNo : word; { Maksymalny numer strony }
begin
  Result:=Succ(MaxOffset div SmpsPerPage);
end;

function TChildForm.GetCurrentPageNo : word; { Aktualna strona }
begin
  Result:=Succ(iStream.PageOffset div SmpsPerPage);
end;

{ ************* 1997 07 16 }

procedure TChildForm.GoToSelectPage(page : word);{ Przeskok do wybranej strony }
begin
  if (page>=1) and (page<=Succ(MaxOffset div SmpsPerPage)) then
    begin
     iStream.PageOffset:=LongInt(Pred(Page))*LongInt(SmpsPerPage);
     Invalidate;
    end;
end;

procedure TChildForm.SetHipnogramPosition;
begin          { Rysowanie hipnogramu }
  DrawHipnogram(GetCurrentPageNo); { Ustalenie aktywnosci wyswietlania headerow }
  if ((iStream is TiPegasus) or (iStream is TiDBin)) then
      MainForm.ViewHeaderInfo.Enabled:=true { 1997 09 26 }
    else
      MainForm.ViewHeaderInfo.Enabled:=false;
end;

{ Modyfikacja 1998 08 18 - validacja oznaczen }
procedure TChildForm.GotoBadPage(what : boolean);
var
  PageNo,StartPage : word;
  OK               : boolean;

begin
  if what then
    StartPage:=1+Succ(iStream.PageOffset div SmpsPerPage)
  else
    StartPage:=1;

  PageNo:=tags.GetBadPage(OK,StartPage,Succ(MaxOffset div SmpsPerPage));
  if OK then
    begin
     iStream.PageOffset:=LongInt(Pred(PageNo))*LongInt(SmpsPerPage);
     Invalidate;
     SetHipnogramPosition;
             { Synchronizacja okien 1998 01 18 }
     if MainForm.SynchroStatus=true then
       MainForm.Synchronize;
    end
  else MessageDlg('No bad pages',mtInformation,[mbOk],0);

end;
                                                                    { GoToPage }
procedure TChildForm.GoToPage;
 var
     PageNo, Min, Max: Word;

begin
 PageNo:=Succ(iStream.PageOffset div SmpsPerPage);
 Min:=1; Max:=Succ(MaxOffset div SmpsPerPage);
 if GoToDialog.Execute(PageNo,Min,Max) then
  begin      { Modyfikacja (niepoprawana konwersja typow) 1996 06 22 }
   iStream.PageOffset:=LongInt(Pred(PageNo))*LongInt(SmpsPerPage);
   Invalidate;
   SetHipnogramPosition;
             { Synchronizacja okien 1998 01 18 }
   if MainForm.SynchroStatus=true then
     MainForm.Synchronize;
  end
end;

procedure TChildForm.Calibration; { Kalibracja zewnetrzna 1997 09 28 }
  var
    NewCalib : single;
    napis    : string;

begin
 NewCalib:=iStream.iCalibConst;
 if CalibDialog.Execute(NewCalib) then
   begin
    iStream.iCalibConst:=NewCalib;
    str(NewCalib:3:2,napis);
    FormatDialog.CalibConstEdit.Text:=napis;
    Invalidate;
   end;
end;

procedure TChildForm.ViewHeaderInfo;
begin
  if iStream is TiPegasus then
    begin
      if PegasusTailDlg.LoadHeader(iStream.FilePath) then
         PegasusTailDlg.Show;
    end
  else if iStream is TiDBin then
    if ReadHeader.LoadHeader(iStream.FilePath,true) then
       ReadHeader.Show;
end;

procedure TChildForm.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
var
  s : integer;    { Przewijarka 1997 06 29 dodatkowe klawisze + - itp }
  R : word;       { Tryb Zgodnosci 1997 07 20 }
  i : integer;
  B : boolean;

begin
  if Key=VK_ADD then
   begin
    ScrollData(scPageDown,s);
    SetHipnogramPosition;
   end
  else if Key=VK_SUBTRACT then
    begin
     ScrollData(scPageUp,s);
     SetHipnogramPosition;
    end
  else if Key=VK_RETURN then
          ImageDblClick(Sender);

  if not MainForm.OldModeStat then    { Tryb zgodnosci dalej tylko }
   exit;                              { dla stargo stylu }

  if (Key=Ord('a')) or (Key=Ord('A')) then
         begin
            if Tags.IsBlkTag(ARTIFACT) then
              begin
                R:=Tags.BlkAdd(TagBlkRec(ARTIFACT,mPag,mBlk));
                if R<>0 then
                  begin
                    SetTagNDX(R);
                    DrawTagName;
                    Invalidate
                  end;
               end;
         end
  else if (Key=Ord('z')) or (Key=Ord('Z')) then
         begin
           if Tags.IsBlkTag(ARTIFACT) then
             for i:=1 to Tags.GetBlockPerPage do
               begin
                 R:=Tags.BlkAdd(TagBlkRec(ARTIFACT,mPag,i));
                 if R<>0 then
                   begin
                     SetTagNDX(R);
                     DrawTagName;
                     Invalidate
                   end;
                end;
         end
  else if (Key=Ord('s')) or (Key=Ord('S')) then
         begin
           if Tags.IsBlkTag(ARTIFACT) then
             begin
              if Tags.BlkSearch(mPag,mBlk,R)=0 then
               if Tags.BlkTag[R].Tag=ARTIFACT then
                begin
                  B:=Tags.BlkDel(R);
                  if B then
                    begin
                      SetTagNDX(0);
                      DrawTagName;
                      Invalidate;
                     end;
                end;
             end;
         end
   else if (Key=Ord('x')) or (Key=Ord('X')) then
          begin
            if Tags.IsBlkTag(ARTIFACT) then
              for i:=1 to Tags.GetBlockPerPage do
                begin
                  if Tags.BlkSearch(mPag,i,R)=0 then
                    if Tags.BlkTag[R].Tag=ARTIFACT then
                      begin
                         B:=Tags.BlkDel(R);
                         if B then
                           begin
                             SetTagNDX(0);
                             DrawTagName;
                             Invalidate;
                           end;
                       end;
                 end;
          end;
end;

procedure TChildForm.OnActive(Sender: TObject);
begin
 if FormOk then
   SetHipnogramPosition;
end;

procedure TChildForm.FormKeyUP(Sender: TObject; var Key: Word;
  Shift: TShiftState);
  var
    dx,dy : integer;                     { Klawiatura 1997 07 20 }
    OldDragMode : TDragMode;             { Przemieszczanie sie i
                                         { sterowanie kursorem }
begin
 if not FormOk then Exit;
 dx:=Image.Width div Tags.GetBlockPerPage;
 dy:=image.Height div Mont.Channels;
 if (dx<>0) and (dy<>0) then
   begin
    OldCordX:=dx*(OldCordX div dx)+(dx div 2);
    OldCordY:=dy*(OldCordY div dy)+(dy div 2);
   end;

 if ((Key=VK_LEFT) and (Shift=[ssShift])) then
   begin                                  { Sterowanie kursorem }
     if not BlkAct[tkChn] then Exit;
     DrawBlock;
     cOffs:=cOffs-Skok;
     DrawBlock;
     exit;
   end
 else if ((Key=VK_RIGHT) and (Shift=[ssShift])) then
   begin
     if not BlkAct[tkChn] then Exit;
     DrawBlock;
     cOffs:=cOffs+Skok;
     DrawBlock;
     exit;
   end
 else if ((Key=VK_LEFT) and (Shift=[ssAlt])) then
    begin
     if not BlkAct[tkChn] then Exit;
     DrawBlock;
     cLen:=cLen-Skok;
     if cLen<1 then
      cLen:=1;
     DrawBlock;
     exit;
   end
 else if ((Key=VK_RIGHT) and (Shift=[ssAlt])) then
   begin
     if not BlkAct[tkChn] then Exit;
     DrawBlock;
     cLen:=cLen+Skok;
     if cLen>MaxChnTagLen then
      cLen:=MaxChnTagLen;
     DrawBlock;
     exit;                            { Zwiekszanie skoku kursora }
   end
 else if ((Key=VK_UP) and (Shift=[ssShift])) then
   begin
     if not BlkAct[tkChn] then Exit;
     Skok:=Skok*2;
     if Skok>64 then Skok:=64;
     exit;
   end
 else if ((Key=VK_DOWN) and (Shift=[ssShift])) then
   begin
     if not BlkAct[tkChn] then Exit;
     Skok:=Skok div 2;
     if Skok<1 then Skok:=1;
     exit;
   end
 else if Key=VK_LEFT then
   begin
     OldCordX:=OldCordX-dx;
     if OldCordX<0 then OldCordX:=0;
     ImageMouseMove(Sender,Shift,OldCordX,OldCordY);
     exit;
   end
 else if Key=VK_RIGHT then
        begin
          OldCordX:=OldCordX+dx;
          if OldCordX>Image.Width then OldCordX:=Image.Width;
          ImageMouseMove(Sender,Shift,OldCordX,OldCordY);
          exit;
        end
 else if Key=VK_UP then
        begin
          OldCordY:=OldCordY-dy;
          if OldCordY<0 then OldCordY:=0;
          ImageMouseMove(Sender,Shift,OldCordX,OldCordY);
          exit;
        end
 else if Key=VK_DOWN then
         begin
          OldCordY:=OldCordY+dy;
          if OldCordY>Image.Height then OldCordY:=Image.Height;
          ImageMouseMove(Sender,Shift,OldCordX,OldCordY);
          exit;
         end;
ImageMouseMove(Sender,Shift,OldCordX,OldCordY); { Na stara pozycje }
end;

end. { DDVCHILD }
