unit  DDVFRMT;

interface

uses  WinTypes, WinProcs, SysUtils, Classes,  Graphics, Forms,    Controls,
      StdCtrls, ExtCtrls, Buttons,  Spin,     Mask,     Dialogs,  IniFiles,
      FIRST,    DDVINI,   DDVAPDLG, DDVINSTR, DDVTAGS,  DDVMNTG,  DDVTAGLI,
      DDVMAIN, HREAD, PEGDLG,EXTHEAD; { Dadatkowo mozliwosc wyswietlania
                                naglowkow 1997 09 26}

const MaxFormat = 7;   { Dodatkowo PEGASUS 1997 09 20; 1998 09 01 }

type  TFormatDialog = class(TForm)
                       RadioGroupFormat:         TRadioGroup;
                       GroupBoxTech:             TGroupBox;
                               LabelBits:        TLabel;
                               SpinEditBits:     TSpinEdit;
                               LabelFreq:        TLabel;
                               MaskEditFreq:     TMaskEdit;
                               LabelChannels:    TLabel;
                               SpinEditChannels: TSpinEdit;
                       GroupBoxPath:             TGroupBox;
                               ComboBoxPath:     TComboBox;
                               LabelExt:         TLabel;
                               EditExt:          TEdit;
                               CheckBoxSort:     TCheckBox;
                               BtnValidate:      TBitBtn;
                               BtnBrowse:        TBitBtn;
                       BtnMontage:               TBitBtn;
                       BtnTag:                   TBitBtn;
                       BtnLoad:                  TBitBtn;
                       BtnSave:                  TBitBtn;
                       CheckBoxDefault:          TCheckBox;
                       BtnOK:                    TBitBtn;
                       BtnCancel:                TBitBtn;
    Label1: TLabel;
    CalibConstEdit: TEdit;
    ViewHeaderBox: TCheckBox;

                       procedure FormCreate(Sender: TObject);
                       procedure FormDestroy(Sender: TObject);
                       procedure RadioGroupFormatClick(Sender: TObject);
                       procedure BtnLoadClick(Sender: TObject);
                       procedure BtnSaveClick(Sender: TObject);
                       procedure BtnBrowseClick(Sender: TObject);
                       procedure BtnValidateClick(Sender: TObject);
                       procedure BtnMontageClick(Sender: TObject);
                       procedure BtnTagClick(Sender: TObject);
                       procedure BtnOKClick(Sender: TObject);

                      private { Private declarations }
                       FFreq: Word;

                       procedure SetFreq(Value: Word);
                       procedure SetFormat;
                       procedure LoadOptions(const FileName: string);
                       procedure SaveOptions(const FileName: string);
                       function  Validate: Boolean;
                       function  CheckSamplingFreq: Boolean;
                       procedure PrepareOpenDialog;
                      public  { Public declarations }
                       iStream: TiStream;
                       Mont:    TMontage;
                       Tags:    TTag;
                       OK   :   boolean;

                       property  SamplingFreq: Word read FFreq write SetFreq;

                       function  Execute: Boolean;
                      end;

var   FormatDialog: TFormatDialog;

implementation

{$R *.DFM}

const SamplingFreqTxt:   string[20] = 'Sampling frequency';

      ConflictSecTxt:    string[60] = 'Conflict between Sampling frequency '+
                                      'and Seconds per page.';
      ConflictBlk1Txt:   string[40] = 'Conflict between Sampling frequency, ';
      ConflictBlk2Txt:   string[40] = 'Seconds per page and Blocks per page.';
      ResultingSPPTxt:   string[40] = 'The resulting value of '+
                                      'Samples per page';
      ResultingSPBTxt:   string[40] = 'The resulting value of '+
                                      'Samples per block';
      MustBeIntegerTxt:  string[20] = ' must be an integer.';
      MustNotExceedTxt:  string[20] = ' must not exceed ';
      ConflictHint1Txt:  string[40] = 'Set proper value for Sampling frequency';
      ConflictHint2Txt:  string[60] = 'or enter Tag list and set proper value'+
                                      ' for Seconds per page.';
      ConflictHint3Txt:  string[40] = 'or enter Tag list and set proper values.';

      DatTitle:          string[20] = 'Open Input Stream';

      DatExt:            array[0..MaxFormat] of string[3]
                                  = ( 'DAT', 'TXT', 'SDT', 'EEG', 'SNK', 'D','?'
                                      ,'BIN' );

      DatFilter:         array[0..MaxFormat] of string[40]
                                  = ( 'MEDELEC files (*.DAT)|*.DAT|',
                                      'ASCII files (*.TXT)|*.TXT|',
                                      'Binary files (*.SDT)|*.SDT|',
                                      'Bio-logic files (*.EEG)|*.EEG|',
                                      'Compressed files (*.SNK)|*.SNK|',
                                      'EASYS D-files (*.D)|*.D|',
                                      'PEGASUS files (*.?)|*.?|',
                                      'FLOAT files (*.bin)|*.bin|' );

                                                                  { FormCreate }
procedure TFormatDialog.FormCreate(Sender: TObject);
begin
 OK:=false;                            { Modufikacja 1997 09 20 }
 SetFormPos(Self,30,60);
 ComboBoxPath.DropDownCount:=MaxHistory;
 with SpinEditChannels do begin MinValue:=1; MaxValue:=MaxChannels end;
 with SpinEditBits do begin MinValue:=1; MaxValue:=16 end;
 SamplingFreq:=1024;
 LoadOptions(MainIniFileName);
 LoadHistory(MainIniFileName,HstDatSec,ComboBoxPath.Items)
end;
                                                                 { FormDestroy }
procedure TFormatDialog.FormDestroy(Sender: TObject);
begin
 if OK then       { Modyfikacja 1997 09 20 }
   begin
     iStream.Free;
     Mont.Free;
     Tags.Free;
   end;
end;
                                                       { RadioGroupFormatClick }
procedure TFormatDialog.RadioGroupFormatClick(Sender: TObject);
begin
 SetFormat
end;
                                                                { BtnLoadClick }
procedure TFormatDialog.BtnLoadClick(Sender: TObject);
begin
 if ApplyOpenDialog(dkIni,IniFileName) then LoadOptions(IniFileName)
end;
                                                                { BtnSaveClick }
procedure TFormatDialog.BtnSaveClick(Sender: TObject);
begin
 if ApplySaveDialog(dkIni,IniFileName) then SaveOptions(IniFileName)
end;
                                                              { BtnBrowseClick }
procedure TFormatDialog.BtnBrowseClick(Sender: TObject);
begin
 PrepareOpenDialog;
 if MainForm.OpenDialog.Execute then
  ComboBoxPath.Text:=ANSILowerCase(ExpandFileName(MainForm.
                                                  OpenDialog.FileName));
 if ComboBoxPath.Enabled then ActiveControl:=ComboBoxPath
end;
                                                            { BtnValidateClick }
procedure TFormatDialog.BtnValidateClick(Sender: TObject);
begin
 Validate
end;
                                                             { BtnMontageClick }
procedure TFormatDialog.BtnMontageClick(Sender: TObject);
begin
 MontageDialog.Execute(MainForm.Mont)
end;
                                                                 { BtnTagClick }
procedure TFormatDialog.BtnTagClick(Sender: TObject);
begin
 TagListDialog.Execute(MainForm.TagHDR,tkPag,0)
end;
                                                                  { BtnOKClick }
procedure TFormatDialog.BtnOKClick(Sender: TObject);
 var
   Useful: Boolean;
   code,i: integer;
   napis : string;

begin
 OK:=true;
 Useful:=Validate and CheckSamplingFreq;
 if Useful then
  begin
   case RadioGroupFormat.ItemIndex of
    0: iStream:=  Ti12B.Create(ComboBoxPath.Text,CheckBoxSort.Checked,
                               SpinEditChannels.Value);
    1: iStream:=TiASCII.Create(ComboBoxPath.Text,CheckBoxSort.Checked,
                               SpinEditChannels.Value);
    2: iStream:=  TiBin.Create(ComboBoxPath.Text,CheckBoxSort.Checked,
                               SpinEditChannels.Value);
    3: iStream:= TiBBin.Create(ComboBoxPath.Text,CheckBoxSort.Checked,
                               SpinEditChannels.Value);
    4: iStream:= TiCBin.Create(ComboBoxPath.Text,CheckBoxSort.Checked,
                               SpinEditChannels.Value,EditExt.Text);
    5: iStream:= TiDBin.Create(ComboBoxPath.Text,CheckBoxSort.Checked,
                               SpinEditChannels.Value,SamplingFreq);
    6: begin       { Modyfikacja 1997 09 20 PEGASUS }
         iStream:= TiPegasus.Create(ComboBoxPath.Text,CheckBoxSort.Checked,
                               SpinEditChannels.Value);
         if (iStream as TiPegasus).PegasusOk then
           begin
            SetFreq((iStream as TiPegasus).GetSamplingFreq);
            SpinEditChannels.Value:=iStream.iChannels;
           end;
       end;
       {1998 09 01 }
    7: iStream:=TiFloatBin.Create(ComboBoxPath.Text,CheckBoxSort.Checked,
                                  SpinEditChannels.Value);
   end;

   Useful:=(iStream<>nil) and iStream.Useful;
   if Useful then
    begin
    if not (RadioGroupFormat.ItemIndex in [5,6]) then
     begin { Dla PEGASUSA nie w tym miejscu }
       Val(CalibConstEdit.Text,iStream.iCalibConst,code);
       if code<>0 then    { Modyfikacja 1997 07 21 }
        begin
         CalibConstEdit.Text:='7.0';
         iStream.iCalibConst:=7.0;
        end;
     end;

     Mont:=TMontage.Assign(MainForm.Mont);
     Useful:=Mont<>nil;
     if Useful then
      begin
       Tags:=TTag.Create(MainForm.TagHDR,SpinEditChannels.Value);
       Useful:=(Tags<>nil) and Tags.Useful
      end
    end
  end;

if iStream<>nil then   { 1998 01 14 Poprawka }
   iStream.FilePath:='';

 if not Useful then
  begin
    iStream.Free;
    Mont.Free;
    Tags.Free;
    OK:=false;
    ModalResult:=mrNone;
  end
else        { Ustawianie oznaczen kanalow 1997 09 28 }
  begin
    iStream.FilePath:=ComboBoxPath.Text;
    case RadioGroupFormat.ItemIndex of
      6: if PegasusTailDlg.LoadHeader(ComboBoxPath.Text) then
           begin
             for i:=1 to iStream.iChannels do
               Mont.Labl[i]:=TrimStr(ExtHeaderDlg.ChnLabels[i]);
              { Kalibracja 1997 10 14 }
             iStream.iCalibConst:=PegasusTailDlg.GetCalibration;
             str(iStream.iCalibConst:2:2,napis);
             CalibConstEdit.Text:=napis;

             if ViewHeaderBox.Checked then {1997 09 26 }
               PegasusTailDlg.Show;
           end;

     5: begin
         if ReadHeader.LoadHeader(ComboBoxPath.Text,
                                   ViewHeaderBox.Checked) then
           begin
             iStream.iCalibConst:=ReadHeader.CalibConst;
             str(iStream.iCalibConst:2:2,napis);
             CalibConstEdit.Text:=napis;

             for i:=1 to iStream.iChannels do
               Mont.Labl[i]:=TrimStr(ExtHeaderDlg.ChnLabels[i]);
             if ViewHeaderBox.Checked then
              ReadHeader.Show;
           end;
        end;
     end;
     iStream.SampFreq:=0.1*SamplingFreq;
   end;
end;
                                                                 { LoadOptions }
procedure TFormatDialog.LoadOptions(const FileName: string);
 var C:       TCursor;
     IniFile: TIniFile;
begin
 if FileName<>'' then
  begin
   C:=SetCursor(crHourglass);
   try IniFile:=TIniFile.Create(FileName);
    with IniFile do
     try
      with RadioGroupFormat do
       ItemIndex:=IntInRange(ReadInteger(InputDataSec,FormatID,ItemIndex),
                             0,MaxFormat);
      with SpinEditBits do
       Value:=IntInRange(ReadInteger(InputDataSec,ADConverterBitsID,Value),
                         MinValue,MaxValue);
      SamplingFreq:=ReadInteger(InputDataSec,SamplingFrequencyID,SamplingFreq);
      with SpinEditChannels do
       Value:=IntInRange(ReadInteger(InputDataSec,NoOfChannelsID,Value),
                         MinValue,MaxValue);
      with EditExt do
       Text:=ReadString(InputDataSec,CounterFileExtID,Text);
       { Modyfikacja 1997 07 21 }
      with CalibConstEdit do
        Text:=ReadString(InputDataSec,CalibrationConstID,Text);

      with CheckBoxSort do
       Checked:=ReadBool(InputDataSec,SortByNumberID,Checked);
      with CheckBoxDefault do
       Checked:=ReadBool(InputDataSec,DefaultID,Checked)
     finally IniFile.Free
     end
   finally SetCursor(C)
   end
  end
end;
                                                                 { SaveOptions }
procedure TFormatDialog.SaveOptions(const FileName: string);
 var C:       TCursor;
     IniFile: TIniFile;
begin
 if FileName<>'' then
  begin
   C:=SetCursor(crHourglass);
   try IniFile:=TIniFile.Create(FileName);
    with IniFile do
     try
      WriteInteger(InputDataSec,FormatID,RadioGroupFormat.ItemIndex);
      WriteInteger(InputDataSec,ADConverterBitsID,SpinEditBits.Value);
      WriteString(InputDataSec,SamplingFrequencyID,MaskEditFreq.Text);
      { Modyfikacja 1997 07 21 }
      WriteString(InputDataSec,CalibrationConstID,CalibConstEdit.Text);
      WriteInteger(InputDataSec,NoOfChannelsID,SpinEditChannels.Value);
      WriteString(InputDataSec,CounterFileExtID,EditExt.Text);
      WriteBool(InputDataSec,SortByNumberID,CheckBoxSort.Checked);
      WriteBool(InputDataSec,DefaultID,CheckBoxDefault.Checked)
     finally IniFile.Free
     end
   finally SetCursor(C)
   end
  end
end;
                                                                     { SetFreq }
procedure TFormatDialog.SetFreq(Value: Word);
begin
 FFreq:=IntInRange(Value,1,9999); MaskEditFreq.Text:=SN(FFreq,-4)
end;
                                                                   { SetFormat }
procedure TFormatDialog.SetFormat;
begin
 case RadioGroupFormat.ItemIndex of
  4:   begin
        LabelFreq.Enabled:=true;
        LabelChannels.Enabled:=false;
        Label1.Enabled:=true;
        CalibConstEdit.Enabled:=true;
        LabelExt.Show
       end;
  5:  begin
        LabelFreq.Enabled:=false;
        LabelChannels.Enabled:=false;
        Label1.Enabled:=false;
        CalibConstEdit.Enabled:=false;
        LabelExt.Hide
       end;
  6: begin                          { PEGASUS }
        LabelFreq.Enabled:=false;
        LabelChannels.Enabled:=false;
        Label1.Enabled:=false;
        CalibConstEdit.Enabled:=false;
        LabelExt.Hide;
     end;
  else begin
        LabelFreq.Enabled:=true;
        LabelChannels.Enabled:=true;
        Label1.Enabled:=true;
        CalibConstEdit.Enabled:=true;
        LabelExt.Hide
       end
 end;
 MaskEditFreq.Enabled:=LabelFreq.Enabled;
 SpinEditChannels.Enabled:=LabelChannels.Enabled;
 if LabelExt.Visible then EditExt.Show else EditExt.Hide;
 with ComboBoxPath do
  Text:=ANSILowerCase(ExtractFilePath(Text)+
                      '*.'+DatExt[RadioGroupFormat.ItemIndex])
end;
                                                                    { Validate }
function TFormatDialog.Validate: Boolean;
 var FileName: string;
begin
 FileName:=ComboBoxPath.Text; Result:=FindFile(FileName,false);
 if Result then
  case RadioGroupFormat.ItemIndex of
   4: begin
       Result:=ReadHDR(ChangeFileExt(FileName,'.'+EditExt.Text),
                       CBinHDR,SizeOf(CBinHDR),false);
       if Result then with SpinEditChannels do
        Value:=IntInRange(CBinHDR.Channels,MinValue,MaxValue)
      end;
   5: begin
       Result:=ValidateDBinHDR(FileName,false);
       if Result then with DBinHDR do
        begin
         with SpinEditChannels do
          Value:=IntInRange(Channels,MinValue,MaxValue);
         SamplingFreq:=SampFrq*10
        end
      end;
  end;
 if not Result and ComboBoxPath.Enabled then ActiveControl:=ComboBoxPath
end;
                                                           { CheckSamplingFreq }
function TFormatDialog.CheckSamplingFreq: Boolean;
 var L: LongInt;
     S: string;
     F: Integer;
begin
 F:=SamplingFreq;
 Result:=SetIntegerValue(SamplingFreqTxt,MaskEditFreq.Text,F,false);
 if Result then
  begin
   SamplingFreq:=F;
   L:=LongInt(SamplingFreq)*MainForm.TagHDR.SecPerPage;
   Result:=L mod 10 = 0;
   if not Result then S:=MustBeIntegerTxt
   else
    begin
     Result:=L div 10 <= MaxSampsPerPage;
     if not Result then S:=MustNotExceedTxt+SN(MaxSampsPerPage,0)+'.'
    end;
   if not Result then
    MessageDlg(ConflictSecTxt+CRLF+
               ResultingSPPTxt+S+CRLF+CRLF+
               ConflictHint1Txt+CRLF+ConflictHint2Txt,mtError,[mbOK],0)
   else
    begin
     Result:=(L div 10) mod MainForm.TagHDR.BlkPerPage = 0;
     if not Result then
      MessageDlg(ConflictBlk1Txt+CRLF+ConflictBlk2Txt+CRLF+
                 ResultingSPBTxt+MustBeIntegerTxt+CRLF+CRLF+
                 ConflictHint1Txt+CRLF+ConflictHint3Txt,mtError,[mbOK],0)
     end
  end;
 if not Result and MaskEditFreq.Enabled then ActiveControl:=MaskEditFreq
end;
                                                           { PrepareOpenDialog }
procedure TFormatDialog.PrepareOpenDialog;
begin
 with MainForm.OpenDialog do
  begin
   DefaultExt:=DatExt[RadioGroupFormat.ItemIndex];
   Filter:=DatFilter[RadioGroupFormat.ItemIndex]+AllFilter;
   Options:=[ofReadOnly,{ofNoChangeDir,}ofNoValidate,ofPathMustExist];
   Title:=DatTitle;
   HistoryList.Assign(ComboBoxPath.Items);
   FileName:=ANSILowerCase(ExtractFileName(ComboBoxPath.Text));
   InitialDir:=ExtractFilePath(ExpandFileName(ComboBoxPath.Text))
  end
end;
                                                                     { Execute }
function TFormatDialog.Execute: Boolean;
 var FormatIndex: Integer;
     Bits:        Byte;
     Freq:        Word;
     Channels:    Byte;
     Path:        string;
     Ext:         string[3];
     Sort:        Boolean;
     Default:     Boolean;
     P:           string;
begin
 Result:=false;
 if OK then               { Modyfikacja 1997 09 20 }
   begin
     iStream.Free;
     Mont.Free;
     Tags.Free;
   end;
 FormatIndex:=RadioGroupFormat.ItemIndex;
 Bits:=SpinEditBits.Value;
 Freq:=SamplingFreq;
 Channels:=SpinEditChannels.Value;
 Path:=ComboBoxPath.Text;
 Ext:=EditExt.Text;
 Sort:=CheckBoxSort.Checked;
 Default:=CheckBoxDefault.Checked;
 SetFormat; ActiveControl:=ComboBoxPath;
 try Result:=ShowModal=mrOK;
 finally
  if Result then
   begin
    ComboBoxPath.Text:=ExpandFileName(ComboBoxPath.Text);
    P:=ComboBoxPath.Text;
    UpdateHistory(ComboBoxPath.Text,ComboBoxPath.Items,ecLowerCase);
    SaveHistory(MainIniFileName,HstDatSec,ComboBoxPath.Items);
    if CheckBoxDefault.Checked then SaveOptions(MainIniFileName);
    ComboBoxPath.Text:=P
   end
  else
   begin
    RadioGroupFormat.ItemIndex:=FormatIndex;
    SpinEditBits.Value:=Bits;
    SamplingFreq:=Freq;
    SpinEditChannels.Value:=Channels;
    ComboBoxPath.Text:=Path;
    EditExt.Text:=Ext;
    CheckBoxSort.Checked:=Sort;
    CheckBoxDefault.Checked:=Default
   end
 end
end;

end. { DDVFRMT }
