unit  DDVMAIN;

interface

uses  WinTypes, WinProcs, SysUtils, Classes,  Graphics, Forms,    Controls,
      StdCtrls, ExtCtrls, Menus,    Buttons,  Dialogs,  IniFiles, Tabs,
      FIRST,    DDVINI,   DDVINSTR, DDVTAGS, ZOOM, CHNFFT, HREAD, PEGDLG,
      FILTFFT,USERFILT,PATIENT,Printers;

type  TTagBtn   = class(TSpeedButton)
                  private
                  public
                   constructor Create(ATag: Char; const AHint: string;
                                      var ALeft: Integer; AInc: Integer;
                                      ADown: Boolean);
                  end;

      TMainForm = class(TForm)
                   MainMenu:                        TMainMenu;
                       MenuFile:                    TMenuItem;
                           FileOpenData:            TMenuItem;
                           FileCloseData:           TMenuItem;
                           FileN1:                  TMenuItem;
                           FileOpenTag:             TMenuItem;
                           FileSaveTag:             TMenuItem;
                           FileSaveTagAs:           TMenuItem;
                           FileCloseTag:            TMenuItem;
                           FileN2:                  TMenuItem;
                           FilePrinter:             TMenuItem;
                           FilePrint:               TMenuItem;
                           FileExit:                TMenuItem;
                       MenuTag:                     TMenuItem;
                           TagCopy:                 TMenuItem;
                           TagN1:                   TMenuItem;
                           TagDelete:               TMenuItem;
                       MenuSearch:                  TMenuItem;
                           SearchGoToPage:          TMenuItem;
                           SearchHome:              TMenuItem;
                           SearchEnd:               TMenuItem;
                           SearchPgUp:              TMenuItem;
                           SearchPgDn:              TMenuItem;
                       MenuView:                    TMenuItem;
                           ViewScaledH:             TMenuItem;
                           ViewScaledV:             TMenuItem;
                           ViewN1:                  TMenuItem;
                           ViewExpand:              TMenuItem;
                           ViewTighten:             TMenuItem;
                           ViewDefault:             TMenuItem;
                           ViewN2:                  TMenuItem;
                           ViewLabels:              TMenuItem;
                           ViewAxes:                TMenuItem;
                           ViewTime:                TMenuItem;
                           ViewCursor:              TMenuItem;
                           ViewN3:                  TMenuItem;
                           ViewSpeedbar:            TMenuItem;
                           ViewStatus:              TMenuItem;
                       MenuOptions:                 TMenuItem;
                           OptionsMontage:          TMenuItem;
                           OptionsTags:             TMenuItem;
                       MenuWindow:                  TMenuItem;
                           WindowArrange:           TMenuItem;
                           WindowTailV:             TMenuItem;
                           WindowTailH:             TMenuItem;
                           WindowCascade:           TMenuItem;
                       MenuHelp:                    TMenuItem;
                           HelpAbout:               TMenuItem;
                   PanelSpeed:                      TPanel;
                        SpeedCom:                   TPanel;
                             ComOpen:               TSpeedButton;
                             ComChild:              TPanel;
                                ComClose:           TSpeedButton;
                                ComSaveTag:         TSpeedButton;
                                ComOpenTag:         TSpeedButton;
                                ComCloseTag:        TSpeedButton;
                        SpeedPag:                   TPanel;
                             PagLeft:               TPanel;
                                TagLeft:            TSpeedButton;
                             PagTag:                TPanel;
                             PagRight:              TPanel;
                                RightTag:           TPanel;
                                     TagRight:      TSpeedButton;
                                Right1:             TPanel;
                                RightWaveShift:     TPanel;
                                Right2:             TPanel;
                                RightPagToggle:     TPanel;
                                Right3:             TPanel;
                                    ModeScaleH:     TSpeedButton;
                                    ModeScaleV:     TSpeedButton;
                                    ModeDefault:    TSpeedButton;
                                    ModeExpand:     TSpeedButton;
                                    ModeTighten:    TSpeedButton;
                        SpeedBottom:                TPanel;
                             BottomScroll:          TPanel;
                             BottomTab:             TPanel;
                                   TabSet:          TTabSet;
                   PanelStatus:                     TPanel;
                        StatusHint:                 TPanel;
                        StatusPag:                  TPanel;
                              PagTagName:           TPanel;
                                 LabelModified:     TLabel;
                              PagSel:               TPanel;
                                 LabelTagSel:       TLabel;
                                 LabelTagSelNo:     TLabel;
                                 LabelPageSel:      TLabel;
                                 LabelPageSelNo:    TLabel;
                                 LabelBlockSel:     TLabel;
                                 LabelBlockSelNo:   TLabel;
                                 LabelChannelSel:   TLabel;
                                 LabelChannelSelNo: TLabel;
                                 LabelSampleSel:    TLabel;
                                 LabelSampleSelNo:  TLabel;
                              PagCoord:             TPanel;
                                 LabelSample:       TLabel;
                                 LabelSampleNo:     TLabel;
                                 LabelChannel:      TLabel;
                                 LabelChannelNo:    TLabel;
                                 LabelBlock:        TLabel;
                                 LabelBlockNo:      TLabel;
                                 LabelPage:         TLabel;
                                 LabelPageNo:       TLabel;
                              PagTime:              TPanel;
                                 LabelTime:         TLabel;
                   OpenDialog:                      TOpenDialog;
                   SaveDialog:                      TSaveDialog;
                   PrinterDialog:                   TPrinterSetupDialog;
                   PrintDialog:                     TPrintDialog;
{ Modyfikacja }
    OpenWzrFile: TMenuItem;
    SaveWZRFile: TMenuItem;
    N1: TMenuItem;
    SleepLabel: TLabel;
    SleepPanel: TPanel;
    Tools1: TMenuItem;
    FFT1: TMenuItem;
    HipnoImage: TImage;
    HipnoPanel: TPanel;
    HipnoLabel: TLabel;
    FFTSpeedButton: TSpeedButton;
    ZoomWindow1: TMenuItem;
    SeleckZoom1: TMenuItem;
    SpeedZoom: TSpeedButton;
    ChannelFFT1: TMenuItem;
    SpeedChnFFT: TSpeedButton;
    OldMode: TMenuItem;
    N2: TMenuItem;
    AmplitudeBar1: TMenuItem;
    Show1SecondBar1: TMenuItem;
    Reverse1: TMenuItem;
    Info1: TMenuItem;
    ReadHeader1: TMenuItem;
    N3: TMenuItem;
    OpenReadHeaderDialog: TOpenDialog;
    SetSignalColorDialog: TColorDialog;
    SignalColors1: TMenuItem;
    PegasOpenDialog: TOpenDialog;
    ReadPEGAUSTail1: TMenuItem;
    N4: TMenuItem;
    ViewHeaderInfo: TMenuItem;
    SetCalibration1: TMenuItem;
    SaveTag: TMenuItem;
    Synchronize1: TMenuItem;
    SynchroLock1: TMenuItem;
    FilterMenu: TMenuItem;
    UserDefined1: TMenuItem;
    N105165Hz1: TMenuItem;
    N70110Hz1: TMenuItem;
    N5: TMenuItem;
    N07540Hz1: TMenuItem;
    FilterSpeedButton: TSpeedButton;
    GoToBadPage1: TMenuItem;
    GoToNextBadPage1: TMenuItem;
    SaveToBmpDialog: TSaveDialog;
    PrintToBMP1: TMenuItem;
    PatientID1: TMenuItem;
    PrinterFontDialog: TFontDialog;
    PrinterFonts1: TMenuItem;

                   procedure FormCreate(Sender: TObject);
                   procedure FormDestroy(Sender: TObject);
                   procedure FormResize(Sender: TObject);

                   procedure FileOpenDataClick(Sender: TObject);
                   procedure FileCloseDataClick(Sender: TObject);
                   procedure FileOpenTagClick(Sender: TObject);
                   procedure FileSaveTagClick(Sender: TObject);
                   procedure FileSaveTagAsClick(Sender: TObject);
                   procedure FileCloseTagClick(Sender: TObject);
                   procedure FilePrinterClick(Sender: TObject);
                   procedure FilePrintClick(Sender: TObject);
                   procedure FileExitClick(Sender: TObject);

                   procedure TagCopyClick(Sender: TObject);
                   procedure TagDeleteClick(Sender: TObject);

                   procedure SearchGoToPageClick(Sender: TObject);

                   procedure SearchHomeClick(Sender: TObject);
                   procedure SearchEndClick(Sender: TObject);
                   procedure SearchPgUpClick(Sender: TObject);
                   procedure SearchPgDnClick(Sender: TObject);
                   procedure SearchCtrlLeftClick(Sender: TObject);
                   procedure SearchCtrlRightClick(Sender: TObject);

                   procedure ViewScaledHClick(Sender: TObject);
                   procedure ViewScaledVClick(Sender: TObject);
                   procedure ViewExpandClick(Sender: TObject);
                   procedure ViewTightenClick(Sender: TObject);
                   procedure ViewDefaultClick(Sender: TObject);
                   procedure ViewLabelsClick(Sender: TObject);
                   procedure ViewAxesClick(Sender: TObject);
                   procedure ViewTimeClick(Sender: TObject);
                   procedure ViewCursorClick(Sender: TObject);
                   procedure ViewSpeedbarClick(Sender: TObject);
                   procedure ViewStatusClick(Sender: TObject);

                   procedure OptionsMontageClick(Sender: TObject);
                   procedure OptionsTagsClick(Sender: TObject);

                   procedure WindowCascadeClick(Sender: TObject);
                   procedure WindowTailHClick(Sender: TObject);
                   procedure WindowTailVClick(Sender: TObject);
                   procedure WindowArrangeClick(Sender: TObject);

                   procedure HelpAboutClick(Sender: TObject);

                   procedure TabSetClick(Sender: TObject);

                   procedure TagLeftClick(Sender: TObject);
                   procedure TagRightClick(Sender: TObject);

                   procedure ScrollBarScroll(Sender: TObject;
                                             ScrollCode: TScrollCode;
                                             var ScrollPos: Integer);
       { Otwarcie Wzr'a }
    procedure OpenWzrFileClick(Sender: TObject);
    procedure SaveWZRFileClick(Sender: TObject);
    procedure FFT1Click(Sender: TObject);
    procedure HipnoImageMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure HipnoImageMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure ZoomWindow1Click(Sender: TObject);
    procedure FixedZoomClick(Sender: TObject);
    procedure ChnFFTOnClick(Sender: TObject);
    procedure OldModeClick(Sender: TObject);
    procedure AmplitudeBarClick(Sender: TObject);
    procedure OneSekBar(Sender: TObject);
    procedure ReverseSignalClick(Sender: TObject);
    procedure Info1Click(Sender: TObject);
    procedure ReadHeader1Click(Sender: TObject);
    procedure SignalColors1Click(Sender: TObject);
    procedure ReadPEGAUSTail1Click(Sender: TObject);
    procedure ViewHeaderInfoClick(Sender: TObject);
    procedure SetCalibration1Click(Sender: TObject);
    procedure SaveTagClick(Sender: TObject);
    procedure SynchronizeClick(Sender: TObject);
    procedure SynchroLock1Click(Sender: TObject);
    procedure N105165Hz1Click(Sender: TObject);
    procedure N70110Hz1Click(Sender: TObject);
    procedure N07540Hz1Click(Sender: TObject);
    procedure UserDefined1Click(Sender: TObject);
    procedure FilterSpeedButtonClick(Sender: TObject);
    procedure GoToBadPage1Click(Sender: TObject);
    procedure GoToNextBadPage1Click(Sender: TObject);
    procedure PrintToBMP1Click(Sender: TObject);
    procedure PatientID1Click(Sender: TObject);
    procedure PrinterFonts1Click(Sender: TObject);

                  private { Private declarations }
                   procedure ApplicationHint(Sender: TObject);
                   procedure ScreenActFormChange(Sender: TObject);
                   function  CheckMDI: Boolean;
                   function  CheckMenuItem(MenuItem: TMenuItem): Boolean;
                   procedure TagBtnClick(Sender: TObject);
                  public  { Public declarations }
                   TagHDR: TTagHDR;
                   Mont:   TMontage;
                   OldModeStat,AmpliBarStat,
                   OneSekBarStat,Reverse,SynchroStatus : boolean;

                   function  MinSpeedComWidth: Integer;
                   procedure Synchronize;
                   procedure SetFilterMenus(FilterNumber : integer);
                  end;

var   MainForm:   TMainForm;

implementation

uses  DDVABOUT, DDVMNTG,  DDVTAGLI, DDVFRMT,  DDVCHILD;

{$R *.DFM}

                                                              { TTagBtn.Create }
constructor TTagBtn.Create(ATag: Char; const AHint: string;
                           var ALeft: Integer; AInc: Integer; ADown: Boolean);
begin
 inherited Create(MainForm);
 AllowAllUp:=true; GroupIndex:=1; Down:=ADown;

 Layout:=blGlyphLeft; Margin:=-1; Spacing:=-1;

 Width:=Succ(AInc); Height:=Width; Left:=ALeft; Top:=1; Inc(ALeft,AInc);
 Visible:=(Left>0) and (ALeft<Pred(MainForm.PagTag.Width));
 SetFont(Font,'MS Sans Serif',12,[fsBold],TagBtnColor);
 Caption:=ATag; Hint:=AHint; Name:='TagBtn'+ATag;

 Parent:=MainForm.PagTag;

 OnClick:=MainForm.TagBtnClick
end;

                                                             { ApplicationHint }
procedure TMainForm.ApplicationHint(Sender: TObject);
begin
 StatusHint.Caption:=Application.Hint
end;

                                                         { ScreenActFormChange }
procedure TMainForm.ScreenActFormChange(Sender: TObject);
 var MDIAct: Boolean;
begin
 MDIAct:=MDIChildCount>0;
 MenuTag.Visible:=MDIAct;       MenuSearch.Visible:=MDIAct;
 MenuView.Visible:=MDIAct;      MenuWindow.Visible:=MDIAct;
 FileCloseData.Visible:=MDIAct; FileN1.Visible:=MDIAct;
 FileOpenTag.Visible:=MDIAct;   FileSaveTag.Visible:=MDIAct;
 FileSaveTagAs.Visible:=MDIAct; FileCloseTag.Visible:=MDIAct;
 FilePrint.Visible:=MDIAct;     ComChild.Visible:=MDIAct;
 { Modyfikacja: Obsluga WZR'a 1997 06 19 }
 OpenWzrFile.Visible:=MDIAct;
 SaveWzrFile.Visible:=MDIAct;
 { Modyfikacja: wyswietalnie stadia snu 1997 06 29 }
 SleepLabel.Visible:=MDIAct;
 SleepPanel.Visible:=MDIAct;
 { Modyfikacja 1997 07 13 }
 Tools1.Visible:=MDIAct;
 { 1997 07 18 }
 HipnoPanel.Visible:=MDIAct;
 FFTSpeedButton.Visible:=MDIAct;
 SpeedZoom.Visible:=MDIAct;
 SpeedChnFFT.Visible:=MDIAct;
 SignalColors1.Enabled:=MDIAct; { 1997 09 11 }
 N1.Visible:=MDIAct;
 ViewHeaderInfo.Visible:=MDIAct;
 SetCalibration1.Visible:=MDIAct; { 1997 09 18 }
 FilterMenu.Visible:=MDIAct;      { 1998 01 21 }
 FilterSpeedButton.Visible:=MDIAct;
 PrintToBmp1.Visible:=MDIAct;

 if MDIAct then with ActiveMDIChild as TChildForm do
  begin
   ViewScaledH.Checked:=ScaledHFlag;   ViewScaledV.Checked:=ScaledVFlag;
   ViewLabels.Checked:=LabelsFlag;     ViewAxes.Checked:=AxesFlag;
   ViewTime.Checked:=TimeFlag;         ViewCursor.Checked:=CursorFlag;
   ViewSpeedbar.Checked:=SpeedbarFlag; ViewStatus.Checked:=StatusFlag;
   TagDelete.Enabled:=TagDeleteFlag;
   SetControls;
   SpeedBottom.Show; SpeedPag.Show; SetPanelSpeed;
   StatusPag.Show; SetPanelStatus
  end
 else
  begin
   SpeedPag.Hide; SpeedBottom.Hide; PanelSpeed.Show;
   StatusPag.Hide; PanelStatus.Show
  end
end;

                                                                  { FormCreate }
procedure TMainForm.FormCreate(Sender: TObject);
 var IniFile:     TIniFile;
     Color,
     Path:        string;
     SecPerPage,
     BlkPerPage:  Word;
begin
 Application.OnHint:=ApplicationHint;
 Application.ShowHint:=true;
 Application.HintColor:=clYellow;
 Application.HintPause:=500;
 TileMode:=tbHorizontal; { Modyfikacja 1996 06 22 }
 Screen.OnActiveFormChange:=ScreenActFormChange;
 AmpliBarStat:=true;
 OneSekBarStat:=true;
 SpeedChnFFT.Enabled:=false;
 FFTSpeedButton.Enabled:=false;
 FFT1.Enabled:=false;
 SaveTag.Enabled:=false;
 ChannelFFT1.Enabled:=false;
 SeleckZoom1.Enabled:=false;
 Reverse:=false;
 SynchroStatus:=false;
 PrintToBMP1.Enabled:=false;
 FilePrint.Enabled:=false;

 Path:=''; SecPerPage:=20; BlkPerPage:=8;
 IniFile:=TIniFile.Create(MainIniFileName);
 try
  Path:=IniFile.ReadString(TagSec,TagPathID,Path); CutStr(Path);
  SecPerPage:=IntInRange(IniFile.ReadInteger(TagSec,SecPerPageID,SecPerPage),
                         1,MaxSecPP);
  BlkPerPage:=IntInRange(IniFile.ReadInteger(TagSec,BlkPerPageID,BlkPerPage),
                         1,MaxBlkPP);
  PanelLabWidth:=IntInRange(IniFile.ReadInteger(LabelsSec,LabelsWidthID,
                                                PanelLabWidth),
                            0,100);
  PanelLabFontSize:=IntInRange(IniFile.ReadInteger(LabelsSec,LabelsFontSizeID,
                                                   PanelLabFontSize),
                               4,12);
  Color:=IniFile.ReadString(ColorsSec,GridEvenID,SetColor(GridColors[false]));
  GridColors[false]:=GetColor(Color);
  Color:=IniFile.ReadString(ColorsSec,GridOddID,SetColor(GridColors[true]));
  GridColors[true]:=GetColor(Color);
  Color:=IniFile.ReadString(ColorsSec,TagBtnID,SetColor(TagBtnColor));
  TagBtnColor:=GetColor(Color);
  Color:=IniFile.ReadString(ColorsSec,HighlightID,SetColor(HighlightColor));
  HighlightColor:=GetColor(Color);
  Color:=IniFile.ReadString(ColorsSec,LabID,SetColor(LabelColor));
  LabelColor:=GetColor(Color);
  Color:=IniFile.ReadString(ColorsSec,GridFldID,SetColor(GridFldColor));
  GridFldColor:=GetColor(Color)
 finally IniFile.Free
 end;

 TagHDR:=TTagHDR.Create(Path,SecPerPage,BlkPerPage);
 Mont:=TMontage.Create; Mont.LoadOptions(MainIniFileName);

 {ScrollBar.Align:=alClient;}
 TabSet.Font.Color:=TagBtnColor; StatusPag.Font.Color:=LabelColor;
 OldModeStat:=true;
end;
                                                                 { FormDestroy }
procedure TMainForm.FormDestroy(Sender: TObject);
 var IniFile: TIniFile;
begin
 IniFile:=TIniFile.Create(MainIniFileName);
 try
  if TagHDR<>nil then
   begin
    IniFile.WriteString(TagSec,TagPathID,TagHDR.Path);
    IniFile.WriteInteger(TagSec,SecPerPageID,TagHDR.SecPerPage);
    IniFile.WriteInteger(TagSec,BlkPerPageID,TagHDR.BlkPerPage);
   end;
  IniFile.WriteInteger(LabelsSec,LabelsWidthID,PanelLabWidth);
  IniFile.WriteInteger(LabelsSec,LabelsFontSizeID,PanelLabFontSize);
  IniFile.WriteString(ColorsSec,GridEvenID,SetColor(GridColors[false]));
  IniFile.WriteString(ColorsSec,GridOddID,SetColor(GridColors[true]));
  IniFile.WriteString(ColorsSec,TagBtnID,SetColor(TagBtnColor));
  IniFile.WriteString(ColorsSec,HighlightID,SetColor(HighlightColor));
  IniFile.WriteString(ColorsSec,LabID,SetColor(LabelColor));
  IniFile.WriteString(ColorsSec,GridFldID,SetColor(GridFldColor))
 finally IniFile.Free
 end;

 Mont.Free; TagHDR.Free;

 Screen.OnActiveFormChange:=nil
end;
                                                                  { FormResize }
procedure TMainForm.FormResize(Sender: TObject);
 var MinW: Integer;
begin
 MinW:=MinSpeedComWidth+PagLeft.Width+PagTag.Height+PagRight.Width;
 if ClientWidth<MinW then ClientWidth:=MinW;
 if ClientHeight<PanelSpeed.Height+PanelStatus.Height then
  ClientHeight:=PanelSpeed.Height+PanelStatus.Height;
 TabSetClick(Self)
end;

procedure TMainForm.FileOpenDataClick(Sender: TObject);
 var
   ChildForm: TChildForm;

begin
 if FormatDialog.Execute then
  begin
   {~~~ChildForm:=TChildForm.Create(Self);}
   Application.CreateForm(TChildForm,ChildForm);
   if not ChildForm.FormInitialize then
     ChildForm.Close;
   tile;  { Modyfikacja 1997 06 22 Po otwarciu pliku porzadkujemy }
  end
end;

procedure TMainForm.FileCloseDataClick(Sender: TObject);
begin
 if CheckMDI then (ActiveMDIChild as TChildForm).Close
end;
                                                                    { File-Tag }
procedure TMainForm.FileOpenTagClick(Sender: TObject);
begin
 if CheckMDI then (ActiveMDIChild as TChildForm).OpenTag
end;

procedure TMainForm.FileSaveTagClick(Sender: TObject);
begin
 if CheckMDI then (ActiveMDIChild as TChildForm).SaveTag(true)
end;

procedure TMainForm.FileSaveTagAsClick(Sender: TObject);
begin
 if CheckMDI then (ActiveMDIChild as TChildForm).SaveTag(false)
end;

procedure TMainForm.FileCloseTagClick(Sender: TObject);
begin
 if CheckMDI then (ActiveMDIChild as TChildForm).CloseTag
end;
                                                                  { File-Print }
procedure TMainForm.FilePrinterClick(Sender: TObject);
begin
 ClearHint; PrinterDialog.Execute
end;

procedure TMainForm.FilePrintClick(Sender: TObject);
begin
 if CheckMDI and PrintDialog.Execute then
   (ActiveMDIChild as TChildForm).Print(true,'');
end;
                                                                   { File-Exit }
procedure TMainForm.FileExitClick(Sender: TObject);
begin
 ClearHint; Close
end;

                                                                    { Tag-Copy }
procedure TMainForm.TagCopyClick(Sender: TObject);
begin
 if CheckMDI then (ActiveMDIChild as TChildForm).ClipboardCopy
end;
                                                                  { Tag-Delete }
procedure TMainForm.TagDeleteClick(Sender: TObject);
begin
 if CheckMDI then (ActiveMDIChild as TChildForm).DeleteTag
end;

                                                             { Search-GoToPage }
procedure TMainForm.SearchGoToPageClick(Sender: TObject);
begin
 if CheckMDI then (ActiveMDIChild as TChildForm).GoToPage
end;

                                                               { Search-Scroll }
procedure TMainForm.SearchHomeClick(Sender: TObject);
 var
    ScrollPos: Integer;
    PageNo   : word;

begin
 if CheckMDI then
  begin
   (ActiveMDIChild as TChildForm).ScrollData(scTop,ScrollPos);
   PageNo:=(ActiveMDIChild as TChildForm).GetCurrentPageNo;
   (ActiveMDIChild as TChildForm).DrawHipnogram(PageNo);
  end
end;

procedure TMainForm.SearchEndClick(Sender: TObject);
 var
   ScrollPos: Integer;
   PageNo   : word;

begin
 if CheckMDI then
  begin
   (ActiveMDIChild as TChildForm).ScrollData(scBottom,ScrollPos);
   PageNo:=(ActiveMDIChild as TChildForm).GetCurrentPageNo;
   (ActiveMDIChild as TChildForm).DrawHipnogram(PageNo);
  end
end;

procedure TMainForm.SearchPgUpClick(Sender: TObject);
 var
   ScrollPos: Integer;
   PageNo   : word;

begin
 if CheckMDI then
  begin
   (ActiveMDIChild as TChildForm).ScrollData(scPageUp,ScrollPos);
   PageNo:=(ActiveMDIChild as TChildForm).GetCurrentPageNo;
   (ActiveMDIChild as TChildForm).DrawHipnogram(PageNo);
  end
end;

procedure TMainForm.SearchPgDnClick(Sender: TObject);
 var
   ScrollPos: Integer;
   PageNo   : word;

begin
 if CheckMDI then
  begin
   (ActiveMDIChild as TChildForm).ScrollData(scPageDown,ScrollPos);
   PageNo:=(ActiveMDIChild as TChildForm).GetCurrentPageNo;
   (ActiveMDIChild as TChildForm).DrawHipnogram(PageNo);
  end
end;

procedure TMainForm.SearchCtrlLeftClick(Sender: TObject);
 var
   ScrollPos: Integer;
   PageNo   : word;

begin
 if CheckMDI then
  begin
   (ActiveMDIChild as TChildForm).ScrollData(scLineUp,ScrollPos);
    PageNo:=(ActiveMDIChild as TChildForm).GetCurrentPageNo;
   (ActiveMDIChild as TChildForm).DrawHipnogram(PageNo);
  end
end;

procedure TMainForm.SearchCtrlRightClick(Sender: TObject);
 var
    ScrollPos: Integer;
    PageNo   : word;

begin
 if CheckMDI then
  begin
   (ActiveMDIChild as TChildForm).ScrollData(scLineDown,ScrollPos);
   PageNo:=(ActiveMDIChild as TChildForm).GetCurrentPageNo;
   (ActiveMDIChild as TChildForm).DrawHipnogram(PageNo);
  end
end;
                                 { Menu-View }
procedure TMainForm.ViewScaledHClick(Sender: TObject);
begin
 if CheckMDI then with ActiveMDIChild as TChildForm do
  begin
    ScaledHFlag:=CheckMenuItem(ViewScaledH);
    SetPageButtons;
    Invalidate;
  end
end;

procedure TMainForm.ViewScaledVClick(Sender: TObject);
begin
 if CheckMDI then
  with ActiveMDIChild as TChildForm do
   begin
    ScaledVFlag:=CheckMenuItem(ViewScaledV);
    SetPageButtons;
    Invalidate;
   end;
end;

procedure TMainForm.ViewExpandClick(Sender: TObject);
begin
 if CheckMDI then (ActiveMDIChild as TChildForm).ShiftDec
end;

procedure TMainForm.ViewTightenClick(Sender: TObject);
begin
 if CheckMDI then (ActiveMDIChild as TChildForm).ShiftInc
end;

procedure TMainForm.ViewDefaultClick(Sender: TObject);
 var S: Byte;
begin
 if CheckMDI then with ActiveMDIChild as TChildForm do
  if ShiftDef then Invalidate
end;

procedure TMainForm.ViewLabelsClick(Sender: TObject);
begin
 if CheckMDI then with ActiveMDIChild as TChildForm do
  begin
   LabelsFlag:=CheckMenuItem(ViewLabels);
   if LabelsFlag then
    begin
     Image.Left:=Image.Left+PanelLabWidth; PanelLab.Width:=PanelLabWidth
    end
   else
    begin
     Image.Left:=Image.Left-PanelLabWidth; PanelLab.Width:=0
    end;
   Invalidate
  end
end;

procedure TMainForm.ViewAxesClick(Sender: TObject);
begin
 if CheckMDI then with ActiveMDIChild as TChildForm do
  begin AxesFlag:=CheckMenuItem(ViewAxes); Invalidate end
end;

procedure TMainForm.ViewTimeClick(Sender: TObject);
begin
 if CheckMDI then with ActiveMDIChild as TChildForm do
  begin TimeFlag:=CheckMenuItem(ViewTime); Invalidate end
end;

procedure TMainForm.ViewCursorClick(Sender: TObject);
begin
 if CheckMDI then with ActiveMDIChild as TChildForm do
  begin
   HighlightOff; CursorFlag:=CheckMenuItem(ViewCursor); HighlightOn
  end
end;

procedure TMainForm.ViewSpeedbarClick(Sender: TObject);
begin
 if CheckMDI then with ActiveMDIChild as TChildForm do
  begin SpeedbarFlag:=CheckMenuItem(ViewSpeedbar); SetPanelSpeed end
end;

procedure TMainForm.ViewStatusClick(Sender: TObject);
begin
 if CheckMDI then with ActiveMDIChild as TChildForm do
  begin StatusFlag:=CheckMenuItem(ViewStatus); SetPanelStatus end
end;

                                                                { Menu-Options }
procedure TMainForm.OptionsMontageClick(Sender: TObject);
begin
 if CheckMDI then (ActiveMDIChild as TChildForm).EditMontage
 else MontageDialog.Execute(Mont)
end;

procedure TMainForm.OptionsTagsClick(Sender: TObject);
begin
 if CheckMDI then (ActiveMDIChild as TChildForm).EditTags
 else TagListDialog.Execute(TagHDR,tkPag,0)
end;

                                                                 { Menu-Window }
procedure TMainForm.WindowCascadeClick(Sender: TObject);
begin
 ClearHint; Cascade
end;

procedure TMainForm.WindowTailHClick(Sender: TObject);
begin
 ClearHint; TileMode:=tbHorizontal; Tile
end;

procedure TMainForm.WindowTailVClick(Sender: TObject);
begin
 ClearHint; TileMode:=tbVertical; Tile
end;

procedure TMainForm.WindowArrangeClick(Sender: TObject);
begin
 ClearHint; ArrangeIcons
end;

                                                               { Help-AboutBox }
procedure TMainForm.HelpAboutClick(Sender: TObject);
begin
 AboutBox.ShowModal
end;

                                                                 { TabSetClick }
procedure TMainForm.TabSetClick(Sender: TObject);
begin
 if CheckMDI then (ActiveMDIChild as TChildForm).SetTagKind
end;

                                                                 { TagBtnClick }
procedure TMainForm.TagBtnClick(Sender: TObject);
begin
 if CheckMDI then with ActiveMDIChild as TChildForm do
  TagBtnClick(StrToChar((Sender as TTagBtn).Caption))
end;

                                                                { TagLeftClick }
procedure TMainForm.TagLeftClick(Sender: TObject);
begin
 if CheckMDI then (ActiveMDIChild as TChildForm).ShiftTagButtonsRight
end;
                                                               { TagRightClick }
procedure TMainForm.TagRightClick(Sender: TObject);
begin
 if CheckMDI then (ActiveMDIChild as TChildForm).ShiftTagButtonsLeft
end;

                                                             { ScrollBarScroll }
procedure TMainForm.ScrollBarScroll(Sender: TObject; ScrollCode: TScrollCode;
                                    var ScrollPos: Integer);
begin
 if CheckMDI then
  (ActiveMDIChild as TChildForm).ScrollData(ScrollCode,ScrollPos)
end;

                                                                    { CheckMDI }
function TMainForm.CheckMDI: Boolean;
begin
 ClearHint; Result:=MDIChildCount>0
end;
                                                               { CheckMenuItem }
function TMainForm.CheckMenuItem(MenuItem: TMenuItem): Boolean;
begin
 with MenuItem do begin Checked:=not Checked; Result:=Checked end
end;
                                                            { MinSpeedComWidth }
function TMainForm.MinSpeedComWidth: Integer;
 var I: Integer;
begin
 Result:=0;
 with SpeedCom do
  for I:=0 to Pred(ControlCount) do with Controls[I] do
   if Succ(Left+Width)>Result then Result:=Succ(Left+Width)
end;

procedure TMainForm.OpenWzrFileClick(Sender: TObject);
begin                  { Otwarcie WZR'a }
   if CheckMDI then
      (ActiveMDIChild as TChildForm).OpenWzr;
end;

procedure TMainForm.SaveWZRFileClick(Sender: TObject);
begin                  { Zapis do WZR'a }
  if CheckMDI then
    (ActiveMDIChild as TChildForm).SaveWzr;
end;

procedure TMainForm.FFT1Click(Sender: TObject);
begin                 { Transformata Fouriera }
  if CheckMDI then
    (ActiveMDIChild as TChildForm).ComputeFFT;
end;

procedure TMainForm.HipnoImageMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
var
  NewPage,maxPage : word;  { Aktywny hipnogram rysowanie + skoki }

begin
   if CheckMDI then
    begin
      maxPage:=(ActiveMDIChild as TChildForm).GetMaxPageNo;
      with HipnoImage do
        NewPage:=round(((maxPage-1)/Width)*X+1.0);
      if NewPage>maxPage then NewPage:=maxPage;
      if NewPage=0 then NewPage:=1;
      (ActiveMDIChild as TChildForm).DrawHipnogram(NewPage);
      (ActiveMDIChild as TChildForm).GoToSelectPage(NewPage);
      Synchronize;
    end;
end;

procedure TMainForm.HipnoImageMouseMove(Sender: TObject;
  Shift: TShiftState; X, Y: Integer);
  var
   Page,maxPage : word;

begin
  if CheckMDI then
    begin
     HipnoPanel.Visible:=true;
     maxPage:=(ActiveMDIChild as TChildForm).GetMaxPageNo;
     with HipnoImage do
       page:=round(((maxPage-1)/Width)*X+1.0);
     if Page>maxPage then Page:=maxPage;
     if Page=0 then Page:=1;
     HipnoLabel.Caption:=(ActiveMDIChild as TChildForm).GetHipnoStadium(page);
   end;
end;

procedure TMainForm.ZoomWindow1Click(Sender: TObject);
begin
 if CheckMDI then
   ZoomForm.Show;
end;

procedure TMainForm.FixedZoomClick(Sender: TObject);
begin
 if CheckMDI then
   begin
     ZoomForm.BlockOn:=true;
     ZoomForm.Show;
     (ActiveMDIChild as TChildForm).LoadFixedSignalToZoom;
   end;
end;

procedure TMainForm.ChnFFTOnClick(Sender: TObject);
begin
   if CheckMDI then
    begin
      ChannelFFT.Show;
      (ActiveMDIChild as TChildForm).ComputeChannelFFT;
    end;
end;

procedure TMainForm.OldModeClick(Sender: TObject);
begin
  OldMode.Checked:=not OldMode.Checked;
  if OldMode.Checked then
    OldModeStat:=true
  else
    OldModeStat:=false;
end;

procedure TMainForm.AmplitudeBarClick(Sender: TObject);
 var
   i : integer;

begin
  if AmpliBarStat then
    AmpliBarStat:=false
  else
    AmpliBarStat:=true;

  AmplitudeBar1.Checked:=AmpliBarStat;
  for I := 0 to MDIChildCount-1 do
   MDIChildren[I].Repaint;
end;

procedure TMainForm.OneSekBar(Sender: TObject);
  var
   i : integer;

begin
  if OneSekBarStat then
    OneSekBarStat:=false
  else
    OneSekBarStat:=true;

  Show1SecondBar1.Checked:=OneSekBarStat;
  for I := 0 to MDIChildCount-1 do
   MDIChildren[I].Repaint;
end;

procedure TMainForm.ReverseSignalClick(Sender: TObject);
 var
   i : integer; { 1997 08 01 }

begin
  if Reverse then
    Reverse:=false
  else
    Reverse:=true;

  Reverse1.Checked:=Reverse;
  for I := 0 to MDIChildCount-1 do
   MDIChildren[I].Repaint;
end;

procedure TMainForm.Info1Click(Sender: TObject);
begin
  Application.HelpFile := 'DDV.HLP';
  Application.HelpCommand(HELP_CONTENTS, 0);
end;

procedure TMainForm.ReadHeader1Click(Sender: TObject);
begin
   if OpenReadHeaderDialog.Execute then
     if ReadHeader.LoadHeader(OpenReadHeaderDialog.FileName,true) then
        ReadHeader.Show;
end;

procedure TMainForm.SignalColors1Click(Sender: TObject);
begin  { Kolorki sygnalu }
   if CheckMDI then
    if SetSignalColorDialog.Execute then
     begin
     (ActiveMDIChild as TChildForm).SetHighlightColor:=
                                    SetSignalColorDialog.Color;
     (ActiveMDIChild as TChildForm).Repaint;
     end;
end;

procedure TMainForm.ReadPEGAUSTail1Click(Sender: TObject);
begin
   if PegasOpenDialog.Execute then
     if PegasusTailDlg.LoadHeader(PegasOpenDialog.FileName) then
       PegasusTailDlg.Show;
end;

procedure TMainForm.ViewHeaderInfoClick(Sender: TObject);
begin
 if CheckMDI then
    (ActiveMDIChild as TChildForm).ViewHeaderInfo;
end;

procedure TMainForm.SetCalibration1Click(Sender: TObject);
begin
  if CheckMDI then      { 1997 09 18 }
    (ActiveMDIChild as TChildForm).Calibration;
end;

procedure TMainForm.SaveTagClick(Sender: TObject);
begin
if CheckMDI then      { 1997 12 10 }
    (ActiveMDIChild as TChildForm).SaveChnToAsciiFile;
end;

procedure TMainForm.Synchronize;
var
  i             : integer;
  NoPageSynchro : word;

begin
  if CheckMDI then { Synchronizacja polozenie we wszystkich oknach 1998 01 18 }
    begin
       NoPageSynchro:=(ActiveMDIChild as TChildForm).GetCurrentPageNo;
       for i:=0 to MDIChildCount-1 do
        if (MDIChildren[I] as TChildForm).GetCurrentPageNo<>NoPageSynchro then
         (MDIChildren[I] as TChildForm).GotoSelectPage(NoPageSynchro);
    end;
end;

procedure TMainForm.SynchronizeClick(Sender: TObject);
begin
  Synchronize;
end;

procedure TMainForm.SynchroLock1Click(Sender: TObject);
begin
  if SynchroStatus then       { Synchronizacja 1998 01 18 }
    SynchroStatus:=false
  else
    SynchroStatus:=true;

  SynchroLock1.Checked:=SynchroStatus;
  if SynchroStatus then
    Synchronize;
end;

procedure TMainForm.N105165Hz1Click(Sender: TObject);
begin
  if CheckMDI then
   begin
    (ActiveMDIChild as TChildForm).SetFilter(10.5,16.5,1.0,1.0,
                                             0.0,Cosinus,1,1);
    SetFilterMenus(1);
   end;
end;

procedure TMainForm.N70110Hz1Click(Sender: TObject);
begin
 if CheckMDI then
   begin
    (ActiveMDIChild as TChildForm).SetFilter(7.0,11.0,1.0,1.0,
                                             0.0,Cosinus,1,2);
     SetFilterMenus(2);
   end;
end;

procedure TMainForm.N07540Hz1Click(Sender: TObject);
begin
  if CheckMDI then
   begin
    (ActiveMDIChild as TChildForm).SetFilter(0.75,4.0,1.0,1.0,
                                              0.0,Cosinus,1,3);
    SetFilterMenus(3);
   end;
end;

procedure TMainForm.SetFilterMenus(FilterNumber : integer);
begin
   if CheckMDI then
     begin
      if (ActiveMDIChild as TChildForm).IsFilterEnabled then
        FilterSpeedButton.Caption:='F'
      else
        FilterSpeedButton.Caption:='NO';
     end;

   case FilterNumber of
        0: begin
            UserDefined1.Checked:=true;
            N105165Hz1.Checked:=false;
            N70110Hz1.Checked:=false;
            N07540Hz1.Checked:=false;
           end;
        1: begin
            UserDefined1.Checked:=false;
            N105165Hz1.Checked:=true;
            N70110Hz1.Checked:=false;
            N07540Hz1.Checked:=false;
           end;
        2: begin
             UserDefined1.Checked:=false;
             N105165Hz1.Checked:=false;
             N70110Hz1.Checked:=true;
             N07540Hz1.Checked:=false;
            end;
        3: begin
             UserDefined1.Checked:=false;
             N105165Hz1.Checked:=false;
             N70110Hz1.Checked:=false;
             N07540Hz1.Checked:=true;
           end;
      end;
end;

procedure TMainForm.UserDefined1Click(Sender: TObject);
begin
if CheckMDI then
   begin
     if UserFilterDlg.Execute then
      with UserFilterDlg.FilterParam do
        begin
         (ActiveMDIChild as TChildForm).SetFilter(RawFreqMin,
                                        RawFreqMax,RawFreqDysp,Gain,
                                        RawFreqAverg,
                                        FilterType,
                                        FilterStatus,0);
          SetFilterMenus(0);
       end;
   end;
end;

procedure TMainForm.FilterSpeedButtonClick(Sender: TObject);
begin
  if CheckMDI then
   begin
     if not (ActiveMDIChild as TChildForm).IsFilterEnabled then
        begin
          FilterSpeedButton.Caption:='F';
          (ActiveMDIChild as TChildForm).SetFilterEnabled(true);
        end
      else
        begin
          FilterSpeedButton.Caption:='NO';
          (ActiveMDIChild as TChildForm).SetFilterEnabled(false);
        end;
      (ActiveMDIChild as TChildForm).ReLoad;
   end;
end;

procedure TMainForm.GoToBadPage1Click(Sender: TObject);
begin
 if CheckMDI then (ActiveMDIChild as TChildForm).GoToBadPage(false);
end;

procedure TMainForm.GoToNextBadPage1Click(Sender: TObject);
begin
 if CheckMDI then (ActiveMDIChild as TChildForm).GoToBadPage(true);
end;

procedure TMainForm.PrintToBMP1Click(Sender: TObject);
begin { 1998 08 23 }
  if CheckMDI and SaveToBmpDialog.Execute then
   (ActiveMDIChild as TChildForm).Print(false,SaveToBmpDialog.FileName);
end;

procedure TMainForm.PatientID1Click(Sender: TObject);
begin
  PatientIDDlg.Show;
end;

procedure TMainForm.PrinterFonts1Click(Sender: TObject);
begin
  if PrinterFontDialog.Execute then
     Printer.Canvas.Font:=PrinterFontDialog.Font;
end;

end. { DDVMAIN }
