unit DDVTAGLI;

interface

uses  WinTypes, WinProcs, SysUtils, Classes,  Graphics, Forms,    Controls,
      StdCtrls, ExtCtrls, Tabs,     Buttons,  Spin,     Grids,    Dialogs,
      IniFiles,
      FIRST,DDVINI,DDVINSTR,DDVTAGS,DDVMAIN,DDVTAGED;

type  TTagListDialog = class(TForm)
                        PanelPage:        TPanel;
                             LabelSec:    TLabel;
                             SpinEditSec: TSpinEdit;
                             LabelBlk:    TLabel;
                             SpinEditBlk: TSpinEdit;
                        PanelGrid:        TPanel;
                             Grid:        TDrawGrid;
                        PanelBtn:         TPanel;
                             BtnAdd:      TBitBtn;
                             BtnEdit:     TBitBtn;
                             BtnDel:      TBitBtn;
                             BtnUp:       TBitBtn;
                             BtnDn:       TBitBtn;
                             BtnLoad:     TBitBtn;
                             BtnSave:     TBitBtn;
                             BtnClose:    TBitBtn;
                        TabSet:           TTabSet;
    BitBtn1: TBitBtn;
                        procedure FormCreate(Sender: TObject);
                        procedure FormShow(Sender: TObject);
                        procedure TabSetClick(Sender: TObject);
                        procedure BtnAddClick(Sender: TObject);
                        procedure BtnEditClick(Sender: TObject);
                        procedure BtnDelClick(Sender: TObject);
                        procedure BtnUpClick(Sender: TObject);
                        procedure BtnDnClick(Sender: TObject);
                        procedure BtnLoadClick(Sender: TObject);
                        procedure BtnSaveClick(Sender: TObject);
                        procedure BtnCloseClick(Sender: TObject);
                        procedure GridDrawCell(Sender: TObject;
                                               C, R: Longint; Rect: TRect;
                                               State: TGridDrawState);
                        procedure GridSelectCell(Sender: TObject;
                                                 Col, Row: Longint;
                                                 var CanSelect: Boolean);
                        procedure GridTopLeftChanged(Sender: TObject);
                        procedure GridRowMoved(Sender: TObject;
                                               FromIndex, ToIndex: Longint);
                        procedure GridDblClick(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
                         { Koniec }
                       private { Private declarations }
                        Tags:     TTagHDR;
                        Kind:     TTagKind;
                        SampFreq: Word;
                        procedure DrawSample(Canvas: TCanvas; DstRect: TRect;
                                             const HDRRec: TTagHDRRec);
                        function  RowToIndex(Row: LongInt): Integer;
                        function  IndexToRow(Index: Integer): LongInt;
                        function  LastRow(Row: LongInt): Boolean;
                        procedure SetButtons(R: LongInt);
                        procedure SetGrid(R: LongInt);
                       public  { Public declarations }
                        function Execute(TagHDR: TTagHDR; Kind: TTagKind;
                                         SampFreq: Word): Boolean;
                       end;

var   TagListDialog: TTagListDialog;

implementation

{$R *.DFM}

const GridCaptionTxt:    array[0..2] of string[15]
                                  = ( 'Tag', 'Description', 'Sample' );

      InvalidSPPTxt:     string[40] = 'Invalid value of Seconds per page.';
      InvalidBPPTxt:     string[40] = 'Invalid value of Blocks per page.';
      ResultingSPPTxt:   string[40] = 'The resulting value of '+
                                      'Samples per page';
      ResultingSPBTxt:   string[40] = 'The resulting value of '+
                                      'Samples per block';
      MustBeIntegerTxt:  string[20] = ' must be an integer.';
      MustNotExceedTxt:  string[20] = ' must not exceed ';

                                                                  { FormCreate }
procedure TTagListDialog.FormCreate(Sender: TObject);
begin
 SetFormPos(Self,10,200);
 with SpinEditSec do
  begin if MinValue<1 then MinValue:=1; MaxValue:=MaxSecPP end;
 with SpinEditBlk do
  begin if MinValue<1 then MinValue:=1; MaxValue:=MaxBlkPP end;
 TabSet.TabIndex:=0; Kind:=tkPag; Caption:=TabSet.Tabs[0]
end;
                                                                    { FormShow }
procedure TTagListDialog.FormShow(Sender: TObject);
begin
 SetGrid(1)
end;
                                                                 { TabSetClick }
procedure TTagListDialog.TabSetClick(Sender: TObject);
begin
 case TabSet.TabIndex of
  0:   Kind:=tkPag;
  1:   Kind:=tkBlk;
  else Kind:=tkChn
 end;
 Caption:=TabSet.Tabs[TabSet.TabIndex]; SetGrid(1)
end;
                                                                 { BtnAddClick }
procedure TTagListDialog.BtnAddClick(Sender: TObject);
 var HDR: TTagHDRRec;
begin
 if Tags=nil then Exit;
 if LastRow(Grid.Row) then HDR:=BlankHDRRec
 else
  begin
   HDR:=Tags.HDR[Kind,RowToIndex(Grid.Row)];
   HDR.Tag:=' '; HDR.Hint:='';
  end;
 with Grid do
  if TagEdDialog.Execute(emAdd,Tags,Kind,RowToIndex(Row),HDR) then
   SetGrid(Succ(Row))
end;
                                                                { BtnEditClick }
procedure TTagListDialog.BtnEditClick(Sender: TObject);
begin
 if Tags=nil then Exit;
 with Grid do
  if TagEdDialog.Execute(emEdit,Tags,Kind,RowToIndex(Row),
                         Tags.HDR[Kind,RowToIndex(Grid.Row)]) then Invalidate
end;
                                                                 { BtnDelClick }
procedure TTagListDialog.BtnDelClick(Sender: TObject);
begin
 if Tags=nil then Exit;
 Tags.DeleteHDR(Kind,RowToIndex(Grid.Row)); SetGrid(Grid.Row)
end;
                                                                  { BtnUpClick }
procedure TTagListDialog.BtnUpClick(Sender: TObject);
begin
 if Tags=nil then Exit;
 if RowToIndex(Grid.Row)>0 then
  begin
   Tags.MoveHDR(Kind,RowToIndex(Grid.Row),Pred(RowToIndex(Grid.Row)));
   Grid.Row:=Grid.Row-1; Grid.Invalidate
  end
end;
                                                                  { BtnDnClick }
procedure TTagListDialog.BtnDnClick(Sender: TObject);
begin
 if Tags=nil then Exit;
 if Succ(RowToIndex(Grid.Row))<Tags.Count[Kind] then
  begin
   Tags.MoveHDR(Kind,RowToIndex(Grid.Row),Succ(RowToIndex(Grid.Row)));
   Grid.Row:=Grid.Row+1; Grid.Invalidate
  end
end;
                                                                { BtnLoadClick }
procedure TTagListDialog.BtnLoadClick(Sender: TObject);
begin
 if Tags=nil then Exit;
 if Tags.LoadHDR then
  begin
   SpinEditSec.Value:=Tags.SecPerPage; SpinEditBlk.Value:=Tags.BlkPerPage;
   SetGrid(1)
  end
end;
                                                                { BtnSaveClick }
procedure TTagListDialog.BtnSaveClick(Sender: TObject);
begin
 if Tags=nil then Exit;
 Tags.SecPerPage:=SpinEditSec.Value; Tags.BlkPerPage:=SpinEditBlk.Value;
 SpinEditSec.Value:=Tags.SecPerPage; SpinEditBlk.Value:=Tags.BlkPerPage;
 Tags.SaveHDR
end;
                                                               { BtnCloseClick }
procedure TTagListDialog.BtnCloseClick(Sender: TObject);
 var SPP,
     BPP: Word;
     L:   LongInt;
     S:   string;
begin
 if SampFreq=0 then Exit; SPP:=SpinEditSec.Value; BPP:=SpinEditBlk.Value;
 L:=LongInt(SampFreq)*SPP;
 if L mod 10 <> 0 then
  begin
   MessageDlg(InvalidSPPTxt+CRLF+ResultingSPPTxt+
              MustBeIntegerTxt,mtError,[mbOK],0);
   if SpinEditSec.Enabled then ActiveControl:=SpinEditSec; ModalResult:=mrNone
  end
 else
  if L div 10 > MaxSampsPerPage then
   begin
    MessageDlg(InvalidSPPTxt+CRLF+ResultingSPPTxt+
               MustNotExceedTxt+SN(MaxSampsPerPage,0),mtError,[mbOK],0);
    if SpinEditSec.Enabled then ActiveControl:=SpinEditSec; ModalResult:=mrNone
   end
  else
   if (L div 10) mod BPP <> 0 then
    begin
     MessageDlg(InvalidBPPTxt+CRLF+ResultingSPBTxt+
                MustBeIntegerTxt,mtError,[mbOK],0);
     if SpinEditBlk.Enabled then ActiveControl:=SpinEditBlk; ModalResult:=mrNone
    end
end;
                                                                { GridDrawCell }
procedure TTagListDialog.GridDrawCell(Sender: TObject;
                                      C, R: Longint;
                                      Rect: TRect; State: TGridDrawState);
 var Sel: Boolean;
begin
 if Tags=nil then Exit;
 Sel:=gdSelected in State;
 with Grid, Tags do
  if R=0 then DrawCaption(Canvas,Rect,bvLowered,8,0,GridCaptionTxt[C])
  else
   if C=0 then
    begin
     DrawCaption(Canvas,Rect,bvLowered,12,0,'');
     if not LastRow(R) then
      DrawButton(Canvas,Rect,24,24,false,TagBtnColor,12,
                 HDR[Kind,RowToIndex(R)].Tag)
    end
   else
    if C=1 then
     if not LastRow(R) then
      DrawField(Canvas,Rect,GridFldColor,Sel,8,2,HDR[Kind,RowToIndex(R)].Hint)
     else DrawField(Canvas,Rect,GridFldColor,Sel,8,2,'')
    else
     if C=2 then
      if not LastRow(R) then DrawSample(Canvas,Rect,HDR[Kind,RowToIndex(R)])
      else DrawField(Canvas,Rect,GridFldColor,false,8,2,'');
 if gdFocused in State then Grid.Canvas.DrawFocusRect(Rect);
 SetFont(Grid.Font,DrawFonts[true],8,[],clWindowText)
end;
                                                              { GridSelectCell }
procedure TTagListDialog.GridSelectCell(Sender: TObject; Col, Row: Longint;
                                        var CanSelect: Boolean);
begin
 SetButtons(Row)
end;
                                                          { GridTopLeftChanged }
procedure TTagListDialog.GridTopLeftChanged(Sender: TObject);
begin
 with Grid do
  if Row<TopRow then Row:=TopRow
  else
   if Row>=TopRow+VisibleRowCount then Row:=Pred(TopRow+VisibleRowCount)
end;
                                                                { GridRowMoved }
procedure TTagListDialog.GridRowMoved(Sender: TObject;
                                      FromIndex, ToIndex: Longint);
begin
 if Tags=nil then Exit;
 if (RowToIndex(FromIndex)<Tags.Count[Kind]) and
    (RowToIndex(ToIndex)<Tags.Count[Kind]) then
  Tags.MoveHDR(Kind,RowToIndex(FromIndex),RowToIndex(ToIndex));
 SetButtons(Grid.Row); Grid.Invalidate
end;
                                                                { GridDblClick }
procedure TTagListDialog.GridDblClick(Sender: TObject);
begin
 if LastRow(Grid.Row) then
  if BtnAdd.Enabled then BtnAdd.Click
  else
 else
  if BtnEdit.Enabled then BtnEdit.Click
end;
                                                                  { DrawSample }
procedure TTagListDialog.DrawSample(Canvas: TCanvas; DstRect: TRect;
                                    const HDRRec: TTagHDRRec);
 var Bitmap:  TBitmap;
     SrcRect: TRect;
begin
 Bitmap:=TBitmap.Create;
 try
  with DstRect do
   begin
    Bitmap.Width:=Succ(Right-Left);
    Bitmap.Height:=Succ(Bottom-Top);
    SrcRect:=Rect(0,0,Right-Left,Bottom-Top)
   end;
  with Bitmap, Canvas, HDRRec do
   begin
    SetBrush(Brush,BColor,BStyle); SetPen(Pen,PColor,PMode,PStyle,PWidth);
    Rectangle(0,0,Pred(Width),Pred(Height))
   end;
  Canvas.CopyRect(DstRect,Bitmap.Canvas,SrcRect)
 finally Bitmap.Free
 end
end;
                                                                  { RowToIndex }
function TTagListDialog.RowToIndex(Row: LongInt): Integer;
begin
 Result:=Pred(Row)
end;
                                                                  { IndexToRow }
function TTagListDialog.IndexToRow(Index: Integer): LongInt;
begin
 Result:=Succ(Index)
end;
                                                                     { LastRow }
function TTagListDialog.LastRow(Row: LongInt): Boolean;
begin
 if Tags=nil then Result:=false
 else Result:=RowToIndex(Row)>=Tags.Count[Kind]
end;
                                                                  { SetButtons }
procedure TTagListDialog.SetButtons(R: LongInt);
begin
 if Tags=nil then Exit;
 BtnEdit.Enabled:=not LastRow(R);
 BtnDel.Enabled :=not LastRow(R) and not Tags.Fixed;
 BtnUp.Enabled  :=(RowToIndex(R)>0) and not LastRow(R);
 BtnDn.Enabled  :=(RowToIndex(R)<Pred(Tags.Count[Kind])) and not LastRow(R);
 BtnLoad.Enabled:=not Tags.Fixed
end;
                                                                     { SetGrid }
procedure TTagListDialog.SetGrid(R: LongInt);
begin
 if Tags=nil then Exit;
 with Grid do
  begin
   RowCount:=Tags.Count[Kind]+2; ColCount:=3; RowHeights[0]:=21;
   ColWidths[0]:=DefaultRowHeight; ColWidths[2]:=2*DefaultRowHeight;
   ColWidths[1]:=ClientWidth-2*GridLineWidth-ColWidths[0]-ColWidths[2];
   if Row=R then SetButtons(R) else Row:=R
  end
end;
                                                                     { Execute }
function TTagListDialog.Execute(TagHDR: TTagHDR; Kind: TTagKind;
                                SampFreq: Word): Boolean;
begin
 if TagHDR=nil then Exit; Tags:=TagHDR; Self.Kind:=Kind;
 TabSet.TabIndex:=Ord(Kind); Caption:=TabSet.Tabs[TabSet.TabIndex];
 Self.SampFreq:=SampFreq;
 SpinEditSec.Value:=TagHDR.SecPerPage;  SpinEditBlk.Value:=TagHDR.BlkPerPage;
 LabelSec.Enabled:=not TagHDR.Fixed;    LabelBlk.Enabled:=not TagHDR.Fixed;
 SpinEditSec.Enabled:=not TagHDR.Fixed; SpinEditBlk.Enabled:=not TagHDR.Fixed;
 Result:=ShowModal=mrOK;
 if Result then
  begin
   Tags.SecPerPage:=SpinEditSec.Value;
   Tags.BlkPerPage:=SpinEditBlk.Value
  end;
 Tags:=nil
end;

procedure TTagListDialog.BitBtn1Click(Sender: TObject);
begin
  if Tags=nil then Exit;     { Ladowanie oznaczen stadiow snu }
  if Tags.SetSleepTags then
    SetGrid(1);
end;

end. { DDVTAGLI }
