unit Exthead;      { 1997 09 07 }

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, TabNotBk, StdCtrls, Buttons, Grids;

type
  TExtHeaderDlg = class(TForm)
    TabbedNotebook1: TTabbedNotebook;
    CalibInfo: TStringGrid;
    Label1: TLabel;
    Edit1: TEdit;
    Label2: TLabel;
    Edit2: TEdit;
    Label3: TLabel;
    label4: TLabel;
    Label5: TLabel;
    ChannelsName: TStringGrid;
    Label6: TLabel;
    Label7: TLabel;
    DataInfo: TMemo;
    Label8: TLabel;
    Edit3: TEdit;
    Label9: TLabel;
    Edit4: TEdit;
    Label10: TLabel;
    Edit5: TEdit;
    Label11: TLabel;
    Edit6: TEdit;
    TextRecord: TMemo;
    Label12: TLabel;
    Edit7: TEdit;
    TextExtension: TMemo;
    Label13: TLabel;
    Edit8: TEdit;
    Label14: TLabel;
    Edit9: TEdit;
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    ChnLabels : array[1..100] of string[6];
    NumofChannels : integer;

    procedure LoadNextHeaders(var plik : file;Chn : integer);
  end;

var
  ExtHeaderDlg: TExtHeaderDlg;

implementation
            { Procedury z recept numerycznych }
PROCEDURE caldat(julian: longint; VAR mm,id,iyyy: integer);
CONST
   igreg=2299161.0;
VAR
   je,jd,jc,jb,jalpha,ja: longint;

BEGIN
   IF (julian >= trunc(igreg)) THEN BEGIN
      jalpha := trunc(((julian-1867216.0)-0.25)/36524.25);
      ja := julian+1+jalpha-trunc(0.25*jalpha)
   END ELSE BEGIN
      ja := julian
   END;
   jb := ja+trunc(1524.0);
   jc := trunc(6680.0+((jb-2439870.0)-122.1)/365.25);
   jd := trunc(365.0*jc+trunc(0.25*jc));
   je := trunc((jb-jd)/30.6001);
   id := jb-jd-trunc(30.6001*je);
   mm := je-1;
   IF (mm > 12) THEN mm := mm-12;
   iyyy := jc-trunc(4715.0);
   IF (mm > 2) THEN iyyy := iyyy-1;
   IF (iyyy <= 0) THEN iyyy := iyyy-1
END;

FUNCTION julday(mm,id,iyyy: integer): longint;
CONST
   igreg=588829.0;
VAR
   ja,jm,jy,jul: longint;

BEGIN
   IF  (iyyy < 0) THEN  iyyy := iyyy+1;
   IF  (mm > 2)  THEN BEGIN
      jy := iyyy;
      jm := mm+1
   END ELSE BEGIN
      jy := iyyy-1;
      jm := mm+13
   END;
   jul := trunc(365.25*jy)+trunc(30.6001*jm)+id+trunc(1720995.0);
   IF  (id+31.0*(mm+12.0*iyyy) >= igreg)  THEN BEGIN
      ja := trunc(0.01*jy);
      jul := jul+2-ja+trunc(0.25*ja)
   END;
   julday := jul
END;

function GetBitValue(x : longint; a,b : integer) : longint;
  var
    sum : longint;         { Wartosci pozycji bitowych }
    i,k : integer;

begin
   sum:=0;
   k:=0;
   for i:=a to b do
    begin
     if (x and (1 shl i))<>0 then
       sum:=sum+(1 shl k);
     k:=k+1;
    end;
   GetBitValue:=sum;
end;

{$R *.DFM}

procedure TExtHeaderDlg.LoadNextHeaders(var plik : file;Chn : integer);
  const
    timezone=18000;

  var
    Code1,Code2 : char;
    Size        : word;
    ftmp        : single;
    nap         : string;
    itmp,i,j,itmp2 : word;
    stmp        : array[1..4] of char;
    ctmp        : char;
    pos,ltmp    : longint;
    days,sek,StartTime : longint;
    mm,dd,yy  : integer;
    hh,min,ss : longint;
    sep,sep2  : string[3];

begin
  Label1.Enabled:=false;         { Domyslnie wylanczamy wszystko }
  Label2.Enabled:=false;
  Label3.Enabled:=false;
  Label4.Enabled:=false;
  Label5.Enabled:=false;
  Label6.Enabled:=false;
  Label7.Enabled:=false;
  Label8.Enabled:=false;
  Label9.Enabled:=false;
  Label10.Enabled:=false;
  Label11.Enabled:=false;
  Label12.Enabled:=false;
  Label13.Enabled:=false;

  while true do       { Czytanie struktur extended header }
    begin
      BlockRead(plik,Code1,sizeOf(char)); BlockRead(plik,Code2,sizeOf(char));
      BlockRead(plik,Size,sizeOf(word));
      if (Code1=chr(0)) and (Code2=chr(0)) then
        begin
         exit;       { Wychodzimy }
        end
      else if (Code1='C') and (Code2='I') then
        begin       { Calibraion Info }
           Label1.Enabled:=true;
           Label2.Enabled:=true;
           Label3.Enabled:=true;
           Label4.Enabled:=true;
           Label5.Enabled:=true;

           BlockRead(plik,itmp,sizeOf(word));
           Edit1.Text:=inttostr(itmp);
           BlockRead(plik,itmp,sizeof(word));
           Edit2.Text:=inttostr(itmp);
           for i:=1 to Chn do
             begin
               BlockRead(plik,ftmp,sizeof(single));
               str(ftmp:5:2,nap);
               CalibInfo.Cells[0,i-1]:=inttostr(i);
               CalibInfo.Cells[1,i-1]:=nap;
               BlockRead(plik,ftmp,sizeof(single));
               str(ftmp:5:2,nap);
               CalibInfo.Cells[2,i-1]:=nap;
             end;
        end
       else if (Code1='C') and (Code2='N') then
         begin        { Channal names }
           Label6.Enabled:=true;
           Label7.Enabled:=true;
           NumOfChannels:=Chn;

           for i:=1 to Chn do
             begin
               BlockRead(plik,stmp,4);
               nap:='';
               for j:=1 to 4 do
                 nap:=nap+stmp[j];

               ChannelsName.Cells[0,i-1]:=inttostr(i);
               ChannelsName.Cells[1,i-1]:=nap;
               ChnLabels[i]:=nap;
              end;
         end
       else if (Code1='D') and (Code2='I') then
         begin            { Data Info }
           i:=0;
           nap:='';
           for j:=1 to Size do
             begin
               BlockRead(plik,ctmp,1);
               nap:=nap+ctmp;
               DataInfo.Lines[i]:=nap;
               if ((j+1) mod 30)=0 then
                 begin
                   i:=i+1;
                   nap:='';
                 end;
              end;
         end
        else if (Code1='F') and (Code2='S') then
          begin           { Probkowanie }
             Label8.Enabled:=true;
             BlockRead(plik,itmp,sizeof(word));
             BlockRead(plik,itmp2,sizeof(word));
             str((itmp/itmp2):5:2,nap);
             Edit3.Text:=nap;
          end
        else if (Code1='I') and (Code2='D') then
          begin             { Identyfikacja }
            Label9.Enabled:=true;
            Label10.Enabled:=true;
            Label11.Enabled:=true;
            Label13.Enabled:=true;

            BlockRead(plik,ltmp,sizeof(longint));
            Edit8.Text:=inttostr(ltmp);
            Edit4.Text:=inttostr(GetBitValue(ltmp,0,13));
            if (ltmp and (1 shl 15))<>0 then
              Edit5.Text:='female'
            else
              Edit5.Text:='male';
            Edit6.Text:=inttostr(GetBitValue(ltmp,16,20))+'-'+
                        inttostr(GetBitValue(ltmp,21,24))+'-'+
                        inttostr(GetBitValue(ltmp,25,31));
          end
        else if (Code1='T') and (Code2='E') then
          begin         { Text }
            i:=0;
            nap:='';
            for j:=1 to Size do
             begin
               BlockRead(plik,ctmp,1);
               nap:=nap+ctmp;
               TextRecord.Lines[i]:=nap;
               if ((j+1) mod 30)=0 then
                 begin
                   i:=i+1;
                   nap:='';
                 end;
             end;
          end
        else if (Code1='T') and (Code2='I') then
          begin         { Time Info }
            Label12.Enabled:=true;

            BlockRead(plik,ltmp,sizeof(longint));
            ltmp:=ltmp-timezone;  { ustalona strefa czasowa }
            Days:=ltmp div trunc(86400.0);
            StartTime:=JulDay(1,1,1970);
            Sek:=ltmp mod 86400;
            CalDat(StartTime+Days,mm,dd,yy);
            hh:=Sek div 3600;
            Sek:=Sek-3600*longint(hh);
            min:=Sek div 60;
            ss:=Sek-60*min;
            { Poprawka formatu czasu 1997 09 28 }
            if min<=9 then sep:='0' else sep:='';
            if ss<=9 then sep2:='0' else sep2:='';
            Edit7.Text:=inttostr(hh)+':'+
                        sep+inttostr(min)+':'+
                        sep2+inttostr(ss);

            Edit9.Text:=inttostr(dd)+'-'+
                        inttostr(mm)+'-'+
                        inttostr(yy);
          end
        else if (Code1='T') and (Code2='X') then
          begin                  { Text (2) }
            i:=0;
            nap:='';
            for j:=1 to Size do
             begin
               BlockRead(plik,ctmp,1);
               nap:=nap+ctmp;
               TextExtension.Lines[i]:=nap;
               if ((j+1) mod 30)=0 then
                 begin
                   i:=i+1;
                   nap:='';
                 end;
             end;
          end
        else
          begin
            pos:=FilePos(plik)+longint(Size);
            Seek(plik,pos);
          end;
    end;
end;

procedure TExtHeaderDlg.FormCreate(Sender: TObject);
  var
    i : integer;

begin
   NumOfChannels:=64;
   for i:=1 to NumOfChannels do
     ChnLabels[i]:=inttostr(i);
end;

end.
