unit Filtfft;
{ Procedury filracji 1998 01 21/02 04 }
{ Dostosowane do dlugosci sygnalu nie bedacego potega 2 }

interface
 const
   MaxSamples=12000;
   MaxIntTabSize=6;

 type
   TIntTab=array[1..MaxIntTabSize] of integer;
   TSingleTab=array[1..MaxSamples] of single;
   TFilterTypes=( Rectangle, Gaussian, Cosinus );
   TFilterParam=record
                   FilterType         : TFilterTypes;
                   Gain               : single;
                   FreqMin,FreqMax    : integer;
                   FreqAverg,FreqDysp : integer;
                   FilterStatus       : integer;
                   RawFreqMin,RawFreqMax,RawFreqSamp,
                   RawFreqAverg,RawFreqDysp : single;
                 end;

                 { Filtracja sygnalu }
procedure SignalFilter(var sig : TSingleTab; Dim : integer;
                       var filter : TFilterParam);

implementation
const
  M_PI_2=1.57079632679489661923;

type
  TFFTTable=array[1..4100] of single;

procedure LengthFactor(var f : TIntTab; n : integer);
begin
  f[1]:=n div 2048;
  n:=n mod 2048;
  f[2]:=n div 1024;
  n:=n mod 1024;
  f[3]:=n div 512;
  n:=n mod 512;
  f[4]:=n div 256;
  n:=n mod 256;
  f[5]:=n div 128;
  n:=n mod 128;
  f[6]:=n div 64;
  if (n mod 64)<>0 then
    f[6]:=f[6]+1;
end;

             { Transformata Fouriera (FFT) }
PROCEDURE four1(VAR data: TFFTTable; nn,isign: integer);
VAR
   ii,jj,n,mmax,m,j,istep,i,itmp: integer;
   wtemp,wr,wpr,wpi,wi,theta: double;
   tempr,tempi: double;

BEGIN
   n := 2*nn;
   j := 1;
   FOR ii := 1 TO nn DO BEGIN
      i := 2*ii-1;
      IF (j > i) THEN BEGIN
         tempr := data[j];
         tempi := data[j+1];
         data[j] := data[i];
         data[j+1] := data[i+1];
         data[i] := tempr;
         data[i+1] := tempi
      END;
      m := n DIV 2;
      WHILE ((m >= 2) AND (j > m))  DO BEGIN
         j := j-m;
         m := m DIV 2
      END;
      j := j+m
   END;
   mmax := 2;

   WHILE (n > mmax) DO BEGIN
      istep := 2*mmax;
      theta := 6.28318530717959/(isign*mmax);
      wpr :=-2.0*sqr(sin(0.5*theta));
      wpi :=sin(theta);
      wr := 1.0;
      wi := 0.0;
      FOR ii := 1 TO (mmax DIV 2) DO BEGIN
         m := 2*ii-1;
         itmp:= ((n-m) DIV istep);
         FOR jj := 0 TO  itmp DO
          BEGIN
            i := m + jj*istep;
            j := i+mmax;
            tempr := wr*data[j]-wi*data[j+1];
            tempi := wr*data[j+1]+wi*data[j];
            data[j] := data[i]-tempr;
            data[j+1] := data[i+1]-tempi;
            data[i] := data[i]+tempr;
            data[i+1] := data[i+1]+tempi
         END;
         wtemp := wr;
         wr := wr*wpr-wi*wpi+wr;
         wi := wi*wpr+wtemp*wpi+wi
      END;
      mmax := istep
   END
END;
                     { Obliczenie FFT sygnalu }

procedure FFTFactor(var Sig : TFFTTable; Dim,isig : integer);
var
  Factor : double;
  i,itmp : integer;
  ok     : boolean;

begin
 four1(Sig,Dim,isig);
 if isig=-1 then
     begin
        Factor:=1.0/Dim;
        itmp:=2*Dim;
        for i:=1 to itmp do
          Sig[i]:=Sig[i]*Factor;
     end;
end;
               { Filtracja }

procedure FiltSignal(var Sig : TFFTTable; Dim : integer;
                     var Filter : TFilterParam);
var
  i,Half,itmp : integer;
  ftmp,W      : double;

begin
   Half:=Dim div 2;
   with Filter do
     if FilterType=Cosinus then
       W:=M_PI_2/FreqDysp;

   for i:=1 to Half do
    begin
       with Filter do
        begin
         case FilterType of
           Rectangle: if (i>=FreqMin) and (i<=FreqMax) then
                          ftmp:=Gain
                        else
                          ftmp:=0.0;
           Gaussian:  ftmp:=Gain*exp(-sqr((i-1.0*FreqAverg)/FreqDysp));
           Cosinus:   if (i>=FreqMin) and (i<=FreqMax) then
                        ftmp:=Gain
                      else if (i>=FreqMax) and (i<=FreqMax+FreqDysp) then
                        ftmp:=Gain*cos(W*(FreqMax-i))
                      else if (i>=FreqMin-FreqDysp) and (i<=FreqMin) then
                        ftmp:=Gain*cos(W*(FreqMin-i))
                      else
                        ftmp:=0.0;
         end;
         if FilterStatus<0 then     { Posmowo-zaporowy }
            ftmp:=Gain-ftmp;
       end;

     itmp:=2*i;
     Sig[itmp-1]:=Sig[itmp-1]*ftmp;
     Sig[itmp]:=Sig[itmp]*ftmp;
     itmp:=2*(Dim-i+1);
     Sig[itmp-1]:=Sig[itmp-1]*ftmp;
     Sig[itmp]:=Sig[itmp]*ftmp;
     end;
end;
         { Ustawianie parametrow filtrow }

procedure SetData(var FreqMin,FreqMax : single; FreqSamp : single);
var
  ftmp : double;

begin
  FreqSamp:=0.5*FreqSamp;
  if FreqMin>FreqSamp then FreqMin:=FreqSamp;
  if FreqMax>FreqSamp then FreqMax:=FreqSamp;
  if FreqMin>FreqMax then
    begin
      ftmp:=FreqMin;
      FreqMin:=FreqMax;
      FreqMax:=ftmp;
    end;
end;

{ Filtr Cosinusowy }
procedure SetCosinusFilter(var FilterParam : TFilterParam;
                           Min,Max,Dysp,FreqSamp,Factor : single;
                           Dim,Status : integer);
begin
  SetData(Min,Max,FreqSamp);
  with FilterParam do
    begin
      FreqMin:=round(Dim*Min/FreqSamp);
      FreqMax:=round(Dim*Max/FreqSamp);
      FreqDysp:=round(Dim*Dysp/FreqSamp);
      if FreqDysp<1 then FreqDysp:=1;
      FilterType:=Cosinus;
      Gain:=Factor;
      FilterStatus:=Status;
    end;
end;

{ Filtr prostokatny }
procedure SetRectangleFilter(var FilterParam : TFilterParam;
                             Min,Max,FreqSamp,Factor : single;
                             Dim,Status : integer);
begin
  SetData(Min,Max,FreqSamp);
  with FilterParam do
    begin
      FreqMin:=round(Dim*Min/FreqSamp);
      FreqMax:=round(Dim*Max/FreqSamp);
      FilterType:=Rectangle;
      Gain:=Factor;
      FilterStatus:=Status;
    end;
end;

{ Filtr Gaussowski }
procedure SetGaussianFilter(var FilterParam : TFilterParam;
                            Averg,Dysp,FreqSamp,Factor : single;
                            Dim,Status : integer);
var
  HalfFreq : single;

begin
  HalfFreq:=0.5*FreqSamp;
  if Averg>HalfFreq then Averg:=HalfFreq;

  with FilterParam do
    begin
      FreqAverg:=round(Dim*Averg/FreqSamp);
      FreqDysp:=round(Dim*Dysp/FreqSamp);
      if FreqDysp<1 then FreqDysp:=1;
      FilterType:=Gaussian;
      Gain:=Factor;
      FilterStatus:=Status;
    end;
end;
{ Reinicjacja parametrow filtru (moga byc rozne dla kadego segmentu) }
procedure SetAllFilters(var filter : TFilterParam; Dim : integer);
begin
  with filter do
    begin
       case FilterType of
         Cosinus:   SetCosinusFilter(filter,RawFreqMin,RawFreqMax,
                                     RawFreqDysp,RawFreqSamp,Gain,
                                     Dim,FilterStatus);
         Rectangle: SetRectangleFilter(filter,RawFreqMin,RawFreqMax,
                                       RawFreqSamp,Gain,Dim,FilterStatus);
         Gaussian:  SetGaussianFilter(Filter,RawFreqAverg,RawFreqDysp,
                                      RawFreqSamp,Gain,Dim,FilterStatus);
      end;
   end;
end;

{ Filtracja sygnalu }
procedure SignalFilter(var sig : TSingleTab; Dim : integer;
                       var filter : TFilterParam);
var
  FactorTab,LengthTab : TIntTab;
  fft                 : ^TFFTTable;
  i,j,k,start,stop,ii : integer;

begin
 GetMem(fft,sizeof(TFFTTable));
 if fft=nil then exit;
 LengthFactor(FactorTab,Dim);
 LengthTab[1]:=2048;
 LengthTab[2]:=1024;
 LengthTab[3]:=512;
 LengthTab[4]:=256;
 LengthTab[5]:=128;
 LengthTab[6]:=64;

 start:=1;
 for i:=1 to MaxIntTabSize do
   if FactorTab[i]<>0 then
      for k:=1 to FactorTab[i] do
        begin
          stop:=start+LengthTab[i];
          ii:=1;
          for j:=start to stop do
            begin
              if j<=Dim then fft^[2*ii-1]:=sig[j] else fft^[2*ii-1]:=0.0;
              fft^[2*ii]:=0.0;
              ii:=ii+1;
            end;

          SetAllFilters(filter,LengthTab[i]);
          FFTFactor(fft^,LengthTab[i],1);
          FiltSignal(fft^,LengthTab[i],filter);
          FFTFactor(fft^,LengthTab[i],-1);

          ii:=1;
          for j:=start to stop do
           if j<=Dim then
            begin
              sig[j]:=fft^[2*ii-1];
              ii:=ii+1;
            end;
          if start>1 then
            sig[start-1]:=0.5*(sig[start-2]+sig[start]);
          start:=stop+1;
        end;

  FreeMem(fft,sizeof(TFFTTable));
end;

end.
