{  Wczytywanie i zapis plikow w formacie WZR 1997 06 16/19 }

unit Getwzr;

interface

  const                           { Stale globalne }
    ARTIFACT='a';
    NONARTIFACT='n';
    STADIUM_4='4';
    STADIUM_3='3';
    STADIUM_2='2';
    STADIUM_1='1';
    REM='r';
    WAKE='w';
    MUSC='m';
    MYERROR='e';

function OpenWzrFileToSave(filename : string;
                            pages,pagesize,blkpp : word) : boolean;
procedure CloseAndSaveWzrFile; { Zapis WZR' do pliku }
procedure PutWzrStatus(page : word; block : word); { Ustawienie statusu }
procedure PutWzrStadium(stadium : char;
                        page : word);      { Oznaczenie stadia }
function LoadWzr(filename : string;BlockPP,PageSize : word) : boolean; { Ladowanie WZR'a }
function SleepStatus(k : word)  : char; { Pobranie statusu segmentu }
function SleepStadium(k : word) : char; { Stadium snu }
function GetWzrLength : word;              { Maksymalna liczba segmentow }
procedure CloseWzr;                           { Zwolnienie pamieci }
function SleepValue(page : word) : char ;  { Oznaczenie stadium snu }
function IsArtifact(k : word) : boolean;   { Stan segmentu }
function IsStadium(page : word) : boolean; { Czy jest oznaczone }

implementation

uses
    SysUtils,Dialogs,FIRST;

type
    SleepStat=record                        { Oznaczenie statusu i stadiw snu }
                 status,stadium : char;
              end;
const
    MaxSleep=MaxSize div sizeOf(SleepStat); { Maksymalna liczba segmentow }
    Binary=1;                               { Klasyfikacja plikow }
    NoExit=2;
    Good=3;

type
    SleepTab=array[0..MaxSleep] of SleepStat;

var
   Sleep                  : ^SleepTab;      { Tablica z zapisem snu (tymczasowa) }
   MypageNo               : word;
   MyPageSize             : word;
   MyBlkPP                : word;
   WZRfilename            : string;
   IsAlloc                : boolean;

            { Ladowanie WZR'a }

function IsBinaryFile(filename : string) : byte;
  var
    buffor : string;             { Uproszczone sprawczenie formatu pliku }
    len,i  : word;               { Wczytywany jest plik tekstowy }
    plik   : Text;

begin
 Assign(plik,filename);
 {$I-}
 Reset(plik);
 {$I+}
 if IOResult<>0 then
   begin
     IsBinaryFile:=NoExit;       { Plik nie istnieje }
     Exit;
   end;

 readln(plik,buffor);
 close(plik);

 len:=length(buffor);
 for i:=1 to len do
   if buffor[i]=#10 then
     begin
       IsBinaryFile:=Binary;   { Niezgodnosc formatu }
       Exit;
     end;
 IsBinaryFile:=Good;           { Ten jest dobry }
end;

function StadiumNameToChar(name : char) : char;
  var               { Konwersja na wewnetrzna reprezentacje }
    tmp : char;

begin
  case name of
    'R': tmp:=REM;
    'M': tmp:=MUSC;
    'W': tmp:=WAKE;
   else
     tmp:=name;
  end;
  StadiumNameToChar:=tmp;
 end;

function LoadWzr(filename : string; BlockPP,PageSize : word) : boolean;
  var                                 { Wczytanie WZR'a }
    B                     : boolean;
    plik                  : Text;
    line,number           : string;
    len,i,k,itmp,index    : word;
    test                  : byte;

begin
 test:=IsBinaryFile(filename);
 if test=Binary then
   begin
     LoadWzr:=false;
     MessageDlg('Wykryta niezgodnosc formatu pliku (jest binarny) !',
                 mtError,[mbOk],0);
     Exit;
   end
 else if test=NoExit then
        begin
           LoadWzr:=false;
           Exit;
        end;

 Assign(plik,filename);
 {$I-}
 Reset(plik);
 {$I+}
 if IOResult<>0 then      { Nawet nie potrzebne ! }
  begin
    LoadWzr:=false;
    Exit;
  end;

 IsAlloc:=false;
 B:=MemInit(Sleep,SizeOf(SleepTab));
 if not B then
  begin
    close(plik);
    LoadWzr:=false;
    Exit;
  end;
 IsAlloc:=true;

 for i:=0 to MaxSleep do             { Domyslnie wszystkie artefakty }
  begin
    Sleep^[i].status:=ARTIFACT;
    Sleep^[i].stadium:=MYERROR;
  end;

 MyPageNo:=0;
 MyBlkPP:=BlockPP;
 MyPageSize:=PageSize;

 while not eof(plik) do              { Czytanie pliku }
  begin
   readln(plik,line);                { W formacie tekstowym }
   len:=length(line);
   itmp:=MyBlkPP*MyPageNo;
   for i:=0 to MyBlkPP-1 do
     Sleep^[itmp+i].stadium:=StadiumNameToChar(line[1]);

   if line[2]<>'A' then
    begin
      k:=2;
      while k<=len do
        begin
          number:='';
          while (line[k]<>',') and (k<=len) do
            begin
              number:=number+line[k];
              inc(k);
            end;
          index:=((MyBlkPP*StrToInt(number)) div MyPageSize);
          if(index<MyBlkPP) then
            Sleep^[itmp+index].status:=NONARTIFACT;
          inc(k);
        end;
    end;
   inc(MyPageNo);
  end;

 close(plik);
 LoadWzr:=true;
end;

function SleepStatus(k : word) : char;
begin                             { Pobranie wartosci statusu snu }
if IsAlloc then
  SleepStatus:=Sleep^[k].status
else
  SleepStatus:=MYERROR;
end;

function SleepStadium(k : word) : char;
begin                              { Pobranie stadia snu }
 if isAlloc then
  SleepStadium:=Sleep^[k].stadium
 else
  SleepStadium:=MYERROR;
end;

function GetWzrLength : word;
begin                              { Liczba segmentow we snie }
  GetWzrLength:=MyBlkPP*MyPageNo;
end;

procedure CloseWzr;
begin
  MyPageNo:=0;
  if IsAlloc then
   begin
     FreeMem(Sleep,SizeOf(SleepTab));
     IsAlloc:=false;
   end;
end;

function IsStadium(page : word) : boolean;
begin                              { Okreslenie poprawnosci zapisu }
  if SleepStadium(MyBlkPP*page)=MYERROR then
    IsStadium:=false
  else
    IsStadium:=true;
end;

function SleepValue(page : word) : char;
begin                               { Okreslenie stadia strony }
  SleepValue:=SleepStadium(MyBlkPP*page);
end;

function IsArtifact(k : word) : boolean;
 begin                              { Stan artefaktu }
  if SleepStatus(k)=ARTIFACT then
    IsArtifact:=true
  else
    ISArtifact:=false;
 end;
              { Zapisywanie WZR'a }

function OpenWzrFileToSave(filename : string;
                           pages,pagesize,blkpp : word) : boolean;
  var
    i : word;
    B : boolean;

begin
  WZRfilename:=filename;
  MyPageNo:=pages-1;
  MyPageSize:=pagesize;
  MyBlkPP:=blkpp;
  IsAlloc:=false;
  B:=MemInit(Sleep,Sizeof(SleepTab));
  if not B then
   begin
     Result:=false;
     Exit;
   end;
  IsAlloc:=true;

  for i:=0 to MaxSleep do          { Ustawiamy wszystko na zle }
    begin
      Sleep^[i].status:=NONARTIFACT;
      Sleep^[i].stadium:=MYERROR;
    end;
  Result:=true;
end;

function CharToStadiumName(stadium : char) : char;
  var                { Konwersja oznaczenia na nazwe w pliku WZR }
     tmp : char;

begin
  case stadium of
    REM:  tmp:='R';
    WAKE: tmp:='W';
    MUSC: tmp:='M';
    MYERROR: tmp:='0';
  else
    tmp:=stadium;
 end;
 CharToStadiumName:=tmp;
end;

procedure CloseAndSaveWzrFile;     { Zamkniecie i zapis WZR'a }
   var
     i,j,k,segment,start : word;
     plik                : Text;
     NumOfSeg,SegSize    : word;

 begin
    Assign(plik,WZRfilename);
    {$I-}
    ReWrite(plik);
    {$I+}
    if IOResult<> 0 then
      begin
        MemFree(Sleep,SizeOf(SleepTab));
        MessageDlg('Problemy z otwarciem pliku !',
                    mtError,[mbOk],0);
        Exit;
      end;

    NumOfSeg:=MyBlkPP;
    SegSize:=MyPageSize div NumOfSeg;
    for i:=0 to MyPageNo do
      begin
        segment:=NumOfSeg*i;
        write(plik,CharToStadiumName(Sleep^[segment].stadium));
        k:=0;
        for j:=0 to NumOfSeg-1 do
          if Sleep^[segment+j].status=NONARTIFACT then
            begin
              start:=SegSize*j+1;
              if k=0 then
                write(plik,start)
               else write(plik,Chr(Ord(',')),start);
               inc(k);
            end;

        if k=0 then
          writeln(plik,'A')
        else writeln(plik);
      end;

    MemFree(Sleep,SizeOf(SleepTab));
    IsAlloc:=false;
    close(plik);
 end;

 procedure PutWzrStatus(page : word; block : word);
   var
     segment : word;

 begin                               { Ustawiamy brak artefaktu }
  if IsAlloc then
   begin
     segment:=MyBlkPP*(page-1)+block-1;
     Sleep^[segment].status:=ARTIFACT;
   end;
 end;

 procedure PutWzrStadium(stadium : char; page : word);
   var
     current,i : word;            { Ustawiamy stadium snu }

 begin
  if IsAlloc then
   begin
     current:=MyBlkPP*(page-1);
     for i:=0 to MyBlkPP-1 do
       Sleep^[current+i].stadium:=stadium;
   end;
 end;

initialization

IsAlloc:=false;                       { Brak alokacji pamieci }

end.
