unit Pegdlg;   { Odczyt ogonka Pegasusa 1997 09 20 }
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, TabNotBk, StdCtrls, Buttons, Grids, PEGTAIL,EXTHEAD;

type
  TPegasusTailDlg = class(TForm)
    PegsusDialog: TTabbedNotebook;
    GroupBox1: TGroupBox;
    Label1: TLabel;
    ProgVersion: TEdit;
    Label2: TLabel;
    DataVersion: TEdit;
    Label3: TLabel;
    SoftModul: TEdit;
    GroupBox2: TGroupBox;
    Label4: TLabel;
    StatName: TEdit;
    Label5: TLabel;
    Memo1: TMemo;
    Label6: TLabel;
    DateEdit: TEdit;
    Label7: TLabel;
    TImeEdit: TEdit;
    Label8: TLabel;
    FreqEdit: TEdit;
    Label9: TLabel;
    ChnEdit: TEdit;
    ChannelsGrid: TStringGrid;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    BitBtn1: TBitBtn;
    AllChn: TEdit;
    Label13: TLabel;
    Label14: TLabel;
    Label15: TLabel;
    ADConverter: TEdit;
    Ampli: TEdit;
    KeyNumber: TEdit;
    GroupBox3: TGroupBox;
    Label16: TLabel;
    Label17: TLabel;
    Label18: TLabel;
    EEGNumber: TEdit;
    EEGSubNumber: TEdit;
    EEGSubSubNumber: TEdit;
    procedure BitBtn1Click(Sender: TObject);

  private
    { Private declarations }
    Header  : TPegasusHeader;
    InfoChn : TPegasusChnInfo;

  public
    { Public declarations }
    function LoadHeader(filename : string) : boolean;
    function GetCalibration : single;
  end;

var
  PegasusTailDlg: TPegasusTailDlg;

implementation

{$R *.DFM}

function TPegasusTailDlg.GetCalibration : single;
  var
    licznik   : array[1..MaxPegasusChn] of integer;
    i,j,k,max : integer;

begin       { Wyznaczanie Kalibracja na razie Tak 1997 10 14 }
  for i:=1 to Header.Nch_AD do
    licznik[i]:=0;

  for i:=1 to Header.Nch_AD do
    for j:=1 to Header.Nch_AD do
      if i<>j then
        if InfoChn[i].ChnGain=InfoChn[j].ChnGain then
          inc(licznik[i]);

   k:=1;
   max:=Licznik[1];
   for i:=2 to Header.Nch_AD do
     if max<Licznik[i] then
       begin
         max:=Licznik[i];
         k:=i;
       end;
               { ????????? }
   Result:=0.5*(1.6384e-3)*InfoChn[k].ChnGain;
end;

function TPegasusTailDlg.LoadHeader(filename : string) : boolean;
  var
    OK  : boolean;
    i   : word;
    s   : string;
    k,len   : integer;
    sep,sep2: string[3];

begin  { Czytamy naglowek i informacje o kanalach }
  OK:=ReadPegasusTail(Header,InfoChn,filename);
  if not OK then
   begin
    MessageDlg('Cannt read PEGASUS header !', mtError,
               [mbOk],0);
    Result:=false;
    Exit;
   end;
       { Przypisujemy do etykiet na obrazku }
 SoftModul.Text:='  '+IntToStr(Header.RID.SoftModul);
 ProgVersion.Text:='  '+IntToStr(Header.RID.VProg);
 DataVersion.Text:='  '+IntToStr(Header.RID.VData);

 DateEdit.Text:='  '+IntToStr(Header.AblTag)+'-'+
                IntToStr(Header.AblMonat)+'-'+
                IntToStr(Header.AblJahr);
       { Poprawka do formatu wypisywania daty 1997 09 28 }
 if Header.Ablm<=9 then sep:='0' else sep:='';
 if Header.Abls<=9 then sep2:='0' else sep2:='';
 TimeEdit.Text:='  '+IntToStr(Header.Ablh)+':'+
                sep+IntToStr(Header.Ablm)+':'+
                sep2+IntToStr(Header.Abls);

 FreqEdit.Text:='  '+IntToStr(Header.Nhz);
 ChnEdit.Text:='  '+IntToStr(Header.Nch_AD);
 AllChn.Text:='  '+IntToStr(Header.Nch_DSK);
 ADConverter.Text:='  '+IntToStr(Header.RID.HWad);
 Ampli.Text:='  '+IntToStr(Header.RID.HWamp);
 KeyNumber.Text:='  '+IntToStr(Header.RID.KeyNr);

 EEGNumber.Text:='  '+IntToStr(Header.EEGNr);
 EEGSubNumber.Text:='  '+IntToStr(Header.SubNr);
 EEGSubSubNumber.Text:='  '+IntToStr(Header.SUBsubNr);

 S:='  ';               { Konwersja tablic znakow na stringi }
 for i:=0 to 11 do
   if Header.StatName[i]<>chr(0) then
     S:=S+Header.StatName[i]
   else
    Break;

 StatName.Text:=S;

 k:=0;
 len:=0;
 Memo1.Lines[0]:='';
 Memo1.Lines[1]:='';
 for i:=0 to 49 do
  begin
    if Header.FileInfo[i]<>chr(0) then
     begin
       Memo1.Lines[k]:=Memo1.Lines[k]+Header.FileInfo[i];
       len:=len+1;
     end else break;

    if len>30 then
      begin
        k:=k+1;
        len:=0;
      end;
  end;

 for i:=1 to header.Nch_AD do     { Opis elektrod }
   begin
     S:='';
     for k:=1 to 6 do
       if InfoChn[i].K_H_Text[k]<>char(0) then
         S:=S+InfoChn[i].K_H_Text[k]
       else
         break;

     ExtHeaderDlg.ChnLabels[i]:=S;  { Ewentualnie do importu }
     ChannelsGrid.Cells[0,i-1]:='  '+IntToStr(i);
     ChannelsGrid.Cells[1,i-1]:=' '+S;
     ChannelsGrid.Cells[2,i-1]:=' '+IntToStr(InfoChn[i].ChnGain);
   end;
 Result:=true;
end;

procedure TPegasusTailDlg.BitBtn1Click(Sender: TObject);
begin
  Close;
end;

end.
