unit Pegtail;     { Odczyt Ogonka Pegasusa 1997 09 20 }

interface
  const
    MaxPegasusChn=64;

  type
    TRelaseID=record
                HWad,
                HWamp,
                KeyNr,
                SoftModul,
                VProg,
                VData : integer;
              end;

    TPegasusHeader=record
                    RID : TRelaseID; { Uwaga na wyrownywanie }
                    StatName : array[0..10] of char;
                    FileInfo : array[0..49] of char;
                    nullChar : char;
                    DataType,
                    EEGNr,
                    SUBNr,
                    SUBsubNr,
                    AblTag,
                    AblMonat,
                    AblJahr,
                    Ablh,
                    Ablm,
                    Abls,
                    Nch_Dsk,
                    Nhz,
                    Nch_AD : integer;
                  end;

   TChnInfo=record
              K_H_Text : array[1..6] of char;
              ChnGain  : word;
             end;

   THeadDesc=record
               Len_Dathead,
               Len_Kanalzu,
               Len_Header : word;
             end;

   TPegasusChnInfo=array[1..MaxPegasusChn] of TChnInfo;

var
  PegasusEndOfFile : longint;

function ReadPegasusTail(var header  : TPegasusHeader;
                         var infoChn : TPegasusChnInfo;
                         filename : string) : boolean;

implementation

function ReadPegasusTail(var header : TPegasusHeader;
                         var infoChn : TPegasusChnInfo;
                         filename : string) : boolean;
var
  headDsc : THeadDesc;
  fileLen : longint;
  plik    : file;
  i       : word;

begin            { Ladowanie ogonka pliku w formacie Pegasusa }
 FillChar(header,sizeOf(TPegasusHeader),#0);
 PegasusEndOfFile:=0;
 {$I-}
 Assign(plik,filename); Reset(plik,1);
 {$I+}
 if IOResult<>0 then
  begin
    Result:=false;
    exit;
  end;

  FileLen:=FileSize(plik);
  {$I-}      { Odczyt pozycji ogonka i naglowka }
  Seek(plik,FileLen-sizeOf(THeadDesc));
  {$I+}
  if IOResult<>0 then
  begin
    Result:=false;
    Close(plik);
    exit;
  end;

  {$I-}
  BlockRead(plik,HeadDsc,sizeOf(THeadDesc));
  {$I+}
  if IOResult<>0 then
  begin
    Result:=false;
    Close(plik);
    exit;
  end;

  {$I-}
  Seek(plik,FileLen-longint(HeadDsc.Len_Header));
  {$I+}
  if IOResult<>0 then
  begin
    Result:=false;
    Close(plik);
    exit;
  end;

  {$I-}
  BlockRead(plik,header,sizeOf(TPegasusHeader));
  {$I+}
  if (IOResult<>0) or (header.NCh_Ad>MaxPegasusChn)
                   or (header.NCh_Ad<=0) then
    begin
      Result:=false;
      Close(plik);
      Exit;
    end;

  {$I-}                { Odczyt inforamcji o kanalach }
  for i:=1 to header.NCh_AD do
   begin
    BlockRead(plik,infoChn[i],sizeOf(TChnInfo));
    if IOResult<>0 then
     begin
      Result:=true;
      Close(plik);
      Exit;
     end;
   end;
  {$I+}

  Close(plik);
  PegasusEndOfFile:=FileLen-longint(HeadDsc.Len_Header);
  Result:=true;
end;

end.
