unit Userfilt; { Dialog do tworzenia filtru 1998 02 04 }

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls,FILTFFT, ExtCtrls,DIALOGS,SYSUTILS;

type
  TUserFilterDlg = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    RadioGroup1: TRadioGroup;
    RadioGroup2: TRadioGroup;
    MinFreqEdit: TEdit;
    MaxFreqEdit: TEdit;
    AvergFreqEdit: TEdit;
    DyspFreqEdit: TEdit;
    GainFreqEdit: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    procedure RadioGroup1Click(Sender: TObject);
    procedure RadioGroup2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SetDlg;
    procedure OKBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    FilterParam : TFilterParam;
    ExitStatus  : boolean;
    function Execute : boolean;
  end;

var
  UserFilterDlg: TUserFilterDlg;

implementation

{$R *.DFM}
function TUserFilterDlg.Execute : boolean;
begin
  ExitStatus:=true;
  Result:=false;
  SetDlg;
  try Result:=(ShowModal=mrOK);
  finally
    if Result then
        Result:=ExitStatus;
  end;
end;

procedure TUserFilterDlg.RadioGroup1Click(Sender: TObject);
begin
  case RadioGroup1.ItemIndex of
     0: begin
        AvergFreqEdit.Enabled:=false;  { Rectangle }
        DyspFreqEdit.Enabled:=false;
        Label1.Enabled:=true;
        Label2.Enabled:=true;
        Label3.Enabled:=false;
        Label4.Enabled:=false;
        MinFreqEdit.Enabled:=true;
        MaxFreqEdit.Enabled:=true;
        FilterParam.FilterType:=Rectangle;
        end;
     1: begin
        AvergFreqEdit.Enabled:=true;   { Gaussian }
        DyspFreqEdit.Enabled:=true;
        Label1.Enabled:=false;
        Label2.Enabled:=false;
        Label3.Enabled:=true;
        Label4.Enabled:=true;
        MinFreqEdit.Enabled:=false;
        MaxFreqEdit.Enabled:=false;
        FilterParam.FilterType:=Gaussian;
        end;

     2: begin
        AvergFreqEdit.Enabled:=false;   { Cosinus }
        DyspFreqEdit.Enabled:=true;
        Label1.Enabled:=true;
        Label2.Enabled:=true;
        Label3.Enabled:=false;
        Label4.Enabled:=true;
        MinFreqEdit.Enabled:=true;
        MaxFreqEdit.Enabled:=true;
        FilterParam.FilterType:=Cosinus;
       end;
  end;
end;

procedure TUserFilterDlg.RadioGroup2Click(Sender: TObject);
begin
  case RadioGroup2.ItemIndex of
    0: begin FilterParam.FilterStatus:=1; end;
    1: begin FilterParam.FilterStatus:=-1; end;
  end;
end;

procedure TUserFilterDlg.FormCreate(Sender: TObject);
begin
  with FilterParam do
    begin
      RawFreqMin:=0.0;
      RawFreqMax:=15.0;
      RawFreqDysp:=1.0;
      RawFreqAverg:=15.0;
      FilterType:=Rectangle;
      FilterStatus:=1;
      Gain:=1.0;
    end;
end;

procedure TUserFilterDlg.SetDlg;
var
  napis  : string;

begin
 with FilterParam do
  begin
    Str(RawFreqMin:7:2,napis);
    MinFreqEdit.Text:=napis;
    Str(RawFreqMax:7:2,napis);
    MaxFreqEdit.Text:=napis;
    Str(RawFreqDysp:7:2,napis);
    DyspFreqEdit.Text:=napis;
    Str(RawFreqAverg:7:2,napis);
    AvergFreqEdit.Text:=napis;
    Str(Gain:7:2,napis);
    GainFreqEdit.Text:=napis;
  end;

  RadioGroup2Click(nil);
  RadioGroup1Click(nil);
end;

procedure TUserFilterDlg.OKBtnClick(Sender: TObject);
var
  Code : integer;
  tmp  : single;

begin
  with FilterParam do
    begin
      Val(MinFreqEdit.Text,RawFreqMin,Code);
      if RawFreqMin<0.0 then
        RawFreqMin:=0.0;

      if code<>0 then
       begin
         MessageDlg('Error in MinFreq at position: ' + IntToStr(Code),
                     mtError,[mbOk],0);
         ExitStatus:=false;
         exit;
       end;

      Val(MaxFreqEdit.Text,RawFreqMax,Code);
      if RawFreqMax<0.0 then
        RawFreqMax:=0.0;
      if code<>0 then
       begin
         MessageDlg('Error in MaxFreq at position: ' + IntToStr(Code),
                     mtError,[mbOk],0);
         ExitStatus:=false;
         exit;
       end;

      Val(AvergFreqEdit.Text,RawFreqAverg,Code);
      if RawFreqAverg<0.0 then
        RawFreqAverg:=0.0;
      if code<>0 then
       begin
         MessageDlg('Error in AvergFreq at position: ' + IntToStr(Code),
                     mtError,[mbOk],0);
         ExitStatus:=false;
         exit;
       end;

       Val(DyspFreqEdit.Text,RawFreqDysp,Code);
       if RawFreqDysp<0.0 then
         RawFreqDysp:=1.0e-3;
       if code<>0 then
        begin
          MessageDlg('Error in DyspFreq at position: ' + IntToStr(Code),
                     mtError,[mbOk],0);
          ExitStatus:=false;
          exit;
       end;

       Val(GainFreqEdit.Text,Gain,Code);
       if Gain<0.0 then
         Gain:=0.0;
       if code<>0 then
        begin
         MessageDlg('Error in Gain at position: ' + IntToStr(Code),
                     mtError,[mbOk],0);
         ExitStatus:=false;
         exit;
        end;

        if RawFreqMax<RawFreqMin then
          begin
             tmp:=RawFreqMax;
             RawFreqMax:=RawFreqMin;
             RawFreqMin:=tmp;
          end;
    end;
end;

end.
