unit Zoom;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, ExtCtrls, StdCtrls, Buttons, Menus;

const
  MaxSignalLen=1024;

type
  SIGNALTABLE=array[1..MaxSignalLen] of single;

  TZoomForm = class(TForm)
    ScrollZoomBox: TScrollBox;
    ZoomImage: TImage;
    procedure CloseZoomButtonClick(Sender: TObject);
    procedure FormZommOnShow(Sender: TObject);
    procedure FormZoomOnPaint(Sender: TObject);
    procedure FormZoomCreate(Sender: TObject);
    procedure SpeedBlockOFFClick(Sender: TObject);
    procedure FormZoomOnKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FormZoomResize(Sender: TObject);
    procedure FormMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure FormMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    
  private
    { Private declarations }
    procedure DrawSek(full : boolean);
    procedure DrawAmpliBar(Scale : single);
  public
    { Public declarations }
    activeZoom : boolean;
    SigLen     : word;
    sig        : SIGNALTABLE;
    BlockON    : boolean;
    sampFreq   : single;
    MinSigLen  : word;
    CalibConst : single;
    zoomInit   : boolean;
    SecBarStat,AmpliBarStat : boolean;
    lastX      : integer;

    procedure DrawSignal;
  end;

var
  ZoomForm: TZoomForm;

implementation

{$R *.DFM}

procedure TZoomForm.CloseZoomButtonClick(Sender: TObject);
begin
 ActiveZoom:=false;
 BlockOn:=false;
 Close;
end;

procedure TZoomForm.DrawSek(full : boolean);
  var
    sekLen,i,n : integer;

begin
  sekLen:=round(sampFreq);
  if sekLen<>0 then
    with ZoomImage,ZoomImage.Canvas do
     begin
      if not full then
        begin
         pen.Color:=clBlue;
         MoveTo(10,10);
         LineTo(10+sekLen,10);
         MoveTo(10,10);
         LineTo(10,5);
         MoveTo(10+sekLen,10);
         LineTo(10+sekLen,5);
         Font.Name:='Times New Roman';
         Font.Size:=8;
         TextOut(10+sekLen div 2,5,'1s');
        end
      else
        begin
          n:=SigLen div sekLen;
          pen.Color:=clBlue;
          MoveTo(10,10);
          LineTo(10+n*SekLen,10);
          Font.Name:='Times New Roman';
          Font.Size:=8;
          for i:=0 to n do
            begin
              pen.Color:=clBlue;
              MoveTo(10+i*SekLen,10);
              LineTo(10+i*SekLen,5);
              pen.Color:=clBlack;
              TextOut(7+i*SekLen,12,IntToStr(i)+'s');
            end;
        end;
       pen.Color:=clBlack;
     end;
end;

procedure TZoomForm.DrawAmpliBar(Scale : single);
 var
   Len : integer;

begin
  Len:=round(75.0*CalibConst*scale);
  with ZoomImage.Canvas,ZoomImage do
    begin
      pen.Color:=clBlue;
      MoveTo(10,20);
      LineTo(10,20+Len);
      MoveTo(10,20);
      LineTo(15,20);
      MoveTo(10,20+Len);
      LineTo(15,20+Len);
      Font.Name:='Times New Roman';
      Font.Size:=8;
      Font.Color:=clRed;
      TextOut(15,16+Len div 2,'75 '+Chr(181)+'V');
      pen.Color:=clBlack;
    end;
end;

procedure TZoomForm.DrawSignal;
  var
    scale,Pmin,Pmax : single;
    i,itmp          : integer;
    MWidth,MHeight  : integer;

begin
  MWidth:=SigLen;
  MHeight:=ScrollZoomBox.Height;
  ScrollZoomBox.HorzScrollBar.Range:=SigLen;

  Pmin:=sig[1];
  Pmax:=Pmin;
  for i:=1 to SigLen do
   begin
     if Pmin>sig[i] then Pmin:=sig[i];
     if Pmax<sig[i] then Pmax:=sig[i];
   end;

   itmp:=MHeight-20;
   if Pmax<>Pmin then
     scale:=(itmp-30)/(Pmax-Pmin)
   else
     scale:=1.0;

   with ZoomImage.Canvas,ZoomImage do
    begin
       brush.Color:=clWhite;
       rectangle(0,0,Width,Height);
       pen.Color:=clBlack;
       MoveTo(20,itmp-round(scale*(sig[1]-Pmin)));
       for i:=1 to SigLen do
         LineTo(20+i,itmp-round(scale*(sig[i]-Pmin)));
    end;

   if SecBarStat then
     DrawSek(BlockOn);
   if AmpliBarStat then
     DrawAmpliBar(Scale);
end;

procedure TZoomForm.FormZommOnShow(Sender: TObject);
begin
  activeZoom:=true;
end;

procedure TZoomForm.FormZoomOnPaint(Sender: TObject);
begin
 if ActiveZoom and ZoomInit then
  DrawSignal;
end;

procedure TZoomForm.FormZoomCreate(Sender: TObject);
  var
    i : integer;

begin
  ActiveZoom:=false;
  ZoomInit:=false;
  BlockOn:=false;
  SigLen:=256; { MaxSignalLen; }
  sampFreq:=1.0;
  CalibConst:=7.0;
  SecBarStat:=true;
  AmpliBarStat:=true;
  lastX:=1;
  for i:=1 to MaxSignalLen do
    sig[i]:=0.0;
end;

procedure TZoomForm.SpeedBlockOFFClick(Sender: TObject);
begin
  BlockOn:=false;
  SigLen:=MinSigLen;
  repaint;
end;

procedure TZoomForm.FormZoomOnKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);

begin                     { 1999 01 27 }
  if Key=VK_ESCAPE then
    CloseZoomButtonClick(Sender)
  else if Key=VK_INSERT then
    begin
      lastX:=1;
      repaint;
    end;
end;

procedure TZoomForm.FormZoomResize(Sender: TObject);
begin
  repaint;
end;

procedure TZoomForm.FormMouseMove(Sender: TObject; Shift: TShiftState; X,
  Y: Integer);
var
  nap,nap2,nap3: string; { Informacje o wartosciach sygnalu 1997 09 28 }
  OldFontColor : TColor; { 1999 01 27 }
  nap4: string;

begin
 if ActiveZoom and ZoomInit then
  with ZoomImage,ZoomImage.Canvas do
    begin
      X:=X-20;
      if (X>=1) and (X<=SigLen) then
        begin
          str(sig[X]:5:0,nap);
          str(X-lastX,nap3);
          if sampFreq<>0.0 then
             str((X-lastX)/sampFreq:5:3,nap4)
          else nap4:='NAN';
          nap:='  ['+nap3+'] '+nap4+' s '+nap;
          if AmpliBarStat and (CalibConst<>0.0) then
            begin
              str(sig[X]/CalibConst:5:2,nap2);
              nap:=nap+'  ('+nap2+' '+chr(181)+'V)       ';
            end
           else nap:=nap+'             ';

          OldFontColor:=Font.Color;
          Font.Color:=clGreen;
          TextOut(120,13,nap);
          Font.Color:=OldFontColor;
        end;
    end;
end;

procedure TZoomForm.FormMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
   X:=X-20;
   if (x>=1) and (x<=SigLen) then
     lastX:=X
    else lastX:=1;
end;

end.
