unit Patient;

interface

uses WinTypes, WinProcs, Classes, Graphics, Forms, Controls, Buttons,
  StdCtrls, ExtCtrls, Dialogs;

type
  TPatientIDDlg = class(TForm)
    OKBtn: TBitBtn;
    CancelBtn: TBitBtn;
    Bevel1: TBevel;
    MemoText: TMemo;
    BitBtn1: TBitBtn;
    BitBtn2: TBitBtn;
    OpenDialog: TOpenDialog;
    SaveDialog: TSaveDialog;
    procedure CancelBtnClick(Sender: TObject);
    procedure OKBtnClick(Sender: TObject);
    procedure BitBtn1Click(Sender: TObject);
    procedure BitBtn2Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    function GetLines(k : integer) : string;
  public
    OK       : boolean;
    MaxLines : word;
  end;

var
  PatientIDDlg: TPatientIDDlg;

implementation

{$R *.DFM}

function TPatientIDDlg.GetLines(k : integer) : string;
begin
  Result:=MemoText.Lines[k];
end;

procedure TPatientIDDlg.CancelBtnClick(Sender: TObject);
begin
  OK:=false;
  Close;
end;

procedure TPatientIDDlg.OKBtnClick(Sender: TObject);
begin
  MaxLines:=MemoText.Lines.Count;
  OK:=true;
  Close;
end;

procedure TPatientIDDlg.BitBtn1Click(Sender: TObject);
begin
   if OpenDialog.Execute then
     MemoText.Lines.LoadFromFile(OpenDialog.FileName);
end;

procedure TPatientIDDlg.BitBtn2Click(Sender: TObject);
begin
   if SaveDialog.Execute then
     MemoText.Lines.SaveToFile(SaveDialog.FileName);
end;

procedure TPatientIDDlg.FormCreate(Sender: TObject);
begin
  MaxLines:=0;
  OK:=false;
end;

end.
