%
%   [PagTag, BlkTag, ChnTag, SecPP, BlkPP] = readtag(filename)
%   
%   version 0.2.2 (1999-11-30/1999-12-01)

function [PagTag, BlkTag, ChnTag, SecPP, BlkPP] = readtag(filename)
id=fopen(filename,'rb','ieee-le');
if id == -1
   error('cant open file');
end

disp(sprintf('\nFilename: %s',filename));

SecPP=fread(id,1,'ushort');
BlkPP=fread(id,1,'ushort');

disp([sprintf('SecPP: %d',SecPP), sprintf(' BlkPP: %d', BlkPP)]);

TagCount(1)=fread(id,1,'short');
TagCount(2)=fread(id,1,'short');
TagCount(3)=fread(id,1,'short');

for i=1:3
   if     (i == 1)
      if (TagCount(1)~=0)
         disp('Page Tags');
      end
   elseif (i == 2)
      if (TagCount(2)~=0)
         disp('Block Tags');
      end
   elseif (i == 3)
      if (TagCount(3)~=0)
         disp('Channel Tags');
      end
   end
   
   for j=1:TagCount(i)
       Tag=fread(id,1,'char');
       string=fread(id,31,'char'); 
       string=string(2:size(string,1));  % Pascal String
       disp([sprintf('%c  ',Tag),sprintf('%c',string)]);
       fread(id,13,'char');              % nil
    end
 end
 
 %
 %  --------------------------- Page Tags --------------------------
 %
  
 Count=fread(id,1,'ushort'); 
 if Count ~= 0
    disp(sprintf('\nPage Tags : %d',Count));
    PagTag=zeros(Count,2);
    
    for i=1:Count
       PagTag(i,1)=fread(id,1,'char');
       PagTag(i,2)=fread(id,1,'ushort');  % Page
    end
 else
    PagTag=zeros(1,2);
 end

 %
 % --------------------------- Block Tags --------------------------
 %
  
 Count=fread(id,1,'ushort');
 if Count ~=0
    disp(sprintf('Block Tags: %d',Count))
    BlkTag=zeros(Count,3);
    for i=1:Count
       BlkTag(i,1)=fread(id,1,'char');
       BlkTag(i,2)=fread(id,1,'ushort'); % Page
       BlkTag(i,3)=fread(id,1,'uchar');  % Block
    end
 else
    BlkTag=zeros(1,3);
 end

 %
 %  -------------------------- Channel Tags ------------------------
 %
 
 Channels=fread(id,1,'uchar');
 if Channels ~= 0
    disp(sprintf('Channels  : %d\nChannel Tags',Channels))
    ChnCount=zeros(Channels,1);
    
    for i=1:Channels
       ChnCount(i)=fread(id,1,'ushort');
       disp(sprintf('[%2d] %d',i,ChnCount(i)));
    end
    
    k=1;
    ChnTag=zeros(sum(ChnCount),4);
    for i=1:Channels
       for j=1:ChnCount(i)
          ChnTag(k,1)=i;
          ChnTag(k,2)=fread(id,1,'char');
          ChnTag(k,3)=fread(id,1,'int32');  % Offset
          ChnTag(k,4)=fread(id,1,'ushort'); % Length
          k=k+1;
       end
    end
  else
     ChnTag=zeros(1,4);
  end
  
  fclose(id);
  
     





