%
% savetag(filename,tagDef,tagTable, [validate])
%
% version 0.1.4 (1999-12-01/04)

function savetag(filename, tagDef, tagTable, valflag) 
if nargin<3
   error('savetag(filename,tagDef,tagTable, [validate])');
   return;
end

if (size(tagDef,2)~=38) | (size(tagTable,2)~=5)
   error('bad matrix dimension');
   return;
end

if nargin==4
   if valflag>0
      code=validatetag(tagDef, tagTable);
      if (code<0)
         error(sprintf('validate error code: %d',code));
         return;
      end
   end
end

MaxTagPag=21840;           %
MaxTagBlk=16380;           % ograniczenie na liczbe tagow. 
MaxTagChn=9360;            %

PageTag =1;                % 
BlockTag=2;                % oznaczenia rodzajaow tagow.
ChnTag  =3;                %

SecPP=tagDef(1,2);         %
BlkPP=tagDef(1,3);         % tagDef - definicje tagow.
Channels=tagDef(1,4);      % 

PagTagCount=sum(tagTable(:,1)==PageTag);
if (PagTagCount>=MaxTagPag)
   error('za duzo tagow typu: Page');
   return;
end

BlkTagCount=sum(tagTable(:,1)==BlockTag);
if (BlkTagCount>=MaxTagBlk)
   error('za duzo tagow typu: Block');
   return;
end

if Channels > 0
   ChnTagNumber=zeros(Channels,1);
   for i=1:Channels
      ChnTagNuber(i)=sum((tagTable(:,1)==ChnTag) & (tagTable(:,2)==i));
      if (ChnTagNuber(i)>=MaxTagChn)
         error('za duzo tagow typu: Channels');
         return;
      end
   end
   ChnTagCount=sum(ChnTagNumber);
else
   ChnTagCount=0;
end

%
% ---------------------- WriteTTagHDRCount --------------------------
%

id=fopen(filename,'wb','ieee-le');
if (id==-1)
   error('cant open file');
   return;
end

fwrite(id, SecPP, 'ushort');
fwrite(id, BlkPP, 'ushort');

PagDefTagCount=sum(tagDef(:,1) == PageTag);
BlkDefTagCount=sum(tagDef(:,1) == BlockTag);
ChnDefTagCount=sum(tagDef(:,1) == ChnTag);

fwrite(id, PagDefTagCount, 'short');
fwrite(id, BlkDefTagCount, 'short');
fwrite(id, ChnDefTagCount, 'short');

%
% ----------------------- Save Tag Def.  ---------------------------
%

numOfTagsDef=size(tagDef,1);
if PagDefTagCount>0
   for i=2:numOfTagsDef
      if tagDef(i, 1) == PageTag
         write_tag_rec(id,tagDef(i,:));   
      end
   end
end

if BlkDefTagCount>0
   for i=2:numOfTagsDef
      if tagDef(i, 1) == BlockTag 
         write_tag_rec(id,tagDef(i,:));
      end
   end
end

if ChnDefTagCount>0
   for i=2:numOfTagsDef
      if tagDef(i, 1) == ChnTag 
         write_tag_rec(id,tagDef(i,:));
      end
   end
end

%
% ------------------- Save Tags: Page  ---------------------------
%

fwrite(id, PagTagCount, 'ushort');
Tags=tagTable(find(tagTable(:,1)==PageTag),:);
if (needsorttags(Tags(:,3))==1)
   [X,idx]=sort(Tags(:,3));
else
   idx=1:size(Tags,1);
end

for i=1:PagTagCount
   JJ=idx(i);
   fwrite(id, Tags(JJ,2), 'char');
   fwrite(id, Tags(JJ,3), 'ushort');
end

%
% ------------------- Save Tags: Block  --------------------------
%

fwrite(id, BlkTagCount, 'ushort');
Tags=tagTable(find(tagTable(:,1)==BlockTag),:);
tmp=BlkPP*Tags(:,3)+Tags(:,4);
if (needsorttags(tmp)==1)
   [X, idx]=sort(tmp);
else
   idx=1:size(Tags,1);
end

for i=1:BlkTagCount
   JJ=idx(i);
   fwrite(id, Tags(JJ,2), 'char');
   fwrite(id, Tags(JJ,3), 'ushort');
   fwrite(id, Tags(JJ,4), 'uchar');
end

%
% ------------------- Save Tags: Channels ------------------------
%

fwrite(id, Channels, 'uchar');
for i=1:Channels
   fwrite(id, ChnTagNuber(i), 'ushort');
end

for i=1:Channels
   if ChnTagNuber(i) > 0 
      Tags=tagTable(find((tagTable(:,1)==ChnTag) & (tagTable(:,2)==i)),:);
      if (needsorttags(Tags(:,3))==1)
         [X,idx]=sort(Tags(:,3));
      else
         idx=1:size(Tags,1);
      end
      
      for j=1:ChnTagNuber(i)
         JJ=idx(j);
         fwrite(id, Tags(JJ,3), 'char');
         fwrite(id, Tags(JJ,4), 'int32');
         fwrite(id, Tags(JJ,5), 'ushort');
      end
   end
end

fclose(id);

