%
% Demo:      tagdemo()
%
% (1999-11-30)

function tagdemo()
[PagTag, BlkTag, ChnTag, SecPP, BlkPP] = readtag('example.tag');
figure(1);

AVR=8;
subplot(2,1,1);
if AVR ~= 1
  maxT=floor(max(PagTag(:,2))/AVR)-1;
else
  maxT=size(PagTag,1);
end


k=(AVR*SecPP/3600.0);
T=(1:maxT).*k;

h=hipno(PagTag,AVR);
stairs(T,h);
hold on;
hh=find(h==4);
for i=1:size(hh,1)
   line([T(1,hh(i)), T(1,hh(i))+k], [3.85, 3.85]);
end   
hold off;
set(gca,'ylim', [-1 9]);
set(gca,'ytick', [1 2 3 4 5 6 7]);
set(gca,'yticklabel',[' IV';'III'; ' II';'REM';' I ';' w ';' m ']);


title('Hypnogram');
%xlabel('[h]');
%ylabel('stages');

subplot(2,1,2);
raw_hipno=hipno(PagTag);

bar(0:7, hist(raw_hipno,[0,1,2,3,4,5,6,7]));
set(gca,'xticklabel',['   ';' IV';'III'; ' II';'REM';' I ';' w ';' m ';'   ']);

hold on;

maxT=min([max(BlkTag(:,2)), max(PagTag(:,2))]);
stage=zeros(8,1);

for i=1:size(BlkTag,1)
  idx=BlkTag(i,2);
  if idx<maxT
    s=raw_hipno(idx)+1;
    stage(s)=stage(s)+1;
  end
end

for i=1:8
  if raw_hipno ~= 0
    stage(i)=stage(i)/raw_hipno(i);
  else
    stage(i)=0;
  end
end

bar(0:7,stage,'r');
title('stages time / artifacts (red)');

