%
% [tagDefOutOut, tagsOut]=addtagDef(tagDef, Type, Tag [, Comment] [, options])
%
%

function tagDefOut=addtagDef(tagDef, Type, Tag, Comment, options)
if (nargin<3)
   error('addtagDefOut(tagDefOut, Type, Tag [, Commnet] [, options])');
   return;
end

if (size(tagDef,1)<1 | size(tagDef,2)~=38)
   error('bad matrix format use inittagDefOut');
   return;
end

TagHintLen=30;
index=size(tagDef,1)+1;  

tagDefOut=zeros(index,38);
tagDefOut(1:index-1,:)=tagDef(1:index-1,:);

tagDefOut(index, 1)=Type;
tagDefOut(index, 2)=Tag;

if (nargin>=4)
   def=abs(Comment);
   len=min(TagHintLen, size(def,2));
   if (len~=0)
      for i=1:len
         tagDefOut(index,3+i)=def(i);
      end
    end
 else
    def=abs('Tag generated by Matlab (C)');
    len=size(def,2);
    for i=1:len
       tagDefOut(index,2+i)=def(i);
    end
 end
 
 opt=zeros(6,1);
 opt(1)=settagcolor('clWhite');       % BColor 
 opt(2)=settagbrush('bsClear');       % Bstyle
 opt(3)=settagcolor('clWhite');       % PColor
 opt(4)=settagmode('pmNop');          % PMode
 opt(5)=settagstyle('psClear');       % PStyle
 opt(6)=1;                            % PWidth
 
 if(nargin==5)
    len=min(size(options,1), 6);
    opt(1:len)=options(1:len);
  end
  
  for i=1:6
     tagDefOut(index,32+i)=opt(i);
  end
  
  tagDefOutOut=tagDefOut;
  
  



