%
% hip=hipno(PageTag,[avr])
%
% version 0.1 (1999-11-30)

function hip=hipno(PagTag,avr)
  raw_hip=zeros(max(PagTag(:,2)),1);
  tagSize=size(PagTag,1);

  for i=1:tagSize
    stage=PagTag(i,1);
    if     stage==77 | stage==109  % MUSC
      s=7; 
    elseif stage==87 | stage==119  % WAKE  
      s=6;
    elseif stage==49               % STADIUM I
      s=5;
    elseif stage==82 | stage==114  % REM
      s=4;
    elseif stage==50               % STADIUM II
      s=3;
    elseif stage==51               % STADIUM III
      s=2;
    elseif stage==52               % STADIUM IV
      s=1;
    else
      s=0;
    end
    raw_hip(PagTag(i,2))=s;
  end

  if nargin == 2                    % opcjonalnie wsrednienie 
    newTagSize=floor(size(raw_hip,1)/avr)-1;

    if avr ~= 1 & newTagSize>1
      hip=zeros(newTagSize,1);
      maxStages=8;

      for i=1:newTagSize
	T=avr*(i-1)+1;
	Count=zeros(maxStages,1);
	for j=T:T+avr-1
	  value=raw_hip(j)+1;
	  Count(value)=Count(value)+1;
	end
	
	maxi=Count(1);
	maxidx=1;
	for j=2:maxStages
	  if Count(j)>maxi          % ? interpretacja rownej ilosci stadiow ? 
	    maxi=Count(j);
	    maxidx=j;
	  end
	end
	hip(i)=maxidx-1;
      end
      return;
    end
    disp('WARING ! function hipno: averg. off');
  end
    
  hip=raw_hip;

