%
% [tagDef, tags]=sleeptags(SecPP, BlkPP, maxChn)
%
% version 0.1.1 (1999-12-01)

function [tagDef, tags]=sleeptags(SecPP_, BlkPP_, maxChn)
PageTag =1;                 
BlockTag=2;               

if (nargin>=1)
   SecPP=SecPP_;
   BlkPP=8;
   Channels=1;
elseif (nargin>=2)
   SecPP=SecPP_;
   BlkPP=BlkPP_;
   Channels=1;
elseif (nargin>=3)
   SecPP=SecPP_;
   BlkPP=BlkPP_;
   Channels=maxChn;
else
   SecPP=20;
   BlkPP=8;
   Channels=1;
end

[tagDef, tags]=inittagdef(SecPP,BlkPP,Channels);

tagDef=addtagdef(tagDef, PageTag, 'w', 'WAKE');
tagDef=addtagdef(tagDef, PageTag, 'm', 'MUSC');
tagDef=addtagdef(tagDef, PageTag, 'r', 'REM');
tagDef=addtagdef(tagDef, PageTag, '1', 'STADIUM I');
tagDef=addtagdef(tagDef, PageTag, '2', 'STADIUM II');
tagDef=addtagdef(tagDef, PageTag, '3', 'STADIUM III');
tagDef=addtagdef(tagDef, PageTag, '4', 'STADIUM IV');

opt=zeros(6,1);
opt(1)=settagcolor('clGray');        % BColor 
opt(2)=settagbrush('bsSolid');       % Bstyle
opt(3)=settagcolor('clGray');        % PColor
opt(4)=settagmode('pmCopy');          % PMode
opt(5)=settagstyle('psSolid');       % PStyle
opt(6)=1;                            % PWidth

tagDef=addtagdef(tagDef, BlockTag,'a', 'atrifact',opt);



