/* 1999 07 25 
   1999 10 24
 */

import java.awt.*;
import java.net.*;
import java.awt.event.*;
import javax.swing.*;

public class FileFromURLDialog extends JDialog implements ActionListener {
    private JTextField   urlname;
    private JButton      setButton,cancelButton;
    private URL         url;

    FileFromURLDialog(String title) {
        super(new JFrame(),true);
     
	setTitle(title);
	JPanel p1  =new JPanel();
	JPanel plab=new JPanel();
	JPanel purl=new JPanel();
	
	p1.setLayout(new FlowLayout(FlowLayout.LEFT));
        JLabel labelurl=new JLabel(" Enter complete URL "+
				 "(e.g.: http://yourURL/FileName)"+
				 " if from WWW or ");
        p1.add("North",labelurl);
	labelurl=new JLabel(" directory (e.g.: file:/yourDirectory/"+
			   "yourFileName) if from file. Good luck!! ");
	p1.add("North",labelurl);
        urlname=new JTextField(32);
	urlname.addActionListener(this);
        p1.add("Center",urlname);
        getContentPane().add("Center", p1);

        JPanel p2 =new JPanel();
        p2.setLayout(new FlowLayout(FlowLayout.RIGHT));
        cancelButton=new JButton("Cancel");
	cancelButton.addActionListener(this);
	p2.add(cancelButton);

        setButton=new JButton("OK");
	setButton.addActionListener(this);
	p2.add(setButton);
        getContentPane().add("South", p2);
	pack();
	setVisible(true);
    }

    public final URL getURL() {
	return url;
    }

    public void actionPerformed(ActionEvent evt) {
	Object object=evt.getSource();
	if(object==setButton || object==urlname) {
	    try {
		url=new URL(urlname.getText());
	    } catch(MalformedURLException e) {
		setVisible(false);
		dispose();
		urlname.removeActionListener(this);
		setButton.removeActionListener(this); // ?? 
		new WaringMessageDialog("Bad URL !");
		url=null;
		return;
	    } 
	    setVisible(false);
	    dispose();
	} else if(object==cancelButton) {
	    setVisible(false);
	    dispose();
	    url=null;
	}
    }
    
     public Dimension getMinimumSize() {
	 return new Dimension(640,150);
     }

    public Dimension getPreferredSize() {
	return getMinimumSize();
    }   
} 
