/* 1999 07 27 */

import java.awt.*;
import java.awt.image.*;
import javax.swing.*;

class InitImage extends Canvas {
    InitImage(String s) {
        Toolkit toolkit=Toolkit.getDefaultToolkit();
        try {
            java.net.URL url=ClassLoader.getSystemResource(s);
            image=toolkit.getImage(url);
            prepareImage(image, this);
            return;
        } catch(Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean imageUpdate(Image image1, int i, int j, 
			       int k, int l, int i1) {
	try {
        if((i & 0xc0) != 0) {
            synchronized(this) {
                image = null;
                loaded = true;
                notify();
            }
            return false;
        }

        boolean flag = false;
        int j1 = 0;
        int k1 = 0;
        if((i & 0x1) != 0) {
            j1 = l;
            flag = true;
        }
        if((i & 0x2) != 0) {
            k1 = i1;
            flag = true;
        }
        if(flag)
            setSize(j1, k1);
        if((i & 0x20) != 0)
            synchronized(this) {
                loaded = true;
                Graphics g = getGraphics();
		try {
		    paint(g);
		    getToolkit().sync();
		    notify();
		} catch(Exception e) { ; } finally {
		    g.dispose();
		}
	    }
	} catch(Exception e) {
	    ;
	}
        return true;
    }
    
    public void setSize(int i, int j) {
        super.setSize(i, j);
        Container container = getParent();
        Insets insets = container.getInsets();
        container.setSize(i + insets.left + insets.right, j + 
			  insets.top + insets.bottom);
    }
    
    public void update(Graphics g) {
        paint(g);
    }

    public void paint(Graphics g) {
        if(g==null)
            return;
        if(image!=null && loaded) {
	    g.drawImage(image, 0, 0, null);
            return;
        }
        if(image == null && loaded) {
            if(emergencyFont == null)
                emergencyFont = new Font("SansSerif", 1, 30);
            g.setFont(emergencyFont);
            g.drawString("Launching Viewer...", 35, 175);
        }
    }

    synchronized void waitTillLoaded() {
        while(!loaded) {
            try {
                wait();
            } catch(Exception _ex) { }
	}
    }
    
    private Image   image;
    private boolean loaded;
    private Font    emergencyFont;
}

public class InitFrame extends JWindow {
    public InitFrame() {
        super(new JFrame());
        setSize(splashWidth,splashHeight);
        image=new InitImage(splashImagePath);
        getContentPane().add("Center", image);
        Dimension dimension=Toolkit.getDefaultToolkit().getScreenSize();
        setLocation(dimension.width/2-splashWidth/2,
		    dimension.height/2-splashHeight/2);
    }
    
    public void waitTillLoaded() {
        image.waitTillLoaded();
    }
    
    private static final String splashImagePath="logo.jpg";
    private static final int splashWidth=302;
    private static final int splashHeight=318;
    private InitImage image;
}







