/* 1999 10 30 */

import java.io.*;
import java.awt.event.*;
import java.awt.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import java.text.*;

class SignalViewer extends JPanel {
    private static final int XMARGIN=10,YMARGIN=10; 
    private double signal[]; 
    private int    y[]=null;

    public SignalViewer(double sig[],String title) {
	super();
	setBorder(BorderFactory.createTitledBorder(title));
	signal=sig;
    }

    public void paintComponent(Graphics g) {
	super.paintComponent(g); 
	drawSignal(g);
    }

    // do wymiany 

    private double []decimate(double sig[],int size) {
	double dec[]=new double[size];
	int oldsize=sig.length,i;
	double dx=(oldsize-1)/(double)(size-1);

	for(i=0 ; i<size ; i++)
	    dec[i]=sig[(int)(dx*i)];
	    
	return dec;
    }

    public void setSignal() {
	double min,max;
	int i,size=signal.length;

	Dimension dim=getSize();
	int height=dim.height,width=dim.width,maxh=height-YMARGIN,
	    fsize=width-2*XMARGIN;
	double dx=(fsize-1)/(double)(size-1);
		
	y=new int[fsize];
	double s[]=decimate(signal,fsize);
	
	min=max=s[0];
	for(i=1 ; i<fsize ; i++) {
	    if(min>s[i]) min=s[i];
	    if(max<s[i]) max=s[i];
	}
	
	double dy=(min!=max) ? (height-2*YMARGIN)/(max-min) : 1.0;
	for(i=0 ; i<fsize ; i++) 
	    y[i]=maxh-(int)(dy*(s[i]-min));
    }

    private void drawSignal(Graphics gDC) {
	if(y!=null) {
	    gDC.setColor(Color.blue);
	    int size=y.length-1,off;
	    for(int i=0 ; i<size ; i++) {
		off=XMARGIN+i;
		gDC.drawLine(off,y[i],off+1,y[i+1]);
	    }
	}
    }
}

public class SignalBuilder extends JDialog implements ActionListener {
    private static final int GABOR=1,FOURIER=2,DIRAC=3,NOISE=4;
    private int          sigSize;
    private double       signal[],newSignal[];
    private SignalViewer sigView,newSig;
    private JButton      OkButton,CancelButton,AddButton,ResetButton;
    private JPanel       ControlPanel,ActivePanel;
    private int          Mode=GABOR;
    private boolean      OK=false;

    public boolean isOK() {
	return OK;
    }

    public double []getSignal() {
	double sig[]=new double[sigSize];
	for(int i=0 ; i<sigSize ; i++)
	    sig[i]=signal[i];
	return sig;
    }

    public SignalBuilder(int size) {
	super(new JFrame(),"Signal Builder",true);
	sigSize=size;
	signal=new double[sigSize];
	newSignal=new double[sigSize];

	for(int i=0 ; i<sigSize ; i++)
	    newSignal[i]=signal[i]=0.0;

	setSize(540,520);
	setResizable(false);
	getContentPane().setLayout(null);

	sigView=new SignalViewer(signal,"Signal");
	sigView.setBounds(5,10,520,128);
	sigView.setSignal();
	getContentPane().add(sigView);

	newSig=new SignalViewer(newSignal,"Component");
	newSig.setBounds(5,140,520,128);
	getContentPane().add(newSig);

	OkButton=new JButton("Ok");
	OkButton.addActionListener(this);
	OkButton.setFont(new Font("Dialog",Font.BOLD,10));
	OkButton.setBounds(5,290,95,30);
	OkButton.setForeground(new Color(0,128,0));
	getContentPane().add(OkButton);

	CancelButton=new JButton("Cancel");
	CancelButton.addActionListener(this);
	CancelButton.setFont(new Font("Dialog",Font.BOLD,10));
	CancelButton.setBounds(5,290+35,95,27);
	CancelButton.setForeground(new Color(228,0,0));
	getContentPane().add(CancelButton);

	ResetButton=new JButton("Reset");
	ResetButton.addActionListener(this);
	ResetButton.setFont(new Font("Dialog",Font.BOLD,10));
	ResetButton.setBounds(5,290+2*35,95,27);
	ResetButton.setForeground(new Color(228,0,0));
	getContentPane().add(ResetButton);

	AddButton=new JButton("Add");
	AddButton.addActionListener(this);
	AddButton.setFont(new Font("Dialog",Font.BOLD,10));
	AddButton.setBounds(5,290+3*35,95,27);
	getContentPane().add(AddButton);

	ControlPanel=new JPanel();
	ControlPanel.setBounds(120,285,400,64);
	ControlPanel.setBorder(BorderFactory.createTitledBorder("Type"));

	JRadioButton b;
	ButtonGroup  group=new ButtonGroup();

	b=(JRadioButton)ControlPanel.add(new JRadioButton("Gabor"));
	b.setSelected(true);
	b.addActionListener(borderedPaneListener);
	group.add(b);

	b=(JRadioButton)ControlPanel.add(new JRadioButton("Fourier"));
	b.addActionListener(borderedPaneListener);
	group.add(b);

	b=(JRadioButton)ControlPanel.add(new JRadioButton("Dirac"));
	b.addActionListener(borderedPaneListener);
	group.add(b);

	b=(JRadioButton)ControlPanel.add(new JRadioButton("Noise"));
	b.addActionListener(borderedPaneListener);
	group.add(b);
	getContentPane().add(ControlPanel);

	ActivePanel=new JPanel();
	ActivePanel.setBounds(120,285+64,400,128);
	ActivePanel.setBorder(BorderFactory.createTitledBorder("Parameters"));
	ActivePanel.setLayout(null);
	getContentPane().add(ActivePanel);

	setGaborPanel();
    }
    
    ActionListener borderedPaneListener = new ActionListener() {
	public void actionPerformed(ActionEvent e) {
	    JRadioButton b=(JRadioButton)e.getSource();
	    if(b.getText().equals("Gabor")) {		
		ActivePanel.removeAll();
		reset();
		setGaborPanel();
	    } else if(b.getText().equals("Fourier")) {
		ActivePanel.removeAll();
		reset();
		setFourierPanel();
	    } else if(b.getText().equals("Dirac")) {
		ActivePanel.removeAll();
		reset();
		setDiracPanel();
	    } else if(b.getText().equals("Noise")) {
		ActivePanel.removeAll();
		reset();
		setNoisePanel();
	    }
	    
	    System.gc();
	    ActivePanel.invalidate();
	    ActivePanel.repaint();
	}
    };

    private JTextField ampField,freqField,posField,scaField,phaField;
    private JSlider    freqSlider,posSlider,scaSlider,phaSlider;
    private double     gab_amp,gab_freq,gab_pos,gab_scale,gab_phase;

    private String formatNumber(double x) {
	NumberFormat format=new DecimalFormat();
	format.setMaximumFractionDigits(4);
	return format.format(x);
    }

    private double SQR(double x) {
	return x*x;
    }

    private void drawGabor() {
	gab_amp=Double.parseDouble(ampField.getText().trim());
	double freq=gab_freq*2.0*Math.PI;

	for(int i=0 ; i<sigSize ; i++)
	    newSignal[i]=gab_amp*Math.exp(-Math.PI*SQR((i-gab_pos)/gab_scale))*
		Math.cos(freq*(i-gab_pos)+gab_phase);
	
	newSig.setSignal();
	newSig.repaint();
    }

    private void drawFourier() {
	gab_amp=Double.parseDouble(ampField.getText().trim());
	double freq=gab_freq*2.0*Math.PI;
	int pos=sigSize/2;

	for(int i=0 ; i<sigSize ; i++)
	    newSignal[i]=gab_amp*Math.cos(freq*(i-pos)+gab_phase);
	
	newSig.setSignal();
	newSig.repaint();
    }

    private void drawDirac() {
	for(int i=0 ; i<sigSize ; i++)
	    newSignal[i]=0.0;
	newSignal[(int)gab_pos]=gab_amp=Double.parseDouble(ampField.getText().trim());

	newSig.setSignal();
	newSig.repaint(); 
    }

    private void drawNoise() {
	gab_amp=Double.parseDouble(ampField.getText().trim());
	for(int i=0 ; i<sigSize ; i++)
	    newSignal[i]=gab_amp*Gauss();
	
	newSig.setSignal();
	newSig.repaint(); 
    }
    
    private class SliderListener implements ChangeListener {
	public void stateChanged(ChangeEvent e) {
	    JSlider s=(JSlider)e.getSource();
	    int     v=s.getValue();

	    switch(Mode) {
	    case GABOR:
		if(s==freqSlider) {
		    freqField.setText(formatNumber(gab_freq=v/(float)sigSize));
		} else if(s==posSlider) {
		    posField.setText(formatNumber(gab_pos=v));
		} else if(s==scaSlider) {
		    scaField.setText(formatNumber(gab_scale=v));
		} else if(s==phaSlider) {
		    phaField.setText(formatNumber(gab_phase=0.02*Math.PI*v));
		}
		drawGabor();
		break;
	    case FOURIER:
		if(s==freqSlider) {
		    freqField.setText(formatNumber(gab_freq=v/(float)sigSize));
		} else if(s==phaSlider) {
		    phaField.setText(formatNumber(gab_phase=0.02*Math.PI*v));
		}
		drawFourier();
		break;
	    case DIRAC:
		if(s==posSlider) 
		    posField.setText(formatNumber(gab_pos=v));
		drawDirac();
		break;
	    }
	}
    }

    private void reset() {
	ampField=null; freqField=null; posField=null; scaField=null;
	phaField=null; freqSlider=null; posSlider=null; scaSlider=null; 
	phaSlider=null;
    }

    private void setGaborPanel() {
	Mode=GABOR;
	gab_amp=1.0;
	gab_phase=0.0;
	gab_scale=sigSize/2;
	gab_freq=0.1;
	gab_pos=sigSize/2;

	JLabel label=new JLabel("Amplitude");
	SliderListener listener=new SliderListener();

	label.setBounds(10,20,120,20);
	ActivePanel.add(label);

	ampField=new JTextField(formatNumber(gab_amp));
	ampField.setBounds(135,20,60,20);
	ampField.addActionListener(this);
	ActivePanel.add(ampField);

	label=new JLabel("Frequency");
	label.setBounds(10,20+20,120,20);
	ActivePanel.add(label);

	freqField=new JTextField(formatNumber(gab_freq));
	freqField.setBounds(135,20+20,60,20);
	freqField.setEditable(false);
	freqField.addActionListener(this);
	ActivePanel.add(freqField);
	
	freqSlider=new JSlider(JSlider.HORIZONTAL,0,sigSize/2,
			       (int)(sigSize*gab_freq/2.0));
	freqSlider.setBounds(135+70,20+20,180,20);
	freqSlider.setPaintTicks(true);
	freqSlider.addChangeListener(listener);
	ActivePanel.add(freqSlider);
	
	label=new JLabel("Position");
	label.setBounds(10,20+2*20,120,20);
	ActivePanel.add(label);

	posField=new JTextField(formatNumber(gab_pos));
	posField.setBounds(135,20+2*20,60,20);
	posField.addActionListener(this);
	posField.setEditable(false);
	ActivePanel.add(posField);

	posSlider=new JSlider(JSlider.HORIZONTAL,0,sigSize,sigSize/2);
	posSlider.setBounds(135+70,20+2*20,180,20);
	posSlider.setPaintTicks(true);
	posSlider.addChangeListener(listener);
	ActivePanel.add(posSlider);

	label=new JLabel("Scale");
	label.setBounds(10,20+3*20,120,20);
	ActivePanel.add(label);

	scaField=new JTextField(formatNumber(gab_scale));
	scaField.setBounds(135,20+3*20,60,20);
	scaField.addActionListener(this);
	scaField.setEditable(false);
	ActivePanel.add(scaField);

	scaSlider=new JSlider(JSlider.HORIZONTAL,0,sigSize,sigSize/2);
	scaSlider.setBounds(135+70,20+3*20,180,20);
	scaSlider.setPaintTicks(true);
	scaSlider.addChangeListener(listener);
	ActivePanel.add(scaSlider);

	label=new JLabel("Phase");
	label.setBounds(10,20+4*20,120,20);
	ActivePanel.add(label);

	phaField=new JTextField(formatNumber(gab_phase));
	phaField.setBounds(135,20+4*20,60,20);
	phaField.addActionListener(this);
	phaField.setEditable(false);
	ActivePanel.add(phaField);

	phaSlider=new JSlider(JSlider.HORIZONTAL,0,100,0);
	phaSlider.setBounds(135+70,20+4*20,180,20);
	phaSlider.setPaintTicks(true);
	phaSlider.addChangeListener(listener);
	ActivePanel.add(phaSlider);
	drawGabor();
    }
    
    private void setFourierPanel() {
	Mode=FOURIER;
	gab_amp=1.0;
	gab_phase=0.0;
	gab_freq=0.1;
	
	JLabel label=new JLabel("Amplitude");
	SliderListener listener=new SliderListener();

	label.setBounds(10,20,120,20);
	ActivePanel.add(label);

	ampField=new JTextField(formatNumber(gab_amp));
	ampField.setBounds(135,20,60,20);
	ampField.addActionListener(this);
	ActivePanel.add(ampField);

	label=new JLabel("Frequency");
	label.setBounds(10,20+20,120,20);
	ActivePanel.add(label);

	freqField=new JTextField(formatNumber(gab_freq));
	freqField.setBounds(135,20+20,60,20);
	freqField.addActionListener(this);
	freqField.setEditable(false);
	ActivePanel.add(freqField);
	
	freqSlider=new JSlider(JSlider.HORIZONTAL,0,sigSize/2,
			       (int)(sigSize*gab_freq/2.0));
	freqSlider.setBounds(135+70,20+20,180,20);
	freqSlider.setPaintTicks(true);
	freqSlider.addChangeListener(listener);
	ActivePanel.add(freqSlider);
	
	label=new JLabel("Phase");
	label.setBounds(10,20+2*20,120,20);
	ActivePanel.add(label);

	phaField=new JTextField(formatNumber(gab_phase));
	phaField.setBounds(135,20+2*20,60,20);
	phaField.addActionListener(this);
	ActivePanel.add(phaField);

	phaSlider=new JSlider(JSlider.HORIZONTAL,0,100,0);
	phaSlider.setBounds(135+70,20+2*20,180,20);
	phaSlider.setPaintTicks(true);
	phaField.setEditable(false);
	phaSlider.addChangeListener(listener);
	ActivePanel.add(phaSlider);
	drawFourier();
    }

    private void setDiracPanel() {
	Mode=DIRAC;
	gab_amp=1.0;
	gab_pos=sigSize/2;

	JLabel label=new JLabel("Amplitude");
	SliderListener listener=new SliderListener();

	label.setBounds(10,20,120,20);
	ActivePanel.add(label);

	ampField=new JTextField(formatNumber(gab_amp));
	ampField.setBounds(135,20,60,20);
	ampField.addActionListener(this);
	ActivePanel.add(ampField);

	label=new JLabel("Position");
	label.setBounds(10,20+20,120,20);
	ActivePanel.add(label);

	posField=new JTextField(formatNumber(gab_pos));
	posField.setBounds(135,20+20,60,20);
	posField.addActionListener(this);
	posField.setEditable(false);
	ActivePanel.add(posField);

	posSlider=new JSlider(JSlider.HORIZONTAL,0,sigSize,sigSize/2);
	posSlider.setBounds(135+70,20+20,180,20);
	posSlider.setPaintTicks(true);
	posSlider.addChangeListener(listener);
	ActivePanel.add(posSlider);

	drawDirac();
    }

    private double Gauss() {
	double v1=Math.random(),v2=Math.random();
	if(v1==0.0) 
	    v1+=1.0e-10;
	else if(v1==1.0) 
	    v1-=1.0e-10;
	if(v2==0.0) 
	    v2+=1.0e-10;
	else if(v2==1.0) 
	    v2-=1.0e-10;
	return Math.sqrt(-2.0*Math.log(v1))*Math.cos(2.0*Math.PI*v2);
    }

    private void setNoisePanel() {
	Mode=NOISE;
	gab_amp=1.0;

	JLabel label=new JLabel("Sigma");
	label.setBounds(10,20,120,20);
	ActivePanel.add(label);
	ampField=new JTextField(formatNumber(gab_amp));
	ampField.setBounds(135,20,60,20);
	ampField.addActionListener(this);
	ActivePanel.add(ampField);
	
	drawNoise();
    }

    public void actionPerformed(ActionEvent event) {
	Object evt=event.getSource();
	if(evt==OkButton) {
	    setVisible(false);
	    dispose();
	    OK=true;
	} else if(evt==CancelButton) {
	    setVisible(false);
	    dispose();
	    OK=false;
	} else if(evt==AddButton) {
	    for(int i=0 ; i<sigSize ; i++)
		signal[i]+=newSignal[i];

	    sigView.setSignal();
	    sigView.repaint();
	} else if(evt==ResetButton) {  
	    for(int i=0 ; i<sigSize ; i++)
		signal[i]=0.0;
	    
	    sigView.setSignal();
	    sigView.repaint();
	} else {
	    switch(Mode) {
	    case GABOR:
		gab_amp=Double.parseDouble(ampField.getText().trim());
		gab_freq=Double.parseDouble(freqField.getText().trim());
		gab_pos=Double.parseDouble(posField.getText().trim());
		gab_scale=Double.parseDouble(scaField.getText().trim());
		gab_phase=Double.parseDouble(phaField.getText().trim());
		drawGabor();
		break;
	    case FOURIER:
		gab_amp=Double.parseDouble(ampField.getText().trim());
		gab_freq=Double.parseDouble(freqField.getText().trim());
		gab_phase=Double.parseDouble(phaField.getText().trim());
		drawFourier();
		break;
	    case DIRAC:
		gab_amp=Double.parseDouble(ampField.getText().trim());
		gab_pos=Double.parseDouble(posField.getText().trim());
		drawDirac();
		break;
	    case NOISE:
		gab_amp=Double.parseDouble(ampField.getText().trim());
		drawNoise();
		break;
	    }
	}
    }
} 






