/* 1999 08 18 */

import java.util.Date;
import java.net.*;
import java.io.*;

public class WignerMap {
  public float Map[][]=null,NormMap[][]=null;
  private double TimeAxis[]=null;
  private double FreqAxis[]=null;
  public int SizeX,SizeY;
  private int Start,Stop,DimBase;
  private static final double EPS=1.0e-13;
  private static final double PI2M=2.0*Math.PI;
  private double minT,maxT,minF,maxF,ATime,BTime,AFreq,BFreq;
  private double minVal=0.0,maxVal=0.0,signal[]=null,SamplingFreq=1.0;
  private float  reconst[][]=null;
  private double ReconstSignal[]=null;;
  public FilterBookLibrary book=null;
  private double FreqMin=0.0,FreqMax=1.0,RBot;
  private boolean AvergMode=false;
  private int ProfileFreqNo=-1;
  private boolean mask[]=null;
  private int Count;

  public final int getMaxOffset() {
      return book.getMaxBookNumber();
  }

  public final double getMinFreq() {
      return FreqMin;
  }

  public final double getMaxFreq() {
      return FreqMax;
  }

  public final double getSignalValue(int k) {
      if(signal==null || k>=DimBase) 
	  return 0.0;
      return signal[k];
  }

  public final double getReconstValue(int k) {
      if(ReconstSignal==null || k>=DimBase || Count==0) 
	  return 0.0;
      return ReconstSignal[k];
  }
 
  public final boolean getAvergMode() {
    return AvergMode;
  }

  private float Round(double val) {
    return (float)Math.floor(val*100.0+0.5)/100.0F;
  }
  
  public final float getValue(int x,int y) {
    if(Map==null) return 0.0F;
    if(x>=0 && x<SizeX && y>=0 && y<SizeY) {
      if(Math.abs(minVal-maxVal)<=EPS)
	return 0.0F;
      return (float)(100.0*(Map[x][y]-minVal)/(maxVal-minVal));
    }
    return 0.0F;
  }

  public String getProfileFreq() {
    if(ProfileFreqNo>=0) {
      double df=SamplingFreq/DimBase,minFreq=df*minF,maxFreq=df*maxF;
      return Round(minFreq+(maxFreq-minFreq)*ProfileFreqNo/
		   (double)SizeY)+" ";
    }
    return "full";
  }

  public double[]getFreqProfile(int time) {
      double profile[]=new double[SizeY],sum;
      int i,j;
      
      if(time<0) {
	  for(i=0 ; i<SizeY ; i++) {
	      sum=0.0;
	      for(j=0 ; j<SizeX ; j++)
		  sum+=Map[j][i];
	      profile[i]=sum;
	  }
      } else {
	  for(i=0 ; i<SizeX ; i++)
	      profile[i]=Map[time][i];
      }
      return profile;
  }

  private double []getFullProfile(int freq) {
      if(Map==null || freq>=SizeY) 
	  return null;

      double profile[]=new double[SizeX],sum;
      float ptr[];
      int i,j;

      if(freq<0) {
	  for(i=0 ; i<SizeX ; i++) {
	      sum=0.0;
	      for(j=0,ptr=Map[i] ; j<SizeY ; j++)
		  sum+=ptr[j];
	      profile[i]=sum;
	  }
      } else {
	  for(i=0 ; i<SizeX ; i++)
	      profile[i]=Map[i][freq];
      }
      return profile;
  }

  public void getEnergyProfile(int Freq) {
    if(Map==null || signal==null || AvergMode==false) 
      return;
    else if(Freq>=SizeY) 
      return;
    double sum,min,max,Profile[]=new double[SizeX];
    float ptr[];
    int i,j;
    
    ProfileFreqNo=Freq;
    if(Freq<0) { 
      for(i=0 ; i<SizeX ; i++) {
	sum=0.0;
	for(j=0,ptr=Map[i] ; j<SizeY ; j++)
	  sum+=ptr[j];
	Profile[i]=sum;
      }
    } else {
      for(i=0 ; i<SizeX ; i++)
	Profile[i]=Map[i][Freq];
    }
    
    double ScaleX=(SizeX-1)/(double)(DimBase-1);
    for(i=0 ; i<DimBase ; i++)
      signal[i]=Profile[(int)(0.5+ScaleX*i)];

    min=max=signal[0];
    for(i=1 ; i<DimBase ; i++) {
      if(signal[i]<min) min=signal[i];
      if(signal[i]>max) max=signal[i];
    }

    double Yscale=((min==max) ? 1.0 : 40.0/(max-min));
    for(i=0 ; i<DimBase ; i++)
      signal[i]=Yscale*(signal[i]-min);
  }

  public final void getEnergyProfile() {
    getEnergyProfile(-1);
  }

  public final void getHistogram(float Hist[]) {
    int Len=Hist.length,i,j;
    double DY=(Len-1)/(maxVal-minVal);
    float ref[];

    for(i=0 ; i<Len ; i++)
      Hist[i]=0.0F;

    for(i=0 ; i<SizeX ; i++) 
      for(j=0,ref=Map[i] ; j<SizeY ; j++) 
	Hist[(int)(DY*(ref[j]-minVal))]+=1.0F;
  }

  public final int getOffset() {
    if(book==null) return 0;
    return book.getBookOffset();
  }

  public void finalize() {
    Map=null;
    try { super.finalize(); } catch(Throwable e) { }
  }

  public final int getDimBase() {
    return DimBase;
  }

    public final boolean isReconst(int k) {
	if(mask==null)
	    return false;
	int index=book.getAtomIndex(k);
	if(index==-1 || index>=book.NumOfAtoms())
	    return false;
	return mask[index];
    }

    public void setAtom(int k) {
	if(mask==null) return;
	if(k>=0 && k<book.NumOfAtoms()) {
	    float ptr[]=reconst[k];
	    int i;
	    
	    if(mask[k]) {
		Count--;
		for(i=0 ; i<DimBase ; i++)
		    ReconstSignal[i]-=ptr[i];
	    } else {
		Count++;
		for(i=0 ; i<DimBase ; i++)
		    ReconstSignal[i]+=ptr[i];
	    }

	    mask[k]=!mask[k];
	    if(Count==0)
		for(i=0 ; i<DimBase ; i++)
		    ReconstSignal[i]=RBot;
	}
    }

  public void saveProfile(String filename,int freq) {
      if(book==null || filename==null)
	  return;
     
      try {
	  BufferedOutputStream file=null;
	  OutputStream fstream=new FileOutputStream(new File(filename));
	  file=new BufferedOutputStream(fstream,1024);
	  double profile[]=getFullProfile(freq);
	  byte buffor[];

	  if(profile!=null) {
	      for(int i=0 ; i<SizeX ; i++) {
		  buffor=new String(profile[i]+"\n").getBytes();
		  file.write(buffor,0,buffor.length);
	      }
	  }
	  file.close();
      } catch(Exception e) {
	  new WaringMessageDialog("ERROR (Save profile): "+e.getMessage());
	  return;
      }	
      
      new WaringMessageDialog("File "+filename+" write OK");
  }

  private void makeCosTable(double Cos[],int start,int stop,
			    double freq,double phase) {
    double sinFreq,cosFreq,sinPhase,cosPhase,newCos,oldSin,oldCos;
    
    sinFreq=Math.sin(freq); 
    cosFreq=Math.cos(freq);

    phase-=freq*start;
    sinPhase=Math.sin(phase); 
    cosPhase=Math.cos(phase);

    oldSin=0.0; 
    oldCos=1.0;
    
    Cos[start]=cosPhase;
    for(int i=start+1 ; i<=stop ; i++) {
      newCos=oldCos*cosFreq-oldSin*sinFreq;
      oldSin=oldSin*cosFreq+oldCos*sinFreq;
      oldCos=newCos;
      Cos[i]=oldCos*cosPhase-oldSin*sinPhase;
    }
  }

  public void saveReconstruction(String filename,boolean full) {
      if(book==null || filename==null)
	  return;

      BufferedOutputStream file=null;
      try {
	  OutputStream fstream=new FileOutputStream(new File(filename));
	  file=new BufferedOutputStream(fstream,1024);
      } catch(Exception e) {
	  new WaringMessageDialog("ERROR (Save signal): "+
				  e.getMessage());
	  return;
      }	
      
      double tmpsig[]=new double[DimBase+1],sum;
      int    i,k;
      double Exp[]=new double[DimBase],Cos[]=new double[DimBase];
      double signal[]=new double[DimBase];
      int    BookLen=book.NumOfAtoms();
      ProgressIndex index=null;

      for(i=0 ; i<DimBase ; i++)
	  signal[i]=0.0;

      if(BookLen>0) {
	  if(BookLen>32) {
	      index=new ProgressIndex(BookLen,"Computing...");
	      index.UpDateIndex(); 
	      index.setVisible(true);
	  }

	  for(k=0 ; k<BookLen ; k++) {
	      if(index!=null) {
		  index.NextIndex();
		  if(k%32==0)
		      index.UpDateIndex();
	      }

	      if(full==false) if(mask[k]==false)
		  continue;
	      
	      if(book.scale(k)==0) {
		  signal[book.position(k)]+=(((book.phase(k)>=0.5F) ? 
					      -1.0 : 1.0)*book.modulus(k));
	      } else if(book.scale(k)==DimBase) {
		  double freq=book.frequency(k),
		         phase=book.phase(k)-freq*book.position(k);
		  
		  for(i=0,sum=0.0 ; i<DimBase ; i++)
		      sum+=SQR(tmpsig[i]=Math.cos(freq*i+phase));
		  
		  sum=book.modulus(k)/Math.sqrt(sum);
		  for(i=0 ; i<DimBase ; i++) 
		      signal[i]+=tmpsig[i]*sum;
	      } else {
		  double freq=book.frequency(k),
		         phase=book.phase(k)-freq*book.position(k);
		  int start=0,stop=DimBase-1;
		  
		  MakeExpTable(Exp,Math.PI/SQR(book.scale(k)),
			       book.position(k),
			       start,stop);
		  makeCosTable(Cos,start,stop,freq,phase);
		  
		  for(i=start,sum=0.0 ; i<=stop ; i++)
		    sum+=SQR(tmpsig[i]=Exp[i]*Cos[i]);
		  /*Math.cos(freq*i+phase))*/
		  
		  sum=book.modulus(k)/Math.sqrt(sum);
		  for(i=start ; i<=stop ; i++) 
		      signal[i]+=tmpsig[i]*sum;
	      }
	  }

	  if(index!=null)
	      index.Close();
      }
      
      try {
	  byte buffor[];
	  for(i=0 ; i<DimBase ; i++) {
	      buffor=new String(signal[i]+"\n").getBytes();
	      file.write(buffor,0,buffor.length);
	  }
	  file.close();
      } catch(Exception e) {
	  new WaringMessageDialog("ERROR (Save signal II): "+
				  e.getMessage());
	  return;
      }	
      
      new WaringMessageDialog("File "+filename+" write OK");
  }
    
  private void RSignal(FilterBookLibrary book,double signal[]) {
    double tmpsig[]=new double[DimBase+1],sum,maxSig,minSig;
    int i,k,itmp;
    double Exp[]=new double[DimBase],Cos[]=new double[DimBase];
    double dtmp;
    float  ptr[];

    Count=0;
    for(i=0 ; i<DimBase ; i++)
      signal[i]=0.0;

    int BookLen=book.NumOfAtoms();
    reconst=null; mask=null;
    System.gc();
    reconst=new float[BookLen][DimBase];
    mask=new boolean[BookLen];
  
    for(k=0 ; k<BookLen ; k++) {
	mask[k]=false;
	ptr=reconst[k];
	for(i=0 ; i<DimBase ; i++) 
	    ptr[i]=0.0F;
    }

    // long t1=new Date().getTime();
    for(int kk=0 ; kk<BookLen ; kk++) {
	k=book.getAtomIndex(kk);
	ptr=reconst[k];
	if(book.scale(k)==0) {
	    signal[itmp=book.position(k)]+=(dtmp=((book.phase(k)>=0.5F) ? 
						  -1.0 : 1.0)*book.modulus(k));
	    ptr[itmp]=(float)dtmp;
	} else if(book.scale(k)==DimBase) {
	    double freq=book.frequency(k),
		   phase=book.phase(k)-freq*book.position(k);
	
	    for(i=0,sum=0.0 ; i<DimBase ; i++)
		sum+=SQR(tmpsig[i]=Math.cos(freq*i+phase));

	    sum=book.modulus(k)/Math.sqrt(sum);
	    for(i=0 ; i<DimBase ; i++) {
		signal[i]+=(dtmp=tmpsig[i]*sum);
		ptr[i]=(float)dtmp;
	    }
	} else {
	    double freq=book.frequency(k),
		   phase=book.phase(k)-freq*book.position(k);
	    int start=0,stop=DimBase-1;

	    MakeExpTable(Exp,Math.PI/SQR(book.scale(k)),
			 book.position(k),
			 start,stop);

	    makeCosTable(Cos,start,stop,freq,phase);

	    for(i=start,sum=0.0 ; i<=stop ; i++)
	      sum+=SQR(tmpsig[i]=Exp[i]*Cos[i]);
	    /*Math.cos(freq*i+phase)*/
	    sum=book.modulus(k)/Math.sqrt(sum);
	    for(i=start ; i<=stop ; i++) {
		signal[i]+=(dtmp=tmpsig[i]*sum);
		ptr[i]=(float)dtmp;
	    }
	}
    }
    /*
      long t2=new Date().getTime();
      System.out.println("rec time: "+(t2-t1)/1000.0);
    */
    minSig=maxSig=signal[0];
    for(i=1 ; i<DimBase ; i++) {
	if(signal[i]<minSig)
	    minSig=signal[i];
	if(signal[i]>maxSig)
	    maxSig=signal[i];
      }
    
    double Yscale=((minSig==maxSig) ? 1.0 : 40.0/(maxSig-minSig));
    RBot=-Yscale*minSig;

    ReconstSignal=new double[DimBase];
    for(i=0 ; i<DimBase ; i++) {
	signal[i]=Yscale*(signal[i]-minSig);
	ReconstSignal[i]=RBot;
    }

    for(k=0 ; k<BookLen ; k++) {
	ptr=reconst[k];
	for(i=0 ; i<DimBase ; i++)
	    ptr[i]=(float)(Yscale*ptr[i]);
    }
  }

  public final void CommonWig() {
    CommonWig(true);
  }

  public final void CommonWig(boolean rec) {
    float ref[];
    int i,j,k;
    for(i=0 ; i<SizeX ; i++)
      for(j=0,ref=Map[i] ; j<SizeY ; j++)
	ref[j]=0.0F;
    
    minVal=maxVal=0.0;
    SamplingFreq=book.SamplingFreq();
    int BookSize=book.NumOfAtoms();
    SetWignerParameters();
    DimBase=book.DimBase();
   
//    if(!NativeAccelerator.isNativeEnabled()) {
      for(k=0 ; k<BookSize ; k++)
	AddAtom(book.modulus(k),book.scale(k),
		book.position(k),book.ifreq(k));
//    }
//    else {
//      NativeAccelerator.addBook(Map,book,SizeX,SizeY,DimBase,
//				ATime,BTime,AFreq,BFreq);
//    }

    signal=new double[DimBase];
    if(rec) {
      RSignal(book,signal);
      AvergMode=false;
    } else { 
      for(i=0 ; i<DimBase ; i++)
	signal[i]=0.0F;
      AvergMode=true;
    }
    SetMinMax();
  }

  public boolean MakeWignerMap(int Offset) {
      if(book==null) 
	  return false;
      if(!book.GoTo(Offset))
	  return false;
      CommonWig();
      return true;
  } 

  public boolean AvergWignerMap(int StartOffset,int StopOffset) {
    if(book==null) 
      return false;
    if(StartOffset>=StopOffset)
      return false;
    if(!book.GoTo(StartOffset))
      return false;
    long t1=new Date().getTime();
    ProgressIndex index=new ProgressIndex(StopOffset-StartOffset,"Progress");
    index.UpDateIndex(); 
    index.setVisible(true);
    //  try { Thread.sleep(2000); } catch(Exception e) { ; } 
    CommonWig(false);
    int AllAtoms=book.NumOfAtoms(),AllBooks=1;
    for(int i=StartOffset+1 ; i<=StopOffset ; i++)
      if(book.NextBook()) {
	index.NextIndex();
	int BookSize=book.NumOfAtoms();
	// Thread.currentThread().yield();
	if((AllBooks%5)==0) {
	    Thread.currentThread().yield();
	    index.UpDateIndex();
	}

//	if(!NativeAccelerator.isNativeEnabled()) {
	    for(int k=0 ; k<BookSize ; k++)
		AddAtom(book.modulus(k),book.scale(k),
			book.position(k),book.ifreq(k));
//	} else {
//	    NativeAccelerator.addBook(Map,book,SizeX,SizeY,DimBase,
//				      ATime,BTime,AFreq,BFreq);
//	}

	AllBooks++;
	AllAtoms+=BookSize;
      } else break;

    SetMinMax();
    index.Close();
  
    long t2=new Date().getTime();
    System.err.println("\n"+AllAtoms+" atoms\n"+AllBooks+" books");
    float Time=(float)(t2-t1)/1000.0F;
    System.err.println("Time: "+Time+" sec");
    if(Time>0.0F) 
      System.err.println(AllAtoms/Time+" atoms/sec\n"+AllBooks/Time
			 +" books/sec\nDone.\n");
    return true;
  }

  public boolean MakeNextWignerMap() {
    if(book==null) return false;
    if(!book.NextBook())
      return false;
    CommonWig();
    return true;
  } 

  public void setDimBase() {
      DimBase=book.DimBase();
      SetTrueSize(0.0,0.5*book.SamplingFreq());
  }

  public boolean MakeWignerMap(String filename,int Offset) {
    book=new FilterBookLibrary();    
    if(!book.Open(filename,Offset))
      return false;
    setDimBase();
    CommonWig();
    return true;
  }

    public boolean MakeWignerMap(String filename,int Offset,
				 double f1,double f2,FilterBookLibrary filt) {
	book=new FilterBookLibrary();    
	if(filt!=null)
	    book.setFilter(filt);

	SetTrueSize(f1,f2);
	if(!book.Open(filename,Offset))
	    return false;
	DimBase=book.DimBase();
	CommonWig(false);
	return true;
    }

    public boolean MakeWignerMap(URL filename,int Offset,
				 double f1,double f2,FilterBookLibrary filt) {
	book=new FilterBookLibrary();    
	if(filt!=null)
	    book.setFilter(filt);
	
	SetTrueSize(f1,f2);
	if(!book.Open(filename,Offset))
	    return false;
	DimBase=book.DimBase();
	CommonWig(false);
	return true;
    }


  public boolean MakeWignerMap(URL filename,int Offset) {
    book=new FilterBookLibrary();    
    if(!book.Open(filename,Offset))
      return false;
    DimBase=book.DimBase();
    SetTrueSize(0.0,0.5*book.SamplingFreq());
    CommonWig();
    return true;
  }

  public final double getSamplingFreq() {
    return SamplingFreq;
  }

  public final double []getSignal() {
    return signal;
  }

  public final double []getReconstruction() {
      return ReconstSignal;
  }

  private void SetWignerParameters() {
    minT=0; maxT=DimBase-1; 
    minF=(int)(0.5+FreqMin*(DimBase-1)/SamplingFreq); 
    maxF=(int)(0.5+FreqMax*(DimBase-1)/SamplingFreq);
    ATime=(maxT-minT)/(SizeX-1); BTime=minT;
    AFreq=(maxF-minF)/(SizeY-1); BFreq=minF;
  }
  
  public void SetTrueSize(double StartFreq,double StopFreq) {
    if(StartFreq>=StopFreq) return;
    FreqMin=StartFreq; FreqMax=StopFreq;
  }

  WignerMap(int Sx,int Sy,int minTT,int maxTT,int minFF,int maxFF,int Dim) {
    SizeX=Sx; SizeY=Sy; minT=minTT; maxT=maxTT; minF=minFF; maxF=maxFF;
    DimBase=Dim;
    try {
	Map=null; NormMap=null; TimeAxis=null; FreqAxis=null;
	System.gc();
	Map=new float[SizeX][SizeY];
	NormMap=new float[SizeX][SizeY];
	TimeAxis=new double[SizeX];
	FreqAxis=new double[SizeY];
    } catch(OutOfMemoryError e) {
	System.gc();
    }
    ATime=(maxT-minT)/(SizeX-1); BTime=minT;
    AFreq=(maxF-minF)/(SizeY-1); BFreq=minF;
  }

  public final void SigmaScale(float Dyst[]) {
    double Scale=(Dyst.length-1)/(maxVal-minVal),OldMinVal=minVal;
    float ftmp,ref[];
    int i,j;

    maxVal=minVal=Map[0][0]*Dyst[(int)(Scale*(Map[0][0]-minVal))];
    for(i=0 ; i<SizeX ; i++)
      for(j=0,ref=Map[i] ; j<SizeY ; j++) {
	ftmp=(ref[j]*=Dyst[(int)(Scale*(ref[j]-OldMinVal))]);
	if(maxVal<ftmp) maxVal=ftmp;
	if(minVal>ftmp) minVal=ftmp;
      }
    getEnergyProfile();
  }

  public final void SigmaScale(float alpha,float trans) {
    if(Map==null) return;
    float Scale=(float)(1.0/(maxVal-minVal));
    alpha*=Scale;
    trans=(float)(alpha*minVal-trans);
    maxVal=minVal=(float)(1.0/(1.0+Math.exp(-alpha*Map[0][0]+trans)));
    float ftmp,ref[];
    int i,j;

    for(i=0 ; i<SizeX ; i++)
      for(j=0,ref=Map[i] ; j<SizeY ; j++) {
	ftmp=ref[j]=(float)(1.0/(1.0+Math.exp(-alpha*ref[j]+trans)));
	if(maxVal<ftmp) maxVal=ftmp;
	if(minVal>ftmp) minVal=ftmp;
      }
    getEnergyProfile();
  }

  public final void SqrtScale() {
      if(Map==null)
	  return;
      maxVal=minVal=(float)Math.sqrt(Map[0][0]);
      float ftmp,ref[];
      int i,j;
      
      for(i=0 ; i<SizeX ; i++)
	  for(j=0,ref=Map[i] ; j<SizeY ; j++) {
	      ftmp=ref[j]=(float)Math.sqrt(ref[j]);
	      if(maxVal<ftmp) maxVal=ftmp;
	      if(minVal>ftmp) minVal=ftmp;
	  }
      getEnergyProfile();
  }

  public final void LogScale() {
    if(Map==null) return;
    maxVal=minVal=(float)Math.log(1.0F+Map[0][0]);
    float ftmp,ref[];
    int i,j;

    for(i=0 ; i<SizeX ; i++)
      for(j=0,ref=Map[i] ; j<SizeY ; j++) {
	ftmp=ref[j]=(float)Math.log(1.0F+ref[j]);
	if(maxVal<ftmp) maxVal=ftmp;
	if(minVal>ftmp) minVal=ftmp;
      }
    getEnergyProfile();
  }

  public final void NormScale() {
    if(Map==null || NormMap==null) return;
    float ftmp,ref1[],ref2[];
    int i,j;

    for(i=0 ; i<SizeX ; i++)
      for(j=0,ref1=Map[i],ref2=NormMap[i] ; j<SizeY ; j++) {
	ftmp=ref1[j]=ref2[j];
	if(maxVal<ftmp) maxVal=ftmp;
	if(minVal>ftmp) minVal=ftmp;
      }
    getEnergyProfile();
  }

  public final double getMinVal() {
    return minVal;
  }

  public final double getMaxVal() {
    return maxVal;
  }

  private void SetMinMax() {
    if(Map==null) return;
    float ftmp,ref1[],ref2[];
    int i,j;

    for(i=0 ; i<SizeX ; i++) 
      for(j=0,ref1=NormMap[i],ref2=Map[i] ; j<SizeY ; j++) {
	ftmp=ref1[j]=ref2[j];
	if(ftmp>maxVal) maxVal=ftmp;
	if(ftmp<minVal) minVal=ftmp;
      }
    getEnergyProfile();
  }

  private void SetExp(double sig[],double alpha,int trans,
		      double modulus,int Max)
    {
      double Const=1.65*Math.sqrt(Math.log(modulus/(2.0*EPS))/(PI2M*alpha));

      Start=(int)(trans-Const)-1; Stop=(int)(trans+Const)+1;
      if(Start<0)  Start=0;
      if(Stop>Max) Stop=Max;
      if(Start>=Stop) return;      
      MakeExpTable(sig,alpha,trans,Start,Stop);
      for(int i=Start ; i<=Stop ; i++)
	sig[i]*=modulus;
  }

  public final void AddAtom(double modulus,int scale,int trans,float ffreq) {
    int i,j,freq;
    float ref[];

    if(scale!=0) {
      double dy=Math.PI/DimBase;
      double alphaTime=4.0*Math.PI/SQR(scale),
	     alphaFreq=4.0*Math.PI*SQR(dy*scale/PI2M);

      alphaTime*=(ATime*ATime);
      trans=(int)((trans-BTime)/ATime);
      alphaFreq*=(AFreq*AFreq);
      freq=(int)((ffreq-BFreq)/AFreq);

      if(scale==DimBase) {
	if(freq<0 || freq>=SizeY) return;
	modulus=SQR(modulus);
	for(i=0 ; i<SizeX ; i++)
	  Map[i][freq]+=modulus;
	return;
      }
 
      SetExp(TimeAxis,alphaTime,trans,modulus,SizeX-1);
      int TimeStart=Start,TimeStop=Stop;
      SetExp(FreqAxis,alphaFreq,freq,modulus,SizeY-1);
      int FreqStart=Start,FreqStop=Stop;
      double dtmp;
      
      if(TimeStart<TimeStop && FreqStart<FreqStop)
	  for(i=TimeStart ; i<=TimeStop ; i++) {
	      dtmp=TimeAxis[i];
	      for(j=FreqStart,ref=Map[i] ; j<=FreqStop ; j++)
		  ref[j]+=dtmp*FreqAxis[j];
	  }
    } else {
      trans=(int)((trans-BTime)/ATime);
      if(trans<0 || trans>=SizeX) return;
      modulus=SQR(modulus);
      for(i=0,ref=Map[trans] ; i<SizeY ; i++)
	  ref[i]+=modulus;
    }
  }

  private static double SQR(double x) { 
    return x*x;
  }

  private static void MakeExpTable(double ExpTab[],double alpha,int trans,
				   int start,int stop)
    {
      int left,right,itmp;	  	 
      double Factor,OldExp,ConstStep;
   
      if(start<trans && trans<stop) {                            	  
	ExpTab[trans]=OldExp=1.0;
	Factor=Math.exp(-alpha);
	ConstStep=SQR(Factor);     	
    
	for(left=trans-1,right=trans+1 ; 
	    start<=left && right<=stop ; 
	    left--,right++)
	  {
	    OldExp*=Factor;
	    ExpTab[left]=ExpTab[right]=OldExp;
	    Factor*=ConstStep;
	  }  
	
	if(left>=start)	 
	  for( ; start<=left ; left--) {
	    ExpTab[left]=OldExp*=Factor;
	    Factor*=ConstStep;
	  }
	else 
	  for( ; right<=stop; right++) {
	    ExpTab[right]=OldExp*=Factor;
	    Factor*=ConstStep;
	  }
	return;      
      } 
   
      ConstStep=Math.exp(-2.0*alpha);
      if(trans>=stop) {
	itmp=trans-stop;	    
	ExpTab[stop]=OldExp=Math.exp(-alpha*SQR(itmp));
	Factor=Math.exp(-alpha*(double)((itmp << 1)+1));
	
	for(left=stop-1; start<=left ; left--) {
	  ExpTab[left]=OldExp*=Factor;
	  Factor*=ConstStep;
	}
      } else {       	
	itmp=start-trans;  
	ExpTab[start]=OldExp=Math.exp(-alpha*SQR(itmp));
	Factor=Math.exp(-alpha*(double)((itmp << 1)+1));
	
	for(right=start+1; right<=stop ; right++) {
	  ExpTab[right]=OldExp*=Factor;
	  Factor*=ConstStep;
	}
      }   
    }              
}
