/* 1998 10 17-20/22-23/26/28/29 
   1998 11 07/08/10-11; 1998 11 18/30; 1998 12 12/15
   1999 06 30    - JDK 1.1 
   1999 07 08    - rekonstrukcja sygnalu
   1999 07 18/23/25/27/30- dalsze poprawki
   1999 08 03/12
   1999 08 18/21/24
   1999 09 03/06
   1999 09 25
   1999 10 03
   1999 10 24/25 - JDK 1.2 (adnotacja w main)
   1999 11 09    - format IV
   1999 11 28
   2000 02 18
   2000 03 01/21/22/24/27
   2000 05 10/11/17
   2000 08 25/26
   2000 09 21/22 PJD
*/

import java.awt.*;
import java.awt.image.*;
import java.awt.event.*;
import java.io.*;
import java.util.Date;
import java.util.*;
import java.applet.*;
import java.net.*;
import java.rmi.*; 
import javax.swing.*;
import javax.swing.border.*;

class SaveDialog extends JDialog implements ActionListener, ItemListener {
    private static final int    GIF=1,JAVA=2,INTEL=3,ASCII=4; 
    private JButton             OkButton,CancelButton,BrowseButton;
    private JTextField          fileField;
    private mpview              applet;
    private int                 mode=GIF;
    private JRadioButton        box1,box2,box3,box4;

    public SaveDialog(mpview parent) {
	super(new JFrame(),true);
	applet=parent;
	getContentPane().setLayout(null);
	setSize(365,195);
	setTitle("Save map to file...");

	OkButton=new JButton("Ok");
	OkButton.addActionListener(this);
	OkButton.setFont(new Font("Courier",Font.BOLD,10));
	OkButton.setBounds(90,120,60,27);
	OkButton.setForeground(new Color(0,128,0));
	getContentPane().add(OkButton);

	CancelButton=new JButton("Cancel");
	CancelButton.addActionListener(this);
	CancelButton.setFont(new Font("Courier",Font.BOLD,10));
	CancelButton.setBounds(90+63,120,90,27);
	CancelButton.setForeground(Color.red);
	getContentPane().add(CancelButton);



	fileField=new JTextField();
	fileField.addActionListener(this);
	fileField.setBounds(20,50,220,27);
	fileField.setText("map.gif");
	getContentPane().add(fileField);

	BrowseButton=new JButton("Browse");
	BrowseButton.addActionListener(this);
	BrowseButton.setFont(new Font("Courier",Font.BOLD,10));
	BrowseButton.setBounds(245,50,90,27);
	getContentPane().add(BrowseButton);

	JPanel panel=new JPanel();
	ButtonGroup group=new ButtonGroup();
	panel.setFont(new Font("Courier",Font.BOLD,10));

	panel.setBounds(10,80,285+30,35);
	panel.setLayout(new FlowLayout());
      
	panel.add(box1=new JRadioButton(" Gif",true));
	box1.addItemListener(this);
	group.add(box1);

	panel.add(box2=new JRadioButton(" JAVA",false));
	box2.addItemListener(this);
	group.add(box2);

	panel.add(box3=new JRadioButton(" INTEL",false));
	box3.addItemListener(this);
	group.add(box3);

	panel.add(box4=new JRadioButton(" Ascii",false));
	box4.addItemListener(this);
	group.add(box4);

	getContentPane().add(panel);
	setResizable(false);
    }

    public void itemStateChanged(ItemEvent evt) {
	if(evt.getSource() instanceof JRadioButton) {
	    String s=((JRadioButton)evt.getSource()).getText();
	    if(s.equals(" Gif")) {
		mode=GIF;
	    } else if(s.equals(" JAVA")) {
		mode=JAVA;
	    } else if(s.equals(" INTEL")) {
		mode=INTEL;
	    } else if(s.equals(" Ascii")) {
		mode=ASCII;
	    }
	}
    }

    private void action() {
	try {
	    String filename=fileField.getText();
	    switch(mode) {
	    case GIF:
		applet.saveImageToGif(filename);
		break;
	    case JAVA:
		applet.SaveToFile(filename,false);
		break;
	    case INTEL:
		applet.SaveToFile(filename,true);
		break;
	    case ASCII:
		applet.SaveToAsciiFile(filename);
		break;
	    }
	} catch(Exception e) {
	    new WaringMessageDialog("ERROR : "+e.getMessage()); 
	}
    }
    
    public void actionPerformed(ActionEvent event) {
	Object evt=event.getSource();
	if(evt==OkButton || evt==fileField) {
	    setVisible(false); 
	    action();
	    dispose(); 
	} else if(evt==CancelButton) {
	    setVisible(false);
	    dispose();
	} else if(evt==BrowseButton) {
	    String s=Utils.getFileName("Save As ...",false);
	    if(s!=null) 
		fileField.setText(s);
	}
    }
}

// ----------------------------------------------------------------------

class LibraryInfoShower extends JDialog implements ActionListener {
    private JButton    ExitButton;
    private WignerMap Map=null;
    private JTextArea  text;

    public LibraryInfoShower(WignerMap map) {
	super(new JFrame(),true); 
	Map=map;
	getContentPane().setLayout(new BorderLayout());
	setSize(350,290);
	setBackground(Color.lightGray);

	JPanel panel1,panel2;
	getContentPane().add("Center",panel1=new JPanel());
	text=new JTextArea(20,25);
	text.setFont(new Font("Courier",Font.PLAIN,10));
	text.setEditable(false);
	text.setBackground(Color.lightGray);

	JScrollPane scroller=new JScrollPane(text,
					     JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
					     JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
       	getContentPane().add(scroller);
	//	panel1.add(text);

	getContentPane().add("South",panel2=new JPanel());
	panel2.setLayout(new BorderLayout());
	panel2.add(ExitButton=new JButton("Close"));

	ExitButton.setForeground(Color.red);
	ExitButton.addActionListener(this);
	setResizable(false);
	setTitle("File Info");
	if(Map!=null)
	    text.setText(Map.book.getInfoString()+"Signal Size       : "+
			 Map.getDimBase());
    }

    public void actionPerformed(ActionEvent event) {
	if(event.getSource()==ExitButton) {
	    setVisible(false);
	    dispose();
	}
    }
}

// ------------------------------------------------------------------------

class BookShower extends JDialog implements ActionListener, ItemListener {
    private JButton ExitButton,ShowInfoButton,SaveBookButton,ReconstButton;
    private JButton ReFilterButton,InvFilterButton;
    private WignerMap Map=null;
    private mpview parent=null;
    private JTextArea  text;
    private JRadioButton box1,box2,box3,box4,box5,box6;
    private JLabel label;
    private Index idx=new Index();

    private void setText() {
	int BookNo=Map.book.NumOfAtoms(),pos=0;
	String s=new String("");

	idx.Clear();
	for(int i=0 ; i<BookNo ; i++) {
	    String stmp=((Map.isReconst(i)) ? "* " :  "  ")
		         +Map.book.getAtomString(i)+"\n";

	    idx.insert(Map.book.getAtomIndex(i),pos,pos+=stmp.length());
	    s+=stmp;
	}
	text.setText(s);
    }

    public void UpDate() {
	if(box1.isSelected()) 
	    Map.book.SortBy(FilterBookLibrary.MODULUS);
	else if(box2.isSelected()) 
	    Map.book.SortBy(FilterBookLibrary.AMPLITUDE);
	else if(box3.isSelected())
	    Map.book.SortBy(FilterBookLibrary.POSITION);
	else if(box4.isSelected())
	    Map.book.SortBy(FilterBookLibrary.SCALE);
	else if(box5.isSelected())
	    Map.book.SortBy(FilterBookLibrary.FREQUENCY);
	else Map.book.SortBy(FilterBookLibrary.PHASE);
	setText();
	label.setText("Sort "+Map.book.NumOfAtoms()+" atoms");
    }

    public BookShower(mpview applet) {
	super(new JFrame(),false);
	parent=applet;
	Map=applet.map;
	getContentPane().setLayout(new BorderLayout());
	setSize(525+230+70,420);
	setBackground(Color.lightGray);
	JPanel panel1,panel2,panel0;
  JLabel label0;
	getContentPane().add("North",panel0=new JPanel());
	panel0.setForeground(Color.blue);
       	panel0.setFont(new Font("Courier",Font.PLAIN,12));
//  panel0.add(new JLabel("Time    "));
//	panel0.add(new JLabel("Number    "));
//	panel0.add(new JLabel("Position  "));
//	panel0.add(new JLabel("Modulus-Amplitude"));
//	panel0.add(new JLabel("Scale       "));
//	panel0.add(new JLabel("Length     "));
//	panel0.add(new JLabel("Frequency  "));
//	panel0.add(new JLabel("Phase      "));
//	panel0.add(new JLabel("True Phase "));
label0=new JLabel("time      #         pos       mod       ampl      scale"+
"     length    frequency  phase     phase2 ");
label0.setFont(new Font("Courier",Font.PLAIN,12));
panel0.add(label0);

	getContentPane().add("Center",panel1=new JPanel());

	text=new JTextArea(23,92);
	text.setEditable(false);
	text.setFont(new Font("Courier",Font.PLAIN,12));
	text.setBackground(Color.lightGray);

	JScrollPane scroller=new JScrollPane(text,
					     JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
					     JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
       	getContentPane().add(scroller);

	Map.book.SortBy(FilterBookLibrary.MODULUS);
	setText();
	getContentPane().add("South",panel2=new JPanel());
	panel2.setLayout(new GridLayout(2,7));
	panel2.add(label=new JLabel("sort "+Map.book.NumOfAtoms()+" atoms"));
	label.setForeground(Color.blue);
	ButtonGroup SortBy=new ButtonGroup();
    
	panel2.add(box1=new JRadioButton("Modulus",true));
	box1.addItemListener(this);
	panel2.add(box2=new JRadioButton("Amplitude",false));
	box2.addItemListener(this);
	panel2.add(box3=new JRadioButton("Position",false));
	box3.addItemListener(this);
	panel2.add(box4=new JRadioButton("Scale",false));
	box4.addItemListener(this);
	panel2.add(box5=new JRadioButton("Frequency",false));
	box5.addItemListener(this);
	panel2.add(box6=new JRadioButton("Phase",false));

	SortBy.add(box1);
	SortBy.add(box2);
	SortBy.add(box3);
	SortBy.add(box4);
	SortBy.add(box5);
	SortBy.add(box6);

	box6.addItemListener(this);

	panel2.add(ShowInfoButton=new JButton("Info"));
	panel2.add(SaveBookButton=new JButton("Save"));
	SaveBookButton.setEnabled(SecurityInfo.canWrite());
	panel2.add(ReconstButton=new JButton("Reconst"));
	panel2.add(ReFilterButton=new JButton("Filter"));
	panel2.add(InvFilterButton=new JButton("InvFilter"));
	panel2.add(ExitButton=new JButton("Close"));

	InvFilterButton.addActionListener(this);
	ReFilterButton.addActionListener(this);
	ReconstButton.addActionListener(this);
	ExitButton.setForeground(Color.red);
	ExitButton.addActionListener(this);
	
	ShowInfoButton.setForeground(Color.blue);
	ShowInfoButton.addActionListener(this);

	SaveBookButton.setForeground(Color.black);
	SaveBookButton.addActionListener(this);

//	setResizable(false);
	setTitle("Parameters of  atoms - chosen marked by *");
    }
               
    public void itemStateChanged(ItemEvent evt) {
	if(evt.getSource() instanceof JRadioButton) {
	    String s=((JRadioButton)evt.getSource()).getText();
	    if(s.equals("Modulus")) 
		Map.book.SortBy(FilterBookLibrary.MODULUS);
	    else if(s.equals("Amplitude")) 
		Map.book.SortBy(FilterBookLibrary.AMPLITUDE);
	    else if(s.equals("Position"))
		Map.book.SortBy(FilterBookLibrary.POSITION);
	    else if(s.equals("Scale"))
		Map.book.SortBy(FilterBookLibrary.SCALE);
	    else if(s.equals("Frequency"))
		Map.book.SortBy(FilterBookLibrary.FREQUENCY);
	    else Map.book.SortBy(FilterBookLibrary.PHASE);
	    setText();
	}
    }

  public void actionPerformed(ActionEvent event) {
      Object evt=event.getSource();
      if(evt==ExitButton) {
	  setVisible(false); 
	  dispose(); 
      } else if(evt==ShowInfoButton) {
	  LibraryInfoShower info=new LibraryInfoShower(Map);
	  info.setVisible(true);
      } else if(evt==SaveBookButton) {
	  SaveAscBook();
      } else if(evt==ReconstButton || evt==ReFilterButton || evt==InvFilterButton) {
	  if(Map.book.NumOfAtoms()>0) {
	      int begin=text.getSelectionStart(),end=text.getSelectionEnd();
	      
	      if(begin!=end) {
		  int index[];
		  if((index=idx.getList(begin,end))!=null) { 
		      if(evt==ReconstButton)
			  parent.makeReconstList(index);
		      else if(evt==ReFilterButton)
			  parent.reFilter(index,false);
		      else
			  parent.reFilter(index,true);
		  }
	      }
	  }
      }
  }
        
    private void SaveAscBook() {
	if(Map==null) return;
	String filename=Utils.getFileName("Save ASCII Book",false);
	if(filename!=null) {
	    try {/*
		try {
		    netscape.security.PrivilegeManager.enablePrivilege("UniversalFileWrite");
		} catch(Exception e) {
		    ;
		    }*/
		OutputStream fstream=new FileOutputStream(new File(filename));
		DataOutputStream file=new DataOutputStream(fstream);
		Map.book.SaveAll(file);
		file.close();
		new WaringMessageDialog("File "+filename+" write OK");
	    } catch(Exception e) {
		new WaringMessageDialog("ERROR (Save ASCII Book): "+
					e.getMessage());
	    }
	}
    }
}

class AvergBookDialog extends JDialog implements ActionListener {
  private int StartOffset=0,StopOffset=0;
  private mpview mod;
  private JTextField TMin,TMax;
  private JButton ExitButton,IgnoreButton;

  private void setStartAndStop() {
    if(mod==null) return;
    try {
      StartOffset=Integer.parseInt(TMin.getText().trim())-1;
      StopOffset=Integer.parseInt(TMax.getText().trim())-1;
    } catch(NumberFormatException e) { 
      return; 
    }

    mod.StartOffset=StartOffset;
    mod.StopOffset=StopOffset;
  }

  public AvergBookDialog(mpview module) {
    super(new JFrame(),true);
    mod=module; mod.StartStopOK=false;
    getContentPane().setLayout(new BorderLayout(2,2));
    setSize(240,120);
    setBackground(new Color(12632256));
    setResizable(false);
    JPanel left=new JPanel(),right=new JPanel(),panel=new JPanel();
    left.setLayout(new GridLayout(2,1));
    left.add(new JLabel("Start Book"));
    left.add(new JLabel("Stop  Book"));
    getContentPane().add("West",left);
    right.setLayout(new GridLayout(2,1));
    right.add(TMin=new JTextField(8));
    TMin.addActionListener(this);
    right.add(TMax=new JTextField(8));
    TMax.addActionListener(this);
    getContentPane().add("East",right);

    TMin.setText(String.valueOf(mod.StartOffset+1));
    TMax.setText(String.valueOf(mod.StopOffset+1));

    ExitButton=new JButton("Apply");
    ExitButton.setForeground(Color.red);
    ExitButton.addActionListener(this);

    IgnoreButton=new JButton("Ignore");
    IgnoreButton.addActionListener(this);

    panel.setLayout(new FlowLayout());
    panel.add(IgnoreButton); 
    panel.add(ExitButton);
    getContentPane().add("South",panel);
    setTitle("Averg Book");
  }

  public void actionPerformed(ActionEvent event) {
      Object evt=event.getSource();

      if(evt==ExitButton || evt==TMin || evt==TMax) {
	  setStartAndStop();
	  setVisible(false);
	  mod.MakeAvergBook(); 
	  mod.StartStopOK=true;  
	  dispose();
      } else if(evt==IgnoreButton) {
	  setVisible(false); 

	  mod.AvergMapOn=false;
	  mod.enabledButtons(false);
	  mod.GoToButton_Clicked();
	  mod.updateAndClose();
	  mod.StartStopOK=true; 
	  dispose();
      }
  }
}

// ---------------------------------------------------------------------

class FilterDialog extends JFrame implements ActionListener {
    private FilterBookLibrary bookCFG=null;
    private JButton ExitButton,IgnoreButton,ResetButton;
    private mpview mod;
    private JTextField TMinScale,TMaxScale,TMinFreq,TMaxFreq;
    private JTextField TMaxAmplitude,TMinAmplitude;
    private JTextField TMinTime,TMaxTime;
    private JTextField TMinPhase,TMaxPhase;
    private JTextField TMinIter,TMaxIter;
    private JCheckBox c1,c2,c3,c4,c5,c6,c7,c8,c9,c10,c11,c12,c13;
    private WignerMap wig;

    public final void SetFilter(FilterBookLibrary book) {
	float ftmp;
	int   itmp;  

	if((itmp=book.getMinIter())>=0) {
	    TMinIter.setText(""+itmp);
	    c12.setSelected(true);
	}

	if((itmp=book.getMaxIter())>=0) {
	    TMaxIter.setText(""+itmp);
	    c13.setSelected(true);
	}

	if((ftmp=book.getMinScale())>=0) {
	    TMinScale.setText(""+ftmp);
	    c1.setSelected(true);
	}

	if((ftmp=book.getMaxScale())>=0) {
	    TMaxScale.setText(""+ftmp);
	    c2.setSelected(true);
	}

	if((ftmp=book.getMinFreq())>=0.0F) {
	    TMinFreq.setText(""+ftmp);
	    c5.setSelected(true);
	}

	if((ftmp=book.getMaxFreq())>=0.0F) {
	    TMaxFreq.setText(""+ftmp);
	    c6.setSelected(true);
	}

	if((ftmp=book.getMinAmplitude())>=0.0F) {
	    TMinAmplitude.setText(""+ftmp);
	    c3.setSelected(true);
	}

	if((ftmp=book.getMaxAmplitude())>=0.0F) {
	    TMaxAmplitude.setText(""+ftmp);
	    c4.setSelected(true);
	}
	
	if((ftmp=book.getMinTime())>=0.0F) {
	    TMinTime.setText(""+ftmp);
	    c7.setSelected(true);
	}

	if((ftmp=book.getMaxTime())>=0.0F) {
	    TMaxTime.setText(""+ftmp);
	    c8.setSelected(true);
	}

	c9.setSelected(!book.getTrueTime());

	ftmp=book.getMinPhase();
	if(ftmp>=0.0F && ftmp<=2.0*Math.PI) {
	    TMinPhase.setText(""+ftmp);
	    c10.setSelected(true);
	}

	ftmp=book.getMaxPhase();
	if(ftmp>=0.0F && ftmp<=2.0*Math.PI) {
	    TMaxPhase.setText(""+ftmp);
	    c11.setSelected(true);
	}
    }
      
    FilterDialog(FilterBookLibrary book,mpview module,
		 WignerMap Wmap) {
	bookCFG=book; mod=module; mod.OK=false; wig=Wmap;
	getContentPane().setLayout(new BorderLayout(2,2));
	setSize(270,400);
	setBackground(new Color(12632256));
	setResizable(false);
	JPanel left=new JPanel(),right=new JPanel(),panel=new JPanel();
	left.setLayout(new GridLayout(13,1,5,5));

	left.add(c1=new JCheckBox("MinScale ",null,false));
	left.add(c2=new JCheckBox("MaxScale ",null,false));
	left.add(c3=new JCheckBox("MinAmp   ",null,false));
	left.add(c4=new JCheckBox("MaxAmp   ",null,false));
	left.add(c5=new JCheckBox("MinFreq  ",null,false));
	left.add(c6=new JCheckBox("MaxFreq  ",null,false));
	left.add(c7=new JCheckBox("MinTime  ",null,false));
	left.add(c8=new JCheckBox("MaxTime  ",null,false));
	left.add(c10=new JCheckBox("MinPhase",null,false));
	left.add(c11=new JCheckBox("MaxPhase",null,false));
	left.add(c12=new JCheckBox("MinIter ",null,false));
	left.add(c13=new JCheckBox("MaxIter ",null,false));
	
	left.add(c9=new JCheckBox("Points   ",null,true));
	getContentPane().add("West",left);

	right.setLayout(new GridLayout(13,1,2,2));
	right.add(TMinScale=new JTextField(8));
	right.add(TMaxScale=new JTextField(8));
	right.add(TMinAmplitude=new JTextField(8));
	right.add(TMaxAmplitude=new JTextField(8));
	right.add(TMinFreq=new JTextField(8));
	right.add(TMaxFreq=new JTextField(8));
	right.add(TMinTime=new JTextField(8));
	right.add(TMaxTime=new JTextField(8));
	right.add(TMinPhase=new JTextField(8));
	right.add(TMaxPhase=new JTextField(8));
	right.add(TMinIter=new JTextField(8));
	right.add(TMaxIter=new JTextField(8));

	getContentPane().add("East",right);

	ExitButton=new JButton("Apply");
	ExitButton.setForeground(Color.red);
	ExitButton.addActionListener(this);

	IgnoreButton=new JButton("Ignore");
	IgnoreButton.addActionListener(this);

	ResetButton=new JButton("Reset");
	ResetButton.addActionListener(this);

	panel.setLayout(new FlowLayout());
	panel.add(ResetButton);
	panel.add(IgnoreButton); 
	panel.add(ExitButton);
	getContentPane().add("South",panel);
	setTitle("Filter");
    }
  
    public void actionPerformed(ActionEvent event) {
	Object evt=event.getSource();

	if(evt==ResetButton) {
	    bookCFG.ResetParameter(); 
	    setVisible(false);
	    bookCFG.GetGoodAtoms();
	    wig.CommonWig();
	    mod.Compute(wig);
	    mod.repaint(); 
	    mod.OK=true; 
	    dispose();
	} else if(evt==ExitButton) {
	    boolean OK=true;
	    float dtmp=0.0F;
	    
	    if(bookCFG!=null) {
		if(c1.isSelected()) {
		    try {
			dtmp=Float.valueOf(TMinScale.getText()).floatValue();
		    } catch(NumberFormatException e) { OK=false; }
		    if(OK)
			bookCFG.SetMinScale(dtmp);
		} else bookCFG.setMinScaleFlag(false);
		OK=true;
		if(c2.isSelected()) {
		    try {
			dtmp=Float.valueOf(TMaxScale.getText()).floatValue();
		    } catch(NumberFormatException e) { OK=false; }
		    if(OK)
			bookCFG.SetMaxScale(dtmp);
		} else bookCFG.setMaxScaleFlag(false);
		OK=true;
		if(c3.isSelected()) {
		    try {
			dtmp=Float.valueOf(TMinAmplitude.getText()).floatValue();
		    } catch(NumberFormatException e) { OK=false; }
		    if(OK)
			bookCFG.SetMinAmplitude(dtmp);
		} else bookCFG.setMinAmplitudeFlag(false);
		OK=true;
		if(c4.isSelected()) {
		    try {
			dtmp=Float.valueOf(TMaxAmplitude.getText()).floatValue();
		    } catch(NumberFormatException e) { OK=false; }
		    if(OK)
			bookCFG.SetMaxAmplitude(dtmp);
		} else bookCFG.setMaxAmplitudeFlag(false);
		OK=true;
		if(c5.isSelected()) {
		    try {
			dtmp=Float.valueOf(TMinFreq.getText()).floatValue();
		    } catch(NumberFormatException e) { OK=false; }
		    if(OK)
			bookCFG.SetMinFreq(dtmp);
		} else bookCFG.setMinFreqFlag(false);
		OK=true;
		if(c6.isSelected()) {
		    try {
			dtmp=Float.valueOf(TMaxFreq.getText()).floatValue();
		    } catch(NumberFormatException e) { OK=false; }
		    if(OK)
			bookCFG.SetMaxFreq(dtmp);
		} else bookCFG.setMaxFreqFlag(false);

		OK=true;
		if(c7.isSelected()) {
		    try {
			dtmp=Float.valueOf(TMinTime.getText()).floatValue();
		    } catch(NumberFormatException e) { OK=false; }
		    if(OK)
			bookCFG.SetMinTime(dtmp);
		} else bookCFG.setMinTimeFlag(false);

		OK=true;
		if(c8.isSelected()) {
		    try {
			dtmp=Float.valueOf(TMaxTime.getText()).floatValue();
		    } catch(NumberFormatException e) { OK=false; }
		    if(OK)
			bookCFG.SetMaxTime(dtmp);
		} else bookCFG.setMaxTimeFlag(false);

		OK=true;
		if(c10.isSelected()) {
		    try {
			dtmp=Float.valueOf(TMaxPhase.getText()).floatValue();
		    } catch(NumberFormatException e) { OK=false; }
		    if(OK)
			bookCFG.setMaxPhase(dtmp);
		} else bookCFG.setMaxPhaseFlag(false);

		OK=true;
		if(c11.isSelected()) {
		    try {
			dtmp=Float.valueOf(TMinPhase.getText()).floatValue();
		    } catch(NumberFormatException e) { OK=false; }
		    if(OK)
			bookCFG.setMinPhase(dtmp);
		} else bookCFG.setMinPhaseFlag(false);

		OK=true;
		if(c12.isSelected()) {
		    try {
			dtmp=Float.valueOf(TMinIter.getText()).floatValue();
		    } catch(NumberFormatException e) { OK=false; }
		    if(OK)
			bookCFG.setMinIter((int)dtmp);
		} else bookCFG.setMinIterFlag(false);

		OK=true;
		if(c13.isSelected()) {
		    try {
			dtmp=Float.valueOf(TMaxIter.getText()).floatValue();
		    } catch(NumberFormatException e) { OK=false; }
		    if(OK)
			bookCFG.setMaxIter((int)dtmp);
		} else bookCFG.setMaxIterFlag(false);

		bookCFG.SetTrueTime(!c9.isSelected());
		    
		bookCFG.GetGoodAtoms();
		if(mod.isAvergMode()) {
		    mod.reaverg();
		} else {
		    wig.CommonWig();
		    mod.Compute(wig);
		    mod.repaint();
		}
	    } 
	    setVisible(false); 
	    mod.OK=true; 
	    mod.updateAndClose();
	    dispose();
	} if(evt==IgnoreButton) {
	    setVisible(false); 
	    mod.OK=true; dispose();
	}
    }
}

// ------------------------------------------------------------------------

public class mpview extends JApplet implements ActionListener,
                                                           MouseListener, 
							   MouseMotionListener,
							   ItemListener {
//  private static final int STARTMAP=188-7+40,S1=18,S2=S1+18;
  private static final int STARTMAP=188-7+40,S1=17,S2=S1+14;
  private static final boolean SERVER=false; // Wlaczenie MP_SERVER
  private final int SizeX=512,SizeY=256;
  private int DimBase=512,MapOffset=0;
  private Image image=null;
  private boolean NoPaint=true;
  private String filename=null;
  private double signal[]=null;
  public double Sampling=1.0,StartFreq=0.0,StopFreq=0.5;
  private double reconst[]=null;
  public WignerMap map=null;
  private int Paleta[]=new int[256];
  private FilterDialog Dialog=null;
  private AvergBookDialog AvergDialog=null;
  public boolean OK=true,StartStopOK=true,AvergMapOn=false,GrayScale=false;
  private int WignerImage[]=new int[SizeX*SizeY]; 
  public int StartOffset=0,StopOffset=0;
  public boolean SigmaOn=true;
  private boolean drawCrossesOn=true,isApplet=true;
  private boolean isIE=false;  
  private String hostname="brain.fuw.edu.pl";
  private BookShower shower=null;
  private RectangleArea     MainPanel;
  private final static String VERSION="ver. 1.3.5 (2000.09.22)";
  private int profileIndex=-1;
  private boolean newWindow=false;
  private JFrame  winFrame=null;
  private URL     fileURL=null;
  private boolean isURL=false;

    public final int getMapOffset() {
	return MapOffset;
    }

    public final void setNewWindowFrame(JFrame frame) {
	winFrame=frame;
    }

    public void reFilter(int index[],boolean inv) {
	map.book.reFilter(index,inv);
	map.CommonWig();
	Compute(map);
	repaint();
	updateAndClose();
    } 

    private void ClearScreen() {
	Graphics g=getGraphics();
	if(g!=null) {
	    if(isIE==true) {
		Dimension s=getSize();
		
		g.setColor(getBackground());
		g.fillRect(0,0,s.width,s.height);
		g.setColor(getForeground());
	    } else if(g!=null) {
		super.update(g);
	    }
	}
    }

    public final String getMapScale() {
	return (String)enScale.getSelectedItem();
    }

    public void setMapScale() {
	String s=(String)enScale.getSelectedItem();
	
	if(     s.equals("En: Linear   "))
	    NormImageProc();
	else if(s.equals("En: log(1+En)"))
	    LogImageProc();
	else if(s.equals("En: Contrast "))
	    SigmImageProc();
	else if(s.equals("En: sqrt(En) "))
	    SqrtImageProc();
    }

    public final String getFileName() {
	return filename;
    }

    public final boolean getIsURL() {
	return isURL;
    }

    public final URL getURLName() {
	return fileURL;
    }

    public String getFileName(String title,boolean load) {
	String s=Utils.getBookFileName(title,load);
	if(s!=null) {
	    filename=s;
	    isURL=false;
	}
	return s;
    }

    class RectangleArea extends JPanel {
	public RectangleArea() {
	    Border raisedBevel = BorderFactory.createRaisedBevelBorder();
	    Border loweredBevel = BorderFactory.createLoweredBevelBorder();
	    Border compound = BorderFactory.createCompoundBorder
		              (raisedBevel, loweredBevel);
//	    setBorder(loweredBevel);
	}

	public void paintComponent(Graphics g) {
	    super.paintComponent(g); 
	    Paint(g);
	}

  public void Paint(Graphics gDC) {
    Color color=gDC.getColor();
    int step=1,maxh=SizeY+95,i;

    gDC.setColor(Color.black);
    drawFrames(gDC);
    gDC.drawRect(STARTMAP-1,39,SizeX+1,SizeY+2);

//    if(uwImage!=null) {
//	gDC.setFont(new Font("Dialog",0,8));
//	gDC.drawImage(uwImage,STARTMAP-70+SizeX,maxh+75,this);
//	String text="Matching Pursuit Viewer,"+
//	            " Warsaw University, http://brain.fuw.edu.pl/~mp";
//	gDC.setColor(Color.black);
//	gDC.drawString(text,STARTMAP+(SizeX-6*text.length())/2,maxh+120);
//	gDC.setColor(color);
//    }

    if(image==null) {
	//System.out.println("No image !");
	return;
    }
    gDC.drawImage(image,STARTMAP,40,SizeX,SizeY,Color.black,this);
    double ScaleX=(SizeX-1)/(double)(DimBase-1);

    if(DimBase==1024) step=2;
    else if(DimBase==2048) step=4;
    else if(DimBase>2048)  step=(int)(0.5+1.0/ScaleX);
    int MaxDimBase=DimBase-1-step;

    gDC.setColor(Color.lightGray);
    gDC.fillRect(STARTMAP-44,maxh-40,SizeX+44,43+45);
        
    gDC.setColor(Color.blue);
    gDC.setFont(new Font("Arial",0,10));
    if(map.getAvergMode())
      gDC.drawString("Profile  "+map.getProfileFreq(),STARTMAP-44,SizeY+64);
    else
      gDC.drawString("Full reconstr.",STARTMAP-44,SizeY+64);

    if(reconst!=null)
	gDC.drawString("Selected",STARTMAP-44,SizeY+64+40);

    gDC.setColor(color);

    for(i=0 ; i<MaxDimBase ; i+=step) {
      int Sx=(int)(0.5+ScaleX*i);
      gDC.drawLine(STARTMAP+Sx,maxh-(int)signal[i],
		   STARTMAP+1+Sx,maxh-(int)signal[i+step]);
    }

    if(reconst!=null) {
	gDC.setColor(Color.red);
	int maxhh=maxh+45;
	for(i=0 ; i<MaxDimBase ; i+=step) {
	    int Sx=(int)(0.5+ScaleX*i);
	    gDC.drawLine(STARTMAP+Sx,maxhh-(int)reconst[i],
			 STARTMAP+1+Sx,maxhh-(int)reconst[i+step]);
	}
	gDC.setColor(color);
    }

    DrawScale(gDC);
    DrawFileName(gDC);
  }
    }

  public final static int RGBToInteger(int red,int green,int blue) {
      return 0xff000000|(red<<16)|(green<<8)|blue;
  }

  private int IndexOfImage(int x,int y) {
    return SizeX*((SizeY-1)-y)+x;
  }

  private static double SQR(double x) { 
    return x*x;
  }

  public final static void MakePalette(int paleta[],boolean GrayScale) {
    double hh=255.0,ww=1.0F/(74.0*75.0);
    int i;
    
    if(!GrayScale)
      for(i=1 ; i<=255 ; i++) {
	int r=(int)(hh*Math.exp(-ww*SQR(i-64.0))),
	    g=(int)(hh*Math.exp(-ww*SQR(i-128.0))),
	    b=(int)(hh*Math.exp(-ww*SQR(i-192.0)));
	    
	paleta[256-i]=RGBToInteger(r,g,b);
      } else for(i=1 ; i<255 ; i++) {
	int itmp=255-i;
	paleta[i]=RGBToInteger(itmp,itmp,itmp);
      }

    paleta[255]=RGBToInteger(0,0,0);
    paleta[0]=RGBToInteger(255,255,255);
  }

   private int Xcord(int x) {
       return STARTMAP+(int)((x*SizeX)/(double)DimBase);
   }

  private void SetMinMaxFreq() {
    if(map==null) return;
    double MinF,MaxF,Nequist=0.5*Sampling,OldMinF=StartFreq,OldMaxF=StopFreq;
    boolean ok=true;

    try {
      MinF=Float.valueOf(StartFreqText.getText()).floatValue();
      MaxF=Float.valueOf(StopFreqText.getText()).floatValue();
      if(MinF>=MaxF) {
	  MinF=0.0; MaxF=Nequist;
	  ok=false;
      }
    } catch(NumberFormatException e) {
	MinF=0.0; MaxF=Nequist; ok=false;
    }

    if(MinF<0.0)     { MinF=0.0; ok=false; }
    if(MaxF>Nequist) { MaxF=Nequist; ok=false; }

    if(!ok) {
	StartFreqText.setText(new Float(MinF).toString());
	StopFreqText.setText(new Float(MaxF).toString());
    }

    map.SetTrueSize(StartFreq=MinF,StopFreq=MaxF);
    double EPS=1.0e-12;
    if(Math.abs(StartFreq-OldMinF)>=EPS || Math.abs(StopFreq-OldMaxF)>=EPS) {
	ClearScreen();
    }
  }

  private void DrawFileName(Graphics gDC) {
      if(filename!=null) {
	  gDC.setColor(Color.lightGray);
	  gDC.fillRect(STARTMAP-2,15,SizeX+1,23);
	  gDC.setColor(Color.blue);
	  gDC.setFont(new Font("Courier",0,12));
	  gDC.drawString(filename,STARTMAP-1,28);
      }
  }

  private void DrawScale(Graphics gDC) {
    int maxh=40+SizeY;
    
    gDC.setColor(Color.black);			
    gDC.drawLine(STARTMAP,maxh,STARTMAP+SizeX,maxh); 

    double maxTime=DimBase/Sampling;
    double Tstep;
    int step,i;

    if(maxTime<10.0)
	Tstep=0.1*maxTime;
    else if(maxTime<20.0)	
	Tstep=1;
    else if(maxTime<100.0)
	Tstep=5;
    else
	Tstep=(int)(0.1*maxTime);

    step=(int)(0.5+Tstep*Sampling);
//    gDC.setFont(new Font("Arial",0,8));

    int k=0,X;
    String s;

    for(i=0 ; i<DimBase ; i+=step) {
      X=Xcord(i);
      gDC.drawLine(X,maxh,X,maxh-3);   
      s=String.valueOf(Round((k++)*Tstep,3));
      gDC.drawString(s,X-2*s.length(),maxh+10);
    }     

    double maxFreq=StopFreq-StartFreq,Fstep;
    
    if(maxFreq<0.1) 
      Fstep=0.1*maxFreq;
    else if(maxFreq<0.5)
      Fstep=0.025;
    else if(maxFreq<1.0)
      Fstep=0.05;	
    else if(maxFreq<2.0)	   
      Fstep=0.1;
    else if(maxFreq<5.0)
      Fstep=0.5;
    else if(maxFreq<10.0)
      Fstep=1.0;
    else if(maxFreq<40.0)
      Fstep=2.0;
    else if(maxFreq<100.0)
      Fstep=5.0;
    else 
      Fstep=10.0;

    double df=Fstep*(SizeY-1)/maxFreq;
    step=(int)(0.5+df);
    X=STARTMAP-5;
//    gDC.drawLine(X,maxh,X,40);
   
    int Y;
    for(i=0,k=0 ; i<SizeY ; i+=step) {
      Y=maxh-(int)(0.5+df*k);
      gDC.drawLine(X,Y,X+3,Y);
      s=String.valueOf(Round(StartFreq+(k++)*Fstep));
      gDC.drawString(s,X-15-2*s.length(),Y+3);
    }
    
    for(i=1 ; i<255 ; i++) {
      gDC.setColor(new Color(Paleta[i]));
      Y=maxh-i;
      gDC.drawLine(STARTMAP+SizeX+8,Y,STARTMAP+SizeX+18,Y);
    }
    gDC.setColor(Color.black);
    gDC.drawRect(STARTMAP+SizeX+7,41,12,255);
  }

  private void SqrtImageProc() {
      if(map==null)
	  return;
      map.SqrtScale();
      DrawMap(map);
      repaint();
  }

  private void LogImageProc() {
    if(map==null) 
	return;
    map.LogScale();
    DrawMap(map);
    repaint();
  }
  
  private void NormImageProc() {
    if(map==null) 
	return;
    map.NormScale();
    DrawMap(map);
    repaint();
  }
    
    private void SigmImageProc() {
	if(map==null) return;
	int i,Max=256;
	float Hist[]=new float[Max];
	
	map.getHistogram(Hist);
	float sum=Hist[0];

	for(i=1 ; i<Max ; i++) {
	    sum+=Hist[i];
	    Hist[i]+=Hist[i-1];
	}
	
	if(sum!=0.0F)
	    for(i=0 ; i<Max ; i++)
		Hist[i]/=sum;

	map.SigmaScale(Hist);
	DrawMap(map);
	repaint(); 
    }

  private void drawCrosses() {
      if(!drawCrossesOn || map==null || AvergMapOn)
	  return;

      double SamplingFreq=map.book.SamplingFreq();
      int minF=(int)(0.5+StartFreq*(DimBase-1)/SamplingFreq); 
      int maxF=(int)(0.5+StopFreq*(DimBase-1)/SamplingFreq);
      double AFreq=(maxF-minF)/(double)(SizeY-1),BFreq=minF;

      int    BookLen=map.book.NumOfAtoms();
      double dx=(SizeX-1)/(double)(DimBase-1);
      int    D=2,C=(GrayScale ? RGBToInteger(64,64,64)
		              : RGBToInteger(220,220,220));
      int i,k,x,y;

      for(k=0 ; k<BookLen ; k++) {
	  x=(int)(map.book.position(k)*dx);
	  y=(int)((map.book.ifreq(k)-BFreq)/AFreq);
	  if(y>=0 && y<SizeY)
	      for(i=x-D ; i<=x+D ; i++)
		  if(i>=0 && i<SizeX) 
		      WignerImage[IndexOfImage(i,y)]=C;

	  if(x>=0 && x<SizeX)
	      for(i=y-D ; i<=y+D ; i++)
		  if(i>=0 && i<SizeY)
		      WignerImage[IndexOfImage(x,i)]=C;
      }
  }

  public void DrawMap(WignerMap map) {
    try {
      int i,j;
      double min=map.getMinVal(),max=map.getMaxVal();    
      double scale=(min!=max) ? 255.0/(max-min) : 1.0;
      int code;
    
      MakePalette(Paleta,GrayScale);
      for(i=0 ; i<SizeX ; i++)
	for(j=0 ; j<SizeY ; j++) {
	  code=(int)(1.5+scale*(map.Map[i][j]-min));
	  if(code<1)   code=1;
	  if(code>254) code=254;
	  WignerImage[IndexOfImage(i,j)]=Paleta[code];
	}

      drawCrosses();
      image=createImage(new MemoryImageSource(SizeX,SizeY,
					      WignerImage,0,SizeX));
      NoPaint=false;
    } catch(OutOfMemoryError e) { 
	new WaringMessageDialog("MEM ERROR "+e.getMessage());
      System.gc(); 
    }
  }
 
  public void GoToButton_Clicked() {
    int Offset=0;
    
    if(filename==null || map==null) return;
    try {
	int maxp=map.book.getMaxBookNumber();
	Offset=Integer.parseInt(textField5.getText().trim())-1;

	if(Offset>=maxp || Offset<0) {
	    new WaringMessageDialog("Book position >= "+maxp+" or <0");
	    textField5.setText(""+(MapOffset+1));
	    return; 
	}
    } catch(NumberFormatException e) {
	new WaringMessageDialog("ERROR (GotoButtonClicked): "+
				 e.getMessage());
	textField5.setText(""+(MapOffset+1));
	return;
    }

    SetMinMaxFreq();
    int OldOffset=MapOffset;
    MapOffset=Offset;

    ComputeOnOff(true);
    if(map.MakeWignerMap(Offset)) {
      Compute(map);
      textField5.setText(""+(Offset+1));
    } else MapOffset=OldOffset;
    ComputeOnOff(false);
  }
  
  public final void Compute(WignerMap map) {
      Sampling=map.getSamplingFreq();
      DimBase=map.getDimBase(); signal=map.getSignal();
      setMapScale();
  }

  private void RightMove_Clicked() {
    if(map==null) return;
    int Offset=MapOffset+1;
    SetMinMaxFreq();
    ComputeOnOff(true);
    if(map.MakeNextWignerMap()) {
	MapOffset=Offset;
	Compute(map);
	textField5.setText(""+(Offset+1));
    }
    ComputeOnOff(false);
  }

  private void showAsciiBook() {
    if(map==null) return;
    shower=new BookShower(this);
    shower.setVisible(true);
  }

  private void AvergBook() {
    if(StartStopOK && map!=null) {
	AvergDialog=new AvergBookDialog(this);
	AvergDialog.setVisible(true);
    } else {
	AvergMapOn=false;
	enabledButtons(false);
    }
  }

  public void MakeAvergBook() { 
    if(map==null) return;
    SetMinMaxFreq();
    if(map.AvergWignerMap(StartOffset,StopOffset)) {
      MapOffset=map.getOffset();
      Compute(map);
      textField5.setText(""+(MapOffset+1));
      setArrowsEnabled();
      ClearScreen();
    } 
  }

  private void ReplotMap() {
    SetMinMaxFreq(); map.CommonWig(); Compute(map);
    repaint();
  }

  private void ReplotMapWithNoPaint() {
    SetMinMaxFreq(); map.CommonWig(); Compute(map);
  }

  private void LeftMove_Clicked() {
    if(map==null) return;
    int Offset=MapOffset-1;
    if(Offset<0) return;

    SetMinMaxFreq();
    ComputeOnOff(true);
    if(map.MakeWignerMap(Offset)) {
      MapOffset=Offset;
      Compute(map);
      textField5.setText(""+(Offset+1));
    }
    ComputeOnOff(false);
  }

    private void fprintf(BufferedOutputStream F0,String string) 
	throws IOException {
	byte buffor[]=string.getBytes();
	F0.write(buffor,0,buffor.length);
    }

  public void SaveToAsciiFile(String filename) throws IOException {
      if(map==null) return;
      if(filename!=null) {/*
	  try {
	      netscape.security.PrivilegeManager.enablePrivilege("UniversalFileWrite");
	  } catch(Exception e) {
	      ;
	      }*/

	  ProgressIndex index;
	  (index=new ProgressIndex(SizeX,"Saving...")).setVisible(true);

	  OutputStream fstream=new FileOutputStream(new File(filename));
	  BufferedOutputStream file=new BufferedOutputStream(fstream,32768);
	  index.UpDateIndex();

	   for(int i=0 ; i<SizeX ; i++) {
	       for(int j=0 ; j<SizeY ; j++) 
		   fprintf(file,map.Map[i][j]+" ");
	       fprintf(file,"\n");
	       
	       index.NextIndex();
	       if(i%32==0)
		   index.UpDateIndex();
	   }

	   file.close();
	   index.Close();
	   new WaringMessageDialog("File "+filename+" write OK");
      }
  }

    private void saveFullSignal() { 
	if(map==null) return;
	String file=Utils.getFileName("Save full signal",true);
	if(file!=null) {
	    if(AvergMapOn==false)
		map.saveReconstruction(file,true);
	    else
		map.saveProfile(file,profileIndex);
	}
    }

    private void saveReconstruction() {
	if(map==null) return;
	String file=Utils.getFileName("Save reconstruction",true);
	if(file!=null) {
	    map.saveReconstruction(file,false);
	}
    }

  public void SaveToFile(String filename,boolean IntelSwap) 
      throws IOException {
      if(map==null) return;
      if(filename!=null) { /*
	  try {
	      netscape.security.PrivilegeManager.enablePrivilege("UniversalFileWrite");
	  } catch(Exception e) {
	      ;
	      }*/

	  OutputStream fstream=new FileOutputStream(new File(filename));
	  DataOutputStream file=new DataOutputStream(fstream);

	  byte buffor[]=new byte[4*SizeY];
	  int i,j,k,itmp;
	  
	  for(i=0 ; i<SizeX ; i++) {
	      for(j=0,k=0 ; j<SizeY ; j++) {
		  itmp=Float.floatToIntBits(map.Map[i][j]);
		  if(IntelSwap) {
		      buffor[k++]=(byte)(itmp&0xff);
		      buffor[k++]=(byte)((itmp>>8)&0xff);
		      buffor[k++]=(byte)((itmp>>16)&0xff);
		      buffor[k++]=(byte)((itmp>>24)&0xff);
		  } else {
		      buffor[k++]=(byte)((itmp>>24)&0xff);
		      buffor[k++]=(byte)((itmp>>16)&0xff);
		      buffor[k++]=(byte)((itmp>>8)&0xff);
		      buffor[k++]=(byte)(itmp&0xff);
		  }
	      }

	      file.write(buffor);
      	  }

	  file.close();
	  new WaringMessageDialog("File "+filename+" write OK");
      }
  }

  private void closeFFTBox() {
      if(shower!=null) {
	  shower.setVisible(false);
	  shower.dispose();
	  shower=null;
      }

      if(FFTSignalDialog!=null) {
	  FFTSignalDialog.setVisible(false);
	  FFTSignalDialog.dispose();
	  FFTSignalDialog=null;
      }
	      
      if(FFTReconstDialog!=null) {
	  FFTReconstDialog.setVisible(false);
	  FFTReconstDialog.dispose();
	  FFTReconstDialog=null;
      }
  }

  private void LoadButton_Clicked() {
      String filename=this.getFileName("Load Book",true);

      if(filename!=null) {
	  ComputeOnOff(true);
	  WignerMap tmap=new WignerMap(512,256,0,512,0,256,512);

	  if(tmap.MakeWignerMap(filename,0)) {
	      map=tmap; tmap=null;
	      loadCommon();
	      closeFFTBox();
	      ClearScreen();
	  }
	  ComputeOnOff(false);
      }
  }

    private void loadCommon() {	
	StartFreqText.setText("0.0"); 
	StartFreq=0.0;
	Sampling=map.getSamplingFreq();
	StopFreqText.setText(""+Round(StopFreq=0.5*Sampling));
	SetMinMaxFreq();
	Compute(map); textField5.setText("1"); MapOffset=0;
	SetMinMaxFreq();

	StartOffset=0;
	StopOffset=map.getMaxOffset()-1;
	StartStopOK=true;
	ClearScreen();
    }

    public boolean loadFile(String file) {
	WignerMap tmap=new WignerMap(512,256,0,512,0,256,512);

	ComputeOnOff(true);
	if(tmap.MakeWignerMap(file,0)) {
	    filename=file;
	    map=tmap; tmap=null;
	    loadCommon();
	    ComputeOnOff(false);
	    return true;
	} 
	ComputeOnOff(false);
	return false;
    }

    public void loadFile(URL file) {
	WignerMap tmap=new WignerMap(512,256,0,512,0,256,512);
	ComputeOnOff(true);
	if(tmap.MakeWignerMap(file,0)) {
	    fileURL=file;
	    isURL=true;
	    filename=file.toString();
	    map=tmap; tmap=null;
	    loadCommon();
	}
	ComputeOnOff(false);
    }

  private void DrawAtom(int x,int y) {
      if(AvergMapOn) return;
      int index=findAtom(x,y);
      if(index!=-1) {
	  if(textField8.isVisible()==false)
	      textField8.setVisible(true);
	  textField8.setText(
           "p2p "+ Round(2*map.book.amplitude(index))+
			     "    f "+Round(map.book.Frequency(index),6)+
           "    t "+Round(map.book.TimePosition(index))+
			     "    scale "+map.book.scale(index)+
			     "    mod "+Round(map.book.modulus(index))+
			     "    phase "+Round(map.book.truephase(index))
			     );
      } else if(textField8.isVisible())
	  textField8.setVisible(false);
  }

  private int findAtom(int x,int y) {
    if(map==null)  return -1;
    if(AvergMapOn) return -1;
   
    double ftmp=(DimBase-1)/Sampling;
    int Start=(int)(StartFreq*ftmp),Stop=(int)(StopFreq*ftmp);
    int ifreq=(int)(Start+((Stop-Start)*y)/(float)(SizeY-1)),
	itime=(int)(((DimBase-1)*x)/(float)(SizeX-1));
    int Len=map.book.NumOfAtoms();
    int index=-1;
    double MinDist=SQR(10.0),Distans;
    
    for(int i=0 ; i<Len ; i++) {
	Distans=SQR(ifreq-map.book.ifreq(i))+
	        SQR(itime-map.book.position(i));
	if(Distans<MinDist) { 
	    MinDist=Distans;
	    index=i;
	}
    }

    return index;
  }

  private static float Round(double x) {
    return (float)(Math.floor(1000.0*x+0.5)/1000.0);
  }

    private static float Round(double x,int n) {
	double fact=Math.pow(10.0,n);
	return (float)(Math.floor(fact*x+0.5)/fact);
    }

    public void mouseMoved(MouseEvent event) {
	int x=event.getX(),y=event.getY();

	if(x>=STARTMAP && x<(STARTMAP+SizeX) && y>=40 && y<(40+SizeY)) {
	    x-=STARTMAP; y=SizeY-y+40;
	    double df=(StopFreq-StartFreq)/SizeY;
	    
	    if(TimeFreqText.isVisible()==false)
		TimeFreqText.setVisible(true);
	    TimeFreqText.setText("t: "+Round((DimBase*x)/(SizeX*Sampling))+
				 " f: "+Round(StartFreq+y*df,6)+" E: "+
				 ((map!=null) ? Round(map.getValue(x,y))+
				  "%" : " "));
	    DrawAtom(x,y);
	} else {
	    if(TimeFreqText.isVisible())
		TimeFreqText.setVisible(false);
	    if(textField8.isVisible())
		textField8.setVisible(false);
	    
	}
    }
    
  private void FilterButtonClicked() {
    if(OK && map!=null) {
	Dialog=new FilterDialog(map.book,this,map);
	Dialog.SetFilter(map.book);
	Dialog.setVisible(true);
    }
  }

    private static final int F=20;
    private static final int HORIZONTAL_SIZE=750+F,VERTICAL_SIZE=464;
  
    private void drawFrames(Graphics gDC) {
	gDC.setFont(new Font("Helvetica",Font.BOLD,10));
	gDC.drawString("mp decomposition",10,25-4);
//	gDC.drawRect(10,25,125+2*F,122);

	gDC.drawString("map",10,148+S1-4);
//	gDC.drawRect(10,148+S1,125+2*F,122);

	gDC.drawString("signal",10,274+S2-4);
	int Y=125;
	if(SERVER && isApplet==false)
	    Y=125;
	else if(SERVER && isApplet)
	    Y=93;
	else if(SERVER==false && isApplet)
	    Y=93-29;
	else if(SERVER==false && isApplet==false)
//	    Y=93;
Y=120;

//	gDC.drawRect(10,274+S2,125+2*F,Y-58); //93
    }

  public void init() {
      if(isApplet) {
	  try {
	      UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
	  } catch(UnsupportedLookAndFeelException exc) {
	      System.err.println("Warning: UnsupportedLookAndFeel ");
	  } catch(Exception exc) {
	      System.err.println("Error loading " + exc);
	  }
      }

    getContentPane().setLayout(null);
    setSize(HORIZONTAL_SIZE,VERTICAL_SIZE);
    setBackground(Color.lightGray);

    MainPanel=new RectangleArea();
    MainPanel.setBounds(0,0,HORIZONTAL_SIZE,VERTICAL_SIZE-10);
    MainPanel.setBackground(Color.lightGray);
    MainPanel.setLayout(null);
    getContentPane().add(MainPanel);

    infoHint=new JLabel();
    infoHint.setBounds(STARTMAP,VERTICAL_SIZE-65,200,15); // *
    infoHint.setFont(new Font("Courier",Font.BOLD,10));
    infoHint.setBackground(Color.yellow);
    infoHint.setForeground(Color.black);
    infoHint.setHorizontalAlignment(JLabel.CENTER);
    infoHint.setVisible(false);
    MainPanel.add(infoHint);

    LoadButton=new JButton("load");
    LoadButton.setBounds(3,30,59+F,27);
    LoadButton.addActionListener(this);
    LoadButton.addMouseListener(this);
//    LoadButton.setFont(new Font("Dialog",Font.BOLD,10));
    LoadButton.setToolTipText("Load a file containing mp decomposition "+
			      "from a local path");
    MainPanel.add(LoadButton);

    loadURLButton = new JButton("url");
    loadURLButton.setBounds(64+F,30,59+F,27);
    loadURLButton.addActionListener(this);
    loadURLButton.addMouseListener(this);
//    loadURLButton.setFont(new Font("Dialog",Font.BOLD,10));
    loadURLButton.setToolTipText("Load a file containing mp decomposition "+
				 "from Internet");
    MainPanel.add(loadURLButton);

    RightMove = new JButton(">");
//    RightMove.setBounds(94+F,60,28+F,27);
    RightMove.setBounds(90+F,60,33+F,27);
    RightMove.addActionListener(this);
    RightMove.addMouseListener(this);
//    RightMove.setFont(new Font("Dialog",Font.PLAIN,8));
    RightMove.setToolTipText("Go to next decomposition in file");
    MainPanel.add(RightMove);

    button1=new JButton("<");
//    button1.setBounds(3,60,28+F,27);
    button1.setBounds(3,60,33+F,27);
    button1.addActionListener(this);
    button1.addMouseListener(this);
//    button1.setFont(new Font("Dialog",Font.PLAIN,8));
    button1.setToolTipText("Go to previous decomposition in file");
    MainPanel.add(button1);

    enScale=new JComboBox();
    enScale.setBounds(3,120,120+2*F,23);
//    enScale.setFont(new Font("Courier",Font.BOLD,10));

    enScale.addItem("En: Linear   ");
    enScale.addItem("En: log(1+En)");
    enScale.addItem("En: sqrt(En) ");
    enScale.addItem("En: Contrast ");
    enScale.setToolTipText("Gamma correction i.e, translation from energy to colors");
    enScale.addItemListener(this);
    enScale.addMouseListener(this);
    MainPanel.add(enScale);


    ShowAscButton=new JButton("param");
    ShowAscButton.setBounds(3,90,60+F,27);
//    ShowAscButton.setFont(new Font("Dialog",Font.BOLD,10));
    ShowAscButton.addActionListener(this);
    ShowAscButton.addMouseListener(this);
    ShowAscButton.setToolTipText("Display/save parameters of the Gabor"+
				 " functions from the current set");
    MainPanel.add(ShowAscButton);

    FilterButton=new JButton("filter");
    FilterButton.setBounds(64+F,90,59+F,27);
    FilterButton.addActionListener(this);
//    FilterButton.setFont(new Font("Dialog",Font.BOLD,8));
    FilterButton.addMouseListener(this);
    FilterButton.setToolTipText("Construct time-freq. map from atoms in"+
				" selected ranges of parameters");
    MainPanel.add(FilterButton);

    TagFilterButton=new JButton("reset");
    TagFilterButton.setBounds(64+F,151+S1,59+F,27);
//    TagFilterButton.setFont(new Font("Dialog",Font.BOLD,8));
    TagFilterButton.addActionListener(this);
    TagFilterButton.addMouseListener(this);
    TagFilterButton.setToolTipText("Reset energy scale and \"selected\" signal"+
				   " reconstruction");
    MainPanel.add(TagFilterButton);

    SaveToFile=new JButton("save");
    SaveToFile.setBounds(3,151+S1,59+F,27);
    SaveToFile.addActionListener(this);
    SaveToFile.addMouseListener(this);
//    SaveToFile.setFont(new Font("Dialog",Font.BOLD,10));
    SaveToFile.setToolTipText("Save time-freq. map to disk");
    MainPanel.add(SaveToFile);

    AvergButton=new JButton("avg...");
    AvergButton.setBounds(3,181+S1,59+F,27);
//    AvergButton.setFont(new Font("Dialog",Font.BOLD,8));
    AvergButton.addActionListener(this);
    AvergButton.addMouseListener(this);
    AvergButton.setToolTipText("Make time-freq. map from all the atoms"+
			       " from selected sets in file");
    MainPanel.add(AvergButton);

    ReAvergButton=new JButton("averg");
    ReAvergButton.setBounds(64+F,181+S1,59+F,27);
    ReAvergButton.addActionListener(this);
    ReAvergButton.addMouseListener(this);
//    ReAvergButton.setFont(new Font("Dialog",Font.BOLD,8));
    ReAvergButton.setToolTipText("Apply chosen filter to the averge map"+
				 " of chosen sets");
    MainPanel.add(ReAvergButton);

    ModeButton=new JButton("gray");
    ModeButton.setBounds(3,240+S1,60+F,27);
    ModeButton.addActionListener(this);
    ModeButton.addMouseListener(this);
//    ModeButton.setFont(new Font("Dialog",Font.BOLD,10));
    ModeButton.setToolTipText("Toggle map display in color/grayscal");
    MainPanel.add(ModeButton);

    JLabel lab=new JLabel("f:");
    lab.setBounds(3,210+S1,15,27);
//    lab.setFont(new Font("Courier",Font.BOLD,8));
    MainPanel.add(lab);

    StartFreqText=new JTextField();
    StartFreqText.setText("0.0");
    StartFreqText.setBounds(14,210+S1,45+F,27);
    StartFreqText.addActionListener(this);
    StartFreqText.addMouseListener(this);
    StartFreqText.setHorizontalAlignment(JTextField.CENTER);
    StartFreqText.setToolTipText("minimum frequency");
    MainPanel.add(StartFreqText);

    lab=new JLabel("-");
    lab.setBounds(64+F,210+S1,15,27);
//    lab.setFont(new Font("Courier",Font.BOLD,12));
    MainPanel.add(lab);

    StopFreqText=new JTextField();
    StopFreqText.setText("0.5");
    StopFreqText.setBounds(73+F,210+S1,45+F,27);
    StopFreqText.addActionListener(this);
    StopFreqText.addMouseListener(this);
    StopFreqText.setHorizontalAlignment(JTextField.CENTER);
    StopFreqText.setToolTipText("maximum frequency");
    MainPanel.add(StopFreqText);

    textField5 = new JTextField();
    textField5.setText("1");
////////////////////
    textField5.setBounds(33+F,60,60,27);
    textField5.addActionListener(this);
    textField5.addMouseListener(this);
    textField5.setHorizontalAlignment(JTextField.CENTER);
    textField5.setToolTipText("number (position) of currently displayed decomposition in file");
    MainPanel.add(textField5);

    CrossesButton=new JButton("cross");
    CrossesButton.setBounds(64+F,240+S1,59+F,27);
//    CrossesButton.setFont(new Font("Courier",Font.BOLD,10));
    CrossesButton.addActionListener(this);
    CrossesButton.addMouseListener(this);
    CrossesButton.setToolTipText("Toggle drawing small crosses in time-freq. ceters"+
				 " of atoms");
    MainPanel.add(CrossesButton);

    FFTButton=new JButton("fft");
    FFTButton.setBounds(3,277+S2,59+F,27);
    FFTButton.addActionListener(this);
    FFTButton.addMouseListener(this);
//    FFTButton.setFont(new Font("Dialog",Font.BOLD,10));
    FFTButton.setToolTipText("Display signal power spectrum");
    MainPanel.add(FFTButton);

    FFTRecButton=new JButton("fft r");
    FFTRecButton.setBounds(64+F,277+S2,59+F,27);
    FFTRecButton.addActionListener(this);
    FFTRecButton.addMouseListener(this);
//    FFTRecButton.setFont(new Font("Dialog",Font.BOLD,10));
    FFTRecButton.setToolTipText("Display spectrum of signal constructed"+
				" from chosen atoms");
    MainPanel.add(FFTRecButton);

    textField8 = new JLabel();
    textField8.setBounds(188+F,256+40+72+35+15+5,224+200+100,15); // *
    textField8.setBackground(Color.yellow);
    textField8.setForeground(Color.black);
//    textField8.setFont(new Font("Courier",Font.BOLD,10));
    textField8.setHorizontalAlignment(JLabel.LEFT);
    textField8.setVisible(false);
    MainPanel.add(textField8);

    fullRec=new JButton("save");
    fullRec.setBounds(3,307+S2,59+F,27);
    fullRec.addActionListener(this);
    fullRec.addMouseListener(this);
//    fullRec.setFont(new Font("Dialog",Font.BOLD,10));
    fullRec.setToolTipText("Save full signal or energy profile to disk");
    MainPanel.add(fullRec);

    chosenRec=new JButton("sav r");
    chosenRec.setBounds(64+F,307+S2,59+F,27);
    chosenRec.addActionListener(this);
    chosenRec.addMouseListener(this);
//    chosenRec.setFont(new Font("Dialog",Font.PLAIN,10));
    chosenRec.setToolTipText("Save signal constructed from chosen atoms");
    MainPanel.add(chosenRec);

    TimeFreqText = new JLabel();
    TimeFreqText.setBounds(188+F,40+256+72+35,150+147+2*F,15);  // *
    TimeFreqText.setBackground(Color.yellow);
    TimeFreqText.setForeground(Color.black);
//    TimeFreqText.setFont(new Font("Courier",Font.BOLD,10));
    TimeFreqText.setHorizontalAlignment(JLabel.LEFT);
    TimeFreqText.setVisible(false);
    MainPanel.add(TimeFreqText);

    isIE=isMicrosoftIE();
    if(!isApplet) {
	exitButton=new JButton("quit");
//	exitButton.setForeground(Color.red);
//	exitButton.setBounds(74+F,(SERVER ? 367 : 337+18)+S2,59+F,27);
	exitButton.setBounds(3,337+30+S2+18,2*(59+F)+2,27);
//	exitButton.setFont(new Font("Courier",Font.BOLD,10));
	exitButton.addActionListener(this);
	exitButton.addMouseListener(this);
	exitButton.setToolTipText("exit application");
	MainPanel.add(exitButton);

	cloneButton=new JButton("clone");
	cloneButton.setForeground(Color.black);
	cloneButton.setBounds(3,(SERVER ? 367 : 337+18)+S2,59+F,27);
//	cloneButton.setFont(new Font("Courier",Font.BOLD,10));
	cloneButton.addActionListener(this);
	cloneButton.addMouseListener(this);
	cloneButton.setToolTipText("new applet window");
	MainPanel.add(cloneButton);

	nativeButton=new JButton("zoom");
//  nativeButton.setForeground(new Color(0,120,0));
	nativeButton.setBounds(64+F,(SERVER ? 367 : 337+18)+S2,59+F,27);
//	nativeButton.setFont(new Font("Courier",Font.BOLD,10));
	nativeButton.addActionListener(this);
	nativeButton.setToolTipText("zoom/save time-freq. map");
	MainPanel.add(nativeButton);





    } else {
	//	Netscape.init();
	String s=getParameter("save");
	if(s!=null) {
	    SecurityInfo.setState(s.equals("true"));
	} else {
	    SecurityInfo.securityInfoInit();
	    System.out.println("Can write: "+SecurityInfo.canWrite());
	}
    }
    
    if(isApplet) {
	String s=getParameter("book");
	if(s!=null) {
	    try {
		URL url=new URL(getDocumentBase(),s);
		loadFile(url);
	    } catch(MalformedURLException e) {
		new WaringMessageDialog("ERROR: "+e.getMessage());
	    }
	}
    }



    if(SERVER) {
	MPButton=new JButton("MP");
	MPButton.setForeground(Color.blue);
	MPButton.setBounds(13,337+S2,60+F,27);
	MPButton.setFont(new Font("Courier",Font.BOLD,10));
	MPButton.addActionListener(this);
	MPButton.addMouseListener(this);
	MPButton.setToolTipText("MP decomposition");
	MainPanel.add(MPButton);


	try {
	    String s;
	    if(isApplet) {
		if((s=getParameter("host"))!=null)
		    hostname=s;
	    } else {
		if((s=System.getProperty("host"))!=null)
		    hostname=s;
	    }
	} catch(SecurityException e) {
	    System.err.println(e.getMessage());
	}
    }





    if(isApplet==true && SecurityInfo.canWrite()==false) {
	SaveToFile.setEnabled(false);
	fullRec.setEnabled(false);
	chosenRec.setEnabled(false);
    }

    addMouseListener(this);
    addMouseMotionListener(this);
//    uwImage=getImage("sigillu.jpg",60,60);
  }

    public void itemStateChanged(ItemEvent evt) {
	if(evt.getSource() instanceof JComboBox) {
	    if(evt.getStateChange()==ItemEvent.SELECTED) {
		String s=(String)((JComboBox)evt.getSource()).getSelectedItem();
		
		if(     s.equals("En: Linear   "))
		    NormImageProc();
		else if(s.equals("En: log(1+En)"))
		    LogImageProc();
		else if(s.equals("En: Contrast "))
		    SigmImageProc();
		else if(s.equals("En: sqrt(En) "))
		    SqrtImageProc();
	    }
	}
    }

    private void setHint(String hint) {
	infoHint.setSize(6*hint.length()+12,15);
	infoHint.setVisible(true);
	infoHint.setText(hint);
    }

    public void mouseEntered(MouseEvent evt) {
	Object object=evt.getSource();
  
	if(object==enScale)
	    setHint("Gamma correction i.e, translation from energy to colors");
    }

    public void mouseExited(MouseEvent evt) {
	Object object=evt.getSource();

	if(object==StartFreqText   || object==StopFreqText    ||
	   object==textField5      || object==enScale ) {
	    infoHint.setVisible(false);
	}

	if(object==this) {
	    infoHint.setVisible(false);
	    textField8.setVisible(false);
	    TimeFreqText.setVisible(false);
	}
    }

    public void mousePressed(MouseEvent evt) {
    }

    public void mouseReleased(MouseEvent evt) {
    }

    public void makeReconstList(int index[]) {
	for(int i=0 ; i<index.length ; i++)
	    map.setAtom(index[i]);

	reconst=map.getReconstruction();
	repaint();

	if(FFTReconstDialog!=null)
	    FFTReconstDialog.UpDate();

	if(shower!=null) 
	    shower.UpDate();
    }

  public void mouseClicked(MouseEvent evt) {
    if(map==null) return;
    int x=evt.getX(),y=evt.getY();

    if(x>=STARTMAP && x<(STARTMAP+SizeX) && y>=40 && y<(40+SizeY)) {
	if(AvergMapOn) {
	    if(evt.getClickCount()>1)
		map.getEnergyProfile(profileIndex=-1);
	    else
		map.getEnergyProfile(profileIndex=SizeY-y+40);
	    repaint();
	} else {
	    x-=STARTMAP; 
	    y=SizeY-y+40;
	    int index=findAtom(x,y);
	    if(index!=-1) {
		map.setAtom(map.book.getAtomIndex(index));
		reconst=map.getReconstruction();
		repaint();
		
		if(FFTReconstDialog!=null) {
		    FFTReconstDialog.UpDate();
		}

		if(shower!=null) {
		    shower.UpDate();
		}
	    }
	}
    }
  }

    public void mouseDragged(MouseEvent evt) {
    }

  private void setColorMode() {
    if(map==null) return;
    GrayScale=!GrayScale;
    if(GrayScale)
	ModeButton.setText("Color");
    else
	ModeButton.setText("Gray");
    DrawMap(map);
    repaint();
  }

   public void updateAndClose() {
       if(shower!=null) {
	   shower.UpDate();
       }

       if(FFTSignalDialog!=null) {
	   FFTSignalDialog.UpDate();
       }
       if(FFTReconstDialog!=null) {
	   FFTReconstDialog.setVisible(false);
	   FFTReconstDialog.dispose();
	   FFTReconstDialog=null;
       }
   }

  private void closeReconst() {
      if(FFTReconstDialog!=null) {
	  FFTReconstDialog.setVisible(false);
	  FFTReconstDialog.dispose();
	  FFTReconstDialog=null;
      }
  }

    private void ComputeOnOff(boolean value) {
	setArrowsEnabled();
	if(value) {
	    textField8.setVisible(true);
	    textField8.setText("Computing...");
	} else {
	    textField8.setVisible(false);
	    textField8.setText(" ");
	}
    }

  private void closeSignal() {
      if(FFTSignalDialog!=null) {
	  FFTSignalDialog.setVisible(false);
	  FFTSignalDialog.dispose();
	  FFTSignalDialog=null;
      }
  }

    public void saveImageToGif(String filename) throws IOException {
	if(image==null)
	    return; /*
	try {
	    netscape.security.PrivilegeManager.enablePrivilege("UniversalFileWrite");
	} catch(Exception e) {
	    ;
	    }*/
	OutputStream stream=new FileOutputStream(new File(filename));
	GifEncoder      gif=new GifEncoder(image,stream);
	    
	gif.encode();
	stream.close();
	new WaringMessageDialog("File "+filename+" write OK");
    } 
    
    public void setArrowsEnabled() {
	if(map!=null) {
	    if(MapOffset<=0) 
		button1.setEnabled(false);
	    else 
		button1.setEnabled(true);

	    if(MapOffset>=map.book.getMaxBookNumber()-1)
		RightMove.setEnabled(false);
	    else 
		RightMove.setEnabled(true); 

	    if(!button1.isEnabled() && !RightMove.isEnabled()) {
		textField5.setText("  ONE ");
		textField5.setEnabled(false);
		AvergButton.setEnabled(false);
		ReAvergButton.setEnabled(false);
	    } else {
		textField5.setText(""+(MapOffset+1));
		textField5.setEnabled(true);
		AvergButton.setEnabled(true);
		ReAvergButton.setEnabled(true);
	    }
	}
    }

    public final boolean isAvergMode() {
	return AvergMapOn;
    }

    public final void reaverg() {
	reconst=null;
	AvergMapOn=true;
	enabledButtons(true);
	ComputeOnOff(true); 
	MakeAvergBook();
	//	setMapScale();
	ComputeOnOff(false);
    }
  
    private void CloseBookShower() {
	if(shower!=null) {
	    shower.setVisible(false);
	    shower.dispose(); 
	    shower=null;
	    System.gc();
	}
    }  

    private void bigMapButtonClicked() {
	if(map!=null) {
	    new BigMapFrame(this).setVisible(true);
	}
    }

  public void actionPerformed(ActionEvent evt) {
      Object event=evt.getSource();
      
      if(event==CrossesButton) {
	  drawCrossesOn=!drawCrossesOn;
	  if(map!=null)
	      DrawMap(map);
	  repaint();
      } else if(event==exitButton) {
	  if(!newWindow)
	      System.exit(0);
	  else {
	      setVisible(false);
	      if(winFrame!=null) {
		  winFrame.setVisible(false);
		  winFrame.dispose();
	      }
	      destroy();
	  }
      } else if(event==loadURLButton) {
	  FileFromURLDialog dialog=new FileFromURLDialog("Book URL");
	  URL url=dialog.getURL();

	  try {
	      if(url!=null) {
		  loadFile(url);
		  AvergMapOn=false;
		  reconst=null;
	      }
	  } catch(Exception e) {
	       new WaringMessageDialog("SECURITY: "+e.getMessage());
	  }
      } else if(event==TagFilterButton) {
	  if(map!=null) {
	      reconst=null;
	      AvergMapOn=false;
	      ComputeOnOff(true);
	      map.book.GetGoodAtoms();
	      ReplotMapWithNoPaint();
	      enabledButtons(false);
	      closeReconst();
	      ComputeOnOff(false);
	      updateAndClose();
	      ClearScreen();
	  }
      } else if(event==LoadButton) {
	  reconst=null;
	  AvergMapOn=false;
	  enabledButtons(false);
	  try {
	      LoadButton_Clicked();
	  } catch(Exception e) {
	      new WaringMessageDialog("SECURITY: "+e.getMessage());
	  }
      } else if(event==button1) {
	  reconst=null;
	  AvergMapOn=false;
	  enabledButtons(false);
	  LeftMove_Clicked();
	  updateAndClose();
      } else if(event==RightMove) {
	  reconst=null;
	  AvergMapOn=false;
	  enabledButtons(false);
	  RightMove_Clicked();
	  updateAndClose();
      } else if(event==FilterButton) {
	  reconst=null;
	  FilterButtonClicked();
      } else if(event==StartFreqText || event==StopFreqText) {
	  reconst=null;
	  AvergMapOn=false;
	  enabledButtons(false);
	  ComputeOnOff(true);
	  if(map!=null)
	      map.book.GetGoodAtoms();
	  ReplotMapWithNoPaint();
	  closeReconst();
	  ComputeOnOff(false);
	  ClearScreen();
	  return;
      } else if(event==textField5) {
	  reconst=null;
	  AvergMapOn=false;
	  enabledButtons(false);
	  GoToButton_Clicked();
	  updateAndClose();
      } else if(event==SaveToFile) {
	  if(map!=null) {
	      SaveDialog dialog=new SaveDialog(this);
	      dialog.setVisible(true);
	  }
      } else if(event==AvergButton) {
	  CloseBookShower();
	  reconst=null;
	  AvergMapOn=true;
	  enabledButtons(true);
	  AvergBook();
      } else if(event==ModeButton) {
	  setColorMode();
      } else if(event==ReAvergButton) {
	 CloseBookShower();
	 reaverg();
      } else if(event==ShowAscButton) {
	  showAsciiBook();
      } else if(event==FFTButton) {
	  if(map!=null && !AvergMapOn) {
	      closeSignal();
	      FFTSignalDialog=new FFTDialog(map,true,"FFT Box (signal)");
	      FFTSignalDialog.setVisible(true);
	  }
      } else if(event==FFTRecButton) {
	  if(map!=null && !AvergMapOn) {
	      closeReconst();
	      FFTReconstDialog=new FFTDialog(map,false,"FFT Box"+
					     " (reconstruction)");
	      FFTReconstDialog.setVisible(true);
	  }
      } else if(event==fullRec) {
	  saveFullSignal();
      } else if(event==chosenRec) {
	  saveReconstruction();
      } else if(event==MPButton) {
	  MPDecomposition();
      } else if(event==cloneButton) {
	  clonempview();
      } else if(event==nativeButton) {
	  bigMapButtonClicked();
      }
  }

    public void enabledButtons(boolean arg) {
	profileIndex=-1;
	arg=!arg;
	CrossesButton.setEnabled(arg);
	ShowAscButton.setEnabled(arg);
	FFTButton.setEnabled(arg); 
	FFTRecButton.setEnabled(arg);
	chosenRec.setEnabled(arg);

	if(isApplet==true && SecurityInfo.canWrite()==false) {
	    SaveToFile.setEnabled(false);
	    chosenRec.setEnabled(false);
	}
    }

    private FFTDialog FFTSignalDialog=null,FFTReconstDialog=null;
    
    public mpview(boolean v) {
	isApplet=v;
    }

    public mpview() {
	isApplet=true;
    }

    public void setNewWindow(boolean win) {
	newWindow=win;
    }

    private void clonempview() {
	System.out.println("new window ...");
	mpview applet=new mpview(false);
	JFrame aFrame=new JFrame("mpview *");

	applet.setNewWindow(true);
	applet.setNewWindowFrame(aFrame);
	aFrame.addWindowListener(new WL(true));
	aFrame.getContentPane().add(applet);
	aFrame.setSize(HORIZONTAL_SIZE+8,VERTICAL_SIZE+20);
	applet.init();
	applet.start();
	aFrame.setVisible(true);
	System.out.println("Done.");
    }

    private static void initJVM() {
	String vers = System.getProperty("java.version");
	if (vers.compareTo("1.1.2") < 0) {
            System.out.println("!!!WARNING: Swing must be run with a " +
                               "1.1.2 or higher version VM!!!");
        }

	try {
	    UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
	    
	} catch (Exception exc) {
	    System.err.println("Error loading L&F: " + exc);
	}
    }

    public static void main(String args[]) {
	boolean flag=false;
	int i;

	for(i=0 ; i<args.length ; i++)
//	  if(args[i].equals("-nonative")) {
//	    NativeAccelerator.disableNativeLibrary();
//	  }
    if(args[i].equals("-noimage")) {
	    flag=false;
	  } else if(args[i].equals("-version")) {
	    System.out.println(VERSION);
	    System.exit(0);
	  } else if(args[i].equals("-help") || 
		    args[i].equals("--help")) { 
	    System.out.println("mpview [-noimage] [-nonative]"+
			       " [-version] [-motif] [-windows]\n\t\t "+
			       "[-metal] [--help] [-help] book.b");
	    System.exit(0);
	  }

	initJVM();
	InitFrame splash=null;
	if(flag) {
	    try {
		splash=new InitFrame();
		splash.setVisible(true);
		splash.toFront();
		splash.waitTillLoaded();
	    } catch(Exception e) {
		System.out.println(e.getMessage());
		splash=null;
	    }
	}

	mpview applet=new mpview(false);
	JFrame aFrame=new JFrame("mpview "+VERSION);

	aFrame.addWindowListener(new WL(false));
	aFrame.getContentPane().add(applet);
	aFrame.setSize(HORIZONTAL_SIZE+8,VERTICAL_SIZE+20);
//	System.out.println("Init application...");
	applet.init();
	applet.start();

	String model=null;
	if(args.length!=0) {
	    for(i=0 ; i<args.length ; i++)
	        if(args[i].equals("-motif")) {
		    model="com.sun.java.swing.plaf.motif.MotifLookAndFeel";
		} else if(args[i].equals("-metal")) {
		    model="javax.swing.plaf.metal.MetalLookAndFeel";
		} else if(args[i].equals("-windows")) {
		    model="com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
		} else if(!args[i].equals("-noimage") && 
			  !args[i].equals("-nonative")) {
//		    System.out.println("Loading book...");
		    if(!applet.loadFile(args[i])) 
			System.out.println("File "+args[i]+" not found !");
		    break;
		}
	}
	
	if(model!=null) {
	     try {
		 UIManager.setLookAndFeel(model);
		 SwingUtilities.updateComponentTreeUI(aFrame);
	     } catch(Exception exc) {
		 System.err.println("Could not load LookAndFeel: "+
				    exc.getMessage());
	     }
	}
	
	aFrame.setVisible(true);
//	System.out.println("Done.");

	if(flag && splash!=null) {
	    try { 
		Thread.sleep(3000L); 
	    } catch(Exception e) {
		System.out.println(e.getMessage());
	    }
	    splash.setVisible(false);
	    splash.dispose();
	    splash=null;
	    System.gc();
	}
    }

  public void start() {
      if(TimeFreqText!=null)
	  TimeFreqText.setBackground(Color.yellow);
      if(infoHint!=null)
	  infoHint.setBackground(Color.yellow);
      if(textField8!=null)
	  textField8.setBackground(Color.yellow);
      repaint();
  }

  public void stop() {
      closeFFTBox();
  }

    private void MPDecomposition() {  // MP_SERVER
	
//	if(SERVER) {
//	    try {
//		MPClient dialog=new MPClient(this,hostname);
//		dialog.setVisible(true);
//	    } catch(RemoteException e) {
//		new WaringMessageDialog("ERROR: "+e.getMessage());
//	    }
//	}

    }

    public void append(Book book) {
	map=new WignerMap(512,256,0,512,0,256,512);
	map.book=new FilterBookLibrary();
	
	filename="MP-SERVER BOOK";
	OK=true;
	map.book.Open(book);
	SetMinMaxFreq();
	MapOffset=0;
	reconst=null;
	AvergMapOn=false;
	ComputeOnOff(true);
	map.setDimBase();
	
	if(map.MakeWignerMap(0)) {
	    Compute(map);
	    textField5.setText("1");
	    repaint();
	} else {
	    System.out.println("MAP ERROR !");
	}
	ComputeOnOff(false);
    }

    private final boolean isMicrosoftIE() {
	try {
	    if(System.getProperty("java.vendor").lastIndexOf("Microsoft")==-1)
		return false;
	} catch(SecurityException e) {
	    return false;
	}
	return true;
    }

    private Image getImage(String filename,int w,int h) {
	Image img=null;
	if(isApplet) {
	    URL imageURL=null,codebase=null;
	    try {
		codebase=getCodeBase();
		imageURL=new URL(codebase,filename);
	    } catch(Exception e) {
		return null;
	    }

	    img=getImage(imageURL);
	} else {
	    Toolkit toolkit=Toolkit.getDefaultToolkit();
	    try {
		URL url=ClassLoader.getSystemResource(filename);
		img=toolkit.getImage(url);
	    } catch(Exception e) {
		return null;
	    }
	}
	return img==null ? null : img.getScaledInstance(w,h,
				      Image.SCALE_SMOOTH);
    }

  Image  uwImage=null;
  JButton LoadButton,RightMove,button1,FilterButton;
  JTextField textField5;
  JButton SaveToFile,AvergButton,CrossesButton;
  JButton ModeButton,ReAvergButton,ShowAscButton,TagFilterButton,FFTButton,
         FFTRecButton;
  JLabel TimeFreqText,textField8,infoHint;
  JTextField StartFreqText,StopFreqText;
  JButton loadURLButton,exitButton;
  JComboBox enScale; 
  JButton fullRec,chosenRec,MPButton,cloneButton=null;  
  JButton nativeButton=null;
}

// ----------------------------------------------------------------------

class WL extends WindowAdapter {
    private boolean newWin;

    public WL(boolean win) {
	newWin=win;
    }

    public void windowClosing(WindowEvent e) {
	if(!newWin)
	    System.exit(0);
    }
}
