// 2000-08-25/26

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.border.*;
import javax.swing.event.*;
import java.io.*;
import java.awt.image.*;

class ImageViewer extends JDialog implements ActionListener {
    JPanel contentPane;
    JToolBar toolBar = new JToolBar();
    JButton saveButton = new JButton();
    JButton printButton = new JButton();
    JButton cancellButton = new JButton();
    BorderLayout borderLayout1 = new BorderLayout();
    MyRectangleArea img=new MyRectangleArea();
    Image image=null;
    boolean status=false;
    int sizeX,sizeY;

    public boolean getStatus() {
	return status;
    }

    public ImageViewer(Image img,int sx,int sy) {
	super(new Frame(),true);
	sizeX=sx; sizeY=sy;
	image=img;
	enableEvents(AWTEvent.WINDOW_EVENT_MASK);
	try {
	    jbInit();
	}
	catch(Exception e) {
	    e.printStackTrace();
	}
    }
    
    private void jbInit() throws Exception  {
	contentPane = (JPanel) this.getContentPane();
	contentPane.setLayout(borderLayout1);
	this.setSize(new Dimension(400, 300));
	this.setTitle("Image Preview");

	saveButton.setToolTipText("Save image");
	saveButton.setText("Save ");
	saveButton.addActionListener(this);

	printButton.setText("Print");
	printButton.setToolTipText("Print Image");
	printButton.addActionListener(this);

	cancellButton.setText("Cancel");
	cancellButton.setForeground(new Color(189, 0, 0));
	cancellButton.setToolTipText("Cancel");
	cancellButton.addActionListener(this);

	toolBar.setBorder(BorderFactory.createLineBorder(Color.black));
	toolBar.add(saveButton);
	toolBar.add(printButton);
	toolBar.add(cancellButton);

	JScrollPane scroller=new JScrollPane(img,
				 JScrollPane.VERTICAL_SCROLLBAR_ALWAYS,
				 JScrollPane.HORIZONTAL_SCROLLBAR_ALWAYS);
       	getContentPane().add(scroller);
	contentPane.add(toolBar, BorderLayout.NORTH);
    }
    
    protected void processWindowEvent(WindowEvent e) {
	super.processWindowEvent(e);
	if (e.getID() == WindowEvent.WINDOW_CLOSING) {
	    setVisible(false);
	    dispose();
	    status=false;
	}
    }
    
    public void actionPerformed(ActionEvent event) {
	Object obj=event.getSource();
	if(obj==saveButton) {
	    setVisible(false);
	    dispose();
	    status=true;
	} else if(obj==printButton) {
	    img.printComponent();
	} else if(obj==cancellButton) {
	    setVisible(false); dispose();
	    status=false;
	}
    }

    class MyRectangleArea extends JPanel {
	private JFrame frame=new JFrame();

	public MyRectangleArea() {
	    setBorder(BorderFactory.createLineBorder(Color.black));
	}

	public void paintComponent(Graphics gDC) {
	    if(image!=null) {
		if(gDC!=null) 
		    gDC.drawImage(image,0,0,this);
	    } 
	}

	public Dimension getPreferredSize() {
	    return new Dimension(sizeX,sizeY);
	}

	public void printComponent() {
	    if(image!=null) {
		PrintJob pj=frame.getToolkit().getPrintJob(frame,
							   "PrintPreview",
							   null);
		if(pj!=null) {
		    Graphics g=pj.getGraphics();
		    g.drawImage(image,0,0,this);
		    g.dispose();
		    pj.end();
		}
	    }
	}
    }
}

public class BigMapFrame extends JDialog implements ItemListener {
  JPanel contentPane;
  JPanel MainPanel = new JPanel();
  Border border1;
  TitledBorder titledBorder1;
  JButton cancelButton = new JButton();
  JButton okButton = new JButton();
  JPanel sizePanel = new JPanel();
  Border border2;
  TitledBorder titledBorder2;
  JPanel modePanel = new JPanel();
  Border border3;
  Border border4;
  Border border5;
  TitledBorder titledBorder3;
  JSlider sizeXSlider = new JSlider();
  JSlider sizeYSlider = new JSlider();
  Border border6;
  TitledBorder titledBorder4;
  JPanel outPanel = new JPanel();
  JRadioButton OneRadioButton = new JRadioButton();
  JRadioButton AvrRadioButton = new JRadioButton();
  JTextField sizeXTextField = new JTextField();
  JTextField sizeYTextField = new JTextField();
  JTextField fileTextField = new JTextField();
  JButton fileButton = new JButton();
  FlowLayout flowLayout1 = new FlowLayout();
  JPanel jPanel1 = new JPanel();
  JRadioButton gifGrayRadioButton = new JRadioButton();
  FlowLayout flowLayout2 = new FlowLayout();
  JRadioButton intelRadioButton = new JRadioButton();
  JRadioButton javaRadioButton = new JRadioButton();
  JRadioButton asciiRadioButton = new JRadioButton();
  JRadioButton gifColorRadioButton = new JRadioButton();
  JRadioButton viewRadioButton=new JRadioButton();
  Border border7;
  private int sizex=512,sizey=256;
  JCheckBox synchroCheckBox = new JCheckBox();
  private static final int SAVE_GIF_COLOR=1,SAVE_GIF_GRAY=2,SAVE_INTEL=3,
                           SAVE_JAVA=4,ONE_BOOK=5,AVERG_BOOK=6,SAVE_ASCII=7;
  private int saveMode=SAVE_GIF_GRAY,bookMode=ONE_BOOK;
  private mpview applet;

  public BigMapFrame(mpview app) {
    super(new JFrame(),true);
    applet=app;

    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  public void itemStateChanged(ItemEvent evt) {
     if(evt.getSource() instanceof JRadioButton) {
        if(((JRadioButton)evt.getSource())==OneRadioButton)
           bookMode=ONE_BOOK;
        else if(((JRadioButton)evt.getSource())==AvrRadioButton)
           bookMode=AVERG_BOOK;
        else if(((JRadioButton)evt.getSource())==intelRadioButton)
           saveMode=SAVE_INTEL;
        else if(((JRadioButton)evt.getSource())==javaRadioButton)
           saveMode=SAVE_JAVA;
        else if(((JRadioButton)evt.getSource())==gifColorRadioButton)
           saveMode=SAVE_GIF_COLOR;
        else if(((JRadioButton)evt.getSource())==gifGrayRadioButton)
           saveMode=SAVE_GIF_GRAY;
        else if(((JRadioButton)evt.getSource())==asciiRadioButton)
           saveMode=SAVE_ASCII;
     }
  }

  private void jbInit() throws Exception  {
    contentPane = (JPanel) this.getContentPane();
    border1 = BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142));
    titledBorder1 = new TitledBorder(border1,"Big Wigner Map Setup");
    border2 = BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142));
    titledBorder2 = new TitledBorder(border2,"Size");
    border3 = BorderFactory.createEmptyBorder();
    border4 = BorderFactory.createEmptyBorder();
    border5 = BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142));
    titledBorder3 = new TitledBorder(border5,"Mode");
    border6 = BorderFactory.createEmptyBorder();
    titledBorder4 = new TitledBorder(border6,"set X size");
    border7 = new EtchedBorder(EtchedBorder.RAISED,Color.white,new Color(139, 139, 139));
    contentPane.setLayout(null);
    this.setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
    this.setSize(new Dimension(524, 376));
    this.setTitle("Setup");
    MainPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142)),"Big Wigner Map Setup"));
    MainPanel.setBounds(new Rectangle(10, 10, 498, 287));
    MainPanel.setLayout(null);
    cancelButton.setForeground(new Color(213, 0, 0));
    cancelButton.setMaximumSize(new Dimension(64, 25));
    cancelButton.setMinimumSize(new Dimension(64, 25));
    cancelButton.setPreferredSize(new Dimension(64, 25));
    cancelButton.setText("Cancel");
    cancelButton.setBounds(new Rectangle(278, 309, 122, 25));
    cancelButton.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        cancelButton_actionPerformed(e);
      }
    });
    okButton.setForeground(new Color(0, 140, 0));
    okButton.setText("OK");
    okButton.setBounds(new Rectangle(152, 309, 122, 25));
    okButton.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        okButton_actionPerformed(e);
      }
    });
    sizePanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142)),"Size"));
    sizePanel.setBounds(new Rectangle(13, 21, 147, 244));
    sizePanel.setLayout(null);
    modePanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142)),"Mode"));
    modePanel.setBounds(new Rectangle(169, 25, 310, 59));
    modePanel.setLayout(flowLayout1);
    sizeXSlider.setValue(512);
    sizeXSlider.setOrientation(JSlider.VERTICAL);
    sizeXSlider.setMaximum(4096);
    sizeXSlider.setMinimum(64);
    sizeXSlider.setMajorTickSpacing(256);
    sizeXSlider.setPaintTicks(true);
    sizeXSlider.setBorder(new TitledBorder(BorderFactory.createEmptyBorder(),"X"));
    sizeXSlider.setBounds(new Rectangle(16, 42, 46, 159));
    sizeXSlider.addChangeListener(new javax.swing.event.ChangeListener() {

      public void stateChanged(ChangeEvent e) {
        sizeXSlider_stateChanged(e);
      }
    });
    sizeYSlider.setValue(256);
    sizeYSlider.setOrientation(JSlider.VERTICAL);
    sizeYSlider.setMaximum(4096);
    sizeYSlider.setMinimum(64);
    sizeYSlider.setMajorTickSpacing(256);
    sizeYSlider.setPaintTicks(true);
    sizeYSlider.setBorder(new TitledBorder(BorderFactory.createEmptyBorder(),"Y"));
    sizeYSlider.setBounds(new Rectangle(84, 41, 42, 160));
    sizeYSlider.addChangeListener(new javax.swing.event.ChangeListener() {

      public void stateChanged(ChangeEvent e) {
        sizeYSlider_stateChanged(e);
      }
    });
    contentPane.setBorder(border7);
    contentPane.setPreferredSize(new Dimension(430, 350));
    outPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142)),"Output"));
    outPanel.setBounds(new Rectangle(171, 93, 309, 174));
    outPanel.setLayout(null);
    OneRadioButton.setSelected(true);
    OneRadioButton.setText("One Book");
    AvrRadioButton.setText("Averge Book");

    ButtonGroup book_mode=new ButtonGroup();
    fileButton.addActionListener(new java.awt.event.ActionListener() {

      public void actionPerformed(ActionEvent e) {
        fileButton_actionPerformed(e);
      }
    });
   
    book_mode.add(OneRadioButton);
    book_mode.add(AvrRadioButton);

    OneRadioButton.addItemListener(this);
    AvrRadioButton.addItemListener(this);

    sizeXTextField.setText("512");
    sizeXTextField.setHorizontalAlignment(SwingConstants.CENTER);
    sizeXTextField.setBounds(new Rectangle(10, 205, 59, 26));
    sizeYTextField.setText("256");
    sizeYTextField.setHorizontalAlignment(SwingConstants.CENTER);
    sizeYTextField.setBounds(new Rectangle(74, 205, 63, 27));
    fileTextField.setText("image.gif");
    fileTextField.setBounds(new Rectangle(9, 135, 187, 28));
    fileButton.setForeground(new Color(0, 0, 195));
    fileButton.setText("File ...");
    fileButton.setBounds(new Rectangle(200, 136, 94, 26));
    jPanel1.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(Color.white,new Color(142, 142, 142)),"Save As ..."));
    jPanel1.setBounds(new Rectangle(9, 22, 288, 85));
    jPanel1.setLayout(flowLayout2);
    gifGrayRadioButton.setSelected(true);
    gifGrayRadioButton.setText("Gif Gray");
    intelRadioButton.setText("INTEL");
    javaRadioButton.setText("JAVA");
    asciiRadioButton.setText("ASCII");
    gifColorRadioButton.setText("Gif Color");

    viewRadioButton.setText("View");
    viewRadioButton.setSelected(false);
    viewRadioButton.setBounds(new Rectangle(9, 135-30, 187, 28 ));
    ButtonGroup save_mode=new ButtonGroup();
    save_mode.add(gifGrayRadioButton);
    save_mode.add(gifColorRadioButton);
    save_mode.add(intelRadioButton);
    save_mode.add(javaRadioButton);
    save_mode.add(asciiRadioButton);

    gifGrayRadioButton.addItemListener(this);
    gifColorRadioButton.addItemListener(this);
    intelRadioButton.addItemListener(this);
    javaRadioButton.addItemListener(this);
    asciiRadioButton.addItemListener(this);

    synchroCheckBox.setSelected(true);
    synchroCheckBox.setText("  Y=X/2");
    synchroCheckBox.setBounds(new Rectangle(23, 17, 105, 16));
    contentPane.add(MainPanel, null);
    MainPanel.add(modePanel, null);
    modePanel.add(OneRadioButton, null);
    modePanel.add(AvrRadioButton, null);
    MainPanel.add(outPanel, null);

    outPanel.add(fileTextField, null);
    outPanel.add(fileButton, null);
    outPanel.add(jPanel1, null);
    outPanel.add(viewRadioButton,null);

    jPanel1.add(gifGrayRadioButton, null);
    jPanel1.add(gifColorRadioButton, null);
    jPanel1.add(intelRadioButton, null);
    jPanel1.add(javaRadioButton, null);
    jPanel1.add(asciiRadioButton, null);

    MainPanel.add(sizePanel, null);
    sizePanel.add(sizeXTextField, null);
    sizePanel.add(sizeYTextField, null);
    sizePanel.add(sizeYSlider, null);
    sizePanel.add(synchroCheckBox, null);
    sizePanel.add(sizeXSlider, null);
    contentPane.add(cancelButton, null);
    contentPane.add(okButton, null);
    setResizable(false);
  }

  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
	dispose();
    }
  }

  void sizeXSlider_stateChanged(ChangeEvent e) {
      sizex=sizeXSlider.getValue();
      sizeXTextField.setText(Integer.toString(sizex));
      if(synchroCheckBox.isSelected()) {
          sizey=sizex/2;
          sizeYTextField.setText(Integer.toString(sizey));
          sizeYSlider.setValue(sizey);
       }
  }

  void sizeYSlider_stateChanged(ChangeEvent e) {
       sizey=sizeYSlider.getValue();
       sizeYTextField.setText(Integer.toString(sizey));
       if(synchroCheckBox.isSelected()) {
          sizex=2*sizey;
          sizeXTextField.setText(Integer.toString(sizex));
          sizeXSlider.setValue(sizex);
       }
  }

  void fileButton_actionPerformed(ActionEvent e) {
       String file=Utils.getFileName("Save as ...",true);
       if(file!=null) {
          fileTextField.setText(file);
       }
  }

    private WignerMap map=null;

    private void makeFinalize(boolean no) {
	map=null;
	System.gc();
	setVisible(false);
	if(no) {
	    new WaringMessageDialog("image ERROR");
	}
	dispose();
    }
    
    void okButton_actionPerformed(ActionEvent e) {
	String filename=fileTextField.getText();
	int sizeX=Integer.parseInt(sizeXTextField.getText());
	int sizeY=Integer.parseInt(sizeYTextField.getText());
	
	map=new WignerMap(sizeX,sizeY,0,sizeX,0,sizeY,sizeX);
	if(bookMode==ONE_BOOK) {
	    if(applet.getIsURL()) {
		if(!map.MakeWignerMap(applet.getURLName(),
				      applet.getMapOffset(),
				      applet.StartFreq,
				      applet.StopFreq,
				      applet.map.book)) {
		    makeFinalize(true);
		    return;
		}
	    } else {
		if(!map.MakeWignerMap(applet.getFileName(),
				      applet.getMapOffset(),
				      applet.StartFreq,
				      applet.StopFreq,
				      applet.map.book)) {
		    makeFinalize(true);
		    return;
		}
	    }
	} else {
	    int start=applet.StartOffset;
	    int stop=applet.StopOffset;
	    
	    if(applet.getIsURL()) {
		if(!map.MakeWignerMap(applet.getURLName(),
				      0,
				      applet.StartFreq,
				      applet.StopFreq,
				      applet.map.book)) {
		    makeFinalize(true);
		    return;
		}
	    } else {
		if(!map.MakeWignerMap(applet.getFileName(),
				      0,
				      applet.StartFreq,
				      applet.StopFreq,
				      applet.map.book)) {
		    makeFinalize(true);
		    return;
		}
	    }

	    if(!map.AvergWignerMap(start,stop)) {
		makeFinalize(true);
		return;
	    }
	}

	String s=applet.getMapScale();
	if(     s.equals("En: Linear   "))
	    map.NormScale();
	else if(s.equals("En: log(1+En)"))
	    map.LogScale();
	else if(s.equals("En: Contrast ")) {
	    int i,Max=256;
	    float Hist[]=new float[Max];
	
	    map.getHistogram(Hist);
	    float sum=Hist[0];
	    
	    for(i=1 ; i<Max ; i++) {
		sum+=Hist[i];
		Hist[i]+=Hist[i-1];
	    }
	    
	    if(sum!=0.0F) {
		for(i=0 ; i<Max ; i++)
		    Hist[i]/=sum;
	    }
	    map.SigmaScale(Hist);
	} else if(s.equals("En: sqrt(En) "))
	    map.SqrtScale();

	if(viewRadioButton.isSelected()) {
	    boolean grayColor=true;
	    if(saveMode!=SAVE_GIF_GRAY)
		grayColor=false;

	    ImageViewer view=new ImageViewer(drawMap(map,sizeX,sizeY,grayColor),
					     sizeX,sizeY);
	    setVisible(false);
	    view.setVisible(true);
	    if(!view.getStatus()) {
		makeFinalize(false);
		return;
	    }
	}

	try {
	    switch(saveMode) {
	    case SAVE_GIF_COLOR:
		saveImageToGif(filename,drawMap(map,sizeX,sizeY,false));
		break;
	    case SAVE_GIF_GRAY:
		saveImageToGif(filename,drawMap(map,sizeX,sizeY,true));
		break;
	    case SAVE_INTEL:
		SaveToFile(filename,map.Map,sizeX,sizeY,true);
		break;
	    case SAVE_JAVA:
		SaveToFile(filename,map.Map,sizeX,sizeY,false);
		break;
	    case SAVE_ASCII:
		SaveToAsciiFile(filename,map.Map,sizeX,sizeY);
		break;
	    }
	} catch(Exception ex) {
	    new WaringMessageDialog("IO ERROR "+ex.getMessage());
	}

	makeFinalize(false);
    }

    private void fprintf(BufferedOutputStream F0,String string) 
	throws IOException {
	byte buffor[]=string.getBytes();
	F0.write(buffor,0,buffor.length);
    }
    
    private void SaveToAsciiFile(String filename,float Map[][],
				 int SizeX,int SizeY) throws IOException {
	ProgressIndex index;
	(index=new ProgressIndex(SizeX,"Saving...")).setVisible(true);

	OutputStream fstream=new FileOutputStream(new File(filename));
	BufferedOutputStream file=new BufferedOutputStream(fstream,32768);
	index.UpDateIndex();
	
	for(int i=0 ; i<SizeX ; i++) {
	    for(int j=0 ; j<SizeY ; j++) 
		fprintf(file,Map[i][j]+" ");
	    fprintf(file,"\n");
	    
	    index.NextIndex();
	    if(i%32==0)
		index.UpDateIndex();
	}
	
	file.close();
	index.Close();
    }

    public void SaveToFile(String filename,float Map[][],
			   int SizeX,int SizeY,boolean IntelSwap) 
	throws IOException {
	OutputStream fstream=new FileOutputStream(new File(filename));
	DataOutputStream file=new DataOutputStream(fstream);
	
	byte buffor[]=new byte[4*SizeY];
	int i,j,k,itmp;
	
	for(i=0 ; i<SizeX ; i++) {
	    for(j=0,k=0 ; j<SizeY ; j++) {
		itmp=Float.floatToIntBits(Map[i][j]);
		if(IntelSwap) {
		    buffor[k++]=(byte)(itmp&0xff);
		    buffor[k++]=(byte)((itmp>>8)&0xff);
		    buffor[k++]=(byte)((itmp>>16)&0xff);
		    buffor[k++]=(byte)((itmp>>24)&0xff);
		} else {
		    buffor[k++]=(byte)((itmp>>24)&0xff);
		    buffor[k++]=(byte)((itmp>>16)&0xff);
		    buffor[k++]=(byte)((itmp>>8)&0xff);
		    buffor[k++]=(byte)(itmp&0xff);
		}
	    }
	    
	    file.write(buffor);
	}
	
	file.close();
    }

    public Image drawMap(WignerMap map,int SizeX,int SizeY,boolean grayScale) {
	try {
	    double min=map.getMinVal(),max=map.getMaxVal();    
	    double scale=(min!=max) ? 255.0/(max-min) : 1.0;
	    int Paleta[]=new int[256],code,i,j;
	    int WignerImage[]=new int[SizeX*SizeY];
	    Image image;

	    applet.MakePalette(Paleta,grayScale);
	    for(i=0 ; i<SizeX ; i++)
		for(j=0 ; j<SizeY ; j++) {
		    code=(int)(1.5+scale*(map.Map[i][j]-min));
		    if(code<1)   code=1;
		    if(code>254) code=254;
		    WignerImage[SizeX*((SizeY-1)-j)+i]=Paleta[code];
		}
	    
	    image=createImage(new MemoryImageSource(SizeX,SizeY,
						    WignerImage,0,SizeX));
	    return image;
	} catch(OutOfMemoryError e) { 
	    new WaringMessageDialog("MEM ERROR "+e.getMessage());
	    System.gc(); 
	}
	return null;
    }
 
    private void saveImageToGif(String filename,Image image) 
	throws IOException {
	if(image==null)
	    throw new IOException("null image");

	OutputStream stream=new FileOutputStream(new File(filename));
	GifEncoder      gif=new GifEncoder(image,stream);
	
	gif.encode();
	stream.close();
    } 

  void cancelButton_actionPerformed(ActionEvent e) {
       setVisible(false);
       dispose();
  }
}
