import java.io.*;

public class BookAtom {
  public short number_of_atom_in_book;
  public byte  octave;
  public byte  type;
  public float frequency;
  public short position;
  public float modulus;
  public float amplitude;
  public float phase;
  public float truePhase;
  public int   scale;
  public int   index;
  
  public final void Read(DataArrayInputStream stream)
    throws IOException
    {
      number_of_atom_in_book=stream.readShort();
      octave=stream.readByte(); 
      if(octave!=0)
	  scale=1<<octave;
      else 
	  scale=0;
      type=stream.readByte();
      frequency=stream.readShort();
      position=stream.readShort();
      modulus=stream.readFloat();
      amplitude=stream.readFloat();
      phase=stream.readFloat();
    }

  public BookAtom() { ; }

  public BookAtom(NewAtom atom) {
      atom.export(this);
  }

  public void finalize() {
    try { super.finalize(); } catch(Throwable e) { }
  }

  public final float Frequency(BookHeader head) {
    return (frequency/(float)(head.signal_size)*head.FREQUENCY);
  }

    public final float NaturalFreq(BookHeader head) {
	return (float)(2.0*Math.PI*frequency/head.signal_size);
    }

  public final float HalfTime(BookHeader head) {
    final double Const=2.0*Math.sqrt(Math.log(2.0)/Math.PI);
    int s;
  
    if(scale==0) 
	return 0.0F;
    if(scale==head.signal_size) 
	return (scale/head.FREQUENCY);
    return (float)(Const*scale/head.FREQUENCY);
  }  

  private static String Format(String str,int Width) {
    String string=new String(str);
    for(int i=string.length() ; i<=Width ; i++)
      string+=" ";
    return string;
  }
  
   private static float Round(float x,int Mul) {
     double factor=Math.pow(10.0,Mul);
     return (float)(Math.floor(0.5+x*factor)/factor);
   }

  public String getAtomString(BookHeader head,float SecPP) {
    int hour,minute,sec,offset;
    float sec_time;

    sec_time=head.file_offset*SecPP+position/head.FREQUENCY;
    hour=(int)(sec_time/3600.0F);
    minute=(int)((sec_time-3600.0F*hour)/60.0F);
    sec=(int)(sec_time-60.0F*minute-3600.0F*hour);

    return new String(Format(hour+"h"+((minute<10) ? "0"+minute : ""+minute)
			     +"'"+((sec<10) ? "0"+sec : ""+sec)+"\" ",9)+
		      Format(number_of_atom_in_book+" ",9)+
		      Format(position+" ",9)+
		      Format(Round(modulus,3)+" ",9)+
		      Format(Round(amplitude,3)+" ",9)+
		      Format(scale+" ",9)+
		      Format(Round(HalfTime(head),2)+"\" ",9)+
		      Format(Round(Frequency(head),4)+" Hz ",9)+
		      Format((phase>=0.0 ? " " : "")+Round(phase,4)+" ",9)+
		      Format((truePhase>=0.0 ? " " : "")+
			     Round(truePhase,4)+" ",9));
  }

  public final void Save(DataOutputStream file,BookHeader head,float SecPP) 
    throws IOException {
    file.writeBytes(getAtomString(head,SecPP)+"\n");
  }

  public void Print(BookHeader head,float SecPP) {
    System.out.println(getAtomString(head,SecPP));
  }
}

