import java.io.*;

public class BookHeader {
  public short file_offset;
  public short book_size;
  public int   signal_size;
  public float points_per_micro_V;
  public float FREQUENCY;
  public float signal_energy;
  public float book_energy;

  public void finalize() {
    try { super.finalize(); } catch(Throwable e) { }
  }

  public final void Read(DataInputStream stream)
     throws IOException
    {
      file_offset=stream.readShort();
      book_size=stream.readShort();
      signal_size=stream.readInt();
      points_per_micro_V=(float)Math.abs(stream.readFloat());
      FREQUENCY=(float)Math.abs(stream.readFloat());
      signal_energy=stream.readFloat();
      book_energy=stream.readFloat();
    }

  BookHeader() { }

  public final void Save(DataOutputStream file) throws IOException {
    file.writeBytes("\nFile offset : "+file_offset+
		    "\nBook size   : "+book_size+
		    "\nSignal size : "+signal_size+
		    "\nConv factor : "+points_per_micro_V+
		    "\nFrequency   : "+FREQUENCY+
		    "\nSignal enrg : "+signal_energy+
		    "\nBook energ  : "+book_energy+"\n");
  }
  
  public String getString() {
    return new String("\nFile offset    : "+file_offset+
		      "\nBook size      : "+book_size+
		      "\nSignal size    : "+signal_size+
		      "\nConv factor    : "+points_per_micro_V+
		      "\nFrequency      : "+FREQUENCY+
		      "\nSignal energy  : "+signal_energy+
		      "\nBook   energy  : "+book_energy);
  }  
}
