/* 1998 12 12
   1999 07 18/27
   1999 10 25
 */

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

public class FFTDialog extends JDialog implements ActionListener,
						MouseMotionListener {
  public static final int SIZEX=256,SIZEY=150,XMARGIN=30,YMARGIN=55;
  private JButton CloseButton,logButton;
  public  JLabel info;
  public  int fft[]=new int[SIZEX],iprof[]=new int[SIZEX];
  public  WignerMap map;
  public  boolean mode,isDead;
  public  double Max,SamplFreq;
  public  int maxFFT,minFFT;
  public  boolean isLogScale=false;
  private RectangleArea PaintPanel;

  private static void four1(double data[],int nn,int isign) {
    int n,mmax,m,j,istep,i;
    double wtemp,wr,wpr,wpi,wi,theta,tempr,tempi;

    n=nn << 1;
    j=1;
    for(i=1 ; i<n ; i+=2) {
      if(j>i) {
	tempr=data[j];  data[j]=data[i]; data[i]=tempr ;
	tempr=data[j+1]; data[j+1]=data[i+1] ; data[i+1]=tempr ;
      }
      m=n >> 1;
      while(m>=2 && j>m) {
	j-=m;
	m>>=1;
      }
      j+=m;
    }
    mmax=2;
    while(n>mmax) {
      istep=mmax << 1;
      theta=isign*(6.28318530717959/mmax);
      wtemp=Math.sin(0.5*theta);
      wpr=-2.0*wtemp*wtemp;
      wpi=Math.sin(theta);
      wr=1.0;
      wi=0.0;
      for(m=1 ; m<mmax ; m+=2) {
	for(i=m ; i<=n ; i+=istep) {
	  j=i+mmax;
	  tempr=wr*data[j]-wi*data[j+1];
	  tempi=wr*data[j+1]+wi*data[j];
	  data[j]=data[i]-tempr;
	  data[j+1]=data[i+1]-tempi;
	  data[i]+=tempr;
	  data[i+1]+=tempi;
	}
	wr=(wtemp=wr)*wpr-wi*wpi+wr;
	wi=wi*wpr+wtemp*wpi+wi;
      }
      mmax=istep;
    }
  }

  private static double SQR(double x) {
    return x*x;
  }

  private static float Round(double x) {
    return (float)Math.floor(1000.0*x+0.5)/1000.0F;
  }
  
  private double getValue(int k) {
      return mode ? map.getSignalValue(k) : map.getReconstValue(k);
  }

  private int setFFTSize(int n) {
      int s=1;
      while(s<n) s*=2;
      return s;
  }

  private void setTrueScale() {
      if(isDead) return;
      int i,Count=setFFTSize(map.getDimBase()),itmp,DimBase=map.getDimBase();
      double sig[]=new double[2*Count+2],dtmp;

      dtmp=0.0;
      for(i=0 ; i<DimBase ; i++)
	dtmp+=map.getSignalValue(i);
      dtmp/=DimBase;
      
      sig[0]=0.0;
      for(i=0 ; i<Count ; i++) {
	  itmp=2*i+1;
	  if(i<DimBase)
	      sig[itmp]=map.getSignalValue(i)-dtmp;
	  else
	      sig[itmp]=0.0;
	  sig[itmp+1]=0.0;
      }
   
      four1(sig,Count,1);
      Count/=2;

      double df=(SIZEX-1)/(double)(Count-1);
      double sum[]=new double[SIZEX];
      int    index[]=new int[SIZEX];

      for(i=0 ; i<SIZEX ; i++) {
	  sum[i]=0.0;
	  index[i]=0;
      }

      for(i=1 ; i<Count ; i++) {
	  int idx=(int)(df*i+0.5);
	  if(idx>=SIZEX)
	      idx=SIZEX-1;

	  itmp=2*i+1;
	  dtmp=SQR(sig[itmp])+SQR(sig[itmp+1]);
	  if(isLogScale)
	      dtmp=Math.log(1.0+dtmp);
	  sum[idx]+=dtmp;
	  index[idx]++;
      }

      Max=0.0;
      for(i=1 ; i<SIZEX ; i++)
	  if(index[i]!=0) {
	      Max=sum[i]/index[i];
	      for(int j=i+1 ; j<SIZEX ; j++) 
		  if(index[i]!=0) {
		      dtmp=sum[j]/index[j];
		      if(dtmp>Max) Max=dtmp;
		  }
	      break;
	  }      

      maxFFT=-2*SIZEY; 
      minFFT=+2*SIZEY;
      double scale=(0.0==Max) ? 1.0 : SIZEY/Max;
      int ff,maxh=SIZEY+YMARGIN;

      for(i=1 ; i<SIZEX ; i++) { 
	if(index[i]!=0) {
 	    ff=maxh-(int)(0.5+scale*(sum[i]/index[i]));
	} else {
	    ff=maxh;
	}
	if(maxFFT<ff)
	    maxFFT=ff;
	if(minFFT>ff)
	    minFFT=ff;
      }
  }

  private void MakeFFT() {
    if(isDead) return;
    int i,Count=setFFTSize(map.getDimBase()),itmp,maxh=SIZEY+YMARGIN;
    double sig[]=new double[2*Count+2],power[]=new double[Count+2],dtmp;
    int    index[]=new int[SIZEX+1];
    double sum[]=new double[SIZEX+1];
    int DimBase=map.getDimBase();

    for(i=0 ; i<SIZEX ; i++) {
	index[i]=0;
	sum[i]=0.0;
    }

    dtmp=0.0;
    for(i=0 ; i<DimBase ; i++)
	dtmp+=getValue(i);
    dtmp/=DimBase;

    for(i=0 ; i<Count ; i++) {
	itmp=2*i+1;
	if(i<DimBase) 
	    sig[itmp]=getValue(i)-dtmp;
	else 
	    sig[itmp]=0.0;
	sig[itmp+1]=0.0;
    }

    four1(sig,Count,1);
    Count/=2;
    double df=(SIZEX-1)/(double)(Count-1);

    power[0]=0.0;
    for(i=1 ; i<Count ; i++) {
      itmp=2*i+1;
      dtmp=SQR(sig[itmp])+SQR(sig[itmp+1]);
      if(isLogScale)
	  dtmp=Math.log(1.0+dtmp);
      power[i]=dtmp;

      int idx=(int)(df*i+0.5);
      sum[idx]+=dtmp;
      index[idx]++;
    }

    double scale=(0.0==Max) ? 1.0 : SIZEY/Max;
    for(i=1 ; i<SIZEX ; i++) { 
	if(index[i]!=0) {
 	    fft[i]=maxh-(int)(0.5+scale*(sum[i]/index[i]));
	} else {
	    fft[i]=maxh;
	}
    }

    double prof[]=map.getFreqProfile(-1),max=((isLogScale) ? 
					      Math.log(1.0+prof[0]) : prof[0]);
    for(i=0 ; i<SIZEX ; i++) {
	if(isLogScale)
	    prof[i]=Math.log(1.0+prof[i]);
	if(max<prof[i])
	    max=prof[i];
    }

    scale=(max==0.0) ? 1.0 : SIZEY/max;
    for(i=0 ; i<SIZEX ; i++)
	iprof[i]=maxh-(int)(0.5+scale*prof[i]);
  }

  private String intToString(int val) {
      if(val<10)
	  return "  "+val;
      if(val<100)
	  return " "+val;
      return String.valueOf(val);
  }

  private String doubleToString(double val) {
      return String.valueOf(Round(val));
  }

    class RectangleArea extends JPanel {
	public RectangleArea() {
	}

	private void drawMarker(Graphics gDC,double freq1,double freq2) {
	    gDC.setColor(Color.green);
	    int x=XMARGIN+(int)(SIZEX*freq1/SamplFreq);
	    int x2=XMARGIN+(int)(SIZEX*freq2/SamplFreq);
	    gDC.fillRect(x,YMARGIN,x2-x,SIZEY);
	}

	public void paintComponent(Graphics gDC) {
	    if(isDead) return;
	    int x,i,maxh=SIZEY+YMARGIN;
	    
	    drawMarker(gDC,map.getMinFreq(),map.getMaxFreq());
	    gDC.setColor(Color.blue);
	    for(i=2 ; i<SIZEX ; i++) {
		x=XMARGIN+i;
		gDC.drawLine(x-1,fft[i-1],x,fft[i]);
	    }

	    gDC.setColor(Color.black);
	    int x1=XMARGIN+(int)(SIZEX*map.getMinFreq()/SamplFreq);
	    int x2=XMARGIN+(int)(SIZEX*map.getMaxFreq()/SamplFreq);
	    double dx=(x2-x1)/(double)(SIZEX-1);

	    for(i=1 ; i<SIZEX ; i++) {
		x=(int)(x1+dx*i);
		gDC.drawLine((int)(x-dx),iprof[i-1],x,iprof[i]);
	    }

	    gDC.setColor(Color.red);
	    gDC.drawLine(XMARGIN-1,maxh+1,XMARGIN+SIZEX+1,maxh+1);
	    gDC.drawLine(XMARGIN-1,maxh+1,XMARGIN-1,YMARGIN-1);
	    gDC.setFont(new Font("Arial",0,8));	

	    gDC.setColor(Color.black);
	    gDC.drawString(isLogScale ? "log Power [%]" : "Power [%]",
			   XMARGIN+2,YMARGIN+5);
	    
	    for(i=0 ; i<=10 ; i++) {
		int y=maxh-(int)((i*SIZEY)/10.0);
		gDC.setColor(Color.red);
		gDC.drawLine(XMARGIN-2,y,XMARGIN,y);
		gDC.setColor(Color.black);
		gDC.drawString(intToString(10*i),XMARGIN-20,y+2);
	    }
	    
	    for(i=1 ; i<=10 ; i++) {
		int xx=XMARGIN+(int)((i*SIZEX)/10.0);
		gDC.setColor(Color.red);
		gDC.drawLine(xx,maxh,xx,maxh+2);
		if(i%2==0) {
		    gDC.setColor(Color.black);
		    gDC.drawString(doubleToString(0.1*i*SamplFreq)+
				   ((i==10) ? " f" : "")
				   ,xx-5,maxh+10);
		}
	    }
	    
	    gDC.setColor(Color.black);
	    gDC.drawRect(XMARGIN-22,maxh-SIZEY-10,SIZEX+50,SIZEY+25);
	}
    }

  public FFTDialog(WignerMap mapa,boolean rec,String title) {
    super(new JFrame(),false);
    setTitle(title);
    isDead=false;
    map=mapa; mode=rec;
    SamplFreq=0.5*map.getSamplingFreq();
    setSize(345,340);
    getContentPane().setLayout(null);
    setBackground(Color.lightGray);
   
    info=new JLabel();
    info.setText("   0.000   0.000 %");
    info.setBounds(10,300-30,140,20);
    getContentPane().add(info);

    logButton=new JButton("Log");
    logButton.setForeground(Color.black);
    logButton.setBounds(150,300-30,80,27);
    logButton.addActionListener(this);
    getContentPane().add(logButton);

    CloseButton=new JButton("Close");
    CloseButton.setForeground(Color.red);
    CloseButton.setBounds(235,300-30,80,27);
    CloseButton.addActionListener(this);
    getContentPane().add(CloseButton);

    PaintPanel=new RectangleArea();
    PaintPanel.setBounds(0,0,SIZEX+2*XMARGIN,SIZEY+YMARGIN+20);
    getContentPane().add(PaintPanel);

    setResizable(false);
    PaintPanel.addMouseMotionListener(this);

    setTrueScale();
    MakeFFT();
  }
    
    public void actionPerformed(ActionEvent event) {
	Object evt=event.getSource();
	if(evt==CloseButton) {
	    setVisible(false); 
	    dispose();
	    isDead=true;
	} else if(evt==logButton) {
	    isLogScale=!isLogScale;
	    UpDate();
	}
    }

    public final void UpDate() {
	setTrueScale();
	MakeFFT();
	repaint();
    }

    public void mouseMoved(MouseEvent event) {
	int x=event.getX()-XMARGIN,y=event.getY()-YMARGIN;
	if(x>=1 && x<SIZEX && y>=0 && y<SIZEY) {
	    int maxh=YMARGIN+SIZEY;
	    if(maxFFT!=minFFT)
		info.setText(Round(SamplFreq*x/(double)(SIZEX-1))+" "
			     +Round((100.0-100.0*(fft[x]-minFFT)/
				     (maxFFT-minFFT)))+
			     " %");
	    
	}
    }

    public void mouseDragged(MouseEvent event) {
    } 
}





