/** 1998 10 07/09/14/20/22 1998 11 30 
 *  1999 06 29 - JDK 1.1
 *  1999 07 23 - nowy format ksiazek
 *  1999 07 30
 *  1999 10 03
 *  1999 11 22
 *  2000 02 18
 */

import java.io.*;
import java.net.*;

class BookLibrary {
  protected NewBookLibrary   newLib=new NewBookLibrary();
  protected BookHeader       head=new BookHeader();
  protected BookAtom         atoms[]=null;  
  protected DataInputStream  file=null;
  protected float            SecPP=20.0F;
  protected int              BookNo=0;
  private   URL              fileURL;
  protected boolean          isFileURL,isNewMode;
  private   String           fileString;
  protected int              MaxBookNumber;

    private void convertPhase() {
	float df=(float)(2.0*Math.PI/head.signal_size);
	for(int i=0 ; i<atoms.length ; i++)
	    if(atoms[i].scale!=0) {
		float freq=df*atoms[i].frequency;
		atoms[i].phase=Utils.HmppPhase(freq,atoms[i].position,
					       atoms[i].phase);
		atoms[i].truePhase=Utils.RawPhase(freq,atoms[i].position,
						  atoms[i].phase);
    
	    }
    } 

  public final int getMaxBookNumber() {
      return isNewMode ? newLib.getMaxBookNumber() : MaxBookNumber;
  }

  public int getBookOffset() {
      return BookNo;
  }

  private void importAtoms() {
      newLib.export(head);
      float df=(float)(2.0*Math.PI/head.signal_size);
      int size;
    
      atoms=new BookAtom[size=newLib.getNumOfAtoms()];
      for(int i=0 ; i<size ; i++) {
	  atoms[i]=new BookAtom();
	  newLib.export(atoms[i],i);
	  atoms[i].truePhase=Utils.MppPhase(df*atoms[i].frequency,
					    atoms[i].position,
					    atoms[i].phase);
	  atoms[i].number_of_atom_in_book=(short)(i+1);
      }
  }

  private boolean SetOffset(int Offset) {
      if(Offset==BookNo)
	  return true;

      if(isNewMode) {
	  if(isFileURL) {
	      if(!newLib.SetOffset(fileURL,Offset)) 
		  return false;
	  } else {
	      if(!newLib.SetOffset(fileString,Offset))
		  return false;
	  }
      } else {
	  return SetOldOffset(Offset);
      }
      BookNo=Offset;
      return true;
  }

    private int countBook() {
//	System.out.println("loading book information ...");
	if(isNewMode) {
	    if(isFileURL) 
		return newLib.countBook(fileURL);
	    else 
		return newLib.countBook(fileString);
	} else {
	    InputStream stream=null;
	    DataInputStream file=null;
	    int k=0;

	    try {
		if(isFileURL) {	
		    stream=fileURL.openStream();	
		    file=new DataInputStream(stream);
		} else {/*
		    try {
			netscape.security.PrivilegeManager.enablePrivilege(
							   "UniversalFileRead");
		    } catch(Exception e) {
			;
			}*/
		    stream=new FileInputStream(fileString);	
		    file=new DataInputStream(stream);
		}
	    } catch(IOException e) { 
		try { file.close(); } catch(Exception ee) { ; }
		return 0;
	    } 

	    try {
		for(k=0 ; ; k++) {
		    head.Read(file);
		    file.skipBytes(head.book_size*20);
		}
	    } catch(IOException e) { 
		try { file.close(); } catch(Exception ee) { ; }
		return k;
	    }
	}
    }

  private boolean SetOldOffset(int Offset) {
    try {
      Close();
      if(isFileURL) {	
	  InputStream stream=fileURL.openStream();	
	  file=new DataInputStream(stream);
      } else {/*
	  try {
	      netscape.security.PrivilegeManager.enablePrivilege("UniversalFileRead");
	  } catch(Exception e) {
	      ;
	      }*/
	  InputStream stream=new FileInputStream(fileString);	
	  file=new DataInputStream(stream);
      }

      for(int i=0 ; i<Offset ; i++) {
	head.Read(file);
	file.skipBytes(head.book_size*20);
      }
    }
    catch(IOException e) { return false; }
    BookNo=Offset;
    return true;
  }

  public boolean GoTo(int Offset) {
      if(Offset==BookNo)
	  return true;

      if(isNewMode) {
	  if(isFileURL) {
	      if(!newLib.loadBook(fileURL,Offset))
		  return false;
	  } else {
	      if(!newLib.loadBook(fileString,Offset))
		  return false;
	  }
      } else {
	  return OldGoTo(Offset);
      }

      importAtoms();
      BookNo=Offset;
      return true;
  }

  public boolean OldGoTo(int Offset) {
    if(!SetOffset(Offset))
      return false;
    try {
	head.Read(file);
	atoms=new BookAtom[head.book_size];
	byte buffor[]=new byte[head.book_size*20];
	DataArrayInputStream bfile=new DataArrayInputStream(file,buffor);
      
	for(int i=0 ; i<head.book_size ; i++) {
	    (atoms[i]=new BookAtom()).Read(bfile);
	    atoms[i].index=i;
	}
	convertPhase();
      } catch(IOException e) {
	  new WaringMessageDialog("ERROR (GOTO): "+e.getMessage());
	  return false;
      }
    return true;
  }

  public void SetSecPP(float secPP_) {
    SecPP=secPP_;
  }

  public boolean NextBook() {
      if(isNewMode) {
	  if(!newLib.readNextBook())
	      return false;
      } else {
	  return OldNextBook();
      }

      importAtoms();
      BookNo++;
      return true;
  }  

  public boolean OldNextBook() {
    try {
	head.Read(file);
	atoms=new BookAtom[head.book_size];
	byte buffor[]=new byte[head.book_size*20];
	DataArrayInputStream bfile=new DataArrayInputStream(file,buffor);
	/*   
	try {
	    netscape.security.PrivilegeManager.enablePrivilege("UniversalFileRead");
	} catch(Exception e) {
	     ;
	}
	*/
	for(int i=0 ; i<head.book_size ; i++) {
	    (atoms[i]=new BookAtom()).Read(bfile);
	    atoms[i].index=i;
	}
	convertPhase();
	BookNo++;
    }
    catch(IOException e) { return false; }
    return true;
  }
      
  private void readFirst() throws IOException {
      head.Read(file);
      atoms=new BookAtom[head.book_size];
      byte buffor[]=new byte[head.book_size*20];
      DataArrayInputStream bfile=new DataArrayInputStream(file,buffor);
      /*
      try {
	  netscape.security.PrivilegeManager.enablePrivilege("UniversalFileRead");
      } catch(Exception e) {
	  ;
      }
      */
      for(int i=0 ; i<head.book_size ; i++) {
	  (atoms[i]=new BookAtom()).Read(bfile);
	  atoms[i].index=i;
	  atoms[i].number_of_atom_in_book=(short)(i+1);
      }
      convertPhase();
  }

  public boolean Open(URL filename,int Offset) {
      if(NewBookLibrary.checkFormat(filename)!=NewBookLibrary.VERSION_NONE) {
	  isNewMode=true;
	  fileURL=filename;
	  isFileURL=true;
	  if(newLib.Open(filename,Offset)) {
	      importAtoms();
	      return true;
	  }   
      } else {
	  isNewMode=false;
	  return OldOpen(filename,Offset);
      }
      return false;
  }

  public boolean OldOpen(URL filename,int Offset) {
    try {
      isFileURL=true;	
      fileURL=filename;	
      InputStream stream=filename.openStream();	
      file=new DataInputStream(stream);

      if(!SetOffset(Offset)) {
	file.close();
	return false;
      }

      readFirst();
      MaxBookNumber=countBook();
    } catch(IOException e) {
	new WaringMessageDialog("ERROR (OPEN): "+e.getMessage());
	return false;
    }
    return true;
  }

  public void Open(Book book) {
      isNewMode=true;
      newLib.importBook(book);
      importAtoms();
      BookNo=0;
  }

  public boolean Open(String filename,int Offset) {
      if(NewBookLibrary.checkFormat(filename)!=NewBookLibrary.VERSION_NONE) {
	  isNewMode=true;
	  fileString=filename;	
	  if(newLib.Open(filename,Offset)) {
	      importAtoms();
	      return true;
	  }
      } else {
	  isNewMode=false;
	  return OldOpen(filename,Offset);
      }
      return false;
  }

  public boolean OldOpen(String filename,int Offset) {
    try {
      isFileURL=false;
      fileString=filename;	
      /*
      try {
	  netscape.security.PrivilegeManager.enablePrivilege("UniversalFileRead");
      } catch(Exception e) {
	  ;
      }
      */
      InputStream stream=new FileInputStream(filename);	
      file=new DataInputStream(stream);
      
      if(!SetOffset(Offset)) {
	file.close();
	return false;
      }

      readFirst();
      MaxBookNumber=countBook();
    } catch(IOException e) {
	new WaringMessageDialog("ERROR (OPEN): "+e.getMessage());
	return false;
    }
    return true;
  }

  public void Close() {
    try { file.close(); }
    catch(IOException e) { 
	new WaringMessageDialog("ERROR (CLOSE): "+e.getMessage()); 
    }
  }
}

public class FilterBookLibrary extends BookLibrary {
  public static final int MODULUS=1,AMPLITUDE=2,POSITION=3,
                          FREQUENCY=4,SCALE=5,PHASE=6;
  public BookAtom goodAtoms[]=null;
  public int Count;
  private boolean MinFreqFlag;
  private boolean MaxFreqFlag;
  private float MinFreq;
  private float MaxFreq;
  private boolean MinTimeFlag;
  private boolean MaxTimeFlag;
  private float MinTime;
  private float MaxTime;
  private boolean MinPowerFlag;
  private boolean MaxPowerFlag;
  private float MinPower;
  private float MaxPower;
  private boolean MinAmplFlag;
  private boolean MaxAmplFlag;
  private float MinAmpl;
  private float MaxAmpl;
  private boolean MinScaleFlag;
  private boolean MaxScaleFlag;
  private float MinScale;
  private float MaxScale;
  private boolean MinModulusFlag;
  private boolean MaxModulusFlag;
  private float MinModulus;
  private float MaxModulus;
  private boolean TrueTime=true; 
  private int SortMode=-1;
  private float MinPhase;
  private float MaxPhase;
  private boolean MinPhaseFlag;
  private boolean MaxPhaseFlag;
  private int     MinIter,MaxIter;
  private boolean MinIterFlag,MaxIterFlag;  

    public final void setFilter(FilterBookLibrary f) {
	MinFreqFlag=f.MinFreqFlag;
	MaxFreqFlag=f.MaxFreqFlag;
	MinFreq=f.MinFreq;
	MaxFreq=f.MaxFreq;
	MinTimeFlag=f.MinTimeFlag;
	MaxTimeFlag=f.MaxTimeFlag;
	MinTime=f.MinTime;
	MaxTime=f.MaxTime;
	MinPowerFlag=f.MinPowerFlag;
	MaxPowerFlag=f.MaxPowerFlag;
	MinPower=f.MinPower;
	MaxPower=f.MaxPower;
	MinAmplFlag=f.MinAmplFlag;
	MaxAmplFlag=f.MaxAmplFlag;
	MinAmpl=f.MinAmpl;
	MaxAmpl=f.MaxAmpl;
	MinScaleFlag=f.MinScaleFlag;
	MaxScaleFlag=f.MaxScaleFlag;
	MinScale=f.MinScale;
	MaxScale=f.MaxScale;
	MinModulusFlag=f.MinModulusFlag;
	MaxModulusFlag=f.MaxModulusFlag;
	MinModulus=f.MinModulus;
	MaxModulus=f.MaxModulus;
	TrueTime=f.TrueTime;
	MinPhase=f.MinPhase;
	MaxPhase=f.MaxPhase;
	MinPhaseFlag=f.MinPhaseFlag;
	MaxPhaseFlag=f.MaxPhaseFlag;
	MinIter=f.MinIter;
	MaxIter=f.MaxIter;
	MinIterFlag=f.MinIterFlag;
	MaxIterFlag=f.MaxIterFlag;
    }

    public final void setMinIterFlag(boolean val) {
	MinIterFlag=val;
    }

    public final void setMaxIterFlag(boolean val) {
	MaxIterFlag=val;
    }
    
    public final void setMinPhaseFlag(boolean val) {
	MinPhaseFlag=val;
    }

    public final void setMaxPhaseFlag(boolean val) {
	MaxPhaseFlag=val;
    }

    public final void setMinTimeFlag(boolean val) {
	MinTimeFlag=val;
    }

    public final void setMaxTimeFlag(boolean val) {
	MaxTimeFlag=val;
    }

  public final void setMinScaleFlag(boolean val) {
    MinScaleFlag=val;
  }

  public final void setMaxScaleFlag(boolean val) {
    MaxScaleFlag=val;
  }

  public final void setMinFreqFlag(boolean val) {
    MinFreqFlag=val;
  }

  public final void setMaxFreqFlag(boolean val) {
    MaxFreqFlag=val;
  }

  public final void setMinAmplitudeFlag(boolean val) {
    MinAmplFlag=val;
  }

  public final void setMaxAmplitudeFlag(boolean val) {
    MaxAmplFlag=val;
  }

    public final int getMinIter() {
	return MinIterFlag ? MinIter : -1;
    }

    public final int getMaxIter() {
	return MaxIterFlag ? MaxIter : -1;
    }
    
  public final float getMinScale() {
    return MinScaleFlag ? MinScale : -1;
  }

  public final float getMaxScale() {
    return MaxScaleFlag ? MaxScale : -1;
  }

  public final float getMinFreq() {
    return MinFreqFlag ? MinFreq : -1.0F;
  }

  public final float getMaxFreq() {
    return MaxFreqFlag ? MaxFreq : -1.0F;
  }

  public final float getMinAmplitude() {
    return MinAmplFlag ? MinAmpl : -1.0F;
  }

  public final float getMaxAmplitude() {
    return MaxAmplFlag ? MaxAmpl : -1.0F;
  }

    public final float getMinTime() {
	return MinTimeFlag ? MinTime : -1.0F;
    }

    public final float getMaxTime() {
	return MaxTimeFlag ? MaxTime : -1.0F;
    }

    public final float getMinPhase() {
	return MinPhaseFlag ? MinPhase : -1.0F;
    }

    public final float getMaxPhase() {
	return MaxPhaseFlag ? MaxPhase : -1.0F;
    }

    public final boolean getTrueTime() {
	return TrueTime;
    }

  public final void ResetParameter() {
    MinFreqFlag=false;    MaxFreqFlag=false;    MinTimeFlag=false; 
    MaxTimeFlag=false;    MinPowerFlag=false;   MaxPowerFlag=false;
    MinAmplFlag=false;    MaxAmplFlag=false;    MinScaleFlag=false;
    MaxScaleFlag=false;  MinModulusFlag=false; MaxModulusFlag=false; 
    MinPhaseFlag=MaxPhaseFlag=false;
    MaxTimeFlag=MinTimeFlag=false;
    TrueTime=true;
    MinIterFlag=MaxIterFlag=false;
  }

    FilterBookLibrary() {
	ResetParameter();
    }

    public final void SetTrueTime(boolean val) {
	TrueTime=val;
    }

    public final void setMinIter(int min) {
	MinIterFlag=true; MinIter=min;
    }

    public final void setMaxIter(int max) {
	MaxIterFlag=true; MaxIter=max;
    }

    public final void setMinPhase(float MinPhase_) {
	MinPhaseFlag=true; MinPhase=MinPhase_;
    }

    public final void setMaxPhase(float MaxPhase_) {
	MaxPhaseFlag=true; MaxPhase=MaxPhase_;
    }

  public final void SetMinFreq(float MinFreq_) {
    MinFreqFlag=true; MinFreq=MinFreq_;
  }

  public final void SetMaxFreq(float MaxFreq_) {
    MaxFreqFlag=true; MaxFreq=MaxFreq_;
  }

  public final void SetMinTime(float MinTime_) {
    MinTimeFlag=true; MinTime=MinTime_;
  }

  public final void SetMaxTime(float MaxTime_) {
    MaxTimeFlag=true; MaxTime=MaxTime_;
  }

  public final void SetMinPower(float MinPower_) {
    MinPowerFlag=true; MinPower=MinPower_;
  }

  public final void SetMaxPower(float MaxPower_) {
    MaxPowerFlag=true; MaxPower=MaxPower_;
  }

  public final void SetMinAmplitude(float MinAmpli_) {
    MinAmplFlag=true; MinAmpl=MinAmpli_;
  }

  public final void SetMaxAmplitude(float MaxAmpli_) {
    MaxAmplFlag=true; MaxAmpl=MaxAmpli_;
  }

  public final void SetMinModulus(float MinModulus_) {
    MinModulusFlag=true; MinModulus=MinModulus_;
  }

  public final void SetMaxModulus(float MaxModulus_) {
    MaxModulusFlag=true; MaxModulus=MaxModulus_;
  }

  public final void SetMinScale(float MinOctave_) {
    MinScaleFlag=true; MinScale=MinOctave_; 
  }

  public final void SetMaxScale(float MaxScale_) {
    MaxScaleFlag=true; MaxScale=MaxScale_;
  }
    
  public final int NumOfAtoms() {
    return Count;
  }

  private static float SQR(float x) { return x*x; }
   
  private final boolean Filter(BookAtom atom) {
    if(MinIterFlag || MaxIterFlag) {
	if(MinIterFlag)
	    if((int)atom.number_of_atom_in_book<MinIter)
		return false;

	if(MaxIterFlag) 
	    if((int)atom.number_of_atom_in_book>MaxIter)
		return false;
    }  

    if(MaxFreqFlag || MinFreqFlag) {
      float frequency=(float)atom.frequency/(float)head.signal_size*
                      head.FREQUENCY;
     
      if(MaxFreqFlag)
	if(frequency>=MaxFreq) 
	  return false;

      if(MinFreqFlag)  
	if(frequency<=MinFreq) 
	  return false;
    }    
  
    if(MaxTimeFlag || MinTimeFlag) {
	float TimePosition=(!TrueTime) ? (float)atom.position 
	                               : atom.position/head.FREQUENCY;
     
      if(MaxTimeFlag)  
	if(TimePosition>=MaxTime) 
	  return false;
  
      if(MinTimeFlag)  
	if(TimePosition<=MinTime) 
	  return false;
    }      

    /*
    if(MinPowerFlag || MaxPowerFlag) {
      float Power=SQR(atom.modulus/head.points_per_micro_V);
       
      if(MaxPowerFlag)  
	if(Power>=MaxPower) 
	  return false;
  
      if(MinPowerFlag)  
	if(Power<=MinPower) 
	  return false;
    }
    */

    if(MinAmplFlag || MaxAmplFlag) {
      float amplitude=atom.amplitude;
      
      if(MaxAmplFlag)  
	if(amplitude>=MaxAmpl) 
	  return false;
      
      if(MinAmplFlag)  
	if(amplitude<=MinAmpl) 
	  return false;
    }     
  
    if(MinScaleFlag || MaxScaleFlag) {
      float scale=(!TrueTime) ? (float)atom.scale 
	                      : atom.scale/head.FREQUENCY;
      
      if(MaxScaleFlag)  
	if(scale>=MaxScale) 
	  return false;
      
      if(MinScaleFlag)  
	if(scale<=MinScale) 
	  return false;
    }
    
    if(MinModulusFlag || MaxModulusFlag) {
      float modulus=atom.modulus;
      
      if(MaxModulusFlag)  
	if(modulus>=MaxModulus) 
	  return false;
      
      if(MinModulusFlag)  
	if(modulus<=MinModulus) 
	  return false;
    }    
       
    if(MinPhaseFlag || MaxPhaseFlag) {
	float phase=atom.truePhase;

	if(MaxPhaseFlag) {
	    if(phase>=MaxPhase) 
		return false;
	}

	if(MinPhaseFlag) {
	    if(phase<=MinPhase) 
		return false;
	}
    }    
    
    return true;
  }  

  public final void GetGoodAtoms() {
    SortMode=-1;
    Count=0;
    goodAtoms=new BookAtom[head.book_size];

//System.out.println("booksize " + head.book_size);

    for(int i=0 ; i<head.book_size ; i++)
	if(Filter(atoms[i])) {
	    goodAtoms[Count]=atoms[i];
	    goodAtoms[Count].index=Count;
	    Count++;
	}
  }

    public boolean reFilter(int index[],boolean inverse) {
	if(Count==0) return false;
	boolean get[]=new boolean[Count];
	int i,j,n;

	if(!inverse) {
	    for(i=0 ; i<Count ; i++)
		get[i]=true;
	    for(i=0 ; i<index.length ; i++)
		get[index[i]]=false;
	} else {
	    for(i=0 ; i<Count ; i++)
		get[i]=false;
	    for(i=0 ; i<index.length ; i++)
		get[index[i]]=true;
	}
	
	for(i=0,n=0 ; i<Count ; i++)
	    if(get[i]) n++;

	if(n==0) 
	    return false;

	BookAtom NewAtoms[]=new BookAtom[n];
	SortBy(MODULUS);
	for(i=0,j=0 ; i<Count ; i++) 
	    if(get[i]) {
		NewAtoms[j]=goodAtoms[i];
		NewAtoms[j].index=j;
		j++;
	    }
	
	SortMode=-1;
	Count=n;
	goodAtoms=NewAtoms;
	return true;
    }

    public void Open(Book book) {
	super.Open(book);
	GetGoodAtoms();
    }

  public boolean Open(URL filename,int Offset) {
    if(!super.Open(filename,Offset))
      return false;
    
    GetGoodAtoms();
    return true;
  }

 public boolean Open(String filename,int Offset) {
    if(!super.Open(filename,Offset))
      return false;
    
    GetGoodAtoms();
    return true;
  }

  public final boolean NextBook() {
    if(!super.NextBook())
      return false;
    GetGoodAtoms();
    return true;
  }

  public final boolean GoTo(int Offset) {
    if(!super.GoTo(Offset))
      return false;
    GetGoodAtoms();
    return true;
  }

  public void SaveAll(DataOutputStream file) throws IOException {
    head.Save(file);
    for(int i=0 ; i<Count; i++)
      goodAtoms[i].Save(file,head,SecPP);
  }

  public String getAtomString(int k) {
    if(k<Count) 
      return goodAtoms[k].getAtomString(head,SecPP);
    return new String("EMPTY");
  }

  public float SamplingFreq() {
    return head.FREQUENCY;
  }

  public final float Frequency(int k) {
    return (goodAtoms[k].frequency/(float)head.signal_size)*head.FREQUENCY;
  }

  public final float frequency(int k) {
    return (float)(2.0*Math.PI*goodAtoms[k].frequency/head.signal_size);
  }
  
  public final float amplitude(int k) {
    return goodAtoms[k].amplitude;
  }

  public final float TimePosition(int k) {
    return ((float)head.file_offset*(float)head.signal_size
	    +goodAtoms[k].position)/head.FREQUENCY;
  }

  public final float modulus(int k) {
    return goodAtoms[k].modulus;
  }

    /*
  public final float octave(int k) {
    return goodAtoms[k].octave;
  }
    */
  public final int scale(int k) {
    return goodAtoms[k].scale;
  }

  public final int position(int k) {
    return goodAtoms[k].position;
  }

  public final int getAtomIndex(int k) {
      if(k<0 || k>=Count)
	  return -1;
      return goodAtoms[k].index;
  }
   
  public final float ifreq(int k) {
    return goodAtoms[k].frequency;
  }

  public final float Power(int k) {
    return SQR(goodAtoms[k].modulus/head.points_per_micro_V);
  }

  public final float phase(int k) {
    return goodAtoms[k].phase;
  }

  public final float truephase(int k) {
      return goodAtoms[k].truePhase;
  }  

  public final int DimBase() {
    return head.signal_size;
  }

  private int Compare(BookAtom a,BookAtom b,int CmpBy) {
    switch(CmpBy) {
    case MODULUS: 
      if(a.modulus<b.modulus) 
	return 1; 
      else if(a.modulus>b.modulus) 
	return -1;
      break;
    case AMPLITUDE: 
      if(a.amplitude<b.amplitude)
	return 1;
      else if(a.amplitude>b.amplitude) 
	return -1;
    break;
    case POSITION:
      if(a.position<b.position)
	return -1;
      else if(a.position>b.position)
	return 1;
      break;
    case FREQUENCY:
      if(a.frequency<b.frequency)
	return -1;
      else if(a.frequency>b.frequency)
	return 1;
      break;
    case SCALE:
      if(a.scale<b.scale)
	return -1;
      else if(a.scale>b.scale)
	return 1;
      break;
    case PHASE:
      if(a.truePhase<b.truePhase)
	return -1;
      else if(a.truePhase>b.truePhase)
	return 1;
      break;
    }
    return 0;
  }

  public final String getInfoString() {   
      return (!isNewMode ? head.getString()+"\nBook number    : "+
	                                     MaxBookNumber+"\n"
                         : newLib.getString());
  }

  public final void SortBy(int CmpBy) {
    if(CmpBy==SortMode)
	return;
    SortMode=CmpBy;
    QuickSort(goodAtoms,0,Count-1,CmpBy);
  }

  private void QuickSort(BookAtom a[],int lo0,int hi0,int CmpBy) {
      int lo=lo0,hi=hi0;
      BookAtom mid,T;
    
      if(hi0>lo0) {
	  mid=a[(lo0+hi0)>>1];
	  while(lo<=hi) {
	      while(lo<hi0 && Compare(a[lo],mid,CmpBy)<0) lo++;
	      while(hi>lo0 && Compare(a[hi],mid,CmpBy)>0) hi--;
	      if(lo<=hi) {
		  T=a[lo]; a[lo]=a[hi]; a[hi]=T;
		  lo++; hi--;
	      }
	  }
	  
	  if(lo0<hi) QuickSort(a,lo0,hi,CmpBy);
	  if(lo<hi0) QuickSort(a,lo,hi0,CmpBy);
      }
  }
}


