import java.io.*;

public class NewAtom implements Serializable {
    public float scale;
    public float frequency;
    public int   position;
    public float modulus;
    public float amplitude;
    public float phase;
    public int   index;
    private boolean versionIV;

    public NewAtom() {
	versionIV=false;
    }

    public NewAtom(boolean v) {
	versionIV=v;
    }

    public final void export(BookAtom atom) {
	atom.frequency=frequency;
	atom.position=(short)position;
	atom.modulus=modulus;
	atom.amplitude=amplitude;
	atom.phase=phase;
	atom.scale=(int)(0.5+scale);
	atom.index=index;
    }

    public final static int sizeOf() {
	return 6*4;
    } 

    public void Read(DataArrayInputStream stream) throws IOException {
	scale=versionIV ? stream.readFloat() : (float)stream.readInt();
	frequency=versionIV ? stream.readFloat() : (float)stream.readInt();
	position=(int)(0.5F+(versionIV ? stream.readFloat() 
		                       : (float)stream.readInt()));
	modulus=stream.readFloat();
	amplitude=stream.readFloat();
	phase=stream.readFloat();
    }
}
