/* 1998 11 30; 2000-05-17 */

import java.awt.*;
import java.util.Date;
import javax.swing.*;

public class ProgressIndex extends JDialog {
    private static final int POSX=10,POSY=35,DY=20,LENGTH=380;
    private int MaxCount,Count=0;
    private long t0=0L;
  
    public ProgressIndex(int maxCount,String title) {
	super(new JFrame(),false);
	getContentPane().setLayout(null);
	MaxCount=maxCount;
	setSize(LENGTH+30,75);
	getContentPane().setBackground(Color.lightGray);
	setResizable(false);
	t0=new Date().getTime();
    }
    
    public final void NextIndex() {
	if(++Count>=MaxCount) 
	    Count=MaxCount;
    }

    public final void UpDateIndex() {
	Graphics gDC=getGraphics();
	if(gDC!=null) {
	    Dimension dim=super.getSize();
	    gDC.setColor(Color.lightGray);
	    gDC.fillRect(0,0,dim.width,dim.height);
	    gDC.setColor(getForeground());
	    Draw(gDC);
	}
    }
  
    private float Round(double x) {
	double factor=10.0;
	return (float)(Math.floor(0.5+x*factor)/factor);
    }
    
    private String TimeToStr(double sec_time) {
	int hour=(int)(sec_time/3600.0),
	    minute=(int)((sec_time-3600.0*hour)/60.0),
	    sec=(int)(sec_time-60.0*minute-3600.0*hour);
	return new String(hour+"h"+((minute<10) ? "0"+minute : ""+minute)+
			  "\'"+((sec<10) ? "0"+sec : ""+sec)+"\"");
  }

    private void Draw(Graphics gDC) {
	gDC.setColor(Color.blue);
	gDC.drawRect(POSX,POSY,LENGTH,DY);
	gDC.fillRect(POSX,POSY,(Count*LENGTH)/MaxCount,DY);
	long t=new Date().getTime(),dt=(t-t0)/1000L;
	double p=100.0*(Count/(double)MaxCount);
	String s=Round(p)+"%  Time: ",s2="";
	if(Math.abs(p)>=0.001) 
	    s2="   "+TimeToStr(100.0*dt/p-dt);
	setTitle(s+=TimeToStr(dt)+s2);
    }
    
    public void paint(Graphics gDC) {
	UpDateIndex();
    }
    
    public final void Close() {
	setVisible(false); 
	dispose();
    }
}

    






