// 1999 10 25

import java.io.*;
import java.awt.*;
import javax.swing.*;

public class Utils {
    private static String oldDirectory="."; 

    public static String getBookFileName(String title,boolean load) {
	return getFileName(title,load,true);
    }
    
    public static String getFileName(String title,boolean load) {
	return getFileName(title,load,false);
    }

    private synchronized static String getFileName(String title,
						   boolean load,boolean book) {
	try {
	    JFrame frame=new JFrame(); frame.setVisible(false);
	    JFileChooser chooser=new JFileChooser(oldDirectory);
	    
	    if(book) {
		BookFileFilter filter = new BookFileFilter(
			                new String[] {"b", "B"}, "Book Files"
					);

		chooser.addChoosableFileFilter(filter);
		chooser.setFileFilter(filter);
	    }

	    chooser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
	    chooser.setFileHidingEnabled(false);
	    
	    if(load) chooser.setDialogType(JFileChooser.OPEN_DIALOG);
	    else     chooser.setDialogType(JFileChooser.SAVE_DIALOG);

	    int retval = chooser.showDialog(frame, null);
	    if(retval == JFileChooser.APPROVE_OPTION) {
		File theFile = chooser.getSelectedFile();
		if(theFile != null) {
		    if(!theFile.isDirectory()) {
			oldDirectory=chooser.getSelectedFile().getPath();
			return chooser.getSelectedFile().getAbsolutePath();
		    }
		}
	    }
	} catch(Exception e) {
	   ;
	}
      	return null;
    }

  public static float HmppPhase(float freq,float position,float phase) {
    double pi2=2.0*Math.PI;
    double RawPhase=(phase<0.0) ? pi2+phase : phase;

    RawPhase+=freq*position;
    return (float)(RawPhase-pi2*Math.floor(RawPhase/pi2));
  }

  public static float MppPhase(float freq,float position,float phase) {
    phase=HmppPhase(freq,position,phase);
    double RawPhase=phase-freq*position,pi2=2.0*Math.PI;
    double NewPhase=RawPhase-pi2*Math.floor(RawPhase/pi2);
  
    NewPhase=(NewPhase>=Math.PI) ? NewPhase-pi2 : NewPhase;
    NewPhase-=freq*position;
    return (float)(NewPhase-pi2*Math.floor(NewPhase/pi2));
  }

  public static float RawPhase(float freq,float position,float phase) {
    double NewPhase=phase-freq*position,pi2=2.0*Math.PI;
    return (float)(NewPhase-pi2*Math.floor(NewPhase/pi2));
  }
}
