%  CONFIG
% probability maps for JGinter's fingertapping experiment
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%                signal parameters
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
N = 57;      %number of repetitions
dimBase = 1024;
% for SP
read_raw_data = 'fid=fopen(''DATA/prawahj12'',''rb'');pr=fread(fid,[24,N*dimBase],''int16'');fclose(fid);data = (reshape(pr(11,:),dimBase,N))'';clear pr; ';
% for MP
bookname = 'B/prawahj12_c11.b';
sampling = 128;               %sampling frequency in Hz
time_length = dimBase/sampling;       %time length in seconds

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%                        MAP
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
ENERGY_SCALE = 'LIN';                   % 'LOG' or 'SQRT' or 'LIN'
MAP_TYPE     = 'SP';                    % 'SP' or 'MP'
dt = 0.25;%0.25;                         % time width of a pixel in sec
left_time_margin=dt;
right_time_margin=dt;
f_min = 0;
f_max = 40;
tmin  = 0;
tmax  = time_length;

% only for MP maps
filter_scale = [0.2 inf];

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%                      STATISTICS
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
STATISTICS   = 'PSEUDO_T';              % 'PSEUDO_T' or 'PERM_TEST'
MULTIPLE_TEST_CORRECTION = 'FDR'; 	% or 'BH' or 'BY_COLUMN' or 'FDR' or 'FULL_BONFERRONI' or 'NONE'
p_level=0.05/2; % bo test dwustronny
FDR_q=0.05/2;
Nboot    = 2000000;                   % number of permutations in PERM_TEST
Npseudot = 2000000;                % number of rep. in estimating PSEUDO_T statistics

ref_sec = [1.5 3];          % reference period in seconds

%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%                         DISPLAY
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
FULL_PRES=-1;          %FULL PRESENTATION -- MORE PLOTS
PLOT_FDR =0;
numfreq = 5;          % number of frequency ticks on the axis - affects only display
num_time =8;          % number of TIMEticks on the axis - affects only display













%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%		        THE END 
%		 OF THE EDITABLE PART 
%                       !!!!!
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% CALCULATING SOME CONSTANTS %%%%%%%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%% the part below should not be changed %%%%%%%%%%%%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% setting the frequency width of a resel  (Heisenberg box)
% requires extra checks so that integer number of resels fit into the time and frequency ranges

switch MAP_TYPE
    case 'SP'
        %obliczamy
        NFFT = dt*sampling*2;%2 bo 2=NFFT/(NFFT-NOVERLAP)
        FFT_window = hanning(NFFT);
        NOVERLAP = ceil(NFFT/2);
        df = sampling/NFFT;
    case 'MP'
        df =  1/(2*dt);
    otherwise
        %wpisujemy
        df = 0.5; %1/(4*pi*dt);%1;
end

minT=tmin*sampling; % czas poczatku mapy w punktach probkowania
maxT=tmax*sampling;  % czas konca mapy w punktach probkowania
minF=f_min*(dimBase)/sampling;
maxF=f_max*(dimBase)/sampling;

t=1:maxT-minT; % skala czasu w punktach
f=1:maxF-minF; % skala czestosci w punktach
Tsize=length(t);
Fsize=length(f);

map_x_size = round((tmax-tmin)/dt);
map_y_size = round((f_max-f_min)/df);

if mod(Tsize,map_x_size)~=0
    disp(sprintf('Wrong dt , possible values are: \n'));
    for i=1:Tsize
        if mod(Tsize,i)==0
            disp((tmax-tmin)/i)
        end
    end
    s=dbstack;
    error(sprintf('Please correct dt value in %s\n',s.name));
elseif mod(Fsize,map_y_size)~=0
    % df value correction
    if strcmp(MAP_TYPE,'MP');
       df_old = abs(df);
       i=1:Fsize;
       i=i(mod(Fsize,i)==0);
       df_new=abs((f_max-f_min)./i);
       df_new=df_new((df_new-df_old)>=0);
       df=df_new(end);
       if df ~= df_old
           disp(sprintf('Wrong df=%.4f value...\n...it was corrected to the nearest possible. New df=%.4f', df_old, df));
           map_x_size = round((tmax-tmin)/dt);
           map_y_size = round((f_max-f_min)/df);
       end
    end
end

ref = round(ref_sec(1)/dt)+1:round(ref_sec(2)/dt);  % points in the reference period
left_time_margin_px=floor(left_time_margin/dt+0.5);
right_time_margin_px=floor(right_time_margin/dt+0.5);


if FULL_PRES==1 & strcmp(MAP_TYPE,'MP')
    NS=3;                   % vertical number of subplots
    NSx = 2;                % horizontal number of subplots
elseif FULL_PRES==-1 & MAP_TYPE=='SP'
    NS=1;
    NSx=2;
else
    NS=1;
    NSx=3;
end




%FULL: set(gcf,'paperposition', [1 1 5 7.5]); print -deps dfull.eps
%colormap(flipud(grayset(gcf,'paperposition', [1 1 5 2.5]); print -deps dsp.ep));set(gcf,'paperposition', [1 1 5 2.5]); print -deps dsp.eps