function [out_map,t,f]=calculate_maps_specgram(config_name, name);

eval(config_name); %read the same parameters as the main function
Xsize=map_x_size;
Ysize=map_y_size;

% sprawdzamy czy wyjsciowe piksle zawieraja calkowita liczbe pikseli dokladnej mapy

if mod(Tsize,Xsize)~=0
   disp(sprintf('wrong Xsize, possible values are: \n'));
   for i=1:Tsize
      if mod(Tsize,i)==0
         disp(i)
      end
   end
   error('... so the end');
elseif mod(Fsize,Ysize)~=0
   disp(sprintf('wrong Ysize, possible values are: \n'));
   for i=1:Fsize
      if mod(Fsize,i)==0
         disp(i)
      end
   end   
   error('... so the end');
end

DX=Tsize/Xsize;
DY=Fsize/Ysize;
%t=t(1:DX:Tsize);
%f=f(1:DY:Fsize);
xx=(1:Xsize)+floor(minT/DX);
yy=(1:Ysize)+floor(minF/DY);

FS = sampling;

%FFT_window = hanning(NFFT);
%NOVERLAP = ceil(NFFT/2);

%CALCULATING MAPS from *.asc 

map_filename=sprintf('calc_map/%s.mat', name);


if exist(map_filename)~=2 %jesli plik nie istnieje
   fo=fopen(map_filename,'wb');
   if fo==-1 
      disp('error opening map file for writing');
      return;
   end
   
   eval(read_raw_data); %wczytanie danych wg recepty z config'a
   mapaXY=zeros(Xsize,Ysize);
   out_map=zeros(N,Ysize,Xsize); % mape trzeba transponowac aby tworzyc rysunek w naturalny sposob - imagesc(t,f,out_map)
   sgramTF=zeros(ceil(dimBase/2),dimBase);
   %X_ind = zeros(Xsize,Ysize,DX);
   %Y_ind = zeros(Xsize,Ysize,DY);
   %for x=1:Xsize
   %   for y=1:Ysize
   %      X_ind(x,y,:)=(1 + (x-1)*DX : x*DX);
   %      Y_ind(x,y,:)=(1 + (y-1)*DY : y*DY);
   %   end
   %end
   for i=1:N
      %drawing single map       
      disp(sprintf('map1:%2d/%d',i,N));
      
      [sgram, f, t] = specgram([zeros(1,NOVERLAP-1) data(i,:) zeros(1,NOVERLAP)], NFFT, FS, FFT_window, NOVERLAP); %przeliczenie defaultowego spektrogramu
      
      %obliczenie mocy
      sgram_power = abs(sgram); % tak to powinno byc w skali liniowej

      %przeliczenie w skali naturalnej
      %Tspec = length(t)*(t(2)-t(1));
      %miss = floor(0.5*(time_length-Tspec)*FS);
      
      %bez przeliczenia
      mapaXY = zeros(length(t),length(f)-1);
      
      %gg=zeros(length(f),dimBase);
      %k=miss+1:dimBase-miss;
      %gg(:,k)=sgram_power(:,ceil((k-miss)/FS));         
      mapaXY(:,:)=sgram_power(1:end-1,:)';         
      
      %k=1:ceil(dimBase/2);
      %sgramTF(k,:) = gg(ceil(length(f)*2*k/dimBase),:);       
      
      %for x=1:Xsize
         %for y=1:Ysize
         %   mapaXY(x,y)=sum(sum(sgramTF(Y_ind(x,y,:),X_ind(x,y,:))));
         %end
      %end
      
      %mapaXY = mapaXY;		%./DX./DY; %normalizacja /DX/DY do uzgodnienia
      
      mapaXY = mapaXY(xx,yy);
      
      fwrite(fo,mapaXY,'double'); %zapamietujemy mapy w skali jaka jest
      
     
      %keyboard
      out_map(i,:,:)=mapaXY'; %tu zapamietujemy zestaw map w zadanej skali i rozdzielczosci
      
      %rysujemy sobie obrazek
      %figure(1)
      %imagesc(t,f,log(mapaXY./DX./DY+1)');set(gca,'ydir', 'normal');title(sprintf('map #%d', i));
      %set(gca,'xtick', ttick, 'xticklabel', tticklabels, 'ytick', ftick, 'yticklabel', fticklabels);
      %title(bookname); drawnow; %pause(.001);
      pause(0);
      
   end
   fclose(fo);
else
   fid=fopen(map_filename,'rb');
   if fid==-1 
      disp('error opening map file for reading');
      return;
   end
   out_map = zeros(N,Ysize,Xsize);
   for i=1:N
      out_map(i,:,:) = fread(fid,[Xsize, Ysize],'double')';%./DX./DY;
   end
   fclose(fid);
end
t=t/FS;
f=f*FS/dimBase;

