/* sys/time.h	? /**/
#include <sys/socket.h>
/* sys/ioctl.h	? /**/
/* net/if.h	? /**/
/* net/route.h	? /**/
#include <errno.h>
#include <stdio.h>
#include "ncp.h"

#define SERVER {0x01,0x86,0x70,0x36}
/*/ #define SERVER {0,0,0,0} /**/

extern int ipx_sock;

int timeouts=0;

static void put_sa_ipx(ipxAddr_t *ipxa, struct sockaddr_ipx *saipx, unsigned char ipxtype) {
	memset(saipx,0,sizeof(*saipx));
	saipx->sipx_family=AF_IPX; saipx->sipx_type=ipxtype;
	if(ipxa!=NULL) {
		saipx->sipx_port=*(u_int16_t*)ipxa->sock;
		memcpy(saipx->sipx_node,ipxa->node,sizeof(saipx->sipx_node));
		saipx->sipx_network=*(u_int32_t*)ipxa->net;
}	}

static unsigned char get_sa_ipx(ipxAddr_t *ipxa, struct sockaddr_ipx *saipx) {
	*(u_int16_t*)ipxa->sock=saipx->sipx_port;
	memcpy(ipxa->node,saipx->sipx_node,sizeof(ipxa->node));
	*(u_int32_t*)ipxa->net=saipx->sipx_network; return saipx->sipx_type;
}

int open_ipx_socket(ipxAddr_t *ipxa_in, ipxAddr_t *ipxa_out) {
	int i,opt,sock; struct sockaddr_ipx saipx; socklen_t sal;
#ifdef FREEBSD
	sock = socket(AF_IPX, SOCK_DGRAM, 0);
#else
	sock = socket(AF_IPX, SOCK_DGRAM, AF_IPX);
#endif
	if (sock < 0) return(sock);
	i=0; if (setsockopt(sock, SOL_SOCKET, SO_DEBUG, /* debug switch */
		&i, sizeof(int))==-1) perror("setsockopt SO_DEBUG");

	/* Now allow broadcast */ opt=1;
	if (setsockopt(sock, SOL_SOCKET, SO_BROADCAST, &opt,sizeof(opt))==-1){
		perror("setsockopt SO_BROADCAST"); goto abort;
	}
	put_sa_ipx(ipxa_in,&saipx,17);
#ifdef FREEBSD
	ipx_netlong(saipx.sipx_addr)=ipx_netlong(fbsd_ipx);
	memcpy(saipx.sipx_node, &fbsd_ipx.x_host, IPX_NODE_SIZE);
#else
	memset(saipx.sipx_node,0,sizeof(saipx.sipx_node));
	saipx.sipx_network=0; /* always default net/node */
#endif
	if (bind(sock, (struct sockaddr*)&saipx, sizeof(saipx))==-1) {
		perror("BIND"); fprintf(stderr, "on socket Nr:0x%04x\n", 
			(int)GET_BE16(&(saipx.sipx_port))); goto abort;
	}
#ifdef FREEBSD
	opt=1;
	if (setsockopt(sock, 0, SO_HEADERS_ON_INPUT, &opt, sizeof(opt))) {
		perror("setsockopt SO_HEADERS_ON_INPUT"); goto abort;
	}
	if (setsockopt(sock, SOL_SOCKET, SO_BROADCAST, &opt, sizeof(opt))==-1) {
		perror("setsockopt SO_BROADCAST"); goto abort;
	}
#endif
	memset(&saipx,0,sal=sizeof(saipx));
	if (getsockname(sock, (struct sockaddr*)&saipx, &sal) == -1)
		{ perror("GETSOCKNAME(IPX)"); goto abort; }
	else if(ipxa_out!=NULL) get_sa_ipx(ipxa_out,&saipx);
/*	for(i=0; i<sizeof(saipx); i++)
		printf(i%16==0?"\n%02x":" %02x",((uint8*)&saipx)[i]);
	printf("\n");	*/
	return(sock);
abort:	close(sock); return(-1);
}

/* U16_TO_BE16(sock_nr, addr->sock); */

ipxAddr_t /* ncp_to={SERVER,{0,0,0,0,0,1},{4,0x51}}, */
	sap_to={{0,0,0,0},{0xff,0xff,0xff,0xff,0xff,0xff},{4,0x52}};
struct sockaddr_ipx from,to; int debug=1;
uint8 snd_buf[546],rcv_buf[546];

char *try_sap(ipxAddr_t *fserv) {
	static unsigned char sap_q[4]={0,3,0,4}, sap_r[66];
	int i,r; socklen_t f=sizeof(from); put_sa_ipx(&sap_to,&to,0);
	alarm(1); if(sendto(ipx_sock,sap_q,sizeof(sap_q),0,
		(struct sockaddr *)&to, sizeof(to))<0) perror("SENDTO");
	alarm(4); r=recvfrom(ipx_sock,sap_r,sizeof(sap_r),0,
		(struct sockaddr *)&from, &f); alarm(0);
	if(r<0) perror("SAP recvfrom");
	else if(debug) {
		for(i=0; i<r; i++) printf(i%16==0?"\n%02x":" %02x",sap_r[i]);
		printf("\n");
	}
	if(r!=sizeof(sap_r)) return NULL;
	memcpy(fserv,sap_r+52,sizeof(ipxAddr_t));
	sap_r[52]=0; return sap_r+4;
}

int ncp_request(int fnc,
	uint8 *snd_buf, int snd_lng,
	uint8 *rcv_buf, int rcv_lng) {
	extern int alarmed; int i,r; socklen_t f=sizeof(from);
	((ncprequest_t*)snd_buf)->function=fnc;
	((ncprequest_t*)snd_buf)->sequence++;
	if(debug) {
		for(i=0; i<snd_lng; i++)
			printf(" %02x",snd_buf[i]);
		printf("\n");
	}
snd:	alarm(1); if(sendto(ipx_sock,snd_buf,snd_lng,0,
		(struct sockaddr *)&to,sizeof(to))<0) perror("SENDTO");
rcv:	alarm(1); if((r=recvfrom(ipx_sock,rcv_buf,rcv_lng,0,
		(struct sockaddr *)&from,&f))<0 && errno!=EINTR) perror("RECVFROM");
/*	if(r>=4) while(r<sizeof(ncpresponse_t)) rcv_buf[r++]=0;	*/
	alarm(0); if(alarmed) {
		fprintf(stderr,"Alarmed!\n");
		timeouts+=alarmed; alarmed=0; goto snd;
	}

#if 1
	/* check if sender of the packet just received is our server;
	 * on receive, from.sipx_zero sometimes has bad value - ignore */
	if(memcmp(&from,&to,sizeof(from)-sizeof(from.sipx_zero))!=0) goto rcv;
#else
	{	static int q=0,b; 
		if(memcmp(&from,&to,sizeof(from)-sizeof(from.sipx_zero))!=0) {
			for(b=0; b<sizeof(struct sockaddr_ipx); )
				fprintf(stderr," %02x",((uint8*)&to)[b++]);
			printf("\n");
			for(b=0; b<sizeof(struct sockaddr_ipx); )
				fprintf(stderr," %02x",((uint8*)&from)[b++]);
			printf("\n"); q++;
	}	}
#endif

	if(debug) {
	/*	for(i=0; i<NCP_REQ_S; i++)
			printf("%02x ",snd_buf[i]); */
	/*	for(i=0; i<snd_lng; i++)
			printf(" %02x",snd_buf[i]);
		printf("\n");	*/
		if(debug==2) for(i=0; i<r; i++) {
			printf(" %02x",rcv_buf[i]);
			if(i%16==15) printf("\n");
		}
		else for(i=0; i<12 /* sizeof(ncpresponse_t) */; i++)
			printf(" %02x",rcv_buf[i]);
		printf(", r=%u\n",r);
	}
	if(r>=sizeof(ncpresponse_t)) {
		if(((ncprequest_t*)snd_buf)->type==0x1111)
			*(uint32*)(snd_buf+2)=*(uint32*)(rcv_buf+2);
		if(((ncpresponse_t*)rcv_buf)->type==0x3333
		&& *(uint32*)(rcv_buf+2)==*(uint32*)(snd_buf+2))
			return r-sizeof(ncpresponse_t);
		goto rcv;
	}
	goto snd;
}

int ncp_detach(void) {
	int r; ((ncprequest_t*)snd_buf)->type=0x5555;
	r=ncp_request(0x11,snd_buf,NCP_REQ_S,rcv_buf,sizeof(rcv_buf));
	if(debug) printf("detach=%u/%x\n",r,NCPCC); return NCPCC;
}

int ncp_attach(ipxAddr_t *ncpto) {
/*	NCP ATTACH request: type=1111h, connection=0FFh, code=11h
	NCP DETACH request: type=5555h, code=0
	NCP LOGOUT request: code=19h	*/
	int r;

	/* attach */
	put_sa_ipx(ncpto,&to,17);
	memset(snd_buf,0,NCP_REQ_S);
	((ncprequest_t*)snd_buf)->type=0x1111;
	((ncprequest_t*)snd_buf)->sequence=
	((ncprequest_t*)snd_buf)->connection=0xff;
	r=ncp_request(0x11,snd_buf,NCP_REQ_S,rcv_buf,sizeof(rcv_buf));
	if(debug) printf("attach=%u/%x\n",r,NCPCC);
	if(NCPCC) return NCPCC; return ncp_logout();
}

int ncp_logout(void) {
	int r; /* logout */
	((ncprequest_t*)snd_buf)->type=0x2222;
	r=ncp_request(0x19,snd_buf,NCP_REQ_S,rcv_buf,sizeof(rcv_buf));
	if(debug) printf("logout=%u/%x\n",r,NCPCC); return NCPCC;
}

ncp_openn(uint8 nwh[6], uint8 dh, char *fn, uint8 nwt[8]) {
/*	NCP OPEN request: code=4Ch, data 1,6,11h name_length name; the reply
	contains 36 bytes of data, first 6 of them are file handle */
	int i,r; i=NCP_REQ_S;
if(debug) fprintf(stderr,"openn - entry\n");
	snd_buf[i++]=dh; /* directory handle */
	/* (after logout dir handle 1 = SYS:LOGIN) */
	snd_buf[i++]=6; /* no create atrribute */
	snd_buf[i++]=1; /* access: shared readonly */
if(debug) fprintf(stderr,"openn - strlen\n");
	snd_buf[i++]=strlen(fn);
if(debug) fprintf(stderr,"openn - strcpy\n");
	strcpy(snd_buf+i,fn);
	i+=snd_buf[i-1];
if(debug) fprintf(stderr,"openn - request\n");
	r=ncp_request(0x4C,snd_buf,i,rcv_buf,sizeof(rcv_buf));
	if(debug>1) printf("open=%u/%x",r,NCPCC);
	if(NCPCC) memset(nwh,0,6); else {
		memcpy(nwh,rcv_buf+sizeof(ncpresponse_t),6);
		if(nwt!=NULL) memcpy(nwt,rcv_buf+sizeof(ncpresponse_t)+28,8);
	}
	if(debug>1) {
		for(i=0; i<6; i++) printf(i==0?" %02x":":%02x",nwh[i]);
		printf("\n"); }
	return NCPCC;
}

int ncp_read(uint8 nwh[6],uint32 ofs,int cnt) {
/*	NCP READ request: code=48h, data 0 handle start[4] length[2],
		note start and length in Hi-Lo order;
		the reply contains data: WORD read_length, the_data_read */
	int i,r;
	/* read */
	i=NCP_REQ_S; snd_buf[i++]=0; memcpy(snd_buf+i,nwh,6); i+=6;
	*(uint32*)(snd_buf+i)=htonl(ofs); i+=4;
	*(uint16*)(snd_buf+i)=htons(cnt); i+=2;
	r=ncp_request(0x48,snd_buf,i,rcv_buf,sizeof(rcv_buf));
	return NCPCC;
}

int ncp_close(uint8 nwh[6]) {
	int i;
	i=NCP_REQ_S; snd_buf[i++]=0; memcpy(snd_buf+i,nwh,6); i+=6;
	ncp_request(0x42,snd_buf,i,rcv_buf,sizeof(rcv_buf));
	return NCPCC;
}

int _FileServiceRequest(BYTE f_al, BYTE *rp, WORD rl, BYTE *ap, WORD al) {
#define MIN(a,b) ((a) < (b) ? (a) : (b))
	unsigned int r;
	memcpy(snd_buf+NCP_REQ_S,rp,MIN(rl,sizeof(snd_buf)-NCP_REQ_S));
	r=ncp_request(f_al,snd_buf,NCP_REQ_S+rl,rcv_buf,sizeof(rcv_buf));
	if(al>0 && ap!=NULL) memcpy(ap,rcv_buf+sizeof(ncpresponse_t),MIN(r,al));
	return NCPCC;
}

