#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <signal.h>
#include <openssl/md5.h>
#include "ncp.h"

int alarmed=0,ipx_sock=-1; long count=-1;
extern int debug,timeouts; char *destin=NULL;
extern uint8 rcv_buf[]; uint8 nwt1[8];
char *getenv(const char *name);

static void sigalrm(int s) {
	signal(SIGALRM,sigalrm);
	siginterrupt(SIGALRM,1);
	if(s) { alarmed++; /* write(2,"alarm\n",6); */ }
}

FILE *openout(char *on) {
	char *cp,*cr; int q; FILE *fd;
	cp=strchr(on,':'); if(cp!=NULL) *cp='/';
agn:	if((fd=fopen(on,"wb"))!=NULL) return fd;
ndr:	cr=strrchr(on,'/'); if(cp!=NULL) *cp='/';
	if(errno!=ENOENT || cr==NULL) { perror(on); return NULL; }
	*cr=0; cp=cr; if(mkdir(on,0700)!=0) goto ndr;
	*cp='/'; cp=NULL; goto agn;
}

int md5file(char *fp, char *dd) {
	unsigned long ofs; MD5_CTX mc; FILE *out; char *on;
	int r,l; uint8 md[MD5_DIGEST_LENGTH],nwh1[6];

	on=NULL; if(dd!=NULL)
		if((on=alloca((l=strlen(dd))+strlen(fp)+2))!=NULL) {
			int i,c; strcpy(on,dd);
			if(l>0 && on[l-1]!='/') on[l++]='/';
			for(i=0; (c=fp[i])!=0; on[l+i]=c,i++)
				if((unsigned)(c-'A')<='Z'-'A') c+='a'-'A';
			on[l+i]=0; for(i=l; (c=on[i])!=0 && c!='/'; )
				if(c==':') on[i]='/'; else i++;
		} else perror("alloca buf for file path");

	r=ncp_openn(nwh1,0,fp,nwt1); if(r!=0) {
		fprintf(stderr,"%s: error %u(%02x)\n",fp,r,r);
		return -1;
	}
	out=NULL; if(on!=NULL && (out=openout(on))==NULL)
		{ ncp_close(nwh1); return -1; }
	r=ncp_read(nwh1,ofs=0,0x200); debug=0;
/*	printf("read=%u/%x\n",r,NCPCC);	*/
	MD5_Init(&mc);
	for(count=0; NCPCC==0 && READ_CNT==0x200; count++) {
		MD5_Update(&mc,READ_BUF,0x200);
		if(out!=NULL) fwrite(READ_BUF,1,0x200,out);
		r=ncp_read(nwh1,ofs+=READ_CNT,0x200);
	}
	MD5_Update(&mc,READ_BUF,READ_CNT); MD5_Final(md,&mc);
	if(out!=NULL) fwrite(READ_BUF,1,READ_CNT,out);
/*	printf("read=%u/%x, %d timeouts, %ld full blocks, s=%02x%02x\n",
		r,NCPCC,timeouts,count,
		(uint8)rcv_buf[sizeof(ncpresponse_t)],
		(uint8)rcv_buf[sizeof(ncpresponse_t)+1]);
	}	*/
	r=ncp_close(nwh1); /* printf("close=%u/%x\n",r,r); */
	printf("%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x%02x  %s\n",
		md[0],md[1],md[2],md[3],md[4],md[5],md[6],md[7],md[8],
		md[9],md[10],md[11],md[12],md[13],md[14],md[15],fp);
	if(out!=NULL)
		if((r=fclose(out))!=0)
			{ perror(on); if(unlink(on)) perror(on); }
		else setfiletime(on,	ntohs(*(short*)(nwt1+4)),
					ntohs(*(short*)(nwt1+6)));
	return r;
}

int copytodir(void) {
	char ib[312]; int c,i,il;
	while(fgets(ib,sizeof(ib),stdin)!=NULL && (il=strlen(ib))>0) {
		if(ib[il-1]!='\n')
			{ fprintf(stderr,"Bad input\n"); return -1; }
		for(i=0; (unsigned)((c=ib[i])-'0')<10
			|| (unsigned)((c|0x20)-'a')<6; i++);
		if(i!=32 || c!=' ' || ib[33]!=' ') continue;
		ib[il-1]=0; md5file(ib+34,destin);
	}
	return 0;
}

bindery(void) {
	static char *bfnvp[]={"OBJ","PROP","VAL",NULL};
	static struct { uint16 l; uint8 f; } br={1};
	static uint16 ba=0; int r;
	char bnwn[24],*svis,*spas;
	svis=getenv("NWSVIS"); spas=getenv("NWSPAS");
	if(svis==NULL) return -1; if(spas==NULL) {
		fprintf(stderr,"Supervisor password unspecified\n"); return -1;
	}
	if((r=LoginToFileServer(svis,1,spas))!=0) {
		fprintf(stderr,"Supervisor login failed, error %u(%02x)\n",r,r);
		goto end;
	}
	br.f=0x44; if((r=_ShellRequest(0xe3,&br,&ba))!=0) goto ber;
	for(/*r=0*/; bfnvp[r]!=NULL; r++) {
		snprintf(bnwn,sizeof(bnwn),
			"SYS:SYSTEM/NET$%s.SYS",bfnvp[r]);
		md5file(bnwn,NULL);
		if(destin!=NULL) md5file(bnwn,destin);
	}
	br.f=0x45; r=_ShellRequest(0xe3,&br,&ba);
ber:	if(r) fprintf(stderr,"Bindery %s failed, error %u(%02x)\n",
		br.f==0x44?"close":"open",r,r);
end:	ncp_logout(); return r;
}

char usage[]=	"%s - backup files from NetWare fileserver\n\n"
		"Usage: %s SERVER backup-parameters\n\n"
		"Copyright: GNU GPL. Read README for details\n"
		"on parameters, COPYING for copyright info.\n\n";

main(int ac, char **av) {
	int a,r,v; extern char *try_sap(ipxAddr_t *);
	uint8 pval[128]; ipxAddr_t ipxa; char *user,*pass;

	debug=0; /**/ sigalrm(0);

	if(ac==1) {
		if((user=strrchr(av[0],'/'))==NULL) user=av[0]; else user++;
		fprintf(stderr,usage,user,av[0]);
	}

	if((ipx_sock=open_ipx_socket(NULL,&ipxa))==-1) return -1;

	/* if(ac==1) debug=1; */ if((user=try_sap(&ipxa))==NULL) return -1;
	if(ac==1) { printf("SAP response: server is [%08lx]=%.48s\n",
			ntohl(*(uint32*)ipxa.net),user); return 0; }

	if(ncp_attach(&ipxa)!=0) return -1;
	r=ReadPropertyValue(av[1],4,"NET_ADDRESS",1,pval,NULL,NULL);
	ncp_detach(); if(r!=0) {
		fprintf(stderr,"Server %s: error %d(%02x)\n",av[1],r,r);
		return -1;
	}
	memcpy(&ipxa,pval,sizeof(ipxAddr_t));

	printf("Attaching to server [%08lx]=%s\n",
		ntohl(*(uint32*)ipxa.net),av[1]);
	if(ncp_attach(&ipxa)!=0) return -1;
	if(ac==2) {
		for(v=0; GetVolumeName(v,pval)==0 && pval[0]!=0; v++)
			printf("Volume %2u=%.16s\n",v,pval);
		ncp_detach(); return 0;
	}

	/* debug=1; */ debug=0;
	if((user=getenv("NWUSER"))==NULL)
		{ fprintf(stderr,"No NWUSER in environment\n"); goto end; }
	if((pass=getenv("NWPASS"))==NULL) pass="";

	for(a=2; a<ac; a++) {
		if((av[a][0]!='-' || av[a][1]!=0)
		&& strchr(av[a],':')==NULL) destin=av[a];

		else if(av[a][0]==':' && av[a][1]==0) bindery();

		else if((r=LoginToFileServer(user,1,pass))!=0) {
			fprintf(stderr,"Login failed, error %u(%02x)\n",r,r);
			return -1;
		}

		else if(av[a][0]=='-' && av[a][1]==0)
			r=copytodir();

		else if(strcmp(av[a],"*:")!=0)
			r=showdir(av[a]);

		else for(v=0; GetVolumeName(v,pval)==0 && pval[0]!=0; v++) {
			printf("Volume %2u=%.16s\n",v,pval);
			pval[16]=0; r=strlen(pval); pval[r++]=':';
			pval[r]=0; r=showdir(pval);
	}	}

end:	ncp_logout(); ncp_detach(); close(ipx_sock); return r;
}
