#include <netipx/ipx.h>
#define GET_BE16(b)	(     (int) *(((uint8*)(b))+1)  \
			| ( ( (int) *( (uint8*)(b)   )  << 8) ) )

typedef unsigned char       uint8;
typedef unsigned short int uint16;
typedef unsigned long  int uint32;

#define IPX_NET_SIZE    4
#define IPX_NODE_SIZE   6
#define IPX_SOCK_SIZE   2

typedef struct {
	uint8  net[IPX_NET_SIZE];
	uint8  node[IPX_NODE_SIZE];
	uint8  sock[IPX_SOCK_SIZE];
} ipxAddr_t;

#define NCP_REQ_S 7

typedef struct S_NCPREQUEST {	/* size = 7 */
	uint16	type;		/* 0x1111 od 0x2222 */
	uint8	sequence,
		connection,	/* low connection */
		task,
		high_connection,/* high connection */
		function;	/* Function  */
} ncprequest_t;

typedef struct S_NCPRESPONSE {	/* size = 8 */
	uint16	type;		/* 0x3333 */
	uint8	sequence,
		connection,	/* low connection */
		task,
		high_connection,/* high connection */
		completition,	/* bzw. ERROR CODE */
		connect_status;
} ncpresponse_t;

typedef unsigned char BYTE; typedef unsigned short WORD; typedef unsigned long DWORD;

#define NCPCC	(((ncpresponse_t*)rcv_buf)->completition)
#define READ_CNT ntohs(*(uint16*)(rcv_buf+sizeof(ncpresponse_t)))
#define READ_BUF (rcv_buf+sizeof(ncpresponse_t)+2)

extern int _FileServiceRequest(BYTE f_al, BYTE *rp, WORD rl, BYTE *ap, WORD al);
