Text		segment	para 'CODE'
		org	0
		assume	cs:Text
StartAskBoot	label	byte
		jmp	short Start
		dw	EndOfAskBoot
AskBoot		proc	far
Start:		mov	si,offset BootQuery
		mov	bx,7
		push	ds
		push	cs
		pop	ds
		cld
ShowQuery:	lodsb
		cmp	al,0
		jz	QueryDone
		mov	ah,0Eh
		int	10h
		jmp	ShowQuery
QueryDone:	mov	si,offset EndOfAskBoot
		mov	cx,cs:[si+0bh]
WaitAnswer:	mov	ah,0
		int	16h
		and	al,not 20h
		cmp	al,'R'
		jz	BootEmul
		cmp	al,'D'
		jnz	WaitAnswer
BootEmul:	push	ax
		mov	ah,0Eh
		int	10h
		mov	ax,0E0Dh
		int	10h
		mov	ax,0E0Ah
		int	10h
		pop	ax
		cmp	al,'R'
		jz	RomBootEmul
DiskBootEmul:	pop	es		; emulate disk boot
		mov	bx,7C00h
		mov	di,bx
		rep	movsb
		xor	ax,ax
		inc	ax
		lea	sp,[bx-4]
		pop	cx
		pop	dx
		push	es
		push	bx
		ret
RomBootEmul:	add	si,cx		; emulate rom boot
		mov	cl,4
		shr	si,cl
		mov	ax,cs
		add	ax,si
		mov	dx,offset Int19Boot
		push	cs
		push	dx
		push	ax
		mov	ax,3
		push	ax
		xor	bx,bx
		mov	ds,bx
		mov	di,0c0h*4
		cmp	word ptr [di+4],6a6eh
		jnz	noInt19Set
		les	ax,[di]
		mov	[bx+19h*4],ax
		mov	[bx+19h*4+2],es
		mov	es,bx
		xchg	ax,bx
		stosw
		stosw
		stosw
noInt19Set:	ret
Int19Boot:	int	19h
		sti
		jmp	$
BootQuery	db	'Select boot emulation: D = disk, R = rom: ',0
AskBoot		endp
ParaFillCount	=	0Fh AND (StartAskBoot-this byte)
		if	ParaFillCount
		db	ParaFillCount dup(0)
		endif
EndOfAskBoot	label	byte
Text		ends
		end
